/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**************************************!*\
  !*** ./src/background/background.js ***!
  \**************************************/
chrome.runtime.onInstalled.addListener(() => {
  console.log('I am installed');
});

// show terms and conditions page when installed`
chrome.runtime.onInstalled.addListener(function (details) {
  if (details.reason === 'install') {
    //  || details.reason === "update"
    // Set a flag in storage that your SPA will check on startup
    chrome.storage.local.set({
      needsTermsAcceptance: true
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'removeExtension') {
    chrome.management.uninstallSelf({
      showConfirmDialog: true
    }, () => {
      if (chrome.runtime.lastError) {
        sendResponse({
          success: false,
          error: chrome.runtime.lastError.message
        });
      } else {
        sendResponse({
          success: true
        });
      }
    });
    return true;
  }
});
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.url && tab.active) {
    chrome.tabs.sendMessage(tabId, {
      method: 'UrlChanged',
      url: changeInfo.url
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'MINIMIZE') {
    const message = {
      type: 'MINIMIZE'
    };
    chrome.tabs.query({
      active: true,
      currentWindow: true
    }, tabs => {
      chrome.tabs.sendMessage(tabs[0].id, message);
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'openTab') {
    chrome.tabs.create({
      url: message.url
    });
  }
});
const queue = [];
let isProcessing = false;
const retryDelay = 1000;
chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
  if (request.linkedinAction === 'getProfileContactInfo') {
    fetchAndImportProfileData(request.profileId).then(result => {
      sendResponse({
        result
      });
    }).catch(error => {
      console.error('Error fetching profile data and contact info', error);
      sendResponse({
        error
      });
    });
  }
  return true; // Indicates we are sending an async response
});
chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
  if (request.linkedinAction === 'getCompanyProfile') {
    fetchCompanyData(request.profileId).then(result => {
      sendResponse({
        result
      });
    }).catch(error => {
      console.error('Error fetching company data', error);
      sendResponse({
        error
      });
    });
  }
  return true; // Indicates we are sending an async response
});
function fetchCompanyData(profileId) {
  console.log('Fetching profile data for profileId:', profileId);
  return new Promise((resolve, reject) => {
    if (!profileId) reject();
    const url = "https://www.linkedin.com/voyager/api/graphql?variables=(universalName:".concat(profileId, ")&&queryId=voyagerOrganizationDashCompanies.4fbcd4df2d3e37fcf3a4f5296be958b9");
    console.log('Fetching profile data from:', url);
    sendRequest(url).then(response => {
      if (response) {
        var _response$data, _companyData$foundedO, _companyData$industry, _companyData$logoReso, _companyData$logoReso2;
        console.log('Company record fetched', response);
        const companyData = response === null || response === void 0 || (_response$data = response.data) === null || _response$data === void 0 || (_response$data = _response$data.organizationDashCompaniesByUniversalName) === null || _response$data === void 0 || (_response$data = _response$data.elements) === null || _response$data === void 0 ? void 0 : _response$data[0];
        resolve({
          name: companyData.name,
          description: companyData.description,
          employeeCount: companyData.employeeCount,
          foundedYear: (_companyData$foundedO = companyData.foundedOn) === null || _companyData$foundedO === void 0 ? void 0 : _companyData$foundedO.year,
          website: companyData.websiteUrl,
          industry: (_companyData$industry = companyData.industry) === null || _companyData$industry === void 0 || (_companyData$industry = _companyData$industry[0]) === null || _companyData$industry === void 0 ? void 0 : _companyData$industry.name,
          image: "".concat((_companyData$logoReso = companyData.logoResolutionResult) === null || _companyData$logoReso === void 0 || (_companyData$logoReso = _companyData$logoReso.vectorImage) === null || _companyData$logoReso === void 0 ? void 0 : _companyData$logoReso.rootUrl).concat((_companyData$logoReso2 = companyData.logoResolutionResult) === null || _companyData$logoReso2 === void 0 || (_companyData$logoReso2 = _companyData$logoReso2.vectorImage) === null || _companyData$logoReso2 === void 0 || (_companyData$logoReso2 = _companyData$logoReso2.artifacts[0]) === null || _companyData$logoReso2 === void 0 ? void 0 : _companyData$logoReso2.fileIdentifyingUrlPathSegment)
        });
        return;
      } else {
        console.error('Company record not fetched');
      }
    }).catch(error => {
      console.error('Error fetching Company record', error);
    });
  });
}

// Function that fetches both profile data and contact info, and imports it
async function fetchAndImportProfileData(profileId) {
  try {
    // First fetch profile data
    const profileData = await fetchProfileData(profileId);

    // Then fetch profile contact info
    const contactInfo = await getProfileContactInfo(profileId);
    return {
      ...profileData,
      ...contactInfo
    };
  } catch (error) {
    console.error('Error in fetchAndImportProfileData', error);
    throw error;
  }
}
function fetchProfileData(profileId) {
  // console.log("Fetching profile data for profileId:", profileId);
  return new Promise((resolve, reject) => {
    if (!profileId) reject();
    const url = 'https://www.linkedin.com/voyager/api/identity/profiles/' + profileId + '/profileView';
    // console.log("Fetching profile data from:", url);
    sendRequest(url).then(response => {
      if (response) {
        console.log('Profile data fetched successfully second', response);
        resolve({
          address: response.profile.geoLocationName && response.profile.geoCountryName ? "".concat(response.profile.geoLocationName, ", ").concat(response.profile.geoCountryName) : '',
          languages: response.languageView !== undefined ? response.languageView.elements : '',
          firstName: response.profile.firstName,
          lastName: response.profile.lastName,
          linkedInProfileHeadline: response.profile.headline,
          about: response.profile.summary,
          education: response.educationView.elements,
          skills: response.skillView ? response.skillView.elements : '',
          companies: response.positionView ? response.positionView.elements : '',
          certifications: response !== null && response !== void 0 && response.certificationView ? response === null || response === void 0 ? void 0 : response.certificationView.elements : '',
          projects: response.projectView ? response.projectView.elements : '',
          publications: response.publicationView ? response.publicationView.elements : '',
          honors: response.honorView ? response.honorView.elements : '',
          volunteerWorks: response.volunteerExperienceView ? response.volunteerExperienceView.elements : '',
          encodedUsername: response.entityUrn.replace('urn:li:fs_profileView:', ''),
          linkedInUrl: "https://www.linkedin.com/in/".concat(response.profile.miniProfile.publicIdentifier)
        });
      } else {
        console.error('No profile data found.');
        reject(null);
      }
    }).catch(error => {
      console.error('Error fetching profile data', error);
      reject(error);
    });
  });
}
function getProfileContactInfo(profileId) {
  return new Promise((resolve, reject) => {
    if (!profileId) {
      console.error('Invalid profileId');
      return reject();
    }
    const url = "https://www.linkedin.com/voyager/api/identity/profiles/".concat(profileId, "/profileContactInfo");
    sendRequest(url).then(async response => {
      if (response) {
        console.log('Profile contact info fetched successfully', response);
        let profileUrlWithName = "https://www.linkedin.com/in/".concat(profileId);
        const profileUrl = response.entityUrn !== undefined && response.entityUrn.length > 0 ? "https://www.linkedin.com/in/".concat(response.entityUrn.replace('urn:li:fs_profileView:', '').replace('urn:li:fs_contactinfo:', '')) : '';
        if (profileUrl === "https://www.linkedin.com/in/".concat(profileId)) {
          const profileData = await fetchProfileData(profileId);
          profileUrlWithName = profileData.profileUrlWithName;
        }
        resolve({
          profileUrl: response.entityUrn,
          email: response.emailAddress,
          website: response.websites,
          phone: response.phoneNumbers,
          skypeId: response.ims,
          birthDate: response.birthDateOn,
          connectedOn: response.connectedAt,
          profileUrlWithName
        });
        return;
      }
      console.error('No response data');
      reject(null);
    }).catch(error => {
      console.error('Error in getProfileContactInfo', error);
      reject(error);
    });
  });
}
async function sendRequest(url) {
  let method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GET';
  let body = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return new Promise((resolve, reject) => {
    queue.push({
      url,
      method,
      body,
      resolve,
      reject
    });
    if (isProcessing) {
      return;
    }
    processQueue();
  });
  function processQueue() {
    if (queue.length === 0) {
      isProcessing = false;
      return;
    }
    isProcessing = true;
    let {
      url,
      method,
      body,
      resolve,
      reject
    } = queue.shift();
    if (!url) {
      console.error('URL is required');
      reject(new Error('URL is required'));
      isProcessing = false;
      return;
    }
    getCsrfToken().then(csrfToken => {
      // console.log("CSRF token fetched:", csrfToken);
      if (body) body = JSON.stringify(body);
      fetch(url, {
        method,
        headers: {
          'x-restli-protocol-version': '2.0.0',
          'csrf-token': csrfToken,
          'x-li-track': JSON.stringify({
            clientVersion: '1.5.*',
            osName: 'web',
            timezoneOffset: 1,
            deviceFormFactor: 'DESKTOP',
            mpName: 'voyager-web'
          })
        },
        credentials: 'include',
        body
      }).then(response => {
        // console.log("Response received:", response);
        return response.status >= 200 && response.status < 300 ? response.text() : response.headers.get('content-type').includes('application/json') ? response.json().then(error => {
          console.error('Error response (JSON)', error);
          reject(JSON.stringify(error));
        }) : response.text();
      }).then(response => {
        // console.log("Response processed:", response);
        resolve(response.startsWith('<') ? response : JSON.parse(response));
      }).catch(error => {
        console.error('Fetch error:', error);
        reject(error);
      }).finally(() => {
        // console.log("Request processing finished");
        isProcessing = false;
        setTimeout(processQueue, retryDelay);
      });
    }).catch(error => {
      console.error('Error fetching CSRF token', error);
      reject(error);
      isProcessing = false;
    });
  }
}
function getCookies() {
  return new Promise((resolve, reject) => {
    chrome.cookies.getAll({
      url: 'https://www.linkedin.com'
    }, cookies => {
      if (cookies.length > 0) {
        let cookieString = cookies === null || cookies === void 0 ? void 0 : cookies.map(cookie => cookie.name + '=' + cookie.value).join('; ');
        resolve(cookieString);
      } else {
        console.error('No cookies found or user not logged in.');
        reject('User is not correctly logged in.');
      }
    });
  });
}
function getCsrfToken() {
  return new Promise((resolve, reject) => {
    chrome.cookies.get({
      url: 'https://www.linkedin.com',
      name: 'JSESSIONID'
    }, cookie => {
      if (!cookie || !cookie.value) {
        console.error('CSRF token not found or invalid.');
        reject('User is not correctly logged in.');
      } else {
        resolve(cookie.value.slice(1, -1));
      }
    });
  });
}
function getAuthToken() {
  return new Promise((resolve, reject) => {
    chrome.cookies.get({
      url: 'YOUR_DOMAIN_URL',
      name: 'YOUR_COOKIE_NAME'
    }, cookie => {
      if (cookie) {
        resolve(cookie.value);
      } else {
        console.error('Auth token not found');
        reject('');
      }
    });
  });
}
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'REMOVE_COOKIES') {
    const cookiesToRemove = request.cookies;
    const domains = request.domains;
    chrome.storage.local.remove('ipAddress');
    domains.forEach(domain => {
      cookiesToRemove.forEach(cookieName => {
        chrome.cookies.remove({
          url: domain,
          name: cookieName
        }, details => {
          // if (details) {
          //   console.log(`Cookie "${cookieName}" removed from ${domain}`);
          // } else {
          //   console.log(
          //     `Failed to remove cookie: "${cookieName}" from ${domain}`
          //   );
          // }
        });
      });
    });
    chrome.tabs.query({}, tabs => {
      tabs.forEach(tab => {
        if (domains.some(domain => {
          var _tab$url;
          return (_tab$url = tab.url) === null || _tab$url === void 0 ? void 0 : _tab$url.startsWith(domain);
        })) {
          chrome.tabs.reload(tab.id);
        }
      });
    });
    sendResponse({
      success: true
    });
  }
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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