/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js":
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* binding */ AbortedDeferredError),
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   IDLE_BLOCKER: () => (/* binding */ IDLE_BLOCKER),
/* harmony export */   IDLE_FETCHER: () => (/* binding */ IDLE_FETCHER),
/* harmony export */   IDLE_NAVIGATION: () => (/* binding */ IDLE_NAVIGATION),
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: () => (/* binding */ UNSAFE_DEFERRED_SYMBOL),
/* harmony export */   UNSAFE_DeferredData: () => (/* binding */ DeferredData),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* binding */ ErrorResponseImpl),
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: () => (/* binding */ convertRouteMatchToUiMatch),
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: () => (/* binding */ convertRoutesToDataRoutes),
/* harmony export */   UNSAFE_getResolveToMatches: () => (/* binding */ getResolveToMatches),
/* harmony export */   UNSAFE_invariant: () => (/* binding */ invariant),
/* harmony export */   UNSAFE_warning: () => (/* binding */ warning),
/* harmony export */   createBrowserHistory: () => (/* binding */ createBrowserHistory),
/* harmony export */   createHashHistory: () => (/* binding */ createHashHistory),
/* harmony export */   createMemoryHistory: () => (/* binding */ createMemoryHistory),
/* harmony export */   createPath: () => (/* binding */ createPath),
/* harmony export */   createRouter: () => (/* binding */ createRouter),
/* harmony export */   createStaticHandler: () => (/* binding */ createStaticHandler),
/* harmony export */   defer: () => (/* binding */ defer),
/* harmony export */   generatePath: () => (/* binding */ generatePath),
/* harmony export */   getStaticContextFromError: () => (/* binding */ getStaticContextFromError),
/* harmony export */   getToPathname: () => (/* binding */ getToPathname),
/* harmony export */   isDeferredData: () => (/* binding */ isDeferredData),
/* harmony export */   isRouteErrorResponse: () => (/* binding */ isRouteErrorResponse),
/* harmony export */   joinPaths: () => (/* binding */ joinPaths),
/* harmony export */   json: () => (/* binding */ json),
/* harmony export */   matchPath: () => (/* binding */ matchPath),
/* harmony export */   matchRoutes: () => (/* binding */ matchRoutes),
/* harmony export */   normalizePathname: () => (/* binding */ normalizePathname),
/* harmony export */   parsePath: () => (/* binding */ parsePath),
/* harmony export */   redirect: () => (/* binding */ redirect),
/* harmony export */   redirectDocument: () => (/* binding */ redirectDocument),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   resolveTo: () => (/* binding */ resolveTo),
/* harmony export */   stripBasename: () => (/* binding */ stripBasename)
/* harmony export */ });
/**
 * @remix-run/router v1.15.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, index];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname) {
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    if (!match) return null;
    Object.assign(matchedParams, match.params);
    let route = meta.route;
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname = toPathname ? toPathname.startsWith("/") ? toPathname : resolvePathname(toPathname, fromPathname) : fromPathname;
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === matches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialErrors = null;
  if (initialMatches == null) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  let initialized;
  let hasLazyRoutes = initialMatches.some(m => m.route.lazy);
  let hasLoaders = initialMatches.some(m => m.route.loader);
  if (hasLazyRoutes) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!hasLoaders) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    initialized = initialMatches.every(m => m.route.loader && m.route.loader.hydrate !== true && (loaderData && loaderData[m.route.id] !== undefined || errors && errors[m.route.id] !== undefined));
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = [];
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let ignoreNextHistoryUpdate = false;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (ignoreNextHistoryUpdate) {
        ignoreNextHistoryUpdate = false;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        ignoreNextHistoryUpdate = true;
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked
            init.history.go(delta);
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      unstable_viewTransitionOpts: opts.viewTransitionOpts,
      unstable_flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
    cancelledFetcherLoads = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.unstable_viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(routesToUse);
      // Cancel all pending deferred on 404s since we don't keep any routes
      cancelActiveDeferreds();
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial load will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionData;
    let pendingError;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingError = {
        [findNearestBoundary(matches).route.id]: opts.pendingError
      };
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionOutput = await handleAction(request, location, opts.submission, matches, {
        replace: opts.replace,
        flushSync
      });
      if (actionOutput.shortCircuited) {
        return;
      }
      pendingActionData = actionOutput.pendingActionData;
      pendingError = actionOutput.pendingActionError;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // Create a GET request for the loaders
      request = new Request(request.url, {
        signal: request.signal
      });
    }
    // Call loaders
    let {
      shortCircuited,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionData, pendingError);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches
    }, pendingActionData ? {
      actionData: pendingActionData
    } : {}, {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      result = await callLoaderOrAction("action", request, actionMatch, matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath);
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        replace = result.location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(state, result, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions are REPLACE navigations, but if the
      // action threw an error that'll be rendered in an errorElement, we fall
      // back to PUSH so that the user can use the back button to get back to
      // the pre-submission form location to try again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        // Send back an empty object we can use to clear out any prior actionData
        pendingActionData: {},
        pendingActionError: {
          [boundaryMatch.route.id]: result.error
        }
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    return {
      pendingActionData: {
        [actionMatch.route.id]: result.data
      }
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionData, pendingError) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionData, pendingError);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingError || null
      }, pendingActionData ? {
        actionData: pendingActionData
      } : {}, updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    if (!isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration)) {
      revalidatingFetchers.forEach(rf => {
        let fetcher = state.fetchers.get(rf.key);
        let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
        state.fetchers.set(rf.key, revalidatingFetcher);
      });
      let actionData = pendingActionData || state.actionData;
      updateState(_extends({
        navigation: loadingNavigation
      }, actionData ? Object.keys(actionData).length === 0 ? {
        actionData: null
      } : {
        actionData
      } : {}, revalidatingFetchers.length > 0 ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      if (fetchControllers.has(rf.key)) {
        abortFetcher(rf.key);
      }
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      results,
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state.matches, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect(results);
    if (redirect) {
      if (redirect.idx >= matchesToLoad.length) {
        // If this redirect came from a fetcher make sure we mark it in
        // fetchRedirectIds so it doesn't get revalidated on the next set of
        // loader executions
        let fetcherKey = revalidatingFetchers[redirect.idx - matchesToLoad.length].key;
        fetchRedirectIds.add(fetcherKey);
      }
      await startRedirectNavigation(state, redirect.result, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, matchesToLoad, loaderResults, pendingError, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // During partial hydration, preserve SSR errors for routes that don't re-run
    if (future.v7_partialHydration && initialHydration && state.errors) {
      Object.entries(state.errors).filter(_ref2 => {
        let [id] = _ref2;
        return !matchesToLoad.some(m => m.route.id === id);
      }).forEach(_ref3 => {
        let [routeId, error] = _ref3;
        errors = Object.assign(errors || {}, {
          [routeId]: error
        });
      });
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    if (fetchControllers.has(key)) abortFetcher(key);
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, flushSync, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, flushSync, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, flushSync, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    if (!match.route.action && !match.route.lazy) {
      let error = getInternalRouterError(405, {
        method: submission.formMethod,
        pathname: path,
        routeId: routeId
      });
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    // Call the action for the fetcher
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResult = await callLoaderOrAction("action", fetchRequest, match, requestMatches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath);
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(state, actionResult, {
            fetcherSubmission: submission
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, {
      [match.route.id]: actionResult.data
    }, undefined // No need to send through errors since we short circuit above
    );
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      if (fetchControllers.has(staleKey)) {
        abortFetcher(staleKey);
      }
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      results,
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state.matches, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect(results);
    if (redirect) {
      if (redirect.idx >= matchesToLoad.length) {
        // If this redirect came from a fetcher make sure we mark it in
        // fetchRedirectIds so it doesn't get revalidated on the next set of
        // loader executions
        let fetcherKey = revalidatingFetchers[redirect.idx - matchesToLoad.length].key;
        fetchRedirectIds.add(fetcherKey);
      }
      return startRedirectNavigation(state, redirect.result);
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, state.matches, matchesToLoad, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, flushSync, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    // Call the loader for this fetcher route match
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let result = await callLoaderOrAction("loader", fetchRequest, match, matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath);
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(state, result);
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(state, redirect, _temp2) {
    let {
      submission,
      fetcherSubmission,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.revalidate) {
      isRevalidationRequired = true;
    }
    let redirectLocation = createLocation(state.location, redirect.location, {
      _isRedirect: true
    });
    invariant(redirectLocation, "Expected a location on the redirect navigation");
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.reloadDocument) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(redirect.location)) {
        const url = init.history.createURL(redirect.location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(redirect.location);
        } else {
          routerWindow.location.assign(redirect.location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: redirect.location
        }),
        // Preserve this flag across redirects
        preventScrollReset: pendingPreventScrollReset
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve this flag across redirects
        preventScrollReset: pendingPreventScrollReset
      });
    }
  }
  async function callLoadersAndMaybeResolveData(currentMatches, matches, matchesToLoad, fetchersToLoad, request) {
    // Call all navigation loaders and revalidating fetcher loaders in parallel,
    // then slice off the results into separate arrays so we can handle them
    // accordingly
    let results = await Promise.all([...matchesToLoad.map(match => callLoaderOrAction("loader", request, match, matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath)), ...fetchersToLoad.map(f => {
      if (f.matches && f.match && f.controller) {
        return callLoaderOrAction("loader", createClientSideRequest(init.history, f.path, f.controller.signal), f.match, f.matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath);
      } else {
        let error = {
          type: ResultType.error,
          error: getInternalRouterError(404, {
            pathname: f.path
          })
        };
        return error;
      }
    })]);
    let loaderResults = results.slice(0, matchesToLoad.length);
    let fetcherResults = results.slice(matchesToLoad.length);
    await Promise.all([resolveDeferredResults(currentMatches, matchesToLoad, loaderResults, loaderResults.map(() => request.signal), false, state.loaderData), resolveDeferredResults(currentMatches, fetchersToLoad.map(f => f.match), fetcherResults, fetchersToLoad.map(f => f.controller ? f.controller.signal : null), true)]);
    return {
      results,
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.push(key);
        abortFetcher(key);
      }
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    if (future.v7_fetcherPersist) {
      activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
      // If this fetcher was previously marked for deletion, unmark it since we
      // have a new instance
      if (deletedFetchers.has(key)) {
        deletedFetchers.delete(key);
      }
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    deletedFetchers.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    if (future.v7_fetcherPersist) {
      let count = (activeFetchers.get(key) || 0) - 1;
      if (count <= 0) {
        activeFetchers.delete(key);
        deletedFetchers.add(key);
      } else {
        activeFetchers.set(key, count);
      }
    } else {
      deleteFetcher(key);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    invariant(controller, "Expected fetch controller: " + key);
    controller.abort();
    fetchControllers.delete(key);
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref4) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref4;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   */
  async function query(request, _temp3) {
    let {
      requestContext
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction, we throw
      // it to bail out and then return or throw here based on whether the user
      // returned or threw
      if (isQueryRouteResponse(e)) {
        if (e.type === ResultType.error) {
          throw e.response;
        }
        return e.response;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      result = await callLoaderOrAction("action", request, actionMatch, matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath, {
        isStaticRequest: true,
        isRouteRequest,
        requestContext
      });
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.status,
        headers: {
          Location: result.location
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(request, matches, requestContext, undefined, {
        [boundaryMatch.route.id]: result.error
      });
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    let context = await loadRouteData(loaderRequest, matches, requestContext);
    return _extends({}, context, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionData: {
        [actionMatch.route.id]: result.data
      },
      actionHeaders: _extends({}, result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {})
    });
  }
  async function loadRouteData(request, matches, requestContext, routeMatch, pendingActionError) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : getLoaderMatchesUntilBoundary(matches, Object.keys(pendingActionError || {})[0]);
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionError || null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await Promise.all([...matchesToLoad.map(match => callLoaderOrAction("loader", request, match, matches, manifest, mapRouteProperties, basename, future.v7_relativeSplatPath, {
      isStaticRequest: true,
      isRouteRequest,
      requestContext
    }))]);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, matchesToLoad, results, pendingActionError, activeDeferreds);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Add an ?index param for matched index routes if we don't already have one
  if ((to == null || to === "" || to === ".") && activeRouteMatch && activeRouteMatch.route.index && !hasNakedIndexQuery(path.search)) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref5) => {
        let [name, value] = _ref5;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId) {
  let boundaryMatches = matches;
  if (boundaryId) {
    let index = matches.findIndex(m => m.route.id === boundaryId);
    if (index >= 0) {
      boundaryMatches = matches.slice(0, index);
    }
  }
  return boundaryMatches;
}
function getMatchesToLoad(history, state, matches, submission, location, isInitialLoad, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionData, pendingError) {
  let actionResult = pendingError ? Object.values(pendingError)[0] : pendingActionData ? Object.values(pendingActionData)[0] : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryId = pendingError ? Object.keys(pendingError)[0] : undefined;
  let boundaryMatches = getLoaderMatchesUntilBoundary(matches, boundaryId);
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (isInitialLoad) {
      if (route.loader.hydrate) {
        return true;
      }
      return state.loaderData[route.id] === undefined && (
      // Don't re-run if the loader ran and threw an error
      !state.errors || state.errors[route.id] === undefined);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      defaultShouldRevalidate:
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired ||
      // Clicked the same link, resubmitted a GET form
      currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial load (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (isInitialLoad || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.includes(key)) {
      // Always revalidate if the fetcher was cancelled
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        defaultShouldRevalidate: isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
async function callLoaderOrAction(type, request, match, matches, manifest, mapRouteProperties, basename, v7_relativeSplatPath, opts) {
  if (opts === void 0) {
    opts = {};
  }
  let resultType;
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    return Promise.race([handler({
      request,
      params: match.params,
      context: opts.requestContext
    }), abortPromise]);
  };
  try {
    let handler = match.route[type];
    if (match.route.lazy) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let values = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadLazyRouteModule(match.route, mapRouteProperties, manifest)]);
        if (handlerError) {
          throw handlerError;
        }
        result = values[0];
      } else {
        // Load lazy route module, then run any returned handler
        await loadLazyRouteModule(match.route, mapRouteProperties, manifest);
        handler = match.route[type];
        if (handler) {
          // Handler still run even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            data: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    resultType = ResultType.error;
    result = e;
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  if (isResponse(result)) {
    let status = result.status;
    // Process redirects
    if (redirectStatusCodes.has(status)) {
      let location = result.headers.get("Location");
      invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
      // Support relative routing in internal redirects
      if (!ABSOLUTE_URL_REGEX.test(location)) {
        location = normalizeTo(new URL(request.url), matches.slice(0, matches.indexOf(match) + 1), basename, true, location, v7_relativeSplatPath);
      } else if (!opts.isStaticRequest) {
        // Strip off the protocol+origin for same-origin + same-basename absolute
        // redirects. If this is a static request, we can let it go back to the
        // browser as-is
        let currentUrl = new URL(request.url);
        let url = location.startsWith("//") ? new URL(currentUrl.protocol + location) : new URL(location);
        let isSameBasename = stripBasename(url.pathname, basename) != null;
        if (url.origin === currentUrl.origin && isSameBasename) {
          location = url.pathname + url.search + url.hash;
        }
      }
      // Don't process redirects in the router during static requests requests.
      // Instead, throw the Response and let the server handle it with an HTTP
      // redirect.  We also update the Location header in place in this flow so
      // basename and relative routing is taken into account
      if (opts.isStaticRequest) {
        result.headers.set("Location", location);
        throw result;
      }
      return {
        type: ResultType.redirect,
        status,
        location,
        revalidate: result.headers.get("X-Remix-Revalidate") !== null,
        reloadDocument: result.headers.get("X-Remix-Reload-Document") !== null
      };
    }
    // For SSR single-route requests, we want to hand Responses back directly
    // without unwrapping.  We do this with the QueryRouteResponse wrapper
    // interface so we can know whether it was returned or thrown
    if (opts.isRouteRequest) {
      let queryRouteResponse = {
        type: resultType === ResultType.error ? ResultType.error : ResultType.data,
        response: result
      };
      throw queryRouteResponse;
    }
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (resultType === ResultType.error) {
      return {
        type: resultType,
        error: new ErrorResponseImpl(status, result.statusText, data),
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (resultType === ResultType.error) {
    return {
      type: resultType,
      error: result
    };
  }
  if (isDeferredData(result)) {
    var _result$init, _result$init2;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status,
      headers: ((_result$init2 = result.init) == null ? void 0 : _result$init2.headers) && new Headers(result.init.headers)
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, matchesToLoad, results, pendingError, activeDeferreds) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  // Process loader results into state.loaderData/state.errors
  results.forEach((result, index) => {
    let id = matchesToLoad[index].route.id;
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      // Look upwards from the matched route for the closest ancestor
      // error boundary, defaulting to the root match
      let boundaryMatch = findNearestBoundary(matches, id);
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError) {
        error = Object.values(pendingError)[0];
        pendingError = undefined;
      }
      errors = errors || {};
      // Prefer higher error values if lower errors bubble to the same boundary
      if (errors[boundaryMatch.route.id] == null) {
        errors[boundaryMatch.route.id] = error;
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
      } else {
        loaderData[id] = result.data;
      }
      // Error status codes always override success status codes, but if all
      // loaders are successful we take the deepest status code.
      if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
        statusCode = result.statusCode;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError) {
    errors = pendingError;
    loaderData[Object.keys(pendingError)[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, matchesToLoad, results, pendingError, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, matchesToLoad, results, pendingError, activeDeferreds);
  // Process results from our revalidating fetchers
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      match,
      controller
    } = revalidatingFetchers[index];
    invariant(fetcherResults !== undefined && fetcherResults[index] !== undefined, "Did not find corresponding fetcher result");
    let result = fetcherResults[index];
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      continue;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  for (let i = results.length - 1; i >= 0; i--) {
    let result = results[i];
    if (isRedirectResult(result)) {
      return {
        result,
        idx: i
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isQueryRouteResponse(obj) {
  return obj && isResponse(obj.response) && (obj.type === ResultType.data || obj.type === ResultType.error);
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveDeferredResults(currentMatches, matchesToLoad, results, signals, isFetcher, currentLoaderData) {
  for (let index = 0; index < results.length; index++) {
    let result = results[index];
    let match = matchesToLoad[index];
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && (isFetcher || isRevalidatingLoader)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      let signal = signals[index];
      invariant(signal, "Expected an AbortSignal for revalidating fetcher deferred result");
      await resolveDeferredData(result, signal, isFetcher).then(result => {
        if (result) {
          results[index] = result || results[index];
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ }),

/***/ "./src/ExtractionClasses/linkedin.js":
/*!*******************************************!*\
  !*** ./src/ExtractionClasses/linkedin.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   linkedInClasses: () => (/* binding */ linkedInClasses)
/* harmony export */ });
const linkedInClasses = {
  BulkSearch: {
    name: "t-roman",
    about: "entity-result__primary-subtitle",
    profileUrl: "t-roman",
    // imageUrl: "presence-entity presence-entity--size-3",
    imageUrl: "display-flex align-items-center"
  },
  IndivitualSearch: {
    name: "text-heading-xlarge",
    about: "text-body-medium",
    profileUrl: "artdeco-hoverable-trigger--content-placed-bottom",
    imageUrl: "pv-top-card--photo-resize",
    imageUrl2: "pv-top-card__edit-photo"
  },
  Connections: {
    name: "mn-connection-card__name",
    about: "mn-connection-card__occupation",
    profileUrl: "mn-connection-card__link",
    imageUrl: "mn-connection-card artdeco-list"
  }
};

/***/ }),

/***/ "./src/component/BizAnalyzerPeople/employCard/index.js":
/*!*************************************************************!*\
  !*** ./src/component/BizAnalyzerPeople/employCard/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/location.svg */ "./public/assets/location.svg");
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/industry.svg */ "./public/assets/industry.svg");
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const BizEmployCard = _ref => {
  var _employee$linkedin, _employee$linkedin2;
  let {
    employee
  } = _ref;
  if (!employee) return null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "!tww-bg-white !tww-p-4 !tww-rounded-lg !tww-shadow-md !tww-border !tww-mb-4 !tww-flex !tww-flex-col !tww-items-center !tww-text-center",
    style: {
      border: "1px solid #F0F0F0"
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "!tww-flex !tww-w-full !tww-justify-between !tww-mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "!tww-flex",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
          src: employee === null || employee === void 0 ? void 0 : employee.image,
          alt: "".concat(employee === null || employee === void 0 ? void 0 : employee.firstName, "'s profile"),
          className: "!tww-rounded-lg",
          style: {
            width: "60px",
            height: "60px",
            objectFit: "cover"
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "!tww-ml-4 !tww-text-left",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("h3", {
            className: "f-14-600 !tww-text-gray-900",
            children: "".concat(employee === null || employee === void 0 ? void 0 : employee.firstName, " ").concat(employee === null || employee === void 0 ? void 0 : employee.lastName)
          }), (employee === null || employee === void 0 ? void 0 : employee.tagline) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
            className: "f-14-400 !tww-text-gray-700 !tww-mt-1 !tww-truncate",
            style: {
              maxWidth: "200px"
            },
            children: employee === null || employee === void 0 ? void 0 : employee.tagline
          })]
        })]
      }), (employee === null || employee === void 0 || (_employee$linkedin = employee.linkedin) === null || _employee$linkedin === void 0 ? void 0 : _employee$linkedin.url) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("a", {
        href: employee === null || employee === void 0 || (_employee$linkedin2 = employee.linkedin) === null || _employee$linkedin2 === void 0 ? void 0 : _employee$linkedin2.url,
        target: "_blank",
        rel: "noopener noreferrer",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
          src: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_1___default()),
          alt: "LinkedIn",
          style: {
            width: "20px",
            height: "20px"
          }
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "!tww-flex !tww-justify-between !tww-items-center !tww-px-2 !tww-mt-2 !tww-w-full",
      children: [(employee === null || employee === void 0 ? void 0 : employee.industry) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-mr-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
          src: (_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_3___default()),
          alt: "Industry",
          className: "!tww-mr-2",
          style: {
            width: "16px",
            height: "16px"
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
          className: "f-12-500 !tww-text-gray-600",
          children: employee === null || employee === void 0 ? void 0 : employee.industry
        })]
      }), (employee === null || employee === void 0 ? void 0 : employee.location) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
          src: (_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_2___default()),
          alt: "Location",
          className: "!tww-mr-2",
          style: {
            width: "16px",
            height: "16px"
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
          className: "f-12-500 !tww-text-gray-600",
          children: employee === null || employee === void 0 ? void 0 : employee.location
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("button", {
      className: "!tww-w-full !tww-mt-4 !tww-text-white !tww-rounded-lg !tww-py-2 f-14-600",
      style: {
        backgroundColor: "#7b7aff",
        cursor: "pointer"
      },
      onClick: () => {
        var _employee$linkedIn;
        window.open("https://".concat(employee === null || employee === void 0 || (_employee$linkedIn = employee.linkedIn) === null || _employee$linkedIn === void 0 ? void 0 : _employee$linkedIn.url), "_blank");
      },
      children: "View Profile"
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizEmployCard);

/***/ }),

/***/ "./src/component/BizAnalyzerPeople/index.js":
/*!**************************************************!*\
  !*** ./src/component/BizAnalyzerPeople/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _BizAnalyzer_companyAbout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../BizAnalyzer/companyAbout */ "./src/component/BizAnalyzer/companyAbout/index.js");
/* harmony import */ var _dummyJson_companyDummy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../dummyJson/companyDummy */ "./src/dummyJson/companyDummy.js");
/* harmony import */ var _employCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./employCard */ "./src/component/BizAnalyzerPeople/employCard/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");








const BizAnalyzerPeople = () => {
  var _companyData$currentE;
  const [searchTerm, setSearchTerm] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("");
  const [companyData, setCompanyData] = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.companySearchDataState);

  // Combine current
  const allEmployees = companyData !== null && companyData !== void 0 && (_companyData$currentE = companyData.currentEmployees) !== null && _companyData$currentE !== void 0 && _companyData$currentE.length ? [...(companyData === null || companyData === void 0 ? void 0 : companyData.currentEmployees)] : [];

  // Filter employees based on search term
  const filteredEmployees = allEmployees.filter(employee => "".concat(employee === null || employee === void 0 ? void 0 : employee.firstName, " ").concat(employee === null || employee === void 0 ? void 0 : employee.lastName).toLowerCase().includes(searchTerm.toLowerCase()));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_BizAnalyzer_companyAbout__WEBPACK_IMPORTED_MODULE_1__["default"], {
      company: companyData === null || companyData === void 0 ? void 0 : companyData.company
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "!tww-bg-white !tww-rounded-lg !tww-shadow-md !tww-p-4 !tww-mt-6",
      style: {
        border: "1px solid #F0F0F0"
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h2", {
        className: "f-16-500 !tww-text-gray-900 !tww-mb-4",
        children: "Employees"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
        type: "text",
        placeholder: "Search employees...",
        value: searchTerm,
        onChange: e => setSearchTerm(e.target.value),
        className: "!tww-w-full !tww-p-2 !tww-mb-4 !tww-border !tww-rounded-lg f-14-400 !tww-text-gray-700",
        style: {
          border: "1px solid #F0F0F0"
        }
      }), filteredEmployees.length > 0 ? filteredEmployees === null || filteredEmployees === void 0 ? void 0 : filteredEmployees.map((employee, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_employCard__WEBPACK_IMPORTED_MODULE_3__["default"], {
        employee: employee
      }, index)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
        className: "f-14-400 !tww-text-gray-600",
        children: "No employees found."
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizAnalyzerPeople);

/***/ }),

/***/ "./src/component/BizAnalyzer/companyAbout/index.js":
/*!*********************************************************!*\
  !*** ./src/component/BizAnalyzer/companyAbout/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../App.css */ "./src/App.css");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const BizCompanyAbout = _ref => {
  let {
    company
  } = _ref;
  const [isExpanded, setIsExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);

  // Get description or fallback
  const description = (company === null || company === void 0 ? void 0 : company.about) || (company === null || company === void 0 ? void 0 : company.description) || "No information available about this company at the moment.";

  // Function to toggle 'See More' state
  const toggleExpanded = () => {
    setIsExpanded(!isExpanded);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "!tww-bg-white !tww-p-6 !tww-rounded-lg !tww-shadow-lg",
    style: {
      border: "1px solid #F0F0F0"
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
        src: (company === null || company === void 0 ? void 0 : company.image) || "https://via.placeholder.com/50",
        alt: "Company Logo",
        className: "!tww-rounded-full",
        style: {
          width: "50px",
          height: "50px"
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: "1.5",
        stroke: "currentColor",
        className: "!tww-text-gray-500 !tww-cursor-pointer",
        style: {
          width: "24px",
          height: "24px"
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
          strokeLinecap: "round",
          strokeLinejoin: "round",
          d: "M6.75 12a.75.75 0 110-1.5.75.75.75 0 010 1.5zM12 12a.75.75 0 110-1.5.75.75.75 0 010 1.5zM17.25 12a.75.75 0 110-1.5.75.75.75 0 010 1.5z"
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "!tww-mt-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h2", {
        className: "f-16-500",
        children: (company === null || company === void 0 ? void 0 : company.name) || "Unknown Company"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("p", {
        className: "f-14-400 !tww-mt-2",
        children: description.length <= 100 || isExpanded ? description : "".concat(description.substring(0, 100), "...")
      }), description.length > 100 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("button", {
        className: "f-12-500 !tww-text-blue-500 !tww-mt-2",
        onClick: toggleExpanded,
        style: {
          cursor: "pointer"
        },
        children: isExpanded ? "See Less" : "See More"
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizCompanyAbout);

/***/ }),

/***/ "./src/component/BizAnalyzer/companyDetails/index.js":
/*!***********************************************************!*\
  !*** ./src/component/BizAnalyzer/companyDetails/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_link_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/link.svg */ "./public/assets/link.svg");
/* harmony import */ var _public_assets_link_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_link_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/employ.svg */ "./public/assets/employ.svg");
/* harmony import */ var _public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../public/assets/founded.svg */ "./public/assets/founded.svg");
/* harmony import */ var _public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../public/assets/industry.svg */ "./public/assets/industry.svg");
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/location.svg */ "./public/assets/location.svg");
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../public/assets/phone.svg */ "./public/assets/phone.svg");
/* harmony import */ var _public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _public_assets_email_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../public/assets/email.svg */ "./public/assets/email.svg");
/* harmony import */ var _public_assets_email_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_public_assets_email_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");












const BizCompanyDetails = _ref => {
  let {
    company,
    websiteData,
    isLinkedIn
  } = _ref;
  const {
    name,
    foundedYear,
    location,
    details,
    industry,
    website,
    linkedin
  } = company || {};
  const {
    contactInfo,
    technologies
  } = websiteData || {};

  // Get email and phone arrays
  const emails = (contactInfo === null || contactInfo === void 0 ? void 0 : contactInfo.emails) || [];
  const phones = (contactInfo === null || contactInfo === void 0 ? void 0 : contactInfo.phones) || [];

  // Contact Section
  const contactData = [{
    category: 'Email',
    svg: (_public_assets_email_svg__WEBPACK_IMPORTED_MODULE_8___default()),
    values: emails === null || emails === void 0 ? void 0 : emails.map(e => e.email)
  }, {
    category: 'Phone',
    svg: (_public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_7___default()),
    values: phones === null || phones === void 0 ? void 0 : phones.map(p => p.phone)
  }];

  // General Information Section
  const generalData = [{
    category: 'Founded In',
    svg: (_public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4___default()),
    value: foundedYear || 'Not available'
  }, {
    category: 'HQ Location',
    svg: (_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6___default()),
    value: location || 'Not available'
  }, {
    category: 'Workforce Size',
    svg: (_public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3___default()),
    value: details || 'Not available'
  }, {
    category: 'Industry',
    svg: (_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5___default()),
    value: industry || 'Not available'
  }, {
    category: 'Website',
    svg: (_public_assets_link_svg__WEBPACK_IMPORTED_MODULE_1___default()),
    value: website ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("a", {
      href: website,
      className: "!tww-text-blue-500 f-14-500",
      target: "_blank",
      rel: "noopener noreferrer",
      children: "Visit page"
    }) : 'Not available'
  }, {
    category: 'Social',
    svg: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2___default()),
    value: linkedin ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("a", {
      href: linkedin,
      target: "_blank",
      rel: "noopener noreferrer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
        src: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2___default()),
        alt: "LinkedIn",
        style: {
          width: '18px'
        }
      })
    }) : 'Not available'
  }];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "!tww-p-6 !tww-bg-white !tww-border !tww-rounded-lg !tww-shadow-lg !tww-mt-5",
    style: {
      maxWidth: '600px',
      margin: 'auto',
      border: '1px solid #F0F0F0'
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h2", {
      className: "f-16-700 !tww-text-gray-800 !tww-mb-4",
      children: name || 'Company Details'
    }), generalData === null || generalData === void 0 ? void 0 : generalData.map((item, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between !tww-py-4 !tww-border-b last:!tww-border-none",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
          src: item.svg,
          alt: item.category,
          className: "!tww-mr-4",
          style: {
            width: '20px',
            height: '20px'
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
          className: "f-14-600 !tww-text-gray-800",
          children: item.category
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
        className: "f-14-400 !tww-text-gray-700 !tww-text-right",
        children: item.value
      })]
    }, idx)), !isLinkedIn && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "!tww-bg-gray-50 !tww-p-4 !tww-rounded-lg !tww-shadow-md !tww-mt-6",
        style: {
          border: '1px solid #E0E0E0'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h3", {
          className: "f-14-600 !tww-text-gray-800 !tww-mb-3",
          children: "Contact"
        }), contactData === null || contactData === void 0 ? void 0 : contactData.map((item, idx) => {
          var _item$values;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "!tww-mb-4",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "!tww-flex !tww-items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
                src: item.svg,
                alt: item.category,
                className: "!tww-mr-4",
                style: {
                  width: '20px',
                  height: '20px'
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
                className: "f-14-600 !tww-text-gray-800",
                children: item.category
              })]
            }), item.values.length > 0 ? (_item$values = item.values) === null || _item$values === void 0 ? void 0 : _item$values.map((value, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
              className: "f-14-500 !tww-text-gray-700 !tww-mt-2 !tww-truncate",
              children: value
            }, index)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
              className: "f-12-400 !tww-text-gray-600 !tww-mt-2",
              children: "Not available"
            })]
          }, idx);
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "!tww-bg-gray-50 !tww-p-4 !tww-rounded-lg !tww-shadow-md !tww-mt-6",
        style: {
          border: '1px solid #E0E0E0'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("h3", {
          className: "f-14-600 !tww-text-gray-800 !tww-mb-3",
          children: "Technologies"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "!tww-flex !tww-flex-wrap !tww-gap-2",
          children: technologies !== null && technologies !== void 0 && technologies.length ? technologies === null || technologies === void 0 ? void 0 : technologies.map((tech, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: "!tww-bg-blue-100 !tww-text-blue-800 !tww-px-3 !tww-py-2 !tww-rounded-lg f-14-500 !tww-truncate",
            style: {
              whiteSpace: 'nowrap'
            },
            children: tech
          }, idx)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
            className: "f-12-400 !tww-text-gray-600",
            children: "No technologies available"
          })
        })]
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizCompanyDetails);

/***/ }),

/***/ "./src/component/BizAnalyzer/index.js":
/*!********************************************!*\
  !*** ./src/component/BizAnalyzer/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _companyAbout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./companyAbout */ "./src/component/BizAnalyzer/companyAbout/index.js");
/* harmony import */ var _companyDetails__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./companyDetails */ "./src/component/BizAnalyzer/companyDetails/index.js");
/* harmony import */ var _showComfimation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./showComfimation */ "./src/component/BizAnalyzer/showComfimation/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");











const Loader = () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
  className: "!tww-loader",
  children: "Loading..."
});
const BizAnalyzer = () => {
  var _compnayData$company;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_7__.useApiRequest)();
  const isBizAnalyzerOnWebsiteRecoil = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.isBizAnalyzerOnWebsiteState);
  const [showCompanyDetails, setShowCompanyDetails] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isBizAnalyzerOnWebsite, setIsBizAnalyzerOnWebsite] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [compnayData, setCompnayData] = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.companySearchDataState);
  const [loading, setLoading] = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.companySearchLoaderState);
  const [companyUrl, setCompanyUrl] = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.companyUrlState);
  const [isLinkedIn, setIsLinkedIn] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [websiteDomain, setWebsiteDomain] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [credits, setCredits] = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.creditState);
  const searchCompany = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async (compnayData, sourceType) => {
    setLoading(true);
    try {
      const endpoint = sourceType === 'linkedin' ? "".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.companyURL, "/search") : "".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.companyURL, "/search/website");
      const {
        data
      } = await makeRequest(endpoint, 'POST', compnayData);
      setCompnayData({
        ...data,
        isLinkedIn: sourceType === 'linkedin'
      });
      updateCredits();
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: sourceType === 'linkedin' ? "Error with the ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.companyURL, "/search API in BizAnalyzer.js") : "Error with the ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.companyURL, "/search/website API in BizAnalyzer.js"),
        source: 'extension',
        module: 'Business Analyser'
      });
    } finally {
      setLoading(false);
    }
  }, []);
  const fetchLinkedInData = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async profileId => {
    return new Promise((resolve, reject) => {
      chrome.runtime.sendMessage({
        linkedinAction: 'getCompanyProfile',
        profileId
      }, response => {
        if (response.error) {
          reject(response.error);
          return;
        }
        const data = {
          ...response.result,
          linkedIn: "https://www.linkedin.com/company/".concat(profileId)
        };
        searchCompany(data, 'linkedin');
        resolve(response.result);
      });
    });
  }, [searchCompany]);
  const updateCredits = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.credit), 'GET');
      setCredits(data.credits);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with \n          ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.credit, " GET API in BizAnlayzer.js file"),
        source: 'extension',
        module: 'Update credits - Business Analyser'
      });
    }
  };
  const fetchWebsiteData = async () => {
    if (!websiteDomain) return;
    searchCompany({
      website: websiteDomain
    }, 'website');
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const url = window.location.href;
    const linkedInMatch = url.match(/\/company\/([^\/]+)/);
    if (linkedInMatch) {
      setIsLinkedIn(true);
    }
    if (url === companyUrl) return;
    setCompanyUrl(url);
    if (linkedInMatch) {
      setIsLinkedIn(true);
      setShowCompanyDetails(false);
      fetchLinkedInData(linkedInMatch[1]);
      return;
    }
    setIsLinkedIn(false);
    if (!showCompanyDetails) setShowCompanyDetails(true);
    setWebsiteDomain(url);
  }, [window.location.href]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setIsBizAnalyzerOnWebsite(isBizAnalyzerOnWebsiteRecoil);
  }, [isBizAnalyzerOnWebsiteRecoil]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    fetchWebsiteData();
  }, [websiteDomain]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "p-4",
    children: loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Loader, {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
      children: showCompanyDetails && !isLinkedIn ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_showComfimation__WEBPACK_IMPORTED_MODULE_3__["default"], {
        setShowCompanyDetails: () => {
          setShowCompanyDetails(false);
          fetchWebsiteData();
        },
        linkedIn: compnayData === null || compnayData === void 0 || (_compnayData$company = compnayData.company) === null || _compnayData$company === void 0 ? void 0 : _compnayData$company.linkedin
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_companyAbout__WEBPACK_IMPORTED_MODULE_1__["default"], {
          company: compnayData.company
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_companyDetails__WEBPACK_IMPORTED_MODULE_2__["default"], {
          company: compnayData.company,
          websiteData: compnayData.websiteData,
          isLinkedIn: (compnayData === null || compnayData === void 0 ? void 0 : compnayData.isLinkedIn) || isLinkedIn
        })]
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizAnalyzer);

/***/ }),

/***/ "./src/component/BizAnalyzer/showComfimation/index.js":
/*!************************************************************!*\
  !*** ./src/component/BizAnalyzer/showComfimation/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../public/assets/goToFolder.svg */ "./public/assets/goToFolder.svg");
/* harmony import */ var _public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



const ShowCompanyDetailsConfirmation = _ref => {
  let {
    setShowCompanyDetails,
    linkedIn
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "!tww-flex !tww-flex-col !tww-items-center !tww-justify-center !tww-h-[75vh]",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      className: "f-16-700 !tww-mb-4 !tww-text-center",
      children: "To access this company's information, please open their LinkedIn profile."
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      className: "f-16-700 !tww-mb-6 !tww-text-center",
      children: "Alternatively, to get basic contact details, perform a domain search from above \uD83D\uDC4D"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "!tww-flex !tww-flex-col !tww-justify-center !tww-p-6 !tww-bg-gray-200 !tww-shadow-md !tww-rounded-lg !tww-w-[350px] hover:!tww-cursor-pointer",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "!tww-flex !tww-flex-col !tww-gap-4 !tww-w-full",
        onClick: () => {
          window.open(linkedIn, '_blank', 'noopener,noreferrer');
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-between !tww-bg-gray-100 !tww-border !tww-border-gray-300 !tww-rounded !tww-p-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
            className: "f-14-500",
            children: "Open LinkedIn"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
            src: (_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_0___default()),
            alt: "LinkedIn Icon",
            className: "!tww-w-6 !tww-h-6"
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("button", {
        className: "!tww-mt-6 !tww-px-6 !tww-py-3 !tww-bg-black f-14-500-white !tww-rounded !tww-hover:bg-gray-800 !tww-transition",
        onClick: () => setShowCompanyDetails() // Call function passed from BizAnalyzer
        ,
        style: {
          color: 'white'
        },
        children: "Click Here To Get Basic Contact Details"
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShowCompanyDetailsConfirmation);

/***/ }),

/***/ "./src/component/BizAnalyzer/tabs/index.js":
/*!*************************************************!*\
  !*** ./src/component/BizAnalyzer/tabs/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../App.css */ "./src/App.css");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");







const BizAnalyzerTab = () => {
  const [isDisabled, setIsDisabled] = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.companySearchLoaderState);
  const [companyData, setCompanyData] = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.companySearchDataState);
  const routes = [{
    path: '/',
    text: 'Company',
    disabled: false
  }, {
    path: '/People',
    text: 'People',
    disabled: isDisabled || Object.keys(companyData).length === 0
  }];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
    className: "containerNav",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "buttonNav",
      children: routes === null || routes === void 0 ? void 0 : routes.map(route => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_6__.NavLink, {
        to: route.path,
        className: _ref => {
          let {
            isActive
          } = _ref;
          return "navButton ".concat(isActive ? 'navButton-active' : '', " ").concat(route.disabled ? 'navButton-disabled' : '');
        },
        onClick: e => route.disabled && e.preventDefault() // Prevent click if disabled
        ,
        children: _ref2 => {
          let {
            isActive
          } = _ref2;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            style: {
              color: '#212529',
              textDecoration: 'none'
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_2__["default"], {
              children: route.text
            })
          });
        }
      }, route.path))
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BizAnalyzerTab);

/***/ }),

/***/ "./src/component/Company/index.js":
/*!****************************************!*\
  !*** ./src/component/Company/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _common_personalityLayout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/personalityLayout */ "./src/component/common/personalityLayout/index.js");
/* harmony import */ var _public_assets_company_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/company.svg */ "./public/assets/company.svg");
/* harmony import */ var _public_assets_company_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_company_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _common_loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/loader */ "./src/component/common/loader/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");












const linkedInSvg = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("svg", {
  width: "15",
  height: "15",
  viewBox: "0 0 13 13",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
    d: "M11.0771 11.1771H11.1771V11.0771V11.076V11.076L11.1782 7.67435V7.67432C11.1782 6.83634 11.0889 6.07219 10.7384 5.51647C10.3814 4.95052 9.76668 4.6194 8.76706 4.619C8.08147 4.59467 7.4311 4.90307 7.01492 5.43474V4.87283V4.77283H6.91492H5.06567H4.96567V4.87283V11.0771V11.1771H5.06567H6.99183H7.09183V11.0771V8.0069C7.09183 7.60469 7.13106 7.22906 7.28171 6.95589C7.35575 6.82164 7.45632 6.71297 7.59331 6.63706C7.73087 6.56083 7.91106 6.51441 8.14883 6.51441C8.38012 6.51441 8.54523 6.56835 8.66539 6.65234C8.78577 6.73648 8.8696 6.85678 8.92776 7.00416C9.04638 7.30469 9.05092 7.69588 9.05092 8.05999V11.0771V11.1771H9.15092H11.0771ZM2.89202 4.12458H2.8925C3.56077 4.12458 4.1105 3.57619 4.1105 2.90767V2.9075C4.10932 2.2394 3.56106 1.68968 2.8925 1.68968C2.22411 1.68968 1.6745 2.23928 1.6745 2.90767L1.6745 2.90825C1.67636 3.23047 1.80527 3.53895 2.03323 3.76669C2.26119 3.99443 2.5698 4.12303 2.89202 4.12458ZM3.85558 11.1771H3.95558V11.0771V4.87283V4.77283H3.85558H1.92725H1.82725V4.87283V11.0771V11.1771H1.92725H3.85558ZM0.95875 0.100016H11.9944L11.9959 0.101531L12.038 0.101094C12.2631 0.098754 12.4801 0.185505 12.6416 0.34244C12.8028 0.499173 12.8957 0.71322 12.9 0.938039V12.0609C12.8957 12.2859 12.8029 12.5002 12.6416 12.6573C12.4801 12.8146 12.2631 12.9018 12.0377 12.9H12.0369L0.95875 12.9L0.958169 12.9C0.733346 12.9013 0.51709 12.8138 0.356398 12.6566C0.195889 12.4995 0.103772 12.2855 0.1 12.061V0.938996C0.103772 0.71448 0.195889 0.500485 0.356398 0.343423C0.51709 0.186181 0.733345 0.0987086 0.958169 0.100014V0.100016H0.95875Z",
    stroke: "#7c7c7c",
    "stroke-width": "1"
  })
});
const Company = _ref => {
  let {
    isContact
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_8__.useApiRequest)();
  const userData = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.indvitualUserState);
  const {
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.tokenState);
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [companyData, setCompanyData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  const fetchCompanies = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      var _userData$leadId, _contact$linkedIn, _contact$linkedIn2, _Object$entries;
      setLoading(true);
      const contact = (_userData$leadId = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId !== void 0 ? _userData$leadId : userData;
      const payload = {
        full_name: "".concat(contact === null || contact === void 0 ? void 0 : contact.firstName, " ").concat(contact === null || contact === void 0 ? void 0 : contact.lastName),
        linkedin_username: contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.userName,
        linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn2 = contact.linkedIn) === null || _contact$linkedIn2 === void 0 ? void 0 : _contact$linkedIn2.url,
        userId: id,
        ...contact
      };
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityCompany), 'POST', {
        ...payload
      });
      const transformedData = (_Object$entries = Object.entries(data)) === null || _Object$entries === void 0 ? void 0 : _Object$entries.map(_ref2 => {
        let [key, value] = _ref2;
        return {
          key,
          data: value
        };
      });
      setCompanyData(transformedData);
      setLoading(false);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityCompany, " POST API in Company.js file"),
        source: 'extension',
        module: 'Personality'
      });
      setLoading(false);
    }
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {});
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Company);
const CompanyNews = _ref3 => {
  let {
    newsType = '',
    platformName = '',
    desc = '',
    platformIcon
  } = _ref3;
  const formatNewsType = newsType => {
    var _newsType$replace;
    return newsType === null || newsType === void 0 || (_newsType$replace = newsType.replace('company', '') // Remove "company"
    ) === null || _newsType$replace === void 0 || (_newsType$replace = _newsType$replace.replace(/([A-Z])/g, ' $1') // Add space before capital letters
    ) === null || _newsType$replace === void 0 ? void 0 : _newsType$replace.trim(); // Trim any leading/trailing spaces
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "!tww-flex !tww-flex-col !tww-px-5 !tww-py-3",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "!tww-px-3 !tww-py-2 !tww-font-bold !tww-rounded-3xl !tww-bg-green-200 !tww-text-green-800 !tww-text-[13px]",
        children: formatNewsType(newsType)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("p", {
        className: "!tww-text-[14px] !tww-flex !tww-gap-1 !tww-items-center",
        children: [platformIcon, platformName]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
      className: "!tww-mt-4 !tww-text-justify !tww-text-[14px] !tww-text-[#272727]",
      children: desc
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("hr", {
      className: "!tww-my-4"
    })]
  });
};

/***/ }),

/***/ "./src/component/LinkedinMessage/index.js":
/*!************************************************!*\
  !*** ./src/component/LinkedinMessage/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_contextAccordian__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/contextAccordian */ "./src/component/common/contextAccordian/index.js");
/* harmony import */ var _common_editTextBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/editTextBox */ "./src/component/common/editTextBox/index.js");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _common_aiSettingModal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/aiSettingModal */ "./src/component/common/aiSettingModal/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");











const EditTextBoxHeader = _ref => {
  let {
    type
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
    className: "!tww-mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-gap-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "!tww-flex !tww-items-center !tww-justify-center headerEditBtn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
          className: "!tww-m-0 f-14-600",
          style: {
            color: 'white'
          },
          children: "People"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
        className: "!tww-m-0",
        children: ">"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
        className: "!tww-m-0 f-14-600",
        style: {
          color: '#9097A5'
        },
        children: type
      })]
    })
  });
};
const LinkedInMessage = () => {
  var _userData$leadId, _contact$linkedIn2, _contact$linkedIn4;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_8__.useApiRequest)();
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.reportPayloadState);
  const aiSetting = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.aiSettingState);
  const [email, setEmail] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const {
    team,
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.tokenState);
  const userData = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.indvitualUserState);
  const contact = (_userData$leadId = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId !== void 0 ? _userData$leadId : userData;
  const generateEmail = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      var _contact$linkedIn;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityLinkedIn), 'POST', {
        userId: id,
        teamId: team === null || team === void 0 ? void 0 : team._id,
        linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.url,
        aiSettings: aiSetting === null || aiSetting === void 0 ? void 0 : aiSetting._id
      });
      setLoading(false);
      setEmail(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityLinkedIn, " POST API in LinkedinMessage.js file in generateEmail method"),
        source: 'extension',
        module: 'AI Reachout - LinkedIn Messages'
      });
      setLoading(false);
    }
  }, [aiSetting === null || aiSetting === void 0 ? void 0 : aiSetting._id, contact === null || contact === void 0 || (_contact$linkedIn2 = contact.linkedIn) === null || _contact$linkedIn2 === void 0 ? void 0 : _contact$linkedIn2.url, id, makeRequest, team === null || team === void 0 ? void 0 : team._id]);
  const initialGeneration = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      var _contact$linkedIn3;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityLinkedIn), 'POST', {
        userId: id,
        teamId: team === null || team === void 0 ? void 0 : team._id,
        linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn3 = contact.linkedIn) === null || _contact$linkedIn3 === void 0 ? void 0 : _contact$linkedIn3.url
      });
      setLoading(false);
      setEmail(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityLinkedIn, " POST API in LinkedinMessage.js file in initialGeneration method"),
        source: 'extension',
        module: 'AI Reachout - LinkedIn Messages'
      });
      setLoading(false);
    }
  }, [contact === null || contact === void 0 || (_contact$linkedIn4 = contact.linkedIn) === null || _contact$linkedIn4 === void 0 ? void 0 : _contact$linkedIn4.url, id, makeRequest, team === null || team === void 0 ? void 0 : team._id]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    initialGeneration();
  }, [initialGeneration]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between !tww-mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-center",
          style: {
            width: '37px',
            height: '37px',
            borderRadius: '3px',
            backgroundColor: '#fff'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
            src: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_3___default()),
            className: "img-fluid",
            style: {
              width: '24px',
              height: '24px'
            },
            alt: "linkedinicon"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-3 f-14-500",
          children: "LinkedIn Messages"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_aiSettingModal__WEBPACK_IMPORTED_MODULE_7__["default"], {
        type: "linkedin",
        setLinkedInMessages: setEmail,
        setLinkedinLoading: setLoading
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_contextAccordian__WEBPACK_IMPORTED_MODULE_1__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(EditTextBoxHeader, {
      type: "Education"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: "Linked Education",
      refresh: generateEmail,
      text: email === null || email === void 0 ? void 0 : email.LinkedInEduMessage,
      isLoading: loading
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(EditTextBoxHeader, {
      type: "Experience"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: "Linked Experience",
      refresh: generateEmail,
      text: email === null || email === void 0 ? void 0 : email.LinkedInExpMessage,
      isLoading: loading
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkedInMessage);

/***/ }),

/***/ "./src/component/bulk/index.js":
/*!*************************************!*\
  !*** ./src/component/bulk/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var _public_assets_folder_icon_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/folder-icon.svg */ "./public/assets/folder-icon.svg");
/* harmony import */ var _public_assets_folder_icon_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_folder_icon_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _folder__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../folder */ "./src/component/folder/index.js");
/* harmony import */ var _userInfoCard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./userInfoCard */ "./src/component/bulk/userInfoCard/index.js");
/* harmony import */ var _indivitual_ProfileComponent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../indivitual/ProfileComponent */ "./src/component/indivitual/ProfileComponent/index.js");
/* harmony import */ var _showProfileHeader__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./showProfileHeader */ "./src/component/bulk/showProfileHeader/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _utils_userNameFormatter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/userNameFormatter */ "./src/utils/userNameFormatter.js");
/* harmony import */ var _utils_formatLinkedinUrl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/formatLinkedinUrl */ "./src/utils/formatLinkedinUrl.js");
/* harmony import */ var _utils_handleStatechange__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/handleStatechange */ "./src/utils/handleStatechange.js");
/* harmony import */ var _ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../ExtractionClasses/linkedin */ "./src/ExtractionClasses/linkedin.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



















const BulkComponent = () => {
  var _data$showProfile$key, _data$showProfile$key2, _data$showProfile$key3;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_15__.useApiRequest)();
  const selectedFolder = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.selectedFolderState);
  const selectedTags = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.selectedTagsState);
  const {
    team,
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.tokenState);
  const [isUpdate, setIsUpdate] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.isUpdatedState);
  const [data, setData] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.fetchedUsersState);
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [selectedUsers, setSelectedUsers] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [showAddButton, setShowAddButton] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [loadingUsers, setLoadingUsers] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [selectedCount, setSelectedCount] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [showProfile, setShowProfile] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    show: false,
    key: 0
  });
  const [loaderDetected, setLoaderDetected] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [credits, setCredits] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.creditState);
  const handleSelectAllChange = e => {
    const isSelected = e.target.checked;
    const newSelectedUsers = {};
    data.forEach(user => {
      newSelectedUsers[user.key] = isSelected;
    });
    setSelectedUsers(newSelectedUsers);
    setShowAddButton(isSelected);
    setSelectedCount(isSelected ? data.length : 0);
  };
  const handleUserCheckboxChange = key => {
    const newSelectedUsers = {
      ...selectedUsers,
      [key]: !selectedUsers[key]
    };
    setSelectedUsers(newSelectedUsers);
    const newSelectedCount = Object.values(newSelectedUsers).filter(Boolean).length;
    setSelectedCount(newSelectedCount);
    setShowAddButton(newSelectedCount > 0);
  };
  const checkSalesQL = async url => {
    try {
      const {
        data
      } = await makeRequest("/leads/salesql/check?linkedinUrl=".concat(encodeURIComponent(url)), 'GET');
      return data;
    } catch (err) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_4__["default"].error('Failed to check contact info from SalesQL');
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (err === null || err === void 0 ? void 0 : err.message) || String(err) || 'An unknown error occurred',
          stack: "Error with /leads/salesql/check?linkedinUrl=".concat(encodeURIComponent(url), " GET API in bulk.js file"),
          source: 'extension',
          module: 'Checking from Salesql in Bulk Prospect Search'
        });
      } catch (error) {}
      return null;
    }
  };
  const handleClickPlus = async key => {
    let keysToUpdate = [];
    let linkedinUrls = [];
    if (key === undefined) {
      var _keysToUpdate;
      keysToUpdate = Object.keys(selectedUsers).filter(k => selectedUsers[k]);
      linkedinUrls = (_keysToUpdate = keysToUpdate) === null || _keysToUpdate === void 0 ? void 0 : _keysToUpdate.map(k => {
        var _data$k$lead$linkedIn, _data$k, _data$k2;
        return (_data$k$lead$linkedIn = (_data$k = data[k]) === null || _data$k === void 0 || (_data$k = _data$k.lead) === null || _data$k === void 0 || (_data$k = _data$k.linkedIn) === null || _data$k === void 0 ? void 0 : _data$k.url) !== null && _data$k$lead$linkedIn !== void 0 ? _data$k$lead$linkedIn : (_data$k2 = data[k]) === null || _data$k2 === void 0 || (_data$k2 = _data$k2.contact) === null || _data$k2 === void 0 || (_data$k2 = _data$k2.leadId) === null || _data$k2 === void 0 || (_data$k2 = _data$k2.linkedIn) === null || _data$k2 === void 0 ? void 0 : _data$k2.url;
      });
    } else {
      var _data$key$lead$linked, _data$key, _data$key2;
      keysToUpdate = [key];
      linkedinUrls = [(_data$key$lead$linked = (_data$key = data[key]) === null || _data$key === void 0 || (_data$key = _data$key.lead) === null || _data$key === void 0 || (_data$key = _data$key.linkedIn) === null || _data$key === void 0 ? void 0 : _data$key.url) !== null && _data$key$lead$linked !== void 0 ? _data$key$lead$linked : (_data$key2 = data[key]) === null || _data$key2 === void 0 || (_data$key2 = _data$key2.contact) === null || _data$key2 === void 0 || (_data$key2 = _data$key2.leadId) === null || _data$key2 === void 0 || (_data$key2 = _data$key2.linkedIn) === null || _data$key2 === void 0 ? void 0 : _data$key2.url];
    }
    setLoadingUsers(prevLoadingUsers => {
      const newLoadingUsers = {
        ...prevLoadingUsers
      };
      keysToUpdate.forEach(k => {
        newLoadingUsers[k] = true;
      });
      return newLoadingUsers;
    });
    for (const url of linkedinUrls) {
      if (!url) continue;
      try {
        var _team$plan;
        const salesQLResponse = await checkSalesQL(url);
        const isPaidPlan = team === null || team === void 0 || (_team$plan = team.plan) === null || _team$plan === void 0 || (_team$plan = _team$plan.planId) === null || _team$plan === void 0 ? void 0 : _team$plan.isPaid;
        const called = (salesQLResponse === null || salesQLResponse === void 0 ? void 0 : salesQLResponse.called) === true;
        const withinThreeMonths = (salesQLResponse === null || salesQLResponse === void 0 ? void 0 : salesQLResponse.withinThreeMonths) === true;
        let shouldCallSalesQL = false;
        let creditType = 'External Credit';
        if (!called) {
          shouldCallSalesQL = true;
          creditType = 'External Credit';
        } else if (isPaidPlan && !withinThreeMonths) {
          shouldCallSalesQL = true;
          creditType = 'External Credit';
        } else {
          creditType = 'Internal Credit';
        }
        if (shouldCallSalesQL) {
          await makeRequest("/leads/salesql/lookup", 'POST', {
            linkedinUrl: url,
            teamId: team === null || team === void 0 ? void 0 : team._id
          });
        }
      } catch (err) {
        try {
          await makeRequest('/ErrorLog', 'POST', {
            message: (err === null || err === void 0 ? void 0 : err.message) || String(err) || 'An unknown error occurred',
            stack: "Error with /leads/salesql/lookup POST API in bulk.js file",
            source: 'extension',
            module: 'Checking from Salesql in Bulk Prospect Search'
          });
        } catch (error) {
          console.log('ERROR', error);
        }
      }
    }
    try {
      const payload = {
        linkedinUrls,
        folderId: selectedFolder.id,
        tags: selectedTags === null || selectedTags === void 0 ? void 0 : selectedTags.map(tag => tag._id),
        source: 'linkedIn'
      };
      const response = await addContacts(payload);
      setData((0,_utils_handleStatechange__WEBPACK_IMPORTED_MODULE_13__.handleStateChange)(data, response === null || response === void 0 ? void 0 : response.data));
      react_hot_toast__WEBPACK_IMPORTED_MODULE_4__["default"].success(response.message);
    } catch (error) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_4__["default"].error('Failed to add contacts.');
    }
    setShowAddButton(false);
    setLoadingUsers(prevLoadingUsers => {
      const newLoadingUsers = {
        ...prevLoadingUsers
      };
      keysToUpdate.forEach(k => {
        delete newLoadingUsers[k];
      });
      return newLoadingUsers;
    });
  };
  const handleBtnText = () => {
    const contactKeys = Object.keys(selectedUsers).filter(k => selectedUsers[k]);
    const allAreContacts = contactKeys.every(key => {
      var _data$key3;
      return ((_data$key3 = data[key]) === null || _data$key3 === void 0 ? void 0 : _data$key3.isContact) === true;
    });
    const someAreContacts = contactKeys.some(key => {
      var _data$key4;
      return ((_data$key4 = data[key]) === null || _data$key4 === void 0 ? void 0 : _data$key4.isContact) === true;
    });
    if (allAreContacts) {
      return 'Update';
    } else if (someAreContacts) {
      return 'Show and Update';
    } else {
      return 'Show and Add';
    }
  };
  const searchContact = async payload => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.contacts, "/search"), 'POST', payload);
      return data;
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.contacts, "/search POST API in bulk.js file"),
          source: 'extension',
          module: 'Bulk Prospect Search'
        });
      } catch (error) {}
    }
  };
  const addContacts = async payload => {
    try {
      if (!selectedFolder.id) {
        throw 'Please Select the Folder';
      }
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.contacts), 'POST', payload);
      updateCredits();
      return data;
    } catch (error) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_4__["default"].error((error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred');
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.contacts, " POST API in bulk.js file"),
          source: 'extension',
          module: 'Bulk Prospect Search'
        });
      } catch (error) {
        console.log('ERROR', error);
      }
    }
  };
  const useElements = className => {
    return Array.from(document.getElementsByClassName(className));
  };
  const extractData = (names, abouts, profileUrls, imageUrls) => {
    console.log('🚀 ~ extractData ~ imageUrls:', imageUrls);
    return names === null || names === void 0 ? void 0 : names.map((name, index) => {
      var _imageUrls$index;
      return {
        name,
        about: abouts[index],
        profileUrl: profileUrls[index],
        imageUrl: imageUrls[index] === 'nothing' || (_imageUrls$index = imageUrls[index]) !== null && _imageUrls$index !== void 0 && _imageUrls$index.startsWith('data:') ? null : imageUrls[index],
        key: index
      };
    });
  };
  const generateLinkedinUrlsPayload = users => {
    return users.reduce((acc, user) => {
      const {
        firstName,
        lastName
      } = (0,_utils_userNameFormatter__WEBPACK_IMPORTED_MODULE_11__.userNameFormatter)(user.name);
      const key = (0,_utils_formatLinkedinUrl__WEBPACK_IMPORTED_MODULE_12__.formatLinkedInURL)(user.profileUrl);
      acc[key] = {
        firstName,
        lastName
      };
      if (user.imageUrl) {
        var _user$imageUrl;
        acc[key].image = (_user$imageUrl = user.imageUrl) !== null && _user$imageUrl !== void 0 ? _user$imageUrl : 'nothing';
      }
      return acc;
    }, {});
  };
  const handleBulkExtraction = async function (getData, setLoading) {
    let isConnections = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    setTimeout(async () => {
      const users = getData();
      const linkedinUrlsPayload = {
        linkedinUrls: generateLinkedinUrlsPayload(users)
      };
      console.log('linkedinUrlsPayload', linkedinUrlsPayload);
      const data = await searchContact(linkedinUrlsPayload);
      const mergedUsers = users === null || users === void 0 ? void 0 : users.map((user, index) => {
        var _data$contacts;
        return {
          ...user,
          ...((data === null || data === void 0 || (_data$contacts = data.contacts) === null || _data$contacts === void 0 ? void 0 : _data$contacts[index]) || {})
        };
      });
      setData(mergedUsers);
      setLoading(false);
    }, isConnections ? 6000 : 4000);
  };
  const bulkExtraction = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    handleBulkExtraction(() => {
      var _useElements, _useElements2, _useElements3, _useElements4;
      return extractData((_useElements = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.BulkSearch.name)) === null || _useElements === void 0 ? void 0 : _useElements.map(el => {
        const linkElement = el.querySelector('a');

        // Extract the name
        const nameElement = linkElement.querySelector("span[aria-hidden='true']");
        const name = nameElement ? nameElement.textContent.trim() : null;
        return name;
      }), (_useElements2 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.BulkSearch.about)) === null || _useElements2 === void 0 ? void 0 : _useElements2.map(el => el === null || el === void 0 ? void 0 : el.innerText), (_useElements3 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.BulkSearch.profileUrl)) === null || _useElements3 === void 0 ? void 0 : _useElements3.map(el => {
        const linkElement = el.querySelector('a');
        return linkElement ? linkElement.href : 'nothing';
      }), (_useElements4 = useElements('linked-area flex-1')) === null || _useElements4 === void 0 ? void 0 : _useElements4.map(parent => {
        var _img$src;
        const imageContainer = parent.querySelector('.display-flex.align-items-center');
        const img = imageContainer === null || imageContainer === void 0 ? void 0 : imageContainer.querySelector('img');
        return (_img$src = img === null || img === void 0 ? void 0 : img.src) !== null && _img$src !== void 0 ? _img$src : 'nothing';
      }));
    }, setLoading);
  }, []);
  const bulkExtractionConnection = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    handleBulkExtraction(() => {
      var _useElements5, _useElements6, _useElements7, _useElements8;
      return extractData((_useElements5 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.Connections.name)) === null || _useElements5 === void 0 ? void 0 : _useElements5.map(el => el === null || el === void 0 ? void 0 : el.innerText), (_useElements6 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.Connections.about)) === null || _useElements6 === void 0 ? void 0 : _useElements6.map(el => el === null || el === void 0 ? void 0 : el.innerText), (_useElements7 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.Connections.profileUrl)) === null || _useElements7 === void 0 ? void 0 : _useElements7.map(el => el.href), (_useElements8 = useElements(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_14__.linkedInClasses.Connections.imageUrl)) === null || _useElements8 === void 0 ? void 0 : _useElements8.map(el => {
        const imgElement = el.querySelector('img');
        // Check if img element exists
        return imgElement ? imgElement === null || imgElement === void 0 ? void 0 : imgElement.src : 'nothing';
      }));
    }, setLoading, true);
  }, []);

  //set selected users
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const newSelected = {};
    data.forEach(user => {
      newSelected[user.key] = false;
    });
    setSelectedUsers(newSelected);
  }, [data]);

  //This useEffect identify the url and call bulkExtraction or bulkExtractionConnection based on the url
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleUrlChange = url => {
      setLoading(true);
      setData([]);
      if (url.match('/search/results/people/*')) {
        console.log('URL change detected: calling bulkExtraction');
        bulkExtraction();
      } else if (url.match(/\/mynetwork\/invite-connect\/connections\/.*/)) {
        console.log('URL change detected: calling bulkEXtractionConnection');
        bulkExtractionConnection();
      }
    };
    if (!data.length) {
      const initialUrl = window.location.href;
      handleUrlChange(initialUrl);
    }
    const onMessage = request => {
      if (request.method === 'UrlChanged') {
        const ChangedUrl = request.url;
        handleUrlChange(ChangedUrl);
      }
    };
    chrome.runtime.onMessage.addListener(onMessage);
    return () => {
      chrome.runtime.onMessage.removeListener(onMessage);
    };
  }, [bulkExtraction, bulkExtractionConnection]);

  // for maintaining state if any user is updated after fetching
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const updateState = async () => {
      try {
        if (isUpdate) {
          setIsUpdate(false);
          const url = (0,_utils_formatLinkedinUrl__WEBPACK_IMPORTED_MODULE_12__.formatLinkedInURL)(data[showProfile.key].profileUrl);
          const {
            firstName,
            lastName
          } = (0,_utils_userNameFormatter__WEBPACK_IMPORTED_MODULE_11__.userNameFormatter)(data[showProfile.key].name);
          const payload = {
            linkedinUrls: {
              [url]: {
                firstName,
                lastName,
                image: data[showProfile.key].imageUrl
              }
            }
          };
          const response = await searchContact(payload);
          setData((0,_utils_handleStatechange__WEBPACK_IMPORTED_MODULE_13__.handleStateChange)(data, response, true));
        }
      } catch (error) {
        console.log('🚀 ~ updateState ~ error:', error);
      }
    };
    updateState();
  }, [isUpdate]);

  //This trigger whenver the loader is detected and call the function to fetch the data cause new Data loaded in DOM
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (loaderDetected) {
      //wait the data to be fully loaded and calls the fucntion
      setTimeout(() => {
        bulkExtractionConnection();
      }, 2000);
    }
  }, [loaderDetected]);
  const updateCredits = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.credit), 'GET');
      setCredits(data.credits);
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.credit, " GET API in bulk.js file"),
          source: 'extension',
          module: 'Update Credits in Bulk Prospect Search'
        });
      } catch (error) {}
    }
  };
  const observer = new MutationObserver((mutationsList, observer) => {
    if (!loaderDetected) {
      // Check if loaderDetected is already set to true
      for (let mutation of mutationsList) {
        if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
          // Check the first node directly
          let node = mutation.addedNodes[0];
          if (node.nodeType === Node.ELEMENT_NODE && node.classList.contains('artdeco-loader__bars')) {
            setLoaderDetected(true);

            // Reset the flag after 2 seconds
            setTimeout(() => {
              setLoaderDetected(false);
            }, 2000);
            break; // Exit after the first match
          }
        }
      }
    }
  });

  // Target is the body or another relevant container
  const observerTarget = document.querySelector('body');

  // Observer configuration
  const config = {
    childList: true,
    subtree: true
  };

  // Start observing
  observer.observe(observerTarget, config);
  const allSelected = data.length > 0 && Object.values(selectedUsers).every(Boolean);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
    children: showProfile.show ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_showProfileHeader__WEBPACK_IMPORTED_MODULE_9__["default"], {
        setShowProfile: setShowProfile
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_indivitual_ProfileComponent__WEBPACK_IMPORTED_MODULE_8__["default"], {
        name: (_data$showProfile$key = data[showProfile.key]) === null || _data$showProfile$key === void 0 ? void 0 : _data$showProfile$key.name,
        about: (_data$showProfile$key2 = data[showProfile.key]) === null || _data$showProfile$key2 === void 0 ? void 0 : _data$showProfile$key2.about,
        profileImageUrl: (_data$showProfile$key3 = data[showProfile.key]) === null || _data$showProfile$key3 === void 0 ? void 0 : _data$showProfile$key3.imageUrl,
        dataFetched: true,
        loading: false,
        contact: data[showProfile.key].contact,
        revealInfo: false,
        showAndAdd: false,
        isContact: true,
        isBulk: true
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_folder__WEBPACK_IMPORTED_MODULE_6__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
        className: "!tww-scroll !tww-no-scrollbar",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "!tww-flex !tww-p-3 !tww-items-center !tww-justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
            className: "checkbox-wrapper-33",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("label", {
              className: "checkbox",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("input", {
                className: "checkbox__trigger visuallyhidden",
                type: "checkbox",
                checked: allSelected,
                onChange: handleSelectAllChange
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("span", {
                className: "checkbox__symbol",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("svg", {
                  "aria-hidden": "true",
                  className: "icon-checkbox",
                  width: "28px",
                  height: "28px",
                  viewBox: "0 0 28 28",
                  version: "1",
                  xmlns: "http://www.w3.org/2000/svg",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("path", {
                    d: "M4 14l8 7L24 7"
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("p", {
                className: "checkbox__textwrapper",
                children: "Select all"
              })]
            })
          }), showAddButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("button", {
            className: "show-add-btn !tww-flex !tww-items-center !tww-justify-center !tww-gap-2",
            onClick: () => handleClickPlus(),
            children: ["".concat(handleBtnText(), " ").concat(selectedCount), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("img", {
              src: (_public_assets_folder_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
              className: "!tww-ml-2 img-fluid"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_userInfoCard__WEBPACK_IMPORTED_MODULE_7__["default"], {
          data: data,
          handleClickPlus: handleClickPlus,
          handleUserCheckboxChange: handleUserCheckboxChange,
          selectedUsers: selectedUsers,
          showAddButton: showAddButton,
          loading: loading,
          loadingUsers: loadingUsers,
          setShowProfile: setShowProfile
        })]
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BulkComponent);

/***/ }),

/***/ "./src/component/bulk/showProfileHeader/index.js":
/*!*******************************************************!*\
  !*** ./src/component/bulk/showProfileHeader/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/back-icon.svg */ "./public/assets/back-icon.svg");
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const ShowProfileHeader = _ref => {
  let {
    setShowProfile
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "!tww-container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "!tww-flex !tww-items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
        role: "button",
        src: (_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_1___default()),
        style: {
          width: "23px"
        },
        onClick: () => setShowProfile({
          show: false,
          key: null
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h4", {
        className: "!tww-ml-2 !tww-m-0",
        children: "Back To List"
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShowProfileHeader);

/***/ }),

/***/ "./src/component/bulk/userInfoCard/index.js":
/*!**************************************************!*\
  !*** ./src/component/bulk/userInfoCard/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_lottie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-lottie */ "./node_modules/react-lottie/dist/index.js");
/* harmony import */ var _animationJson_Profile_loading_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../animationJson/Profile-loading.json */ "./src/animationJson/Profile-loading.json");
/* harmony import */ var _public_assets_email_grey_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/email-grey.svg */ "./public/assets/email-grey.svg");
/* harmony import */ var _public_assets_email_grey_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_email_grey_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _public_assets_phone_grey_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../public/assets/phone-grey.svg */ "./public/assets/phone-grey.svg");
/* harmony import */ var _public_assets_phone_grey_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_phone_grey_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _public_assets_plus_btn_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../public/assets/plus-btn.svg */ "./public/assets/plus-btn.svg");
/* harmony import */ var _public_assets_plus_btn_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_plus_btn_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_forward_icon_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/forward-icon.svg */ "./public/assets/forward-icon.svg");
/* harmony import */ var _public_assets_forward_icon_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_forward_icon_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../public/assets/add-tag.svg */ "./public/assets/add-tag.svg");
/* harmony import */ var _public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");












const UserInfoCard = _ref => {
  var _ref2;
  let {
    data,
    handleClickPlus,
    handleUserCheckboxChange,
    selectedUsers,
    showAddButton,
    loading,
    loadingUsers,
    setShowProfile
  } = _ref;
  const defaultOptions = {
    loop: true,
    autoplay: true,
    animationData: _animationJson_Profile_loading_json__WEBPACK_IMPORTED_MODULE_2__,
    rendererSettings: {
      preserveAspectRatio: 'xMidYMid slice'
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
    children: [loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "!tww-skeleton-loader",
      children: (_ref2 = [...Array(10)]) === null || _ref2 === void 0 ? void 0 : _ref2.map((_, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "user-box !tww-px-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "skeleton skeleton-check"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          alt: "User Name",
          className: "".concat(loading ? 'skeleton skeleton-image' : '', " !tww-w-[45px] !tww-h-[45px] !tww-object-cover")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "user-info",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: "userName !tww-mb-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "skeleton skeleton-text"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "userAbout !tww-mb-2",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "skeleton skeleton-text",
              style: {
                width: '200px'
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "skeleton skeleton-text"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "skeleton email-count-container"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "!tww-ml-2 skeleton email-count-container"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "user-interaction",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: "skeleton skeleton-button"
          })
        })]
      }, index))
    }), data === null || data === void 0 ? void 0 : data.map((user, idx) => {
      var _user$imageUrl, _user$contact$leadId$, _user$contact, _user$lead, _user$contact2, _user$lead2;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "user-box",
        style: {
          backgroundColor: selectedUsers[user.key] && '#ECF5FF'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
          className: "checkbox-wrapper-33",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("label", {
            className: "checkbox",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("input", {
              className: "checkbox__trigger visuallyhidden",
              type: "checkbox",
              checked: selectedUsers[user.key] || false,
              onChange: () => handleUserCheckboxChange(user.key)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
              className: "checkbox__symbol",
              style: {
                border: '1px solid #E7E9EA'
              },
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("svg", {
                "aria-hidden": "true",
                className: "icon-checkbox",
                width: "28px",
                height: "28px",
                viewBox: "0 0 28 28",
                version: "1",
                xmlns: "http://www.w3.org/2000/svg",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("path", {
                  d: "M4 14l8 7L24 7"
                })
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
          src: (_user$imageUrl = user.imageUrl) !== null && _user$imageUrl !== void 0 ? _user$imageUrl : 'https://cdn.pixabay.com/photo/2015/10/05/22/37/blank-profile-picture-973460_960_720.png',
          alt: "User Name",
          className: "".concat(loading ? 'skeleton skeleton-image' : '', "  !tww-w-[45px] !tww-h-[45px] !tww-object-cover")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "!tww-flex !tww-flex-col !tww-gap-1 !tww-w-full !tww-ml-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: "userName",
            style: {
              lineHeight: '15px',
              maxWidth: '170px',
              fontSize: '16px'
            },
            children: user.name
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_8__["default"], {
            tooltipText: user.about,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "userAbout !tww-w-[80%]",
              style: {
                WebkitLineClamp: 1
              },
              children: user.about
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "email-count-container",
              style: {
                backgroundColor: selectedUsers[user.key] && '#D8EAFF'
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
                src: (_public_assets_email_grey_svg__WEBPACK_IMPORTED_MODULE_3___default()),
                style: {
                  width: '15px',
                  height: '12px'
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
                className: "f-11-lightGrey !tww-m-0 !tww-ml-2",
                children: (_user$contact$leadId$ = user === null || user === void 0 || (_user$contact = user.contact) === null || _user$contact === void 0 || (_user$contact = _user$contact.leadId) === null || _user$contact === void 0 ? void 0 : _user$contact.emailIds.length) !== null && _user$contact$leadId$ !== void 0 ? _user$contact$leadId$ : user === null || user === void 0 || (_user$lead = user.lead) === null || _user$lead === void 0 ? void 0 : _user$lead.emailIds.length
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "email-count-container !tww-ml-2",
              style: {
                backgroundColor: selectedUsers[user.key] && '#D8EAFF'
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
                src: (_public_assets_phone_grey_svg__WEBPACK_IMPORTED_MODULE_4___default()),
                style: {
                  width: '8px',
                  height: '12px'
                }
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
                className: "f-11-lightGrey !tww-m-0 !tww-ml-2",
                children: Array.isArray(user === null || user === void 0 || (_user$contact2 = user.contact) === null || _user$contact2 === void 0 || (_user$contact2 = _user$contact2.leadId) === null || _user$contact2 === void 0 ? void 0 : _user$contact2.phoneNumbers) ? user.contact.leadId.phoneNumbers.length : Array.isArray(user === null || user === void 0 || (_user$lead2 = user.lead) === null || _user$lead2 === void 0 ? void 0 : _user$lead2.phoneNumbers) ? user.lead.phoneNumbers.length : 0
              })]
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "user-interaction !tww-w-[40px] !tww-h-[40px] !tww-pe-2",
          children: [!showAddButton && !loadingUsers[user.key] && (user.isContact ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
            src: (_public_assets_forward_icon_svg__WEBPACK_IMPORTED_MODULE_6___default()),
            "data-index": user.key,
            style: {
              transition: 'transform 0.3s ease',
              cursor: 'pointer'
            },
            onMouseOver: e => e.target.style.transform = 'scale(1.1)',
            onMouseOut: e => e.target.style.transform = 'scale(1)',
            onClick: () => setShowProfile({
              show: true,
              key: user.key
            })
          }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
            src: (_public_assets_plus_btn_svg__WEBPACK_IMPORTED_MODULE_5___default()),
            "data-index": user.key,
            style: {
              transition: 'transform 0.3s ease',
              cursor: 'pointer'
            },
            onMouseOver: e => e.target.style.transform = 'scale(1.1)',
            onMouseOut: e => e.target.style.transform = 'scale(1)',
            onClick: () => handleClickPlus(user.key)
          })), loadingUsers[user.key] && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_lottie__WEBPACK_IMPORTED_MODULE_1__["default"], {
            options: defaultOptions
          })]
        })]
      }, user.key);
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserInfoCard);

/***/ }),

/***/ "./src/component/common/CustomLoader/index.js":
/*!****************************************************!*\
  !*** ./src/component/common/CustomLoader/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");


const CustomLoader = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    role: "status",
    className: "!tww-text-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
      "aria-hidden": "true",
      className: "!tww-w-8 !tww-h-8 !tww-text-gray-200 !tww-animate-spin dark:!tww-text-gray-600 !tww-fill-blue-600",
      viewBox: "0 0 100 101",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
        d: "M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z",
        fill: "currentColor"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
        d: "M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z",
        fill: "currentFill"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
      className: "!tww-sr-only",
      children: "Loading..."
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomLoader);

/***/ }),

/***/ "./src/component/common/LinkedinInsight/index.js":
/*!*******************************************************!*\
  !*** ./src/component/common/LinkedinInsight/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _insight__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./insight */ "./src/component/common/LinkedinInsight/insight.js");
/* harmony import */ var _loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../loader */ "./src/component/common/loader/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");









const LinkedinInsights = () => {
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_3__.useApiRequest)();
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.reportPayloadState);
  const [linkedinInsight, setLinkedinInsight] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const generateInsight = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.personalityInsight), 'POST', {
        ...reportPayload
      });
      setLoading(false);
      setLinkedinInsight(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.personalityInsight, " POST API in common/LinkedinInsight.js file"),
        source: 'extension',
        module: 'Linkedin Insight'
      });
      setLoading(false);
    }
  }, [makeRequest, reportPayload]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    generateInsight();
  }, [generateInsight]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-center",
          style: {
            width: '37px',
            height: '37px',
            borderRadius: '3px',
            marginLeft: '8px'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
            src: 'https://ez-staging.s3.ap-south-1.amazonaws.com/Linkedin+Insights+pink.png',
            className: "img-fluid",
            style: {
              width: '37px',
              height: '37px'
            }
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-3 f-14-500",
          children: "LinkedIn Insight"
        })]
      })
    }), loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "!tww-h-[65vh] !tww-flex !tww-items-center !tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_loader__WEBPACK_IMPORTED_MODULE_6__["default"], {})
    }), linkedinInsight && !loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_insight__WEBPACK_IMPORTED_MODULE_5__["default"], {
      linkedinInsight: linkedinInsight
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkedinInsights);

/***/ }),

/***/ "./src/component/common/LinkedinInsight/insight.js":
/*!*********************************************************!*\
  !*** ./src/component/common/LinkedinInsight/insight.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_icons_ci__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-icons/ci */ "./node_modules/react-icons/ci/index.mjs");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



const InsightBox = _ref => {
  var _ref2;
  let {
    linkedinInsight
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "!tww-p-4 !tww-rounded-lg !tww-shadow-xl !tww-mt-4",
    children: (_ref2 = ['Experience', 'Education', 'Skill', 'Others', 'Interest']) === null || _ref2 === void 0 ? void 0 : _ref2.map((category, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "!tww-flex !tww-justify-between",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          className: "!tww-px-4 !tww-py-1 !tww-rounded-full !tww-bg-[#dcfce7] !tww-font-bold !tww-mb-2 !tww-text-[12px] !tww-text-green-900 !tww-w-fit",
          children: category
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-end !tww-gap-1",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_icons_ci__WEBPACK_IMPORTED_MODULE_1__.CiLinkedin, {
            className: "!tww-text-[16px]"
          }), " LinkedIn"]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        className: "!tww-text-[16px] !tww-border-b !tww-pb-2 !tww-mb-4",
        children: (linkedinInsight === null || linkedinInsight === void 0 ? void 0 : linkedinInsight[category]) || 'No data available'
      })]
    }, idx))
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InsightBox);

/***/ }),

/***/ "./src/component/common/LowerHeader/index.js":
/*!***************************************************!*\
  !*** ./src/component/common/LowerHeader/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _public_assets_backSvgNew_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../public/assets/backSvgNew.svg */ "./public/assets/backSvgNew.svg");
/* harmony import */ var _public_assets_backSvgNew_svg__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_public_assets_backSvgNew_svg__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const LowerHeader = () => {
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_2__.useNavigate)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "!tww-flex !tww-justify-between !tww-items-center !tww-bg-white !tww-p-4 !tww-text-[#7B5DE9]",
    style: {
      border: "1px solid #ebebeb"
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "!tww-flex !tww-items-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("a", {
        className: "!tww-flex !tww-items-center !tww-text-[#7B5DE9] hover:!tww-text-[#7B5DE9]",
        role: "button",
        onClick: () => navigate(-1),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
          xmlns: "http://www.w3.org/2000/svg",
          className: "!tww-h-6 !tww-w-6 !tww-mr-2",
          fill: "none",
          viewBox: "0 0 24 24",
          stroke: "currentColor",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: "2",
            d: "M15 19l-7-7 7-7"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
          className: "!tww-text-[14px]",
          children: "Back to profile"
        })]
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LowerHeader);

/***/ }),

/***/ "./src/component/common/accordian/index.js":
/*!*************************************************!*\
  !*** ./src/component/common/accordian/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_upArrow_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/upArrow.svg */ "./public/assets/upArrow.svg");
/* harmony import */ var _public_assets_upArrow_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_upArrow_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _public_assets_downArrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/downArrow.svg */ "./public/assets/downArrow.svg");
/* harmony import */ var _public_assets_downArrow_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_downArrow_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const Accordian = _ref => {
  let {
    title,
    icon,
    data,
    listIcon,
    tickIcon,
    crossIcon,
    isDesignChange = false,
    isOpened = false,
    discription = false,
    contactName
  } = _ref;
  const [isOpen, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(isOpened);
  const {
    tickData,
    crossData,
    tickHeading,
    crossHeading
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    let tickData = [];
    let crossData = [];
    let tickHeading = '';
    let crossHeading = '';
    if (listIcon === 'tick-cross') {
      tickData = data.slice(0, 5);
      crossData = data.slice(5);
      const titleWithoutFirstWord = title.split(' ').slice(1).join(' ');
      tickHeading = "Thriving".concat(titleWithoutFirstWord === 'with Peer' ? ' Working' : '', " ").concat(titleWithoutFirstWord);
      crossHeading = "Struggling".concat(titleWithoutFirstWord === 'with Peer' ? ' Working' : '', " ").concat(titleWithoutFirstWord);
    }
    return {
      tickData,
      crossData,
      tickHeading,
      crossHeading
    };
  }, [title, data, listIcon]);
  const mapData = (data, icon) => {
    return data === null || data === void 0 ? void 0 : data.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "!tww-flex !tww-items-start !tww-mb-6",
      children: [!(discription && index === data.length - 1) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
        src: icon,
        className: "!tww-mt-2 img-fluid"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        children: [title === 'While Negotiating & Closing' && index === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
          className: "!tww-ml-2 !tww-font-semibold !tww-text-[12px] !tww-mb-2",
          children: ["The secret to closing fast with ", contactName, " is"]
        }), title === 'While Negotiating & Closing' && index === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
          className: "!tww-ml-2 !tww-font-semibold !tww-text-[12px] !tww-mb-2",
          children: ["Will you ever get a clear answer from ", contactName]
        }), title === 'Insights For Deal Planning' && index === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
          className: "!tww-ml-2 !tww-font-semibold !tww-text-[12px] !tww-mb-2",
          children: ["How Fast (Or Slow) Will ", contactName, " Move?"]
        }), title === 'Insights For Deal Planning' && index === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
          className: "!tww-ml-2 !tww-font-semibold !tww-text-[12px] !tww-mb-2",
          children: ["Can ", contactName, " Take Some Risk Or Not?"]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-2 f-14-400 !tww-text-[12px]",
          style: {
            color: '#52585F'
          },
          children: item
        })]
      })]
    }, index));
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "!tww-mt-3 accordianContainer",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      onClick: () => setOpen(!isOpen),
      role: "button",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [!isDesignChange && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
          src: icon,
          className: "img-fluid"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
            className: "!tww-m-0 !tww-ml-3 !tww-font-semibold !tww-text-[14px]",
            style: {
              color: '#1C1C1C'
            },
            children: title
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "!tww-w-[12px]",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
          src: (_public_assets_downArrow_svg__WEBPACK_IMPORTED_MODULE_2___default()),
          className: "!tww-transition !tww-w-full ".concat(isOpen ? '!tww-rotate-180' : '')
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "!tww-mt-3 !tww-p-2 ".concat(isOpen ? '!tww-block' : '!tww-hidden'),
      children: listIcon === 'tick-cross' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "!tww-ml-1 !tww-mb-1 !tww-font-semibold !tww-text-[12px]",
          children: tickHeading
        }), mapData(tickData, tickIcon), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "!tww-ml-1 !tww-mb-1 !tww-font-semibold !tww-text-[12px]",
          children: crossHeading
        }), mapData(crossData, crossIcon)]
      }) : mapData(data, listIcon)
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Accordian);

/***/ }),

/***/ "./src/component/common/aiSettingModal/Proposition.js":
/*!************************************************************!*\
  !*** ./src/component/common/aiSettingModal/Proposition.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Proposition)
/* harmony export */ });
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-icons/fa */ "./node_modules/react-icons/fa/index.mjs");
/* harmony import */ var react_icons_wi__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-icons/wi */ "./node_modules/react-icons/wi/index.mjs");
/* harmony import */ var react_icons_io__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-icons/io */ "./node_modules/react-icons/io/index.mjs");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");











function Proposition(_ref) {
  let {
    index,
    proposition,
    setValueProposition,
    setAiSettings,
    deleteProposition,
    selectedIndex,
    setSelectedIndex,
    onPropositionSaved
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_3__.useApiRequest)();
  const {
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.tokenState);
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [title, setTitle] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [inputTitle, setInputTitle] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [inputWebsite, setInputWebsite] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [inputCompanyName, setInputCompanyName] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const [inputValueProposition, setInputValueProposition] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    var _proposition$valueTex;
    setTitle((proposition === null || proposition === void 0 ? void 0 : proposition.title) || '');
    setInputTitle((proposition === null || proposition === void 0 ? void 0 : proposition.title) || '');
    setInputWebsite((proposition === null || proposition === void 0 ? void 0 : proposition.companyWebsite) || '');
    setInputCompanyName((proposition === null || proposition === void 0 ? void 0 : proposition.companyName) || '');
    if (!inputValueProposition && proposition !== null && proposition !== void 0 && proposition.valueText) {
      setInputValueProposition(proposition.valueText);
    }

    // Only open the panel for empty (new) entries
    if (!(proposition !== null && proposition !== void 0 && (_proposition$valueTex = proposition.valueText) !== null && _proposition$valueTex !== void 0 && _proposition$valueTex.trim())) {
      setIsOpen(true);
    }

    // Only set as selected if explicitly marked
    if (proposition !== null && proposition !== void 0 && proposition.isSelected) {
      setSelectedIndex(index);
    }
  }, [proposition === null || proposition === void 0 ? void 0 : proposition._id]);
  const handleInputChange = e => {
    const {
      name,
      value
    } = e.target;
    setValueProposition(index, name, value);
    if (name === 'title') setInputTitle(value);else if (name === 'companyWebsite') setInputWebsite(value);else if (name === 'companyName') setInputCompanyName(value);else if (name === 'valueText') setInputValueProposition(value);
  };
  const updateOrCreateValueProposition = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "/").concat(String(id)), 'GET');
      const isFirstProposition = data.length === 0;
      const payload = {
        userId: String(id),
        title: inputTitle,
        companyName: inputCompanyName,
        companyWebsite: inputWebsite,
        valueText: inputValueProposition,
        isSelected: isFirstProposition
      };
      let response;
      if (proposition._id) {
        payload.id = proposition._id;
        try {
          response = await makeRequest(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, 'PUT', payload);
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, " PUT API in common/aiSettingModal/Proposition.js file"),
            source: 'extension',
            module: 'Value Propositions'
          });
        }
      } else {
        try {
          response = await makeRequest(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, 'POST', payload);
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, " GET API in common/aiSettingModal/Proposition.js file"),
            source: 'extension',
            module: 'Value Propositions'
          });
        }
      }
      onPropositionSaved();
      if (response.data) {
        react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].success("Value proposition ".concat(proposition._id ? 'updated' : 'created', " successfully!"));
      }
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "/").concat(String(id), " POST API in common/aiSettingModal/Proposition.js file"),
        source: 'extension',
        module: 'Value Propositions'
      });
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error("Failed to ".concat(proposition._id ? 'update' : 'create', " value proposition!"));
    }
  };
  const toggleOpen = () => {
    const newState = !isOpen;
    setIsOpen(newState);
  };
  const toggleSelection = async () => {
    if (!inputValueProposition.trim()) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('Cannot select an empty Value Proposition!');
      return;
    }
    if (!proposition._id) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('Please save the value proposition before selecting!');
      return;
    }
    try {
      if (selectedIndex === index) {
        setSelectedIndex(null);
        const payload = {
          userId: String(id),
          title: inputTitle,
          companyName: inputCompanyName,
          companyWebsite: inputWebsite,
          valueText: inputValueProposition,
          isSelected: false,
          id: String(proposition._id)
        };
        try {
          const {
            data
          } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions), 'PUT', payload);
          if (data) {
            setValueProposition(index, data);
            react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].success('Deselected successfully!');
          }
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "} PUT API in common/aiSettingModal/Proposition.js file"),
            source: 'extension',
            module: 'Value Propositions'
          });
        }
      } else {
        try {
          await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "/unselect-all/").concat(String(id)), 'PUT');
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "/unselect-all/").concat(String(id), " PUT API in common/aiSettingModal/Proposition.js file"),
            source: 'extension',
            module: 'Value Propositions'
          });
        }
        setSelectedIndex(index);
        const payload = {
          userId: String(id),
          title: inputTitle,
          companyName: inputCompanyName,
          companyWebsite: inputWebsite,
          valueText: inputValueProposition,
          isSelected: true,
          id: String(proposition._id)
        };
        const {
          data
        } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions), 'PUT', payload);
        if (data) {
          setValueProposition(index, data);
          react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].success('Selection updated!');
        }
      }
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "\n        PUT API in common/aiSettingModal/Proposition.js file"),
        source: 'extension',
        module: 'Value Propositions'
      });
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('Failed to update selection!');
    }
  };
  const generateAIContent = async () => {
    if (!inputCompanyName.trim() || !inputWebsite.trim()) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('Please provide both Company Name and Website!');
      return;
    }
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "/generateAI"), 'POST', {
        companyName: inputCompanyName.trim(),
        companyWebsite: inputWebsite.trim()
      });
      if (data !== null && data !== void 0 && data.message) {
        setInputValueProposition(data.message);
        if (data.fallback) {
          react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].success('AI guidance provided instead of value proposition.');
        } else {
          react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].success('AI-generated value proposition is ready!');
        }
      } else {
        react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('No content received. Try again.');
      }
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.valuePropositions, "generateAI POST API in common/aiSettingModal/Proposition.js file"),
        source: 'extension',
        module: 'Value Propositions'
      });
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('Something went wrong while generating content.');
    }
  };
  const handleSave = () => {
    if (!(inputTitle !== null && inputTitle !== void 0 && inputTitle.trim()) || !(inputWebsite !== null && inputWebsite !== void 0 && inputWebsite.trim()) || !(inputCompanyName !== null && inputCompanyName !== void 0 && inputCompanyName.trim()) || !(inputValueProposition !== null && inputValueProposition !== void 0 && inputValueProposition.trim())) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_0__["default"].error('All fields are required!');
      return;
    }
    setTitle(inputTitle);
    setIsOpen(false);
    updateOrCreateValueProposition();
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "!tww-p-2 !tww-mt-4 !tww-border !tww-border-blue-500 !tww-rounded-md !tww-w-[340px]",
    style: {
      border: '1px solid',
      borderRadius: '8px !important'
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-gap-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          onClick: toggleOpen,
          className: "cursor-pointer",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_icons_io__WEBPACK_IMPORTED_MODULE_7__.IoMdArrowDropright, {})
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
          className: "!tww-font-semibold !tww-text-[14px]",
          children: title
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "".concat(isOpen ? '!tww-hidden' : '', " !tww-flex !tww-items-center !tww-gap-2"),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          onClick: inputValueProposition.trim() ? toggleSelection : undefined,
          className: "!tww-w-[30px] !tww-h-[16px] !tww-rounded-full !tww-flex ".concat(selectedIndex === index ? '!tww-justify-end !tww-bg-blue-500' : '!tww-bg-gray-400', " !tww-items-center ").concat(inputValueProposition.trim() ? '' : '!tww-opacity-50 !tww-cursor-not-allowed'),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "!tww-h-[12px] !tww-mx-[2px] !tww-aspect-square !tww-rounded-full !tww-bg-white"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_icons_fa__WEBPACK_IMPORTED_MODULE_8__.FaTrashAlt, {
          onClick: () => deleteProposition(index),
          className: "cursor-pointer"
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: " ".concat(isOpen ? '!tww-max-h-[400px] !tww-overflow-y-auto' : '!tww-hidden', " !tww-pt-2"),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "!tww-pt-2 !tww-pl-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
          className: "!tww-font-semibold !tww-text-[12px] !tww-mb-2",
          children: "Value proposition title"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
          type: "text",
          name: "title",
          value: inputTitle,
          onChange: handleInputChange,
          className: "!tww-w-full !tww-p-2 border border-gray-200 !tww-rounded-lg",
          style: {
            border: '1px solid'
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "!tww-flex !tww-flex-col !tww-gap-2 !tww-pt-2 !tww-pl-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
            className: "!tww-font-semibold !tww-text-[12px] !tww-mb-2",
            children: "Company's website"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
            type: "text",
            name: "companyWebsite",
            value: inputWebsite,
            onChange: handleInputChange,
            className: "!tww-w-full !tww-p-2 border border-gray-200 !tww-rounded-lg",
            style: {
              border: '1px solid'
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
            className: "!tww-font-semibold !tww-text-[12px] !tww-mb-2",
            children: "Company's name"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
            type: "text",
            name: "companyName",
            value: inputCompanyName,
            onChange: handleInputChange,
            className: "!tww-w-full !tww-p-2 border border-gray-200 !tww-rounded-lg",
            style: {
              border: '1px solid'
            }
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-justify-between !tww-pt-2 !tww-pl-4 !tww-my-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
          className: "!tww-font-semibold !tww-text-[12px] ",
          children: "Value proposition"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("button", {
          onClick: generateAIContent,
          className: "!tww-flex !tww-items-center !tww-gap-2 !tww-px-4 !tww-py-2 !tww-text-blue-300 !tww-border !tww-border-blue-300 !tww-rounded-md",
          style: {
            border: '1px solid',
            borderRadius: '8px !important'
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_icons_wi__WEBPACK_IMPORTED_MODULE_9__.WiStars, {
            className: "!tww-w-[20px] !tww-h-[20px]"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
            className: "!tww-font-semibold !tww-text-[12px]",
            children: "Generate with AI"
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "!tww-pl-4 !tww-pr-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("textarea", {
          name: "valueText",
          value: inputValueProposition,
          onChange: handleInputChange,
          className: "!tww-w-full !tww-p-2 !tww-border !tww-h-[300px] !tww-border-gray-200 !tww-rounded-lg",
          style: {
            border: '1px solid'
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "!tww-flex !tww-justify-center !tww-mt-4",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("button", {
          onClick: handleSave,
          className: "!tww-px-4 !tww-py-2 !tww-mt-6 !tww-text-white !tww-rounded-md !tww-bg-blue-600",
          children: "Save Value Proposition"
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./src/component/common/aiSettingModal/index.js":
/*!******************************************************!*\
  !*** ./src/component/common/aiSettingModal/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _public_assets_aiSetting_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/aiSetting.svg */ "./public/assets/aiSetting.svg");
/* harmony import */ var _public_assets_aiSetting_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_aiSetting_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _Proposition__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Proposition */ "./src/component/common/aiSettingModal/Proposition.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










function CustomModal(_ref) {
  var _payload$valueProposi;
  let {
    type,
    setLinkedInMessages,
    setIceBreaker,
    setEmail,
    setEmailLoading,
    setLinkedinLoading,
    setIceBreakerLoading
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_4__.useApiRequest)();
  const [aiSettingData, setAiSettingData] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.aiSettingState);
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [selectedIndex, setSelectedIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const {
    team,
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.tokenState);
  const userData = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.indvitualUserState);
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.reportPayloadState);
  const [payload, setPayload] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    userId: id,
    language: 'English',
    gender: 'Neutral',
    agenda: 'Sales',
    valuePropositions: []
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    fetchAiSettings();
    fetchValuePropositions();
  }, [aiSettingData, id]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const fetchAiSettings = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.aiSetting, "/user/").concat(id, "/last"), 'GET');
      if (data) {
        setPayload(prevState => ({
          ...prevState,
          language: data.language || 'English',
          agenda: data.agenda || 'Sales',
          gender: data.gender || 'Neutral'
        }));
      }
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.aiSetting, "/user/").concat(id, "/last GET API in common/aiSettingModal.js file"),
          source: 'extension',
          module: 'AI Settings'
        });
      } catch (error) {}
      console.error('Error fetching AI settings:', error);
    }
  };

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const fetchValuePropositions = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.valuePropositions, "/").concat(id), 'GET');
      setPayload({
        ...payload,
        userId: data.userId || id,
        valuePropositions: data || []
      });
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.valuePropositions, "/").concat(id, " GET API in common/aiSettingModal.js file"),
          source: 'extension',
          module: 'AI Settings - Value Propositions'
        });
      } catch (error) {}
    }
  };
  const deleteProposition = async index => {
    const propositionToDelete = payload.valuePropositions[index];
    try {
      await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.valuePropositions, "/").concat(propositionToDelete._id), 'DELETE');
      const newPropositions = payload.valuePropositions.filter((_, i) => i !== index);
      setPayload(prevState => ({
        ...prevState,
        valuePropositions: newPropositions
      }));
      react_hot_toast__WEBPACK_IMPORTED_MODULE_2__["default"].success('Value proposition deleted successfully!');
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.valuePropositions, "/").concat(propositionToDelete._id, " DELETE API in common/aiSettingModal.js file"),
        source: 'extension',
        module: 'AI Settings - Delete Value Propositions'
      });
      react_hot_toast__WEBPACK_IMPORTED_MODULE_2__["default"].error('Failed to delete value proposition!');
    }
  };
  const addProposition = () => {
    setPayload(prevState => {
      const newValuePropositions = [...prevState.valuePropositions, {
        title: '',
        website: '',
        companyName: '',
        valueProposition: ''
      }];
      return {
        ...prevState,
        valuePropositions: newValuePropositions
      };
    });
  };
  const handleInputChange = e => {
    const {
      id,
      value
    } = e.target;
    setPayload(prevState => ({
      ...prevState,
      [id]: value
    }));
  };
  const setValueProposition = (index, key, value) => {
    const newPropositions = [...payload.valuePropositions];
    newPropositions[index] = {
      ...newPropositions[index],
      [key]: value
    };
    setPayload(prevState => ({
      ...prevState,
      valuePropositions: newPropositions
    }));
  };
  const generateWithAi = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async _ref2 => {
    var _userData$leadId;
    let {
      aiSettingsId
    } = _ref2;
    const contact = (_userData$leadId = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId !== void 0 ? _userData$leadId : userData;
    setLinkedinLoading(true);
    try {
      var _contact$linkedIn;
      const payload = {
        userId: id,
        teamId: team === null || team === void 0 ? void 0 : team._id,
        linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.url,
        aiSettings: aiSettingsId
      };
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityLinkedIn), 'POST', payload);
      setLinkedInMessages(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityLinkedIn, " POST API in common/aiSettingModal.js file"),
        source: 'extension',
        module: 'AI Settings - LinkedinMessages'
      });
    } finally {
      setLinkedinLoading(false);
    }
  }, [userData, id, team === null || team === void 0 ? void 0 : team._id, makeRequest, setLinkedInMessages]);
  const setAiSettings = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      const allValueProposition = payload.valuePropositions;
      const allvaluesPayload = {
        ...payload,
        valuePropositions: allValueProposition
      };
      const selectedProposition = selectedIndex !== null ? [payload.valuePropositions[selectedIndex]] : [];
      const updatedPayload = {
        ...payload,
        valuePropositions: selectedProposition,
        userId: String(id)
      };
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.aiSetting), 'POST', updatedPayload);
      react_hot_toast__WEBPACK_IMPORTED_MODULE_2__["default"].success('AI settings saved successfully');
      if (type === 'linkedin') {
        generateWithAi({
          aiSettingsId: data === null || data === void 0 ? void 0 : data._id
        });
      }
      if (type === 'icebreaker') {
        var _userData$leadId2;
        const contact = (_userData$leadId2 = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId2 !== void 0 ? _userData$leadId2 : userData;
        setIceBreakerLoading(true);
        try {
          var _contact$linkedIn2;
          const payload = {
            userId: id,
            teamId: team === null || team === void 0 ? void 0 : team._id,
            linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn2 = contact.linkedIn) === null || _contact$linkedIn2 === void 0 ? void 0 : _contact$linkedIn2.url,
            aiSettings: data === null || data === void 0 ? void 0 : data._id
          };
          const response = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker), 'POST', payload);
          setIceBreaker(response.data);
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker, " POST API in common/aiSettingModal.js file"),
            source: 'extension',
            module: 'AI Settings - Ice Breaker'
          });
        } finally {
          setIceBreakerLoading(false);
        }
      }
      if (type === 'composeEmail') {
        setEmailLoading(true);
        try {
          const response = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityEmail), 'POST', {
            ...reportPayload,
            aiSettings: data === null || data === void 0 ? void 0 : data._id
          });
          setEmail(response.data);
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityEmail, " POST API in aiSettingModal.js file"),
            source: 'extension',
            module: 'AI Settings - Compose Email'
          });
        } finally {
          setEmailLoading(false);
        }
      }
      fetchAiSettings();
      setAiSettingData(allvaluesPayload);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.aiSetting, " POST API in common/aiSettingModal.js file"),
        source: 'extension',
        module: 'AI Settings'
      });
    }
  }, [fetchAiSettings, generateWithAi, id, makeRequest, payload, selectedIndex, setAiSettingData, setIceBreaker, team === null || team === void 0 ? void 0 : team._id, type, userData]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("button", {
      className: "!tww-flex !tww-items-center",
      onClick: () => setIsOpen(!isOpen),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("img", {
        src: (_public_assets_aiSetting_svg__WEBPACK_IMPORTED_MODULE_6___default()),
        alt: "aisettings"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
        className: "!tww-m-0 !tww-ml-3 f-13-400",
        style: {
          color: '#5690E8'
        },
        children: "AI settings"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      style: {
        top: '0',
        left: '0',
        zIndex: '5',
        backgroundColor: '#343a40bd'
      },
      className: "".concat(isOpen ? '!tww-flex' : '!tww-hidden', " !tww-absolute !tww-h-full !tww-w-full !tww-items-center !tww-justify-center"),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "!tww-flex !tww-flex-col !tww-max-h-[90vh] !tww-overflow-y-scroll custom-scrollbar2 !tww-p-4 !tww-bg-white",
        style: {
          width: '90%',
          borderRadius: '8px'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
          className: "!tww-relative !tww-flex !tww-items-center !tww-justify-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
            className: "!tww-text-center !tww-font-semibold !tww-text-[22px]",
            children: "AI Settings"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("button", {
            onClick: () => setIsOpen(false),
            className: "!tww-absolute !tww-top-0 !tww-right-0 !tww-flex !tww-items-center !tww-justify-center",
            style: {
              width: '20px',
              height: '20px',
              fontSize: '24px'
            },
            children: "x"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
          className: "!tww-text-center !tww-text-[12px] !tww-font-semibold !tww-text-gray-400",
          children: "In order to improve our AI algorithms you must enter the value proposition of your business."
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
          className: "!tww-flex !tww-flex-col",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("label", {
            htmlFor: "ui",
            className: "!tww-font-semibold !tww-text-[14px]",
            children: "Language used for generative AI *"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
            className: "!tww-flex !tww-items-center !tww-gap-3",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("select", {
              id: "language",
              value: payload.language,
              onChange: handleInputChange,
              className: "!tww-block !tww-p-2 !tww-w-[250px] !tww-mt-2 !tww-text-[14px] !tww-text-gray-900 !tww-border !tww-outline-none !tww-border-blue-200 !tww-rounded !tww-focus:!tww-border-blue-200",
              style: {
                border: '1px solid',
                borderRadius: '8px !important'
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "English",
                children: "English"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "French",
                children: "French"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Spanish",
                children: "Spanish"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "German",
                children: "German"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Dutch",
                children: "Dutch"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Italian",
                children: "Italian"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Portuguese",
                children: "Portuguese"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Chinese",
                children: "Chinese"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Japanese",
                children: "Japanese"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Korean",
                children: "Korean"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Russian",
                children: "Russian"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Arabic",
                children: "Arabic"
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
          className: "!tww-flex !tww-flex-col",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("label", {
            htmlFor: "he",
            className: "!tww-font-semibold",
            children: "What is the agenda of your email? Specify!"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("select", {
            id: "agenda",
            className: "!tww-block !tww-p-2 !tww-w-[250px] !tww-mt-2 !tww-text-[14px] !tww-text-gray-900 !tww-border !tww-outline-none !tww-border-blue-200 !tww-rounded !tww-focus:!tww-border-blue-200",
            style: {
              border: '1px solid',
              borderRadius: '8px !important'
            },
            value: payload.agenda,
            onChange: handleInputChange,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Sales",
              children: "Sales"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "C Level Pitch",
              children: "The C Level Pitch"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Feedback",
              children: "Feedback"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Casual",
              children: "Casual"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Holiday Greetings",
              children: "Holiday Greetings"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Sell",
              children: "Sell"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Invitation",
              children: "Invitation"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Collaboration Request",
              children: "Collaboration Request"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Suggestion Request",
              children: "Suggestion Request"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
              value: "Appreciation/Recognition",
              children: "Appreciation/Recognition"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
          className: "!tww-flex !tww-flex-col",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("label", {
            htmlFor: "ui",
            className: "!tww-font-semibold",
            children: "Gender used for generative AI *"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
            className: "!tww-flex !tww-items-center !tww-gap-3",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("select", {
              id: "gender",
              value: payload.gender,
              onChange: handleInputChange,
              className: "!tww-block !tww-p-2 !tww-w-[250px] !tww-mt-2 !tww-text-[14px] !tww-text-gray-900 !tww-border !tww-outline-none !tww-border-blue-200 !tww-rounded !tww-focus:!tww-border-blue-200",
              style: {
                border: '1px solid',
                borderRadius: '8px !important'
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "Undefined",
                children: "Neutral"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "male",
                children: "Male"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("option", {
                value: "female",
                children: "Female"
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("button", {
          style: {
            background: '#4083ff',
            color: 'white',
            borderRadius: '8px'
          },
          className: "!tww-w-[80px] !tww-mt-4 !tww-py-2 !tww-text-[14px] !tww-font-semibold",
          onClick: () => {
            setAiSettings();
            setIsOpen(false);
          },
          children: "Apply AI Settings"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-between !tww-mt-5",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
            className: "!tww-font-semibold !tww-text-[14px]",
            children: "Value Propositions"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("button", {
            style: {
              background: '#4083ff',
              color: 'white',
              borderRadius: '8px'
            },
            className: "!tww-w-[80px] !tww-py-2 !tww-text-[14px] !tww-font-semibold",
            onClick: addProposition,
            children: "Add"
          })]
        }), (_payload$valueProposi = payload.valuePropositions) === null || _payload$valueProposi === void 0 ? void 0 : _payload$valueProposi.map((proposition, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Proposition__WEBPACK_IMPORTED_MODULE_7__["default"], {
          index: index,
          proposition: proposition,
          setValueProposition: setValueProposition,
          setAiSettings: setAiSettings,
          deleteProposition: deleteProposition,
          selectedIndex: selectedIndex,
          setSelectedIndex: setSelectedIndex,
          onPropositionSaved: fetchValuePropositions
        }, index))]
      })
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomModal);

/***/ }),

/***/ "./src/component/common/apiContext/index.js":
/*!**************************************************!*\
  !*** ./src/component/common/apiContext/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApiHostProvider: () => (/* binding */ ApiHostProvider),
/* harmony export */   useApiHost: () => (/* binding */ useApiHost)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _middleware_fetch_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../middleware/fetch-api */ "./src/middleware/fetch-api/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const ApiHostContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  host: null,
  settingData: null
});
const ApiHostProvider = _ref => {
  let {
    children
  } = _ref;
  const [userData, setUserData] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.tokenState);
  const [host, setHost] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const [settingData, setSettingData] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.settingState);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    function handleStorageChange(changes, namespace) {
      try {
        if (namespace === 'local' && changes.userInfo) {
          const {
            newValue
          } = changes.userInfo;
          if (newValue) {
            setUserData(newValue);
          }
        }
      } catch (error) {
        console.error('Error in storage change handler:', error);
      }
    }
    chrome.storage.local.get('userInfo', result => {
      if (result.hasOwnProperty('userInfo')) {
        setUserData(result.userInfo);
      }
    });
    chrome.storage.onChanged.addListener(handleStorageChange);
    return () => {};
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const env = userData === null || userData === void 0 ? void 0 : userData.environment;
    const newHost = env === 'development' ? 'https://dev-api.eazyconnections.com/v1' : env === 'staging' ? 'https://staging-api.eazyconnections.com/v1' : env === 'production' ? 'https://api.eazyconnections.com/v1' : env === 'local' ? 'http://localhost:3001/v1' : null;
    // const newHost = "http://localhost:3001/v1";
    setHost(newHost);
  }, [userData === null || userData === void 0 ? void 0 : userData.environment]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!host) return;
    getSettings();
    const intervalId = setInterval(() => {
      getSettings();
    }, 30000);
    return () => clearInterval(intervalId);
  }, [host]);
  const getSettings = async () => {
    try {
      const {
        data
      } = await (0,_middleware_fetch_api__WEBPACK_IMPORTED_MODULE_4__.makeRequest)("".concat(host).concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.setting), 'GET', null, userData === null || userData === void 0 ? void 0 : userData.accessToken);
      setSettingData(data);
      chrome.storage.local.set({
        isCompanyAnalyzerEnabled: data === null || data === void 0 ? void 0 : data.companyAnalyzer,
        isCompanyAnalyzerExtensionEnabled: data === null || data === void 0 ? void 0 : data.companyAnalyzerExtension
      });
      chrome.runtime.sendMessage({
        type: 'SET_COMPANY_ANALYZER',
        value: !!(data !== null && data !== void 0 && data.companyAnalyzer),
        extensionValue: !!(data !== null && data !== void 0 && data.companyAnalyzerExtension)
      });
      // console.log("API Settings Response:", data);
      // console.log("companyAnalyzer value:", data?.companyAnalyzer);
      // console.log("companyAnalyzerExtension value:", data?.companyAnalyzerExtension);
    } catch (error) {
      await (0,_middleware_fetch_api__WEBPACK_IMPORTED_MODULE_4__.makeRequest)('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(host).concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.setting, " GET API in common/apiContext.js file"),
        source: 'extension'
      });
    }
    if (!host || !(userData !== null && userData !== void 0 && userData.accessToken)) return;
    try {
      await (0,_middleware_fetch_api__WEBPACK_IMPORTED_MODULE_4__.makeRequest)("".concat(host, "/users/update-extension-installed"), 'POST', null, userData.accessToken);
    } catch (error) {
      await (0,_middleware_fetch_api__WEBPACK_IMPORTED_MODULE_4__.makeRequest)('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(host, "/users/update-extension-installed POST API in common/apiContext.js file"),
        source: 'extension',
        module: 'Update Extension'
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(ApiHostContext.Provider, {
    value: {
      host,
      settingData
    },
    children: children
  });
};
const useApiHost = () => (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ApiHostContext);

/***/ }),

/***/ "./src/component/common/barChart/index.js":
/*!************************************************!*\
  !*** ./src/component/common/barChart/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recharts */ "./node_modules/recharts/es6/component/ResponsiveContainer.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! recharts */ "./node_modules/recharts/es6/chart/BarChart.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recharts */ "./node_modules/recharts/es6/cartesian/XAxis.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! recharts */ "./node_modules/recharts/es6/cartesian/Bar.js");
/* harmony import */ var recharts__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! recharts */ "./node_modules/recharts/es6/component/Cell.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const CustomXAxisTick = _ref => {
  let {
    x,
    y,
    payload,
    data
  } = _ref;
  const entry = data.find(d => d.name === payload.value);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("g", {
    transform: "translate(".concat(x, ",").concat(y, ")"),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("text", {
      x: 0,
      y: 0,
      dy: 16,
      textAnchor: "middle",
      style: {
        fill: entry === null || entry === void 0 ? void 0 : entry.color,
        fontSize: '19px',
        fontWeight: 'bold'
      },
      children: payload.value.charAt(0)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("text", {
      x: 0,
      y: 0,
      dy: 39,
      textAnchor: "middle",
      style: {
        fill: '#4d4d4d',
        fontSize: '16px',
        fontWeight: 'bolder'
      },
      children: entry ? "".concat(entry.value, "%") : ''
    })]
  });
};
const BarChart = _ref2 => {
  var _Object$values;
  let {
    data,
    isOcean = false
  } = _ref2;
  const ScoreValues = (_Object$values = Object.values(data)) === null || _Object$values === void 0 ? void 0 : _Object$values.map(Number);
  const discData = [{
    name: 'Dominant',
    value: ScoreValues[0],
    color: '#514BFE'
  }, {
    name: 'Influenced',
    value: ScoreValues[1],
    color: '#DF3260'
  }, {
    name: 'Steady',
    value: ScoreValues[2],
    color: '#FDC944'
  }, {
    name: 'Complaint',
    value: ScoreValues[3],
    color: '#4CB04F'
  }];
  const oceanData = [{
    name: 'O',
    value: ScoreValues[0],
    color: '#514BFE'
  }, {
    name: 'C',
    value: ScoreValues[1],
    color: '#DF3260'
  }, {
    name: 'E',
    value: ScoreValues[2],
    color: '#FDC944'
  }, {
    name: 'A',
    value: ScoreValues[3],
    color: '#4CB04F'
  }, {
    name: 'N',
    value: ScoreValues[4],
    color: '#0F87E4'
  }];
  const graphData = isOcean ? oceanData : discData;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(recharts__WEBPACK_IMPORTED_MODULE_2__.ResponsiveContainer, {
    width: "100%",
    height: 250,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(recharts__WEBPACK_IMPORTED_MODULE_3__.BarChart, {
      data: graphData,
      margin: {
        bottom: 50
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(recharts__WEBPACK_IMPORTED_MODULE_4__.XAxis, {
        dataKey: "name",
        tick: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(CustomXAxisTick, {
          data: graphData
        }),
        tickLine: false,
        axisLine: false
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(recharts__WEBPACK_IMPORTED_MODULE_5__.Bar, {
        dataKey: "value",
        barSize: 40,
        radius: 10,
        children: graphData === null || graphData === void 0 ? void 0 : graphData.map((entry, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(recharts__WEBPACK_IMPORTED_MODULE_6__.Cell, {
          fill: entry.color
        }, "cell-".concat(index)))
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BarChart);

/***/ }),

/***/ "./src/component/common/callScript/callScriptBox.js":
/*!**********************************************************!*\
  !*** ./src/component/common/callScript/callScriptBox.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_icons_lu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-icons/lu */ "./node_modules/react-icons/lu/index.mjs");
/* harmony import */ var _utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../utils/copyTextToClipboard */ "./src/utils/copyTextToClipboard.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




function CallScriptBox(_ref) {
  var _Object$keys;
  let {
    callScripts
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "!tww-p-4 !tww-rounded-lg !tww-shadow-xl !tww-relative !tww-mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "!tww-absolute !tww-top-4 !tww-right-4",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_icons_lu__WEBPACK_IMPORTED_MODULE_2__.LuCopy, {
        onClick: () => (0,_utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_0__.copyTextToClipboard)(JSON.stringify(callScripts, null, 2)),
        role: "button"
      })
    }), (_Object$keys = Object.keys(callScripts)) === null || _Object$keys === void 0 ? void 0 : _Object$keys.map((key, idx) => {
      const cleanedKey = key === null || key === void 0 ? void 0 : key.replace(/company|based/gi, '');
      const formatTitle = title => {
        var _title$replace;
        return title === null || title === void 0 || (_title$replace = title.replace(/([A-Z])/g, ' $1')) === null || _title$replace === void 0 || (_title$replace = _title$replace.replace(/^./, str => str.toUpperCase())) === null || _title$replace === void 0 ? void 0 : _title$replace.trim();
      };
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "!tww-flex !tww-justify-between",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "!tww-px-4 !tww-py-1 !tww-rounded-full !tww-bg-[#dcfce7] !tww-font-bold !tww-mb-2 !tww-text-[12px] !tww-text-green-900 !tww-w-fit",
            children: formatTitle(cleanedKey)
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "!tww-relative !tww-w-full !tww-pb-2 !tww-mb-4 !tww-whitespace-pre-line ".concat(idx === Object.keys(callScripts).length - 1 ? '' : '!tww-border-b'),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
            className: "text-[16px]",
            children: callScripts[key]
          })
        })]
      }, idx);
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallScriptBox);

/***/ }),

/***/ "./src/component/common/callScript/index.js":
/*!**************************************************!*\
  !*** ./src/component/common/callScript/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-icons/bs */ "./node_modules/react-icons/bs/index.mjs");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _callScriptBox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./callScriptBox */ "./src/component/common/callScript/callScriptBox.js");
/* harmony import */ var _loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../loader */ "./src/component/common/loader/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const CallScripts = () => {
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_3__.useApiRequest)();
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.reportPayloadState);
  const [callScripts, setCallScripts] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const [selectedScriptType, setSelectedScriptType] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('default');
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const generateCallScript = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const payload = {
        ...reportPayload
      };
      if (selectedScriptType === "Josh Braun's Insights") {
        payload.cLevelPitch = true;
      }
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.personalityCallScript), 'POST', payload);
      setCallScripts(data);
      setLoading(false);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_2__.personalityCallScript, " POST API in common/callScript.js file"),
        source: 'extension',
        module: 'Call Script'
      });
      setLoading(false);
    }
  }, [makeRequest, reportPayload, selectedScriptType]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    generateCallScript();
  }, [generateCallScript]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-justify-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-center",
          style: {
            width: '37px',
            height: '37px',
            borderRadius: '3px',
            marginLeft: '8px'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-bg-sky-700 !tww-h-[37px] !tww-w-[37px] !tww-rounded-lg !tww-flex !tww-items-center !tww-justify-center",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_icons_bs__WEBPACK_IMPORTED_MODULE_8__.BsTelephoneForwardFill, {
              className: "!tww-text-white",
              size: 20
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-3 f-14-500",
          children: "Call Script"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-center !tww-gap-6 !tww-mt-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "scriptType",
        className: "!tww-font-bold !tww-pb-3",
        children: "Select Call Script Type:"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("select", {
        id: "scriptType",
        className: "!tww-p-2 !tww-border !tww-rounded-lg !tww-w-[200px]",
        value: selectedScriptType,
        onChange: e => setSelectedScriptType(e.target.value),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("option", {
          value: "default",
          children: "Eazyconnection Default"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("option", {
          value: "Josh Braun's Insights",
          children: "Josh Braun's Insights"
        })]
      })]
    }), loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "!tww-h-[65vh] !tww-flex !tww-items-center !tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_loader__WEBPACK_IMPORTED_MODULE_6__["default"], {})
    }), callScripts && !loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_callScriptBox__WEBPACK_IMPORTED_MODULE_5__["default"], {
      callScripts: callScripts
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallScripts);

/***/ }),

/***/ "./src/component/common/contextAccordian/index.js":
/*!********************************************************!*\
  !*** ./src/component/common/contextAccordian/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_caretDown_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/caretDown.svg */ "./public/assets/caretDown.svg");
/* harmony import */ var _public_assets_caretDown_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_caretDown_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const Contexts = ["Captain (D)", "Job Title", "Industry", "Biography", "Age Range", "Job Level", "+7"];
const ContextAccordian = () => {
  var _data$leadId, _personalityData$disc, _data$leadId2, _data$leadId3, _data$leadId4, _data$leadId5;
  const data = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.indvitualUserState);
  const personalityData = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.personalityReportState);
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "text-box-2 !tww-flex !tww-flex-col !tww-mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-gap-3 cursor-pointer",
      onClick: () => setIsOpen(!isOpen),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("img", {
        src: (_public_assets_caretDown_svg__WEBPACK_IMPORTED_MODULE_1___default()),
        className: "!tww-transition ".concat(isOpen ? "!tww-rotate-180" : "")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
        className: "f-13-600 !tww-m-0",
        children: ["Personalization Context for ", data === null || data === void 0 || (_data$leadId = data.leadId) === null || _data$leadId === void 0 ? void 0 : _data$leadId.firstName]
      })]
    }), isOpen ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: " !tww-flex !tww-items-center !tww-gap-1 !tww-font-bold !tww-text-[10px] !tww-mt-2 !tww-capitalize",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "active-box",
        children: personalityData === null || personalityData === void 0 || (_personalityData$disc = personalityData.discStyle) === null || _personalityData$disc === void 0 ? void 0 : _personalityData$disc.pertyDiscType
      }), (data === null || data === void 0 || (_data$leadId2 = data.leadId) === null || _data$leadId2 === void 0 ? void 0 : _data$leadId2.jobTitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
        className: "context-box",
        children: ["Job Title: ", data === null || data === void 0 || (_data$leadId3 = data.leadId) === null || _data$leadId3 === void 0 ? void 0 : _data$leadId3.jobTitle]
      }), (data === null || data === void 0 || (_data$leadId4 = data.leadId) === null || _data$leadId4 === void 0 ? void 0 : _data$leadId4.industry) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
        className: "context-box",
        children: ["Industry: ", data === null || data === void 0 || (_data$leadId5 = data.leadId) === null || _data$leadId5 === void 0 ? void 0 : _data$leadId5.industry]
      })]
    }) : null]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContextAccordian);

/***/ }),

/***/ "./src/component/common/customPopup/index.js":
/*!***************************************************!*\
  !*** ./src/component/common/customPopup/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_icons_io5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-icons/io5 */ "./node_modules/react-icons/io5/index.mjs");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const CustomPopup = _ref => {
  let {
    text,
    onClose
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "!tww-fixed !tww-inset-0 !tww-z-50 !tww-flex !tww-items-center !tww-justify-center !tww-bg-opacity-50 !tww-py-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "!tww-bg-gray-400 !tww-p-4 !tww-rounded-lg !tww-shadow-lg",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "!tww-flex !tww-justify-between !tww-items-start !tww-gap-3 !tww-text-sm",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          className: "!tww-w-[270px] !tww-text-center",
          children: text
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_icons_io5__WEBPACK_IMPORTED_MODULE_1__.IoClose, {
          size: 22,
          onClick: () => onClose(),
          className: "cursor-pointer !tww-w-[20px] !tww-mt-1"
        })]
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomPopup);

/***/ }),

/***/ "./src/component/common/customTooltip/index.js":
/*!*****************************************************!*\
  !*** ./src/component/common/customTooltip/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



const traingleSvg = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  xmlnsXlink: "http://www.w3.org/1999/xlink",
  fill: " #374151",
  height: "10px",
  width: "10px",
  version: "1.1",
  id: "Layer_1",
  viewBox: "0 0 511.509 511.509",
  xmlSpace: "preserve",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("g", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("g", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
        d: "M498.675,493.845L265.16,5.568c-3.541-7.424-15.701-7.424-19.243,0L11.251,496.235c-1.579,3.307-1.344,7.189,0.597,10.283    s5.355,4.992,9.024,4.992h469.76c5.888,0,10.667-4.779,10.667-10.667C501.299,498.176,500.317,495.723,498.675,493.845z"
      })
    })
  })
});
const CustomTooltip = _ref => {
  let {
    children,
    tooltipText,
    maxWidth = false,
    customClass = "",
    tooltipLink
  } = _ref;
  const [showTooltip, setShowTooltip] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const tooltipRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleMouseMove = event => {
      var _tooltipRef$current;
      const rect = tooltipRef === null || tooltipRef === void 0 || (_tooltipRef$current = tooltipRef.current) === null || _tooltipRef$current === void 0 ? void 0 : _tooltipRef$current.getBoundingClientRect();
      const isInside = (rect === null || rect === void 0 ? void 0 : rect.left) <= (event === null || event === void 0 ? void 0 : event.clientX) && (event === null || event === void 0 ? void 0 : event.clientX) <= (rect === null || rect === void 0 ? void 0 : rect.right) && (rect === null || rect === void 0 ? void 0 : rect.top) <= (event === null || event === void 0 ? void 0 : event.clientY) && event.clientY <= (rect === null || rect === void 0 ? void 0 : rect.bottom);
      if (!isInside) {
        setShowTooltip(false);
      }
    };
    window.addEventListener("mousemove", handleMouseMove);
    return () => {
      window.removeEventListener("mousemove", handleMouseMove);
    };
  }, []);
  const handleMouseEnter = () => {
    setShowTooltip(true);
  };
  const handleMouseLeave = () => {
    setShowTooltip(false);
  };
  const handleRedirect = () => {
    if (!tooltipLink) return;
    window.open(tooltipLink, "_blank");
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    ref: tooltipRef,
    className: "!tww-relative ".concat(tooltipLink && "!tww-cursor-pointer"),
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    onClick: handleRedirect,
    children: [children, showTooltip && tooltipText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "!tww-bg-slate-700 ".concat(tooltipText.includes("You have") ? "!tww-w-[160px] !tww-ml-[-40px]" : "", " !tww-text-white !tww-p-2.5 !tww-rounded-md !tww-absolute !tww-top-[115%] !tww-text-xl !tww-font-medium !tww-z-[99] ").concat(maxWidth ? "!tww-text-nowrap" : "", " ").concat(customClass),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "!tww-relative !tww-w-full !tww-h-full",
        children: tooltipText
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomTooltip);

/***/ }),

/***/ "./src/component/common/editTextBox/index.js":
/*!***************************************************!*\
  !*** ./src/component/common/editTextBox/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_edit_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/edit.svg */ "./public/assets/edit.svg");
/* harmony import */ var _public_assets_edit_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_edit_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _public_assets_refresh_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/refresh.svg */ "./public/assets/refresh.svg");
/* harmony import */ var _public_assets_refresh_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_refresh_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_copyNew_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/copyNew.svg */ "./public/assets/copyNew.svg");
/* harmony import */ var _public_assets_copyNew_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_copyNew_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CustomLoader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../CustomLoader */ "./src/component/common/CustomLoader/index.js");
/* harmony import */ var _utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/copyTextToClipboard */ "./src/utils/copyTextToClipboard.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");








const EditTextBox = _ref => {
  let {
    label,
    text,
    isLoading,
    refresh
  } = _ref;
  const [isEditable, setIsEditable] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("false");
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "!tww-flex !tww-flex-col text-box !tww-mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "!tww-flex !tww-justify-end",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
          onClick: () => !isLoading && refresh(),
          className: "!tww-cursor-pointer ".concat(isLoading ? "!tww-opacity-50" : ""),
          src: (_public_assets_refresh_svg__WEBPACK_IMPORTED_MODULE_2___default())
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
          onClick: () => (0,_utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_5__.copyTextToClipboard)(text),
          className: "!tww-cursor-pointer",
          src: (_public_assets_copyNew_svg__WEBPACK_IMPORTED_MODULE_3___default())
        })]
      })
    }), isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CustomLoader__WEBPACK_IMPORTED_MODULE_4__["default"], {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("pre", {
      className: "!tww-mt-5 f-13-400",
      contentEditable: isEditable,
      style: {
        textWrap: "balance"
      },
      children: text
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditTextBox);

/***/ }),

/***/ "./src/component/common/engagementCards/index.js":
/*!*******************************************************!*\
  !*** ./src/component/common/engagementCards/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _customPopup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../customPopup */ "./src/component/common/customPopup/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const EngagementCard = _ref => {
  let {
    label,
    icon,
    color,
    text,
    btnText,
    endpoint
  } = _ref;
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_4__.useNavigate)();
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isPopupOpen, setIsPopupOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const popUpRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleClickOutside = event => {
      if (popUpRef.current && !popUpRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    };
    if (isOpen) {
      document.addEventListener("click", handleClickOutside, true);
    }
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  }, [isOpen]);
  const handleClick = () => {
    if (["AI Coaching"].includes(label)) {
      setIsPopupOpen(true);
      // toast(
      //   "This Feature will be released in the Next Version!",
      //   {
      //     style: {
      //       background: '#334155',
      //       color: '#fff'
      //     }
      //   }
      // );
    } else {
      navigate("/personality/".concat(endpoint));
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isPopupOpen) {
      const timer = setTimeout(() => {
        setIsPopupOpen(false);
      }, 4000);
      return () => clearTimeout(timer);
    }
  }, [isPopupOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    onClick: () => setIsOpen(true),
    ref: popUpRef,
    className: "!tww-p-3 !tww-relative engagement-card",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "!tww-flex !tww-items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
        src: icon,
        className: "img-fluid",
        alt: "icon",
        style: {
          width: "20px",
          height: "20px"
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "!tww-m-0 !tww-ml-2 f-13-700",
        children: label
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
      className: "!tww-m-0 !tww-mt-2 !tww-mb-6 f-13-400",
      children: text
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-center !tww-mt-2",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("button", {
        type: "button",
        onClick: handleClick,
        className: "!tww-relative !tww-text-white !tww-bg-gradient-to-r !tww-from-[#7B5DE9] !tww-via-[#7B5DE9] !tww-to-[#7B5DE9] hover:!tww-bg-gradient-to-br focus:!tww-ring-4 focus:!tww-outline-none focus:!tww-ring-blue-300 dark:focus:!tww-ring-blue-800 !tww-rounded-lg !tww-px-3 !tww-py-2.5 !tww-text-center !tww-me-2 !tww-mb-2 !tww-shadow-[0_4px_8px_rgba(0,0,0,0.2)] hover:!tww-shadow-[0_6px_12px_rgba(0,0,0,0.3)] active:!tww-shadow-[0_2px_4px_rgba(0,0,0,0.2)] active:!tww-translate-y-1 !tww-transition-all !tww-duration-200",
        style: {
          fontSize: "11px",
          fontWeight: "500",
          width: "120px"
        },
        children: btnText
      })
    }), isPopupOpen && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_customPopup__WEBPACK_IMPORTED_MODULE_1__["default"], {
      text: "This Feature will be released in the Next Version!",
      onClose: () => setIsPopupOpen(false)
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EngagementCard);

/***/ }),

/***/ "./src/component/common/loader/index.js":
/*!**********************************************!*\
  !*** ./src/component/common/loader/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/logo-main.svg */ "./public/assets/logo-main.svg");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



const Loader = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: "!tww-flex !tww-items-center !tww-justify-center",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("img", {
      src: (_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1___default()),
      alt: "EazyConnections Logo",
      className: "!tww-animate-spin-slow"
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Loader);

/***/ }),

/***/ "./src/component/common/personalityLayout/index.js":
/*!*********************************************************!*\
  !*** ./src/component/common/personalityLayout/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");


const PersonalityLayout = _ref => {
  let {
    children,
    title,
    isFullAnalytics,
    tooltipLink
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "!tww-relative !tww-mt-10 !tww-mb-2 layoutContainer",
    style: {
      border: !isFullAnalytics ? "1px solid #e7e9ea" : "none"
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "header",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-px-2 !tww-mr-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
          src: "https://ez-staging.s3.ap-south-1.amazonaws.com/borderIcon.png",
          className: "img-fluid"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
          className: "!tww-ml-2 f-12-600 !tww-uppercase ".concat(title.includes("Personality") ? "userNamePersonality" : "userName !!tww-max-w-full"),
          children: title
        })]
      })
    }), children]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PersonalityLayout);

/***/ }),

/***/ "./src/component/common/runAnalysisModal/index.js":
/*!********************************************************!*\
  !*** ./src/component/common/runAnalysisModal/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/logo-main.svg */ "./public/assets/logo-main.svg");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");





const RunAnalysisModal = _ref => {
  let {
    onGeneratePersonality,
    credits,
    environment
  } = _ref;
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const creditsLeft = (credits === null || credits === void 0 ? void 0 : credits.remainingPersonality) > 0;
  const personalityBarProgress = (credits.totalPersonality - credits.remainingPersonality) / credits.totalPersonality * 100;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    style: {
      top: '0',
      left: '0'
    },
    className: "".concat(isOpen ? '!tww-flex' : '!tww-hidden', " !tww-absolute !tww-h-full !tww-w-full !tww-items-center !tww-justify-center"),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "!tww-bg-white !tww-w-[360px] !tww-rounded-md !tww-p-5 !tww-border !tww-border-gray-500 !tww-shadow-xl ",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "!tww-flex !tww-justify-center",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
          src: (_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_1___default()),
          alt: "logo",
          width: 50,
          height: 50
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
        className: "!tww-text-center f-14-400 !tww-mt-3",
        children: creditsLeft ? "Use 1 Personality Credits to know about Prospect's Personality and Prospect's Company" : 'No Personality Credits left. Please upgrade your plan to generate Personality Credits.'
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "!tww-flex !tww-justify-center",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("button", {
          type: "button",
          className: "!tww-w-[240px] !tww-mt-5 reveal-btn !tww-py-3 !tww-text-white !tww-rounded-xl !tww-font-bold",
          onClick: () => {
            if (creditsLeft) {
              setIsOpen(false);
              onGeneratePersonality();
            } else {
              (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_2__.navigateToPortal)('subscriptions/new', environment);
            }
          },
          children: creditsLeft ? 'Generate Personality Credits' : 'Upgrade Plan'
        })
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RunAnalysisModal);

/***/ }),

/***/ "./src/component/common/traistProgressBar/index.js":
/*!*********************************************************!*\
  !*** ./src/component/common/traistProgressBar/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressChart)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");


function Bar(_ref) {
  let {
    percent
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "!tww-relative !tww-w-full !tww-h-[18px] !tww-bg-gray-200 !tww-rounded-sm",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "!tww-absolute !tww-top-0 !tww-left-0 !tww-h-[18px] !tww-rounded-sm !tww-bg-[#8382fb] !tww-flex !tww-justify-end",
      style: {
        width: percent
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        className: "!tww-mr-1 !tww-text-white !tww-flex !tww-items-center !tww-text-[10px]",
        children: percent
      })
    })
  });
}
function ProgressChart(_ref2) {
  let {
    oceanScore
  } = _ref2;
  // Ensure oceanScore is a JSON string, if not convert it to a string format
  const scores = typeof oceanScore === "string" ? JSON.parse(oceanScore) : oceanScore;
  const data = [{
    title: "OPENNESS",
    desc: "Is the measure of how open to experience, open-minded, and imaginative. ",
    percent: scores[0] / 50 * 100 + "%"
  }, {
    title: "CONSCIENTIOUSNESS",
    desc: "Conscientiousness measures the thoutfulness and organization of person.",
    percent: scores[1] / 50 * 100 + "%"
  }, {
    title: "EXTRAVERSION",
    desc: "Extraversion is a measure of how outgoing, talkative, and people-oriented.",
    percent: scores[2] / 50 * 100 + "%"
  }, {
    title: "AGREEABLENESS",
    desc: "Agreeableness measures how easily a person connects with others.",
    percent: scores[3] / 50 * 100 + "%"
  }, {
    title: "EMOTIONAL STABILITY",
    desc: "Is a measure of how calm and stable a person is during stress.",
    percent: scores[4] / 50 * 100 + "%"
  }];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "!tww-text-[10px] !tww-pb-7 !tww-w-full !tww-flex !tww-flex-col !tww-gap-5",
    children: data === null || data === void 0 ? void 0 : data.map((d, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        className: "!tww-font-semibold !tww-text-[12px]",
        children: d.title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        className: "!tww-text-[10px] !tww-mb-2",
        children: d.desc
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Bar, {
        percent: d.percent
      })]
    }, idx))
  });
}

/***/ }),

/***/ "./src/component/common/traistsGraph/index.js":
/*!****************************************************!*\
  !*** ./src/component/common/traistsGraph/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TraitsGraph)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



function TraitsGraphRow(_ref) {
  let {
    markIndex,
    leftName,
    rightName
  } = _ref;
  const markers = [1, 2, 3, 4, 5];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "!tww-flex !tww-justify-center !tww-items-center !tww-my-2 !tww-text-[8px] !tww-w-full",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      className: "!tww-mr-2 !tww-w-[65px] !tww-text-[10px]",
      children: leftName
    }), markers === null || markers === void 0 ? void 0 : markers.map((_, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-center !tww-h-full",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        className: "!tww-relative !tww-flex !tww-items-center !tww-justify-center",
        children: index === markIndex ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
          className: "!tww-h-[10px] !tww-w-[10px] !tww-absolute !tww-top-1/2 !tww-left-1/2 -!tww-translate-x-1/2 -!tww-translate-y-1/2 !tww-bg-green-500 !tww-rounded-full"
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("hr", {
          className: "!tww-h-[10px] !tww-m-0 !tww-w-[1px] !tww-bg-gray-500 !tww-mx-auto"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("hr", {
        className: "".concat(index === 4 ? '!tww-hidden' : '', " !tww-h-[2px] !tww-w-[34px] !tww-bg-gray-300 !tww-m-0")
      })]
    }, index)), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      className: "!tww-ml-2 !tww-w-[65px] !tww-text-right !tww-text-[10px]",
      children: rightName
    })]
  });
}
function TraitsGraph(_ref2) {
  let {
    data
  } = _ref2;
  const points = [{
    markIndex: parseInt(data[0][data[0].length - 1], 10) - 1,
    leftName: 'Risk tolerant',
    rightName: 'Risk averse'
  }, {
    markIndex: parseInt(data[1][data[1].length - 1], 10) - 1,
    leftName: 'Trusting',
    rightName: 'Skeptical'
  }, {
    markIndex: parseInt(data[2][data[2].length - 1], 10) - 1,
    leftName: 'Optimistic',
    rightName: 'Pragmatic'
  }, {
    markIndex: parseInt(data[3][data[3].length - 1], 10) - 1,
    leftName: 'Deliberate',
    rightName: 'Fast-paced'
  }, {
    markIndex: parseInt(data[4][data[4].length - 1], 10) - 1,
    leftName: 'Matter-of-fact',
    rightName: 'Expressive'
  }, {
    markIndex: parseInt(data[5][data[5].length - 1], 10) - 1,
    leftName: 'Autonomous',
    rightName: 'Collaborative'
  }, {
    markIndex: parseInt(data[6][data[6].length - 1], 10) - 1,
    leftName: 'Supporting',
    rightName: 'Dominant'
  }];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "!tww-relative !tww-flex !tww-flex-col !tww-w-full !tww-gap-3 !tww-mb-2",
    children: points === null || points === void 0 ? void 0 : points.map((d, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(TraitsGraphRow, {
      markIndex: d.markIndex,
      leftName: d.leftName,
      rightName: d.rightName
    }, idx))
  });
}

/***/ }),

/***/ "./src/component/composeEmail/index.js":
/*!*********************************************!*\
  !*** ./src/component/composeEmail/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_contextAccordian__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/contextAccordian */ "./src/component/common/contextAccordian/index.js");
/* harmony import */ var _common_editTextBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/editTextBox */ "./src/component/common/editTextBox/index.js");
/* harmony import */ var _public_assets_engageEmail_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../public/assets/engageEmail.svg */ "./public/assets/engageEmail.svg");
/* harmony import */ var _public_assets_engageEmail_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_engageEmail_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _common_aiSettingModal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/aiSettingModal */ "./src/component/common/aiSettingModal/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _common_loader__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../common/loader */ "./src/component/common/loader/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");












const ComposeEmail = () => {
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_8__.useApiRequest)();
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.reportPayloadState);
  const aiSetting = (0,recoil__WEBPACK_IMPORTED_MODULE_4__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.aiSettingState);
  const [email, setEmail] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const generateEmail = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityEmail), 'POST', {
        ...reportPayload,
        aiSettings: aiSetting === null || aiSetting === void 0 ? void 0 : aiSetting._id
      });
      setLoading(false);
      setEmail(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityEmail, " POST API in composeEmail.js file in generateEmail method"),
        source: 'extension',
        module: 'Compose Email'
      });
      setLoading(false);
    }
  }, [aiSetting, reportPayload]);
  const initialGeneration = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityEmail), 'POST', {
        ...reportPayload
      });
      setLoading(false);
      setEmail(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.personalityEmail, " POST API in composeEmail.js file in initialGeneraation method"),
        source: 'extension',
        module: 'Compose Email'
      });
      setLoading(false);
    }
  }, [reportPayload]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    initialGeneration();
  }, [initialGeneration]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-center",
          style: {
            width: '37px',
            height: '37px',
            borderRadius: '3px',
            backgroundColor: '#AD1269'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("img", {
            src: (_public_assets_engageEmail_svg__WEBPACK_IMPORTED_MODULE_3___default()),
            alt: "email-svg",
            className: "img-fluid",
            style: {
              width: '24px',
              height: '24px'
            }
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-3 f-14-500",
          children: "Email"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_common_aiSettingModal__WEBPACK_IMPORTED_MODULE_7__["default"], {
        type: 'composeEmail',
        setEmail: setEmail,
        setEmailLoading: setLoading
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_common_contextAccordian__WEBPACK_IMPORTED_MODULE_1__["default"], {}), loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "!tww-h-[65vh] !tww-flex !tww-items-center !tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_common_loader__WEBPACK_IMPORTED_MODULE_9__["default"], {})
    }), (email === null || email === void 0 ? void 0 : email.emailBody) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_2__["default"], {
      label: email === null || email === void 0 ? void 0 : email.emailSubject,
      refresh: generateEmail,
      text: email === null || email === void 0 ? void 0 : email.emailBody,
      isLoading: loading
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComposeEmail);

/***/ }),

/***/ "./src/component/folder/folderModal/create.js":
/*!****************************************************!*\
  !*** ./src/component/folder/folderModal/create.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../loading */ "./src/component/loading/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");








const FolderCreation = _ref => {
  let {
    userInfo,
    setOpenFolderModal,
    isTag,
    isUpdateContact,
    setViewFolder
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_5__.useApiRequest)();
  const [payload, setPayload] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    color: "#7c838a"
  });
  const [loading, setloading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [selectedFolder, setSelectedFolder] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedFolderState);
  const [selectedTags, setSelectedTags] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedTagsState);
  const handleColorSelect = e => {
    setPayload({
      ...payload,
      color: e.target.value
    });
  };
  const handleFolderNameChange = event => {
    if (isTag) {
      setPayload({
        ...payload,
        title: event.target.value
      });
    } else {
      setPayload({
        ...payload,
        name: event.target.value
      });
    }
  };
  const handleSubmit = async () => {
    try {
      setloading(true);
      if (isTag) {
        var _data$data, _data$data2, _data$data3;
        const {
          data
        } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.Tags), "POST", payload);
        setSelectedTags([...selectedTags, {
          _id: data === null || data === void 0 || (_data$data = data.data) === null || _data$data === void 0 ? void 0 : _data$data._id,
          title: data === null || data === void 0 || (_data$data2 = data.data) === null || _data$data2 === void 0 ? void 0 : _data$data2.title,
          color: data === null || data === void 0 || (_data$data3 = data.data) === null || _data$data3 === void 0 ? void 0 : _data$data3.color
        }]);
      } else {
        const {
          data
        } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.folder), "POST", payload);
        setSelectedFolder({
          id: data.data._id,
          name: data.data.name
        });
      }
      if (isUpdateContact) {
        setViewFolder(true);
      } else {
        setOpenFolderModal(false);
      }
      setloading(false);
    } catch (error) {
      console.log("🚀 ~ getCurrentUser ~ error:", error);
      setloading(false);
    }
  };
  const buttonStyle = {
    backgroundColor: !payload.name && !payload.title && "grey",
    cursor: !payload.name && !payload.title && "not-allowed"
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "folder-creation-container",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "createfolder-form",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
        type: "text",
        value: payload.name,
        onChange: handleFolderNameChange,
        placeholder: isTag ? "Tag Name" : "Folder Name",
        className: "folderSearch focus:!tww-outline-none hover:!tww-outline-none !tww-border !tww-border-gray-600 hover:!tww-shadow-none",
        style: {
          width: "100%",
          backgroundColor: "#f6f6f6",
          outline: "none !important"
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "color-palette",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
          type: "color",
          id: "color",
          name: "color",
          value: payload.color,
          onChange: handleColorSelect
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
          children: "Select your color"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("button", {
        onClick: handleSubmit,
        className: "create-select-button",
        style: buttonStyle,
        disabled: !payload.name && !payload.title,
        children: loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_3__["default"], {}) : "Create & Select"
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FolderCreation);

/***/ }),

/***/ "./src/component/folder/folderModal/index.js":
/*!***************************************************!*\
  !*** ./src/component/folder/folderModal/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../public/assets/close-icon.svg */ "./public/assets/close-icon.svg");
/* harmony import */ var _public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/addFolder-icon.svg */ "./public/assets/addFolder-icon.svg");
/* harmony import */ var _public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../public/assets/back-icon.svg */ "./public/assets/back-icon.svg");
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../public/assets/add-folder.svg */ "./public/assets/add-folder.svg");
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../public/assets/search.svg */ "./public/assets/search.svg");
/* harmony import */ var _public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _create__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./create */ "./src/component/folder/folderModal/create.js");
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../loading */ "./src/component/loading/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");















const FolderModal = _ref => {
  let {
    openFolderModal,
    setOpenFolderModal,
    isUpdateContact,
    contact
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_12__.useApiRequest)();
  const userInfo = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.tokenState);
  const [selectedFolder, setSelectedFolder] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedFolderState);
  const [, setIsUpdate] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.isUpdatedState);
  const [viewFolder, setViewFolder] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const [folderData, setFolderData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  const [loading, setloading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [folderId, setFolderId] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [folderName, setFolderName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [folderColor, setFolderColor] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [search, setSearch] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const handleFolderChange = event => {
    const {
      value,
      dataset
    } = event.target;
    setFolderId(value);
    setFolderName(dataset.folderName);
    setFolderColor(dataset.folderColor);
  };
  const handleClick = async () => {
    try {
      if (isUpdateContact) {
        var _contact$leadId;
        const {
          data
        } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.contacts), 'Post', {
          linkedinUrls: [contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 || (_contact$leadId = _contact$leadId.linkedIn) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.url],
          folderId
        });
        react_hot_toast__WEBPACK_IMPORTED_MODULE_3__["default"].success(data.message);
        setIsUpdate(true);
      }
      setSelectedFolder({
        id: folderId,
        name: folderName,
        color: folderColor
      });
      setOpenFolderModal(false);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.contacts, " POST API in folderModal.js file"),
        source: 'extension',
        module: 'Prospect Search - Add to folder in folder popup'
      });
    }
  };
  const fetchFolders = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setloading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.folder), 'GET', null, userInfo === null || userInfo === void 0 ? void 0 : userInfo.accessToken);
      setFolderData(data.data);
      setloading(false);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.folder, " GET API in folderModal.js file"),
        source: 'extension',
        module: 'Prospect Search - Get folders in folder popup'
      });
      setloading(false);
    }
  }, [makeRequest, userInfo === null || userInfo === void 0 ? void 0 : userInfo.accessToken]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (openFolderModal && selectedFolder) {
      setFolderId(selectedFolder.id);
      setFolderName(selectedFolder.name);
      setFolderColor(selectedFolder.color);
    }
  }, [openFolderModal, selectedFolder]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    fetchFolders();
  }, [fetchFolders, selectedFolder]);

  //this needs to be wrap around useEffect
  const searchedFolders = folderData.filter(folder => folder.name.toLowerCase().includes(search.toLowerCase()));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
    className: "!tww-absolute !tww-w-full !tww-top-0 !tww-left-0 !tww-h-full !tww-flex !tww-justify-center !tww-items-center !tww-z-[9999] ".concat(openFolderModal ? 'show' : ''),
    style: {
      display: openFolderModal ? 'flex' : 'none',
      background: 'linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 0, 0, 0) 100%)'
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "!tww-bg-white !tww-w-[90%] !tww-p-1 !tww-rounded-lg",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "modal-header",
        children: viewFolder ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-px-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "!tww-flex !tww-items-center !tww-w-full !tww-mr-2 !tww-py-3",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
              src: (_public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_8___default()),
              style: {
                width: '25px'
              },
              alt: "folder"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
              className: "!tww-ml-3 modal-title f-20-400",
              id: "exampleModalLabel",
              children: "Folder"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
            type: "button",
            src: (_public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
            onClick: () => setOpenFolderModal(false),
            width: 16,
            height: 16,
            alt: "closes"
          })]
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "!tww-flex !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
            type: "button",
            src: (_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_7___default()),
            onClick: () => setViewFolder(true),
            style: {
              width: '15px',
              marginRight: '10px'
            },
            alt: "back"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
            className: "modal-title !tww-m-0",
            id: "exampleModalLabel",
            style: {
              fontSize: '20px'
            },
            children: "New Folder"
          })]
        })
      }), viewFolder ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "modal-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-bg-[#f6f6f6] !tww-p-2 !tww-mx-2 !tww-rounded",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
            src: (_public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9___default()),
            width: "20",
            height: "20",
            alt: "ez portal icons",
            className: "!tww-mr-2"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("input", {
            type: "text",
            className: "folderSearch focus:!tww-outline-none hover:!tww-outline-none !tww-border !tww-border-gray-600 hover:!tww-shadow-none !tww-w-full !tww-bg-transparent",
            placeholder: "Search",
            onChange: e => setSearch(e.target.value)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("hr", {
          className: "!tww-my-3"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
          className: "folder-selection !tww-overflow-y-scroll custom-scrollbar",
          children: loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_11__["default"], {
            position: 'text-center'
          }) : searchedFolders === null || searchedFolders === void 0 ? void 0 : searchedFolders.map((item, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "custom-radio-container !tww-px-4",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("input", {
              className: "custom-radio hover:!tww-shadow-none",
              type: "radio",
              id: "folder=".concat(idx),
              value: item._id,
              name: "folderSelection",
              onChange: handleFolderChange,
              "data-folder-name": item.name,
              "data-folder-color": item.color,
              checked: folderId === item._id
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
              className: "custom-radio-label !tww-flex !tww-items-center",
              htmlFor: "folder=".concat(idx),
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("svg", {
                width: "25",
                height: "25",
                viewBox: "0 0 24 24",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                className: "!tww-mr-2",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("path", {
                  d: "M4 20C3.45 20 2.97933 19.8043 2.588 19.413C2.19667 19.0217 2.00067 18.5507 2 18V6C2 5.45 2.196 4.97933 2.588 4.588C2.98 4.19667 3.45067 4.00067 4 4H10L12 6H20C20.55 6 21.021 6.196 21.413 6.588C21.805 6.98 22.0007 7.45067 22 8V18C22 18.55 21.8043 19.021 21.413 19.413C21.0217 19.805 20.5507 20.0007 20 20H4Z",
                  fill: item.color
                })
              }), "".concat(item.name)]
            })]
          }, idx))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("hr", {
          className: "!tww-mt-3"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "!tww-flex !tww-justify-between !tww-items-center",
          style: {
            padding: '0px 10px',
            marginBottom: '10px'
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "!tww-flex !tww-justify-center !tww-items-center newFolder-btn",
            role: "button",
            onClick: () => setViewFolder(false),
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
              src: (_public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_6___default()),
              style: {
                width: '15px'
              },
              alt: "addFolder"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
              className: "f-15-lightGrey !tww-m-0",
              children: "New Folder"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("button", {
            type: "button",
            className: "modal-footer-btn",
            onClick: handleClick,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
              className: "!tww-m-0",
              style: {
                color: 'white'
              },
              children: "Apply"
            })
          })]
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_create__WEBPACK_IMPORTED_MODULE_10__["default"], {
        userInfo: userInfo,
        setOpenFolderModal: setOpenFolderModal,
        isUpdateContact: isUpdateContact,
        setViewFolder: setViewFolder
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FolderModal);

/***/ }),

/***/ "./src/component/folder/index.js":
/*!***************************************!*\
  !*** ./src/component/folder/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/add-folder.svg */ "./public/assets/add-folder.svg");
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../public/assets/add-tag.svg */ "./public/assets/add-tag.svg");
/* harmony import */ var _public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_add_tag_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_assign_to_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../public/assets/assign-to.svg */ "./public/assets/assign-to.svg");
/* harmony import */ var _public_assets_assign_to_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_assign_to_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _folderModal__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./folderModal */ "./src/component/folder/folderModal/index.js");
/* harmony import */ var _tagModal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./tagModal */ "./src/component/folder/tagModal/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");















const AddFolder = () => {
  var _selectedTags$4, _selectedTags$5;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_11__.useApiRequest)();
  const [openFolderModal, setOpenFolderModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [openTagModal, setOpenTagModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [selectedFolder, setSelectedFolder] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedFolderState);
  const selectedTags = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedTagsState);
  const showTagsInfo = () => {
    var _selectedTags$, _selectedTags$2, _selectedTags$3;
    return (_selectedTags$ = selectedTags[0]) !== null && _selectedTags$ !== void 0 && _selectedTags$.title ? selectedTags.length > 1 ? "".concat((_selectedTags$2 = selectedTags[0]) === null || _selectedTags$2 === void 0 ? void 0 : _selectedTags$2.title, " + ").concat(selectedTags.length - 1) : (_selectedTags$3 = selectedTags[0]) === null || _selectedTags$3 === void 0 ? void 0 : _selectedTags$3.title : 'Add Tag';
  };
  const fetchFolders = async () => {
    try {
      var _data$data;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.folder), 'GET', null);
      data === null || data === void 0 || (_data$data = data.data) === null || _data$data === void 0 || _data$data.map(item => {
        if (item !== null && item !== void 0 && item.isLocked) {
          setSelectedFolder({
            id: item === null || item === void 0 ? void 0 : item._id,
            name: item === null || item === void 0 ? void 0 : item.name,
            color: item === null || item === void 0 ? void 0 : item.color
          });
        }
      });
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.folder, " GET API in folder.js file"),
        source: 'extension',
        module: 'Prospect Search - Folders'
      });
    }
  };

  // This useEffect will run only one time to set the default folder
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!selectedFolder.id) {
      fetchFolders();
    }
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "!tww-flex !tww-justify-between !tww-px-3 !tww-mt-7",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
        className: "!tww-m-0 !tww-mt-3 f-13-600 !tww-text-[14px]",
        children: "Add to:"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "!tww-flex !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("button", {
          type: "button",
          className: "!tww-mr-3 custom-btn",
          onClick: () => setOpenFolderModal(true),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_10__["default"], {
            maxWidth: true,
            tooltipText: selectedFolder === null || selectedFolder === void 0 ? void 0 : selectedFolder.name,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
              className: "truncate-button",
              children: selectedFolder !== null && selectedFolder !== void 0 && selectedFolder.name ? selectedFolder === null || selectedFolder === void 0 ? void 0 : selectedFolder.name : 'Folder'
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("svg", {
            width: "15",
            height: "15",
            viewBox: "0 0 24 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            className: "!tww-ml-2 !tww-mr-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("path", {
              d: "M4 20C3.45 20 2.97933 19.8043 2.588 19.413C2.19667 19.0217 2.00067 18.5507 2 18V6C2 5.45 2.196 4.97933 2.588 4.588C2.98 4.19667 3.45067 4.00067 4 4H10L12 6H20C20.55 6 21.021 6.196 21.413 6.588C21.805 6.98 22.0007 7.45067 22 8V18C22 18.55 21.8043 19.021 21.413 19.413C21.0217 19.805 20.5507 20.0007 20 20H4Z",
              fill: selectedFolder !== null && selectedFolder !== void 0 && selectedFolder.color ? selectedFolder === null || selectedFolder === void 0 ? void 0 : selectedFolder.color : '#7B7AFF'
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("button", {
          type: "button",
          className: "custom-btn",
          onClick: () => setOpenTagModal(true),
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_10__["default"], {
            maxWidth: true,
            tooltipText: showTagsInfo(),
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("span", {
              className: "truncate-button",
              children: showTagsInfo()
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("svg", {
            width: "15",
            height: "15",
            viewBox: "0 0 24 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            className: "!tww-ml-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("path", {
              d: "M4 6C3.46957 6 2.96086 6.21071 2.58579 6.58579C2.21071 6.96086 2 7.46957 2 8V16C2 16.5304 2.21071 17.0391 2.58579 17.4142C2.96086 17.7893 3.46957 18 4 18H15.613C16.1107 18.0002 16.5907 17.8148 16.959 17.48L21.359 13.48C21.5652 13.2925 21.73 13.0641 21.8428 12.8092C21.9555 12.5543 22.0138 12.2787 22.0138 12C22.0138 11.7213 21.9555 11.4457 21.8428 11.1908C21.73 10.9359 21.5652 10.7075 21.359 10.52L16.959 6.52C16.5907 6.18522 16.1107 5.9998 15.613 6H4Z",
              fill: (_selectedTags$4 = selectedTags[0]) !== null && _selectedTags$4 !== void 0 && _selectedTags$4.color ? (_selectedTags$5 = selectedTags[0]) === null || _selectedTags$5 === void 0 ? void 0 : _selectedTags$5.color : '#7B7AFF'
            })
          })]
        })]
      })]
    }), openFolderModal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_folderModal__WEBPACK_IMPORTED_MODULE_8__["default"], {
      openFolderModal: openFolderModal,
      setOpenFolderModal: setOpenFolderModal
    }), openTagModal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_tagModal__WEBPACK_IMPORTED_MODULE_9__["default"], {
      openTagModal: openTagModal,
      setOpenTagModal: setOpenTagModal
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddFolder);

/***/ }),

/***/ "./src/component/folder/tagModal/index.js":
/*!************************************************!*\
  !*** ./src/component/folder/tagModal/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_icons_fa6__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-icons/fa6 */ "./node_modules/react-icons/fa6/index.mjs");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/close-icon.svg */ "./public/assets/close-icon.svg");
/* harmony import */ var _public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../public/assets/addFolder-icon.svg */ "./public/assets/addFolder-icon.svg");
/* harmony import */ var _public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../public/assets/back-icon.svg */ "./public/assets/back-icon.svg");
/* harmony import */ var _public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../public/assets/search.svg */ "./public/assets/search.svg");
/* harmony import */ var _public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../loading */ "./src/component/loading/index.js");
/* harmony import */ var _folderModal_create__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../folderModal/create */ "./src/component/folder/folderModal/create.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");















const TagModal = _ref => {
  let {
    openTagModal,
    setOpenTagModal,
    isUpdateContact,
    contact
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_5__.useApiRequest)();
  const userInfo = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.tokenState);
  const [viewFolder, setViewFolder] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
  const [tagData, setTagData] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [loading, setloading] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const [selectedTags, setSelectedTags] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.selectedTagsState);
  const [isUpdate, setIsUpdate] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.isUpdatedState);
  const [tempSelectedTags, setTempSelectedTags] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [search, setSearch] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  const handleTagChange = tag => {
    setTempSelectedTags(prevTags => prevTags.some(t => t._id === tag._id) ? prevTags.filter(t => t._id !== tag._id) : [...prevTags, tag]);
  };
  const handleClick = async () => {
    try {
      setloading(true);
      if (isUpdateContact) {
        var _contact$leadId, _contact$folderId;
        const {
          data
        } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.contacts), 'Post', {
          linkedinUrls: [contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 || (_contact$leadId = _contact$leadId.linkedIn) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.url],
          folderId: contact === null || contact === void 0 || (_contact$folderId = contact.folderId) === null || _contact$folderId === void 0 ? void 0 : _contact$folderId._id,
          tags: tempSelectedTags === null || tempSelectedTags === void 0 ? void 0 : tempSelectedTags.map(t => t._id)
        });
      }
      setIsUpdate(true);
      setSelectedTags(tempSelectedTags);
      setOpenTagModal(false);
      setloading(true);
    } catch (error) {
      setloading(true);
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.contacts, " POST API in tagModal.js file"),
        source: 'extension',
        module: 'Prospect Search - Tags'
      });
    }
  };
  const fetchTags = async () => {
    try {
      setloading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.Tags), 'GET', null, userInfo === null || userInfo === void 0 ? void 0 : userInfo.accessToken);
      setTagData(data.data.filter(tag => !tag.isDefault));
      setloading(false);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.Tags, " GET API in tagModal.js file"),
        source: 'extension',
        module: 'Prospect Search - Tags'
      });
      setloading(false);
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (openTagModal && selectedTags) {
      setTempSelectedTags(selectedTags);
    }
  }, [openTagModal, selectedTags]);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    fetchTags();
  }, [selectedTags]);
  const searchedTag = tagData.filter(tag => tag.title.toLowerCase().includes(search.toLowerCase()));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
    className: "!tww-absolute !tww-w-full !tww-top-0 !tww-left-0 !tww-h-full !tww-flex !tww-justify-center !tww-items-center !tww-z-[9999] ".concat(openTagModal ? 'show' : ''),
    style: {
      display: openTagModal ? 'flex' : 'none',
      background: 'linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 0, 0, 0) 100%)'
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "!tww-bg-white !tww-w-[90%] !tww-p-1 !tww-rounded-lg",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
        className: "modal-header",
        children: viewFolder ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-px-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "!tww-flex !tww-items-center !tww-w-full !tww-mr-2 !tww-py-3",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("svg", {
              width: "24",
              height: "24",
              viewBox: "0 0 24 24",
              fill: "none",
              xmlns: "http://www.w3.org/2000/svg",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("path", {
                d: "M4 6C3.46957 6 2.96086 6.21071 2.58579 6.58579C2.21071 6.96086 2 7.46957 2 8V16C2 16.5304 2.21071 17.0391 2.58579 17.4142C2.96086 17.7893 3.46957 18 4 18H15.613C16.1107 18.0002 16.5907 17.8148 16.959 17.48L21.359 13.48C21.5652 13.2925 21.73 13.0641 21.8428 12.8092C21.9555 12.5543 22.0138 12.2787 22.0138 12C22.0138 11.7213 21.9555 11.4457 21.8428 11.1908C21.73 10.9359 21.5652 10.7075 21.359 10.52L16.959 6.52C16.5907 6.18522 16.1107 5.9998 15.613 6H4Z",
                fill: "#7c838a"
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
              className: "!tww-ml-3 modal-title f-20-400",
              id: "exampleModalLabel",
              children: "Tag"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
            type: "button",
            src: (_public_assets_close_icon_svg__WEBPACK_IMPORTED_MODULE_6___default()),
            onClick: () => setOpenTagModal(false),
            width: 16,
            height: 16
          })]
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "!tww-flex !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
            type: "button",
            src: (_public_assets_back_icon_svg__WEBPACK_IMPORTED_MODULE_8___default()),
            onClick: () => setViewFolder(true),
            style: {
              width: '15px',
              marginRight: '10px'
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
            className: "modal-title !tww-m-0",
            id: "exampleModalLabel",
            style: {
              fontSize: '20px'
            },
            children: "New Tag"
          })]
        })
      }), viewFolder ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "modal-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          style: {
            display: 'flex',
            alignItems: 'center',
            backgroundColor: '#f6f6f6',
            padding: '8px',
            borderRadius: '4px',
            marginLeft: '8px',
            marginRight: '8px'
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
            src: (_public_assets_search_svg__WEBPACK_IMPORTED_MODULE_9___default()),
            width: "20",
            height: "20",
            alt: "ez portal icons",
            style: {
              marginRight: '8px'
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("input", {
            type: "text",
            style: {
              width: '100%',
              backgroundColor: 'transparent',
              outline: 'none !important'
            },
            className: "folderSearch !tww-focus:outline-none !tww-hover:outline-none !tww-border !tww-border-gray-600 !tww-hover:shadow-none",
            placeholder: "Search",
            onChange: e => setSearch(e.target.value)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("hr", {
          className: "!tww-my-3"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
          className: "folder-selection no-scrollbar",
          children: loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_10__["default"], {
            position: 'text-center'
          }) : searchedTag === null || searchedTag === void 0 ? void 0 : searchedTag.map((item, idx) => {
            const checked = tempSelectedTags.some(tag => tag._id === item._id);
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "!tww-flex !tww-items-center !tww-gap-4 !tww-px-4",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("button", {
                className: "mycheckbox !tww-border !tww-h-7 !tww-rounded-lg p-2 ".concat(checked ? '!tww-bg-[#7B5DE9] !tww-border-[#7B5DE9]' : '!tww-bg-white !tww-border-gray-400'),
                onClick: () => handleTagChange(item),
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(react_icons_fa6__WEBPACK_IMPORTED_MODULE_13__.FaCheck, {
                  size: 16,
                  className: "!tww-text-white ".concat(checked ? '!tww-opacity-100' : '!tww-opacity-20')
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
                className: "!tww-flex !tww-items-center !tww-mb-4",
                htmlFor: "tag=".concat(idx),
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("svg", {
                  width: "25",
                  height: "25",
                  viewBox: "0 0 24 24",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg",
                  className: "!tww-mr-2",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("path", {
                    d: "M4 6C3.46957 6 2.96086 6.21071 2.58579 6.58579C2.21071 6.96086 2 7.46957 2 8V16C2 16.5304 2.21071 17.0391 2.58579 17.4142C2.96086 17.7893 3.46957 18 4 18H15.613C16.1107 18.0002 16.5907 17.8148 16.959 17.48L21.359 13.48C21.5652 13.2925 21.73 13.0641 21.8428 12.8092C21.9555 12.5543 22.0138 12.2787 22.0138 12C22.0138 11.7213 21.9555 11.4457 21.8428 11.1908C21.73 10.9359 21.5652 10.7075 21.359 10.52L16.959 6.52C16.5907 6.18522 16.1107 5.9998 15.613 6H4Z",
                    fill: item.color
                  })
                }), "".concat(item.title)]
              })]
            }, idx);
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("hr", {
          className: "!tww-mt-3"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "!tww-flex !tww-justify-between !tww-items-center",
          style: {
            padding: '0px 10px',
            marginBottom: '10px'
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "!tww-flex !tww-justify-center !tww-items-center newFolder-btn",
            role: "button",
            onClick: () => setViewFolder(false),
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("img", {
              src: (_public_assets_addFolder_icon_svg__WEBPACK_IMPORTED_MODULE_7___default()),
              style: {
                width: '15px'
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
              className: "f-15-lightGrey !tww-m-0",
              children: "New Tag"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("button", {
            type: "button",
            className: "modal-footer-btn",
            onClick: handleClick,
            disabled: loading,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("p", {
              className: "!tww-m-0",
              style: {
                color: 'white'
              },
              children: "Apply"
            })
          })]
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_folderModal_create__WEBPACK_IMPORTED_MODULE_11__["default"], {
        userInfo: userInfo,
        setOpenFolderModal: setOpenTagModal,
        isTag: true,
        isUpdateContact: isUpdateContact,
        setViewFolder: setViewFolder
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TagModal);

/***/ }),

/***/ "./src/component/footer/index.js":
/*!***************************************!*\
  !*** ./src/component/footer/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const Footer = () => {
  const userInfo = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.tokenState);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "!tww-text-center !tww-p-5 !tww-mt-auto",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("p", {
        className: "f-14-400 !tww-flex !tww-gap-1",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("button", {
          className: "!tww-text-[#7B7AFF]",
          onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_2__.navigateToPortal)('referral-management', userInfo === null || userInfo === void 0 ? void 0 : userInfo.environment),
          children: "Invite Friend"
        }), ' ', "for Free", ' ', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("button", {
          className: "!tww-text-[#7B7AFF]",
          onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_2__.navigateToPortal)('billing-and-subscriptions/subscription-information', userInfo === null || userInfo === void 0 ? void 0 : userInfo.environment),
          children: "Credits & Personality Assessments"
        })]
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Footer);

/***/ }),

/***/ "./src/component/header/index.js":
/*!***************************************!*\
  !*** ./src/component/header/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../public/assets/logo-main.svg */ "./public/assets/logo-main.svg");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_headerSetting_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../public/assets/headerSetting.svg */ "./public/assets/headerSetting.svg");
/* harmony import */ var _public_assets_headerSetting_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_headerSetting_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../public/assets/minimize.svg */ "./public/assets/minimize.svg");
/* harmony import */ var _public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _public_assets_person_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/person.svg */ "./public/assets/person.svg");
/* harmony import */ var _public_assets_person_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_person_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react-icons/fa */ "./node_modules/react-icons/fa/index.mjs");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _common_apiContext__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/apiContext */ "./src/component/common/apiContext/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");

















const Header = () => {
  var _credits$remaining, _credits$remainingPer, _credits$remainingCom, _credits$remaining2, _credits$remainingPer2;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_11__.useApiRequest)();
  const user = (0,recoil__WEBPACK_IMPORTED_MODULE_7__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_8__.tokenState);
  const [credits, setCredits] = (0,recoil__WEBPACK_IMPORTED_MODULE_7__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_8__.creditState);
  const {
    settingData
  } = (0,_common_apiContext__WEBPACK_IMPORTED_MODULE_12__.useApiHost)();
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_14__.useNavigate)();
  const {
    team
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_7__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_8__.tokenState);
  const [planData, setPlanData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const handleMinimize = () => {
    const message = {
      type: 'MINIMIZE'
    };
    chrome.runtime.sendMessage(message, response => {});
  };
  const getCredits = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.credit), 'GET');
      setCredits(data.credits);
    } catch (error) {
      console.log('🚀 ~ file: index.js:Setting ~ getCredits ~ error:', error);
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    getCredits();
    getPlan();
  }, []);
  const getPlan = async () => {
    try {
      var _team$plan;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.plan, "/").concat(team === null || team === void 0 || (_team$plan = team.plan) === null || _team$plan === void 0 ? void 0 : _team$plan.planId), 'GET');
      setPlanData(data);
    } catch (error) {
      var _team$plan2;
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_10__.plan, "/").concat(team === null || team === void 0 || (_team$plan2 = team.plan) === null || _team$plan2 === void 0 ? void 0 : _team$plan2.planId, " GET API in header.js file"),
        source: 'extension',
        module: 'Header - Get Plan'
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("nav", {
    className: "navbar",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "navbar-logo",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
        src: (_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_2___default()),
        alt: "EazyConnections Logo"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("span", {
        style: {
          fontSize: '16px'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("strong", {
          children: "Eazy"
        }), "Connections"]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "!tww-flex !tww-items-center navbar-icons",
      children: [planData.title === 'Free' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        role: "button",
        onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_9__.navigateToPortal)('subscriptions/new', user === null || user === void 0 ? void 0 : user.environment),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
          className: "!tww-text-green-500 !tww-mr-3 !tww-font-semibold !tww-text-[12px]",
          children: "UPGRADE"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
        tooltipText: "You have ".concat((_credits$remaining = credits === null || credits === void 0 ? void 0 : credits.remaining) !== null && _credits$remaining !== void 0 ? _credits$remaining : 0, " credits for contacts \nYou have ").concat((_credits$remainingPer = credits === null || credits === void 0 ? void 0 : credits.remainingPersonality) !== null && _credits$remainingPer !== void 0 ? _credits$remainingPer : 0, " credits for personality ").concat(settingData !== null && settingData !== void 0 && settingData.companyAnalyzer ? "\nYou have ".concat((_credits$remainingCom = credits === null || credits === void 0 ? void 0 : credits.remainingCompany) !== null && _credits$remainingCom !== void 0 ? _credits$remainingCom : 0, " credits for company") : ''),
        customClass: "!tww-min-w-[230px] !tww-ml-[-60px] !tww-whitespace-pre-wrap",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "creditContainer",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(react_icons_fa__WEBPACK_IMPORTED_MODULE_15__.FaCoins, {
              className: "!tww-mr-1 !tww-text-yellow-600",
              size: 16
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
              className: "!tww-m-0 !tww-ml-1 !tww-text-[14px]",
              children: (_credits$remaining2 = credits === null || credits === void 0 ? void 0 : credits.remaining) !== null && _credits$remaining2 !== void 0 ? _credits$remaining2 : 0
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
              src: (_public_assets_person_svg__WEBPACK_IMPORTED_MODULE_5___default()),
              className: "!tww-img-fluid"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
              className: "!tww-m-0 !tww-ml-1 !tww-text-[14px]",
              children: (_credits$remainingPer2 = credits === null || credits === void 0 ? void 0 : credits.remainingPersonality) !== null && _credits$remainingPer2 !== void 0 ? _credits$remainingPer2 : 0
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
        src: (_public_assets_headerSetting_svg__WEBPACK_IMPORTED_MODULE_3___default()),
        alt: "setting",
        style: {
          width: '20px',
          height: '20px'
        },
        onClick: () => navigate('/settings'),
        role: "button"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
        src: (_public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_4___default()),
        alt: "minimize",
        style: {
          width: '20px',
          height: '20px'
        },
        role: "button",
        onClick: handleMinimize
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ "./src/component/iceBreaker/index.js":
/*!*******************************************!*\
  !*** ./src/component/iceBreaker/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _common_contextAccordian__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/contextAccordian */ "./src/component/common/contextAccordian/index.js");
/* harmony import */ var _common_editTextBox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/editTextBox */ "./src/component/common/editTextBox/index.js");
/* harmony import */ var _common_aiSettingModal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/aiSettingModal */ "./src/component/common/aiSettingModal/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const EditTextBoxHeader = _ref => {
  let {
    type
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "!tww-mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-gap-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
        className: "!tww-flex !tww-items-center !tww-justify-center headerEditBtn",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
          className: "!tww-m-0 f-14-600",
          style: {
            color: 'white'
          },
          children: "People"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
        className: "!tww-m-0",
        children: ">"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
        className: "!tww-m-0 f-14-600",
        style: {
          color: '#9097A5'
        },
        children: type
      })]
    })
  });
};
const IceBreaker = () => {
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_7__.useApiRequest)();
  const reportPayload = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.reportPayloadState);
  const aiSetting = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.aiSettingState);
  const [icebreaker, setIcebreaker] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const generateIcebreaker = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker), 'POST', {
        ...reportPayload,
        aiSettings: aiSetting === null || aiSetting === void 0 ? void 0 : aiSetting._id
      });
      setLoading(false);
      setIcebreaker(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker, " POST API in iceBreaker.js file in generateIceBreaker method"),
        source: 'extension',
        module: 'AI Reachout - Ice Breaker'
      });
      setLoading(false);
    }
  }, [makeRequest, reportPayload, aiSetting === null || aiSetting === void 0 ? void 0 : aiSetting._id]);
  const initialGeneration = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker), 'POST', {
        ...reportPayload
      });
      setLoading(false);
      setIcebreaker(data);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_3__.personalityIceBreaker, " POST API in iceBreaker.js file in initialGeneration method"),
        source: 'extension',
        module: 'AI Reachout - Ice Breaker'
      });
      setLoading(false);
    }
  }, [makeRequest, reportPayload]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    initialGeneration();
  }, [initialGeneration]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "!tww-p-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "!tww-flex !tww-items-center !tww-justify-between !tww-mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-mb-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
          className: "!tww-flex !tww-items-center !tww-justify-center",
          style: {
            width: '37px',
            height: '37px',
            borderRadius: '3px'
            // backgroundColor: '#5690E8'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("img", {
            src: "https://ez-staging.s3.ap-south-1.amazonaws.com/Icebreaker+blue.png",
            className: "img-fluid",
            style: {
              width: '24px',
              height: '24px'
            },
            alt: "ice-breaker"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("p", {
          className: "!tww-m-0 !tww-ml-3 f-14-500",
          children: "Ice Breaker"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_aiSettingModal__WEBPACK_IMPORTED_MODULE_6__["default"], {
        type: "icebreaker",
        setIceBreaker: setIcebreaker,
        setIceBreakerLoading: setLoading
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_contextAccordian__WEBPACK_IMPORTED_MODULE_4__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(EditTextBoxHeader, {
      type: "Education"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_5__["default"], {
      label: "Propotional 1:",
      refresh: generateIcebreaker,
      text: icebreaker === null || icebreaker === void 0 ? void 0 : icebreaker.icebreakerEducationBased,
      isLoading: loading
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(EditTextBoxHeader, {
      type: "Experience"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_5__["default"], {
      label: "Propotional 2:",
      refresh: generateIcebreaker,
      text: icebreaker === null || icebreaker === void 0 ? void 0 : icebreaker.icebreakerExperienceBased,
      isLoading: loading
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(EditTextBoxHeader, {
      type: "Others"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_5__["default"], {
      label: "Propotional 2:",
      refresh: generateIcebreaker,
      text: icebreaker === null || icebreaker === void 0 ? void 0 : icebreaker.icebreakerOthersBased,
      isLoading: loading
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(EditTextBoxHeader, {
      type: "Skill"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_editTextBox__WEBPACK_IMPORTED_MODULE_5__["default"], {
      label: "Propotional 3:",
      refresh: generateIcebreaker,
      text: icebreaker === null || icebreaker === void 0 ? void 0 : icebreaker.icebreakerSkillBased,
      isLoading: loading
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IceBreaker);

/***/ }),

/***/ "./src/component/index.js":
/*!********************************!*\
  !*** ./src/component/index.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EzApp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var react_tooltip_dist_react_tooltip_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-tooltip/dist/react-tooltip.css */ "./node_modules/react-tooltip/dist/react-tooltip.min.css");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../App.css */ "./src/App.css");
/* harmony import */ var react_tooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-tooltip */ "./node_modules/react-tooltip/dist/react-tooltip.min.mjs");
/* harmony import */ var _indivitual__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./indivitual */ "./src/component/indivitual/index.js");
/* harmony import */ var _header__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./header */ "./src/component/header/index.js");
/* harmony import */ var _bulk__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./bulk */ "./src/component/bulk/index.js");
/* harmony import */ var _setting__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./setting */ "./src/component/setting/index.js");
/* harmony import */ var _wrongPage__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./wrongPage */ "./src/component/wrongPage/index.js");
/* harmony import */ var _login__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./login */ "./src/component/login/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./tabs */ "./src/component/tabs/index.js");
/* harmony import */ var _personality__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./personality */ "./src/component/personality/index.js");
/* harmony import */ var _personality_analysis__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./personality/analysis */ "./src/component/personality/analysis/index.js");
/* harmony import */ var _common_LowerHeader__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./common/LowerHeader */ "./src/component/common/LowerHeader/index.js");
/* harmony import */ var _composeEmail__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./composeEmail */ "./src/component/composeEmail/index.js");
/* harmony import */ var _iceBreaker__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./iceBreaker */ "./src/component/iceBreaker/index.js");
/* harmony import */ var _LinkedinMessage__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./LinkedinMessage */ "./src/component/LinkedinMessage/index.js");
/* harmony import */ var _footer__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./footer */ "./src/component/footer/index.js");
/* harmony import */ var _personality_engage__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./personality/engage */ "./src/component/personality/engage/index.js");
/* harmony import */ var _BizAnalyzer__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./BizAnalyzer */ "./src/component/BizAnalyzer/index.js");
/* harmony import */ var _BizAnalyzer_tabs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./BizAnalyzer/tabs */ "./src/component/BizAnalyzer/tabs/index.js");
/* harmony import */ var _BizAnalyzerPeople__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./BizAnalyzerPeople */ "./src/component/BizAnalyzerPeople/index.js");
/* harmony import */ var _common_loader__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./common/loader */ "./src/component/common/loader/index.js");
/* harmony import */ var _common_LinkedinInsight__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./common/LinkedinInsight */ "./src/component/common/LinkedinInsight/index.js");
/* harmony import */ var _common_callScript__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./common/callScript */ "./src/component/common/callScript/index.js");
/* harmony import */ var _utils_isBizAnalyzerOnWebsiteState__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../utils/isBizAnalyzerOnWebsiteState */ "./src/utils/isBizAnalyzerOnWebsiteState.js");
/* harmony import */ var _common_apiContext__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./common/apiContext */ "./src/component/common/apiContext/index.js");
/* harmony import */ var _termsAndConditions__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./termsAndConditions */ "./src/component/termsAndConditions/index.js");
/* harmony import */ var _utils_getStoragevalue__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../utils/getStoragevalue */ "./src/utils/getStoragevalue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");



































const getDynamicComponent = activeComponent => {
  switch (activeComponent) {
    case "bulk":
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_bulk__WEBPACK_IMPORTED_MODULE_9__["default"], {});
    case "individual":
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_indivitual__WEBPACK_IMPORTED_MODULE_7__["default"], {});
    case "bizAnalyzer":
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_BizAnalyzer__WEBPACK_IMPORTED_MODULE_22__["default"], {});
    default:
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_wrongPage__WEBPACK_IMPORTED_MODULE_11__["default"], {});
  }
};
const DynamicContent = _ref => {
  let {
    activeComponent,
    setActiveComponent
  } = _ref;
  const onReloadUrl = window.location.href;
  const {
    settingData
  } = (0,_common_apiContext__WEBPACK_IMPORTED_MODULE_29__.useApiHost)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const determineComponent = () => {
      if (onReloadUrl.includes("google.com")) {
        // Google: Show WrongPage
        setActiveComponent("default");
      } else if (onReloadUrl.includes("linkedin.com")) {
        // LinkedIn-specific logic
        if (onReloadUrl.match(/\/in\/.*/)) {
          setActiveComponent("individual");
        } else if ((onReloadUrl.match(/\/search\/results\/people\/.*/) || onReloadUrl.match(/\/mynetwork\/invite-connect\/connections\/.*/)) && settingData !== null && settingData !== void 0 && settingData.bulkProspect
        // checking if bulk prospect is enabled, only then setting the comppojnent to bulk
        ) {
          setActiveComponent("bulk");
        } else if (onReloadUrl.match(/\/company\/.*/) || onReloadUrl.match(/\/school\/.*/)) {
          setActiveComponent("bizAnalyzer");
        } else {
          setActiveComponent("default");
        }
      } else {
        // All other websites: Show BizAnalyzer
        setActiveComponent("bizAnalyzer");
        (0,_utils_isBizAnalyzerOnWebsiteState__WEBPACK_IMPORTED_MODULE_28__.updateIsBizAnalyzerOnWebsite)(true);
      }
    };
    determineComponent();
    const handleMessage = (request, sender, sendResponse) => {
      if (request.method === "UrlChanged") {
        const url = request.url;
        if (url.includes("google.com")) {
          setActiveComponent("default");
        } else if (url.includes("linkedin.com")) {
          if (url.match(/\/in\/.*/)) {
            setActiveComponent("individual");
          } else if ((url.match(/\/search\/results\/people\/.*/) || url.match(/\/mynetwork\/invite-connect\/connections\/.*/)) && settingData !== null && settingData !== void 0 && settingData.bulkProspect) {
            setActiveComponent("bulk");
          } else if (url.match(/\/company\/.*/) || url.match(/\/school\/.*/)) {
            setActiveComponent("bizAnalyzer");
          } else {
            setActiveComponent("default");
          }
        } else {
          setActiveComponent("bizAnalyzer");
          (0,_utils_isBizAnalyzerOnWebsiteState__WEBPACK_IMPORTED_MODULE_28__.updateIsBizAnalyzerOnWebsite)(true);
        }
      }
    };
    chrome.runtime.onMessage.addListener(handleMessage);
    return () => {
      chrome.runtime.onMessage.removeListener(handleMessage);
    };
  }, [settingData === null || settingData === void 0 ? void 0 : settingData.bulkProspect]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(RequireAuth, {
    children: getDynamicComponent(activeComponent)
  });
};
const RequireAuth = _ref2 => {
  let {
    children
  } = _ref2;
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_33__.useNavigate)();
  const [token, setToken] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.tokenState);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (0,_utils_getStoragevalue__WEBPACK_IMPORTED_MODULE_31__.getStorageValue)("needsTermsAcceptance").then(flag => {
      console.log("🚀 ~ getStorageValue ~ flag:", flag);
      if (flag) {
        navigate("/terms-and-conditions");
      }
    });
  }, [navigate]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    function handleStorageChange(changes, namespace) {
      try {
        if (namespace === "local" && changes.userInfo) {
          const {
            newValue
          } = changes.userInfo;
          if (newValue) {
            setToken(newValue);
            navigate("/");
          } else {
            navigate("/login");
          }
        }
      } catch (error) {
        console.error("Error in storage change handler:", error);
      }
    }
    chrome.storage.local.get("userInfo", result => {
      if (result.hasOwnProperty("userInfo")) {
        setToken(result.userInfo);
      } else {
        navigate("/login");
      }
    });
    chrome.storage.onChanged.addListener(handleStorageChange);
    return () => {};
  }, [navigate]);
  return children;
};
const Layout = _ref3 => {
  let {
    showTabs,
    children,
    isBizAnalyzer = false,
    isDefault = false,
    isBulk = false
  } = _ref3;
  const {
    host
  } = (0,_common_apiContext__WEBPACK_IMPORTED_MODULE_29__.useApiHost)();
  const env = host !== null && host !== void 0 && host.includes("dev-api") || host !== null && host !== void 0 && host.includes("localhost") ? "DEVELOPMENT" : host !== null && host !== void 0 && host.includes("staging-api") ? "STAGING" : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(RequireAuth, {
    children: host ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsxs)("div", {
      className: "!tww-flex !tww-flex-col !tww-h-full !tww-overflow-y-scroll no-scrollbar",
      children: [env && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)("div", {
        className: "".concat(env === "DEVELOPMENT" ? "!tww-bg-blue-800" : "!tww-bg-green-800", " !tww-text-white !tww-py-2 !tww-flex !tww-justify-center !tww-text-[16px]"),
        children: env
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsxs)("div", {
        className: "header-fix",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_header__WEBPACK_IMPORTED_MODULE_8__["default"], {}), isDefault ? null : isBizAnalyzer ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_BizAnalyzer_tabs__WEBPACK_IMPORTED_MODULE_23__["default"], {}) : showTabs ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_tabs__WEBPACK_IMPORTED_MODULE_13__["default"], {
          isBulk: isBulk
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_common_LowerHeader__WEBPACK_IMPORTED_MODULE_16__["default"], {})]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)("div", {
        className: "tww-flex-grow tww-overflow-y-scroll custom-scrollbar2",
        children: children
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_footer__WEBPACK_IMPORTED_MODULE_20__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(react_hot_toast__WEBPACK_IMPORTED_MODULE_3__.Toaster, {
        position: "top-center",
        richColors: true
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(react_tooltip__WEBPACK_IMPORTED_MODULE_6__.Tooltip, {
        id: "my-tooltip"
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)("div", {
      className: "tww-flex tww-items-center tww-h-full tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_common_loader__WEBPACK_IMPORTED_MODULE_25__["default"], {})
    })
  });
};
function EzApp() {
  const [activeComponent, setActiveComponent] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("default");
  const router = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_33__.createMemoryRouter)([{
    path: "/",
    children: [{
      index: true,
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: true,
        isBizAnalyzer: activeComponent === "bizAnalyzer",
        isDefault: activeComponent === "default",
        isBulk: activeComponent === "bulk",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(DynamicContent, {
          activeComponent: activeComponent,
          setActiveComponent: setActiveComponent
        })
      })
    }, {
      path: "settings",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_setting__WEBPACK_IMPORTED_MODULE_10__["default"], {})
      })
    }, {
      path: "personality",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_personality__WEBPACK_IMPORTED_MODULE_14__["default"], {})
      })
    }, {
      path: "ai-engage",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_personality_engage__WEBPACK_IMPORTED_MODULE_21__["default"], {})
      })
    }, {
      path: "personality/:id",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_personality_analysis__WEBPACK_IMPORTED_MODULE_15__["default"], {})
      })
    }, {
      path: "personality/email",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_composeEmail__WEBPACK_IMPORTED_MODULE_17__["default"], {})
      })
    }, {
      path: "personality/icebreaker",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_iceBreaker__WEBPACK_IMPORTED_MODULE_18__["default"], {})
      })
    }, {
      path: "personality/linkedinMessage",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_LinkedinMessage__WEBPACK_IMPORTED_MODULE_19__["default"], {})
      })
    }, {
      path: "personality/linkedinInsight",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_common_LinkedinInsight__WEBPACK_IMPORTED_MODULE_26__["default"], {})
      })
    }, {
      path: "personality/callScript",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_common_callScript__WEBPACK_IMPORTED_MODULE_27__["default"], {})
      })
    }, {
      path: "People",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(Layout, {
        showTabs: true,
        isBizAnalyzer: activeComponent === "bizAnalyzer",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_BizAnalyzerPeople__WEBPACK_IMPORTED_MODULE_24__["default"], {})
      })
    }, {
      path: "terms-and-conditions",
      element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_termsAndConditions__WEBPACK_IMPORTED_MODULE_30__["default"], {})
    }]
  }, {
    path: "login",
    element: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_login__WEBPACK_IMPORTED_MODULE_12__["default"], {})
  }]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(recoil__WEBPACK_IMPORTED_MODULE_1__.RecoilRoot, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(_common_apiContext__WEBPACK_IMPORTED_MODULE_29__.ApiHostProvider, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_32__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_34__.RouterProvider, {
        router: router
      })
    })
  });
}

/***/ }),

/***/ "./src/component/indivitual/AddedFolderAndTags/index.js":
/*!**************************************************************!*\
  !*** ./src/component/indivitual/AddedFolderAndTags/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _folder_folderModal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../folder/folderModal */ "./src/component/folder/folderModal/index.js");
/* harmony import */ var _folder_tagModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../folder/tagModal */ "./src/component/folder/tagModal/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");







const AddedFolderAndTags = _ref => {
  var _selectedTag$0$color, _selectedTag$, _selectedTag$2;
  let {
    folderData,
    contact,
    tagData
  } = _ref;
  const [openFolderModal, setOpenFolderModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [openTagModal, setOpenTagModal] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [selectedFolder, setSelectedFolder] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedFolderState);
  const [selectedTag, setSelectedTag] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.selectedTagsState);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (folderData) {
      setSelectedFolder({
        id: folderData._id,
        name: folderData.name,
        color: folderData.color
      });
    }
    if (tagData.length > 0) {
      setSelectedTag(tagData);
    }
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "folder-tags-container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      role: "button",
      className: "folder-tags-container-fetched",
      onClick: () => setOpenFolderModal(true),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "!tww-flex !tww-justify-between !tww-w-full !tww-items-center !tww-my-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "!tww-flex !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
            width: "25",
            height: "25",
            viewBox: "0 0 24 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            className: "!tww-mr-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
              d: "M4 20C3.45 20 2.97933 19.8043 2.588 19.413C2.19667 19.0217 2.00067 18.5507 2 18V6C2 5.45 2.196 4.97933 2.588 4.588C2.98 4.19667 3.45067 4.00067 4 4H10L12 6H20C20.55 6 21.021 6.196 21.413 6.588C21.805 6.98 22.0007 7.45067 22 8V18C22 18.55 21.8043 19.021 21.413 19.413C21.0217 19.805 20.5507 20.0007 20 20H4Z",
              fill: selectedFolder.color
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("p", {
            className: "f-14-400 !tww-m-0 !tww-ml-2",
            children: ["Added to ", selectedFolder.name]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      role: "button",
      className: "folder-tags-container-fetched",
      onClick: () => setOpenTagModal(true),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "!tww-flex !tww-justify-between !tww-w-full !tww-items-center !tww-my-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "!tww-flex !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("svg", {
            width: "24",
            height: "24",
            viewBox: "0 0 24 24",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg",
            className: "!tww-mr-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("path", {
              d: "M4 6C3.46957 6 2.96086 6.21071 2.58579 6.58579C2.21071 6.96086 2 7.46957 2 8V16C2 16.5304 2.21071 17.0391 2.58579 17.4142C2.96086 17.7893 3.46957 18 4 18H15.613C16.1107 18.0002 16.5907 17.8148 16.959 17.48L21.359 13.48C21.5652 13.2925 21.73 13.0641 21.8428 12.8092C21.9555 12.5543 22.0138 12.2787 22.0138 12C22.0138 11.7213 21.9555 11.4457 21.8428 11.1908C21.73 10.9359 21.5652 10.7075 21.359 10.52L16.959 6.52C16.5907 6.18522 16.1107 5.9998 15.613 6H4Z",
              fill: (_selectedTag$0$color = (_selectedTag$ = selectedTag[0]) === null || _selectedTag$ === void 0 ? void 0 : _selectedTag$.color) !== null && _selectedTag$0$color !== void 0 ? _selectedTag$0$color : '#000000'
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
            className: "f-14-400 !tww-m-0 !tww-ml-2",
            children: selectedTag && selectedTag.length > 0 ? "Tagged as ".concat((_selectedTag$2 = selectedTag[0]) === null || _selectedTag$2 === void 0 ? void 0 : _selectedTag$2.title) : 'No Tags Selected'
          })]
        }), selectedTag.length > 1 && "+".concat(selectedTag.length - 1)]
      })
    }), openFolderModal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_folder_folderModal__WEBPACK_IMPORTED_MODULE_3__["default"], {
      openFolderModal: openFolderModal,
      setOpenFolderModal: setOpenFolderModal,
      isUpdateContact: true,
      contact: contact
    }), openTagModal && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_folder_tagModal__WEBPACK_IMPORTED_MODULE_4__["default"], {
      openTagModal: openTagModal,
      setOpenTagModal: setOpenTagModal,
      isUpdateContact: true,
      contact: contact
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddedFolderAndTags);

/***/ }),

/***/ "./src/component/indivitual/EmailNumber/index.js":
/*!*******************************************************!*\
  !*** ./src/component/indivitual/EmailNumber/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_io__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-icons/io */ "./node_modules/react-icons/io/index.mjs");
/* harmony import */ var react_icons_ri__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-icons/ri */ "./node_modules/react-icons/ri/index.mjs");
/* harmony import */ var _public_assets_email_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../public/assets/email.svg */ "./public/assets/email.svg");
/* harmony import */ var _public_assets_email_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_public_assets_email_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/phone.svg */ "./public/assets/phone.svg");
/* harmony import */ var _public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_copy_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/copy.svg */ "./public/assets/copy.svg");
/* harmony import */ var _public_assets_copy_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_copy_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/copyTextToClipboard */ "./src/utils/copyTextToClipboard.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const EmailPhoneComponent = _ref => {
  var _contact$leadId, _contact$leadId2;
  let {
    dataFetched,
    isContact = true,
    contact
  } = _ref;
  console.log("contact", contact);
  const [isPlanUpgraded, setIsPlanUpgraded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const renderContactOrCount = (data, icon, type) => {
    // if (!Array.isArray(data) || data.length === 0) {
    //   return (
    //     <div className='email-container !tww-my-3'>
    //       <div className='!tww-flex !tww-ml-3 !tww-w-full !tww-items-center !tww-my-4'>
    //         <img src={icon} alt={type} className='img-fluid' />
    //         <p className='f-14-400 !tww-m-0 !tww-ml-2'>No data found</p>
    //       </div>
    //     </div>
    //   )
    // }

    if (!Array.isArray(data) || data.length === 0 || !isContact) {
      const countEmailType = () => {
        var _Object$entries;
        const count = {};
        data.forEach(email => {
          count[email === null || email === void 0 ? void 0 : email.emailType] = (count[email === null || email === void 0 ? void 0 : email.emailType] || 0) + 1;
        });
        return (_Object$entries = Object.entries(count)) === null || _Object$entries === void 0 ? void 0 : _Object$entries.map(_ref2 => {
          let [type, count] = _ref2;
          return {
            emailType: type,
            count
          };
        });
      };
      const typeCountsArray = countEmailType();
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "email-container !tww-my-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "!tww-flex !tww-justify-between !tww-ml-3 !tww-w-full !tww-items-center !tww-my-4",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
              src: icon,
              alt: type,
              className: "img-fluid"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("p", {
              className: "f-14-400 !tww-m-0 !tww-ml-2",
              children: [type === 'email' && 'email*********.com', type === 'phone' && '*********']
            })]
          })
        })
      });
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "email-container !tww-mt-3",
      children: data === null || data === void 0 ? void 0 : data.map((item, idx) => {
        var _item$phoneNumber, _item$emailAddress;
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: " !tww-flex !tww-justify-between !tww-w-full !tww-items-center !tww-my-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [item !== null && item !== void 0 && item.userVerified || item !== null && item !== void 0 && item.sysVerified ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_icons_ri__WEBPACK_IMPORTED_MODULE_6__.RiVerifiedBadgeFill, {
              size: 20,
              className: "!tww-text-blue-500"
            }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_icons_io__WEBPACK_IMPORTED_MODULE_7__.IoIosWarning, {
              size: 20,
              className: "!tww-text-yellow-500"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
              className: "f-14-400 !tww-m-0 !tww-ml-2 truncate-email",
              children: type === 'phone' ? (_item$phoneNumber = item === null || item === void 0 ? void 0 : item.phoneNumber) !== null && _item$phoneNumber !== void 0 ? _item$phoneNumber : '' : (_item$emailAddress = item === null || item === void 0 ? void 0 : item.emailAddress) !== null && _item$emailAddress !== void 0 ? _item$emailAddress : ''
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "!tww-flex !tww-items-center",
            children: [type === 'email' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "!tww-bg-[#888F97] !tww-text-white !tww-py-2 !tww-px-2 !tww-rounded-md !tww-mr-2 !tww-h-[20px] !tww-text-center !tww-flex !tww-items-center !tww-justify-center",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
                className: "f-12-400 !tww-m-0 !tww-text-white",
                children: item === null || item === void 0 ? void 0 : item.emailType
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("button", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
                src: (_public_assets_copy_svg__WEBPACK_IMPORTED_MODULE_3___default()),
                alt: "icon",
                role: "button",
                width: 20,
                onClick: () => {
                  var _item$phoneNumber2, _item$emailAddress2;
                  return (0,_utils_copyTextToClipboard__WEBPACK_IMPORTED_MODULE_4__.copyTextToClipboard)(type === 'phone' ? (_item$phoneNumber2 = item === null || item === void 0 ? void 0 : item.phoneNumber) !== null && _item$phoneNumber2 !== void 0 ? _item$phoneNumber2 : '' : (_item$emailAddress2 = item === null || item === void 0 ? void 0 : item.emailAddress) !== null && _item$emailAddress2 !== void 0 ? _item$emailAddress2 : '');
                }
              })
            })]
          })]
        }, idx);
      })
    });
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [renderContactOrCount(isContact ? contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.emailIds : contact === null || contact === void 0 ? void 0 : contact.emailIds, (_public_assets_email_svg__WEBPACK_IMPORTED_MODULE_1___default()), 'email'), renderContactOrCount(isContact ? contact === null || contact === void 0 || (_contact$leadId2 = contact.leadId) === null || _contact$leadId2 === void 0 ? void 0 : _contact$leadId2.phoneNumbers : contact === null || contact === void 0 ? void 0 : contact.phoneNumbers, (_public_assets_phone_svg__WEBPACK_IMPORTED_MODULE_2___default()), 'phone'), isContact && !isPlanUpgraded && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "unlock-phone-container !tww-flex !tww-justify-between !tww-w-full !tww-items-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "!tww-flex !tww-justify-between !tww-w-full !tww-items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
          className: "f-14-400 !tww-m-0",
          children: "Unlock phone numbers."
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("button", {
          className: "!tww-m-0 f-14-400",
          style: {
            color: '#7B7AFF'
          },
          onClick: () => setIsPlanUpgraded(true),
          children: "Upgrade plan"
        })]
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EmailPhoneComponent);

/***/ }),

/***/ "./src/component/indivitual/ProfileComponent/index.js":
/*!************************************************************!*\
  !*** ./src/component/indivitual/ProfileComponent/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _EmailNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../EmailNumber */ "./src/component/indivitual/EmailNumber/index.js");
/* harmony import */ var _revealLoading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../revealLoading */ "./src/component/indivitual/revealLoading/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _folder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../folder */ "./src/component/folder/index.js");
/* harmony import */ var _Company__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Company */ "./src/component/Company/index.js");
/* harmony import */ var _companyInfo__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../companyInfo */ "./src/component/indivitual/companyInfo/index.js");
/* harmony import */ var _AddedFolderAndTags__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../AddedFolderAndTags */ "./src/component/indivitual/AddedFolderAndTags/index.js");
/* harmony import */ var _common_loader__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../common/loader */ "./src/component/common/loader/index.js");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");















const ProfileComponent = _ref => {
  var _ref2, _contact$leadId$image, _contact$leadId, _contact$tags;
  let {
    name,
    about,
    profileImageUrl,
    dataFetched,
    contact,
    loading,
    revealInfo,
    showAndAdd,
    isContact,
    isBulk = false,
    showAndAddCalled
  } = _ref;
  //for maintaining data for personality when coming from a bulk profile
  const [data, setData] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.indvitualUserState);
  const {
    environment
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.tokenState);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (isBulk) {
      setData(contact);
    }
  });
  return loading || !isContact && showAndAddCalled ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
    className: "!tww-flex !tww-items-center !tww-h-full !tww-justify-center",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_loader__WEBPACK_IMPORTED_MODULE_11__["default"], {})
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
    className: "!tww-mt-2 scroll-indivitual no-scrollbar",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "!tww-py-[1px] !tww-px-[14px]",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "!tww-mt-4",
        id: "UserInfo",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-gap-8",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
              id: "profileImage",
              className: "".concat(loading ? 'skeleton skeleton-image' : ''),
              width: 90,
              height: 90,
              alt: "profile-img",
              src: (_ref2 = (_contact$leadId$image = contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.image) !== null && _contact$leadId$image !== void 0 ? _contact$leadId$image : contact === null || contact === void 0 ? void 0 : contact.image) !== null && _ref2 !== void 0 ? _ref2 : profileImageUrl,
              style: {
                borderRadius: '15px'
              }
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "!tww-w-full",
            style: {
              marginLeft: '-10px'
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
              className: "!tww-flex",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
                tooltipText: !loading && name,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                  id: "name",
                  className: "userName ".concat(loading ? 'skeleton skeleton-text' : ''),
                  children: !loading && name
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
                src: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_12___default()),
                className: "!tww-ml-2 img-fluid",
                role: "button",
                alt: "link-logo",
                onClick: () => {
                  var _contact$leadId2, _contact$linkedIn;
                  return window.open("https://".concat(contact === null || contact === void 0 || (_contact$leadId2 = contact.leadId) === null || _contact$leadId2 === void 0 || (_contact$leadId2 = _contact$leadId2.linkedIn) === null || _contact$leadId2 === void 0 ? void 0 : _contact$leadId2.url) || 0, '_blank');
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
              tooltipText: !loading && about,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                id: "about",
                className: "userAbout ".concat(loading ? 'skeleton skeleton-text' : ''),
                children: !loading && about
              })
            })]
          })]
        }), !isContact && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_folder__WEBPACK_IMPORTED_MODULE_7__["default"], {})]
      }), isContact && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "!tww-mt-6",
        id: "RevealInfo",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("button", {
          className: "!tww-m-0 show-dashboard",
          onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_4__.navigateToPortal)("contacts-manager?extension-search=".concat(encodeURIComponent(name)), environment),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
            className: "f-12-500",
            style: {
              color: '#7B7AFF'
            },
            children: "Open in dashboard"
          })
        })
      }), revealInfo ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_revealLoading__WEBPACK_IMPORTED_MODULE_3__["default"], {}) : !loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "!tww-mt-9",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_EmailNumber__WEBPACK_IMPORTED_MODULE_2__["default"], {
          dataFetched: dataFetched,
          contact: contact,
          loading: loading,
          isContact: isContact
        })
      }), isContact && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_AddedFolderAndTags__WEBPACK_IMPORTED_MODULE_10__["default"], {
        folderData: contact === null || contact === void 0 ? void 0 : contact.folderId,
        contact: contact,
        tagData: contact === null || contact === void 0 || (_contact$tags = contact.tags) === null || _contact$tags === void 0 ? void 0 : _contact$tags.filter(tag => !tag.isDefault)
      }), !isContact && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "!tww-mt-9 !tww-mb-9",
        id: "RevealInfo",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("button", {
          className: "!tww-m-0 reveal-btn",
          onClick: showAndAdd,
          children: "Reveal Contact & Add"
        })
      })]
    }), !loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_companyInfo__WEBPACK_IMPORTED_MODULE_9__["default"], {
      img: profileImageUrl,
      contact: contact,
      isContact: isContact
    }), !loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_Company__WEBPACK_IMPORTED_MODULE_8__["default"], {
      isContact: isContact
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProfileComponent);

/***/ }),

/***/ "./src/component/indivitual/companyInfo/index.js":
/*!*******************************************************!*\
  !*** ./src/component/indivitual/companyInfo/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../App.css */ "./src/App.css");
/* harmony import */ var _public_assets_link_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/link.svg */ "./public/assets/link.svg");
/* harmony import */ var _public_assets_link_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_link_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/employ.svg */ "./public/assets/employ.svg");
/* harmony import */ var _public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../public/assets/founded.svg */ "./public/assets/founded.svg");
/* harmony import */ var _public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../public/assets/industry.svg */ "./public/assets/industry.svg");
/* harmony import */ var _public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../public/assets/location.svg */ "./public/assets/location.svg");
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const CompanyInfo = _ref => {
  var _contact$leadId, _companyData$, _companyData$2, _companyData$3, _companyData$4, _companyData$5, _companyData$6, _companyData$7, _companyData$8, _companyData$9;
  let {
    img,
    contact,
    isContact
  } = _ref;
  const [loading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [showMore, setShowMore] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const companyData = isContact ? contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.employment : contact === null || contact === void 0 ? void 0 : contact.employment;
  const description = (companyData === null || companyData === void 0 || (_companyData$ = companyData[0]) === null || _companyData$ === void 0 || (_companyData$ = _companyData$.companyId) === null || _companyData$ === void 0 ? void 0 : _companyData$.about) || (companyData === null || companyData === void 0 || (_companyData$2 = companyData[0]) === null || _companyData$2 === void 0 || (_companyData$2 = _companyData$2.companyId) === null || _companyData$2 === void 0 ? void 0 : _companyData$2.description) || 'No information available about this company at the moment.';
  const data = [{
    category: 'Employees',
    svg: (_public_assets_employ_svg__WEBPACK_IMPORTED_MODULE_3___default()),
    value: companyData === null || companyData === void 0 || (_companyData$3 = companyData[0]) === null || _companyData$3 === void 0 || (_companyData$3 = _companyData$3.companyId) === null || _companyData$3 === void 0 ? void 0 : _companyData$3.details
  }, {
    category: 'Founded',
    svg: (_public_assets_founded_svg__WEBPACK_IMPORTED_MODULE_4___default()),
    value: companyData === null || companyData === void 0 || (_companyData$4 = companyData[0]) === null || _companyData$4 === void 0 || (_companyData$4 = _companyData$4.companyId) === null || _companyData$4 === void 0 ? void 0 : _companyData$4.foundedYear
  }, {
    category: 'Industry',
    svg: (_public_assets_industry_svg__WEBPACK_IMPORTED_MODULE_5___default()),
    value: companyData === null || companyData === void 0 || (_companyData$5 = companyData[0]) === null || _companyData$5 === void 0 || (_companyData$5 = _companyData$5.companyId) === null || _companyData$5 === void 0 ? void 0 : _companyData$5.industry
  }, {
    category: 'Headquarter',
    svg: (_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_6___default()),
    value: companyData === null || companyData === void 0 || (_companyData$6 = companyData[0]) === null || _companyData$6 === void 0 || (_companyData$6 = _companyData$6.companyId) === null || _companyData$6 === void 0 ? void 0 : _companyData$6.location
  }];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: "!tww-px-[14px]",
    children: (companyData === null || companyData === void 0 ? void 0 : companyData.length) === 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "container !tww-mt-3 !tww-border !tww-rounded-lg",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "!tww-mt-4",
        id: "UserInfo",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-gap-8",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
              width: 74,
              height: 74,
              className: "".concat(loading ? 'skeleton' : ''),
              src: companyData === null || companyData === void 0 || (_companyData$7 = companyData[0]) === null || _companyData$7 === void 0 || (_companyData$7 = _companyData$7.companyId) === null || _companyData$7 === void 0 ? void 0 : _companyData$7.image,
              style: {
                borderRadius: '15px'
              }
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
            style: {
              marginLeft: '-10px'
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
              className: "!tww-flex",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
                id: "name",
                className: "userName ".concat(loading ? 'skeleton skeleton-text' : ''),
                children: companyData === null || companyData === void 0 || (_companyData$8 = companyData[0]) === null || _companyData$8 === void 0 || (_companyData$8 = _companyData$8.companyId) === null || _companyData$8 === void 0 ? void 0 : _companyData$8.name
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
              id: "about",
              className: "userAbout ".concat(loading ? 'skeleton skeleton-text' : '')
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("a", {
              href: companyData === null || companyData === void 0 || (_companyData$9 = companyData[0]) === null || _companyData$9 === void 0 || (_companyData$9 = _companyData$9.companyId) === null || _companyData$9 === void 0 ? void 0 : _companyData$9.website,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
                src: (_public_assets_link_svg__WEBPACK_IMPORTED_MODULE_2___default()),
                role: "button"
              })
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("p", {
          className: "!tww-mt-4 f-12-400-grey",
          children: [showMore ? description : description.substring(0, 200), description.length > 200 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("a", {
            role: "button",
            onClick: () => setShowMore(!showMore),
            style: {
              color: '#1677FF',
              marginLeft: '2'
            },
            children: showMore ? 'Show Less' : '...Show More'
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "!tww-flex !tww-flex-wrap !tww-justify-center !tww-mt-4 no-gutters",
          children: data === null || data === void 0 ? void 0 : data.map((item, idx) => item.value ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-w-1/2 !tww-mb-2",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
              className: "company-detail-card",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
                className: "!tww-flex !tww-items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
                  src: item.svg,
                  role: "button"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
                  className: "f-12-400-9097A5 !tww-m-0 !tww-ml-2",
                  children: item.category
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("p", {
                className: "!tww-mt-3 f-12-500 truncate-company !tww-text-[#52585F]",
                style: {
                  fontWeight: 700
                },
                children: item.value
              })]
            })
          }, idx) : null)
        })]
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CompanyInfo);

/***/ }),

/***/ "./src/component/indivitual/index.js":
/*!*******************************************!*\
  !*** ./src/component/indivitual/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var _ProfileComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ProfileComponent */ "./src/component/indivitual/ProfileComponent/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _utils_userNameFormatter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/userNameFormatter */ "./src/utils/userNameFormatter.js");
/* harmony import */ var _utils_isPlaceholderImage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/isPlaceholderImage */ "./src/utils/isPlaceholderImage.js");
/* harmony import */ var _ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../ExtractionClasses/linkedin */ "./src/ExtractionClasses/linkedin.js");
/* harmony import */ var _utils_getLinkedInUsername__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/getLinkedInUsername */ "./src/utils/getLinkedInUsername.js");
/* harmony import */ var _utils_personImage__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/personImage */ "./src/utils/personImage.js");
/* harmony import */ var _utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/getDateFromMonthYear */ "./src/utils/getDateFromMonthYear.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");















const IndivitualComponent = () => {
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_13__.useApiRequest)();
  const memoizedState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    const initialName = '';
    const initialAbout = '';
    const initialProfileImageUrl = '';
    const initialLoading = true;
    return {
      initialName,
      initialAbout,
      initialProfileImageUrl,
      initialLoading
    };
  }, []);
  const [name, setName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(memoizedState.initialName);
  const [about, setAbout] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(memoizedState.initialAbout);
  const [profileImageUrl, setProfileImageUrl] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(memoizedState.initialProfileImageUrl);
  const {
    team,
    id
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.tokenState);
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(memoizedState.initialLoading);
  const [revealInfo, setRevealInfo] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [dataFetched, setdataFetchec] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [contact, setContact] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.indvitualUserState);
  const [reportPayload, setReportPayload] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.reportPayloadState);
  const [openPersonalityAnalysis, setOpenPersonalityAnalysis] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.openAnalysisState);
  const [isPersonalityActive, setIsPersonalityActive] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.isPersonalityActiveState);
  const [personalityData, setPersonalityData] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.personalityReportState);
  const [isContact, setIsContact] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [scraped, setScraped] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const selectedFolder = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.selectedFolderState);
  const selectedTag = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.selectedTagsState);
  const [credits, setCredits] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_5__.creditState);
  const [showAndAddCalled, setShowAndAddCalled] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const fetchData = profileId => {
    return new Promise((resolve, reject) => {
      chrome.runtime.sendMessage({
        linkedinAction: 'getProfileContactInfo',
        profileId
      }, response => {
        var _response$result, _response$result2, _response$result3, _response$result4, _response$result5, _response$result6, _response$result7, _response$result8, _response$result9, _response$result10, _response$result11;
        if (response.error) {
          console.error('Error:', response.error);
          reject(response.error);
          return;
        }
        console.log('Response from getProfileContactInfo:', response);
        response.result.education = response === null || response === void 0 || (_response$result = response.result) === null || _response$result === void 0 || (_response$result = _response$result.education) === null || _response$result === void 0 ? void 0 : _response$result.map(item => {
          var _item$school, _item$school2, _item$timePeriod, _item$timePeriod2;
          return {
            instituteName: item.schoolName,
            instituteLogo: "".concat((_item$school = item.school) === null || _item$school === void 0 || (_item$school = _item$school.logo) === null || _item$school === void 0 || (_item$school = _item$school['com.linkedin.common.VectorImage']) === null || _item$school === void 0 ? void 0 : _item$school.rootUrl).concat((_item$school2 = item.school) === null || _item$school2 === void 0 || (_item$school2 = _item$school2.logo) === null || _item$school2 === void 0 || (_item$school2 = _item$school2['com.linkedin.common.VectorImage']) === null || _item$school2 === void 0 ? void 0 : _item$school2.artifacts[0].fileIdentifyingUrlPathSegment),
            degree: item.degreeName,
            fieldOfStudy: item.fieldOfStudy,
            startDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod = item.timePeriod) === null || _item$timePeriod === void 0 ? void 0 : _item$timePeriod.startDate),
            endDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod2 = item.timePeriod) === null || _item$timePeriod2 === void 0 ? void 0 : _item$timePeriod2.endDate)
          };
        });
        response.result.projects = response === null || response === void 0 || (_response$result2 = response.result) === null || _response$result2 === void 0 || (_response$result2 = _response$result2.projects) === null || _response$result2 === void 0 ? void 0 : _response$result2.map(item => {
          var _item$timePeriod3, _item$timePeriod4, _item$members;
          return {
            title: item.title,
            description: item.description,
            url: item.url,
            startDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod3 = item.timePeriod) === null || _item$timePeriod3 === void 0 ? void 0 : _item$timePeriod3.startDate),
            endDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod4 = item.timePeriod) === null || _item$timePeriod4 === void 0 ? void 0 : _item$timePeriod4.endDate),
            members: item === null || item === void 0 || (_item$members = item.members) === null || _item$members === void 0 ? void 0 : _item$members.map(member => {
              var _member$member;
              return member === null || member === void 0 || (_member$member = member.member) === null || _member$member === void 0 ? void 0 : _member$member.publicIdentifier;
            })
          };
        });
        response.result.certifications = response === null || response === void 0 || (_response$result3 = response.result) === null || _response$result3 === void 0 || (_response$result3 = _response$result3.certifications) === null || _response$result3 === void 0 ? void 0 : _response$result3.map(item => {
          var _item$company, _item$company2, _item$timePeriod5, _item$timePeriod6;
          return {
            name: item.name,
            companyName: (_item$company = item.company) === null || _item$company === void 0 ? void 0 : _item$company.name,
            companyUsername: (_item$company2 = item.company) === null || _item$company2 === void 0 ? void 0 : _item$company2.universalName,
            startDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod5 = item.timePeriod) === null || _item$timePeriod5 === void 0 ? void 0 : _item$timePeriod5.startDate),
            endDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod6 = item.timePeriod) === null || _item$timePeriod6 === void 0 ? void 0 : _item$timePeriod6.endDate)
          };
        });
        response.result.honors = response === null || response === void 0 || (_response$result4 = response.result) === null || _response$result4 === void 0 || (_response$result4 = _response$result4.honors) === null || _response$result4 === void 0 ? void 0 : _response$result4.map(item => ({
          title: item.title,
          issuer: item.issuer,
          issueDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)(item.issueDate)
        }));
        response.result.publications = response === null || response === void 0 || (_response$result5 = response.result) === null || _response$result5 === void 0 || (_response$result5 = _response$result5.publications) === null || _response$result5 === void 0 ? void 0 : _response$result5.map(item => {
          var _item$authors;
          return {
            name: item.name,
            publisher: item.publisher,
            url: item.url,
            date: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)(item.date),
            authors: item === null || item === void 0 || (_item$authors = item.authors) === null || _item$authors === void 0 ? void 0 : _item$authors.map(author => {
              var _author$member;
              return author === null || author === void 0 || (_author$member = author.member) === null || _author$member === void 0 ? void 0 : _author$member.publicIdentifier;
            })
          };
        });
        response.result.volunteerWorks = response === null || response === void 0 || (_response$result6 = response.result) === null || _response$result6 === void 0 || (_response$result6 = _response$result6.volunteerWorks) === null || _response$result6 === void 0 ? void 0 : _response$result6.map(item => {
          var _item$company$company, _item$company3, _item$company4, _item$company5, _item$timePeriod7, _item$timePeriod8;
          return {
            role: item.role,
            description: item.description,
            cause: item.cause,
            companyName: (_item$company$company = (_item$company3 = item.company) === null || _item$company3 === void 0 ? void 0 : _item$company3.companyName) !== null && _item$company$company !== void 0 ? _item$company$company : (_item$company4 = item.company) === null || _item$company4 === void 0 || (_item$company4 = _item$company4.miniCompany) === null || _item$company4 === void 0 ? void 0 : _item$company4.name,
            companyUsername: (_item$company5 = item.company) === null || _item$company5 === void 0 || (_item$company5 = _item$company5.miniCompany) === null || _item$company5 === void 0 ? void 0 : _item$company5.universalName,
            startDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod7 = item.timePeriod) === null || _item$timePeriod7 === void 0 ? void 0 : _item$timePeriod7.startDate),
            endDate: (0,_utils_getDateFromMonthYear__WEBPACK_IMPORTED_MODULE_12__.getDateWithDefault)((_item$timePeriod8 = item.timePeriod) === null || _item$timePeriod8 === void 0 ? void 0 : _item$timePeriod8.endDate)
          };
        });
        response.result.employment = response === null || response === void 0 || (_response$result7 = response.result) === null || _response$result7 === void 0 || (_response$result7 = _response$result7.companies) === null || _response$result7 === void 0 ? void 0 : _response$result7.map(item => {
          var _item$company6, _item$company7, _item$company8, _Date, _item$timePeriod9, _item$timePeriod10, _item$timePeriod11, _Date2, _item$timePeriod12, _item$timePeriod13, _item$company9, _item$company10, _item$company11;
          return {
            name: item === null || item === void 0 ? void 0 : item.companyName,
            industry: item !== null && item !== void 0 && (_item$company6 = item.company) !== null && _item$company6 !== void 0 && (_item$company6 = _item$company6.industries) !== null && _item$company6 !== void 0 && _item$company6.length ? item === null || item === void 0 || (_item$company7 = item.company) === null || _item$company7 === void 0 ? void 0 : _item$company7.industries[0] : '',
            linkedIn: "https://linkedin.com/company/".concat(item === null || item === void 0 || (_item$company8 = item.company) === null || _item$company8 === void 0 || (_item$company8 = _item$company8.miniCompany) === null || _item$company8 === void 0 ? void 0 : _item$company8.universalName),
            startDate: (_Date = new Date((_item$timePeriod9 = item.timePeriod) === null || _item$timePeriod9 === void 0 || (_item$timePeriod9 = _item$timePeriod9.startDate) === null || _item$timePeriod9 === void 0 ? void 0 : _item$timePeriod9.year, ((_item$timePeriod10 = item.timePeriod) === null || _item$timePeriod10 === void 0 || (_item$timePeriod10 = _item$timePeriod10.startDate) === null || _item$timePeriod10 === void 0 ? void 0 : _item$timePeriod10.month) - 1)) === null || _Date === void 0 ? void 0 : _Date.getTime(),
            endDate: (_item$timePeriod11 = item.timePeriod) !== null && _item$timePeriod11 !== void 0 && _item$timePeriod11.endDate ? (_Date2 = new Date((_item$timePeriod12 = item.timePeriod) === null || _item$timePeriod12 === void 0 || (_item$timePeriod12 = _item$timePeriod12.endDate) === null || _item$timePeriod12 === void 0 ? void 0 : _item$timePeriod12.year, ((_item$timePeriod13 = item.timePeriod) === null || _item$timePeriod13 === void 0 || (_item$timePeriod13 = _item$timePeriod13.endDate) === null || _item$timePeriod13 === void 0 ? void 0 : _item$timePeriod13.month) - 1)) === null || _Date2 === void 0 ? void 0 : _Date2.getTime() : undefined,
            image: "".concat(item === null || item === void 0 || (_item$company9 = item.company) === null || _item$company9 === void 0 || (_item$company9 = _item$company9.miniCompany) === null || _item$company9 === void 0 || (_item$company9 = _item$company9.logo) === null || _item$company9 === void 0 || (_item$company9 = _item$company9['com.linkedin.common.VectorImage']) === null || _item$company9 === void 0 ? void 0 : _item$company9.rootUrl).concat(item === null || item === void 0 || (_item$company10 = item.company) === null || _item$company10 === void 0 || (_item$company10 = _item$company10.miniCompany) === null || _item$company10 === void 0 || (_item$company10 = _item$company10.logo) === null || _item$company10 === void 0 || (_item$company10 = _item$company10['com.linkedin.common.VectorImage']) === null || _item$company10 === void 0 ? void 0 : _item$company10.artifacts[0].fileIdentifyingUrlPathSegment),
            jobTitle: item.title,
            location: item === null || item === void 0 ? void 0 : item.locationName,
            empCount: item === null || item === void 0 || (_item$company11 = item.company) === null || _item$company11 === void 0 || (_item$company11 = _item$company11.employeeCountRange) === null || _item$company11 === void 0 ? void 0 : _item$company11.start
          };
        });
        response.result.languages = response === null || response === void 0 || (_response$result8 = response.result) === null || _response$result8 === void 0 || (_response$result8 = _response$result8.languages) === null || _response$result8 === void 0 ? void 0 : _response$result8.map(lang => lang === null || lang === void 0 ? void 0 : lang.name);
        response.result.skills = response === null || response === void 0 || (_response$result9 = response.result) === null || _response$result9 === void 0 || (_response$result9 = _response$result9.skills) === null || _response$result9 === void 0 ? void 0 : _response$result9.map(item => item.name);
        response.result.emails = [response === null || response === void 0 || (_response$result10 = response.result) === null || _response$result10 === void 0 ? void 0 : _response$result10.email];
        response.result.phoneNumbers = response === null || response === void 0 || (_response$result11 = response.result) === null || _response$result11 === void 0 || (_response$result11 = _response$result11.phone) === null || _response$result11 === void 0 ? void 0 : _response$result11.map(item => item === null || item === void 0 ? void 0 : item.number);
        resolve(response.result);
      });
    });
  };
  const searchContact = async (profileUrl, name, profileImageUrl, about) => {
    try {
      var _contact$leadId, _data$contacts$0$cont, _respnseData$leadId, _userData$linkedIn, _userData$linkedIn2;
      if (profileUrl !== null && profileUrl !== void 0 && profileUrl.includes(contact === null || contact === void 0 || (_contact$leadId = contact.leadId) === null || _contact$leadId === void 0 || (_contact$leadId = _contact$leadId.linkedIn) === null || _contact$leadId === void 0 ? void 0 : _contact$leadId.url)) {
        setIsContact(contact !== null && contact !== void 0 && contact.leadId ? true : false);
        setIsPersonalityActive(contact !== null && contact !== void 0 && contact.leadId ? true : false);
        setLoading(false);
        return;
      }
      setPersonalityData({});
      setIsPersonalityActive(false);
      const url = formatLinkedInURL(window.location.href);
      const {
        firstName,
        lastName
      } = (0,_utils_userNameFormatter__WEBPACK_IMPORTED_MODULE_7__.userNameFormatter)(name);
      const isPlaceholder = (0,_utils_isPlaceholderImage__WEBPACK_IMPORTED_MODULE_8__.isPlaceholderImage)(profileImageUrl);
      let profileData = {};
      try {
        profileData = await fetchData((0,_utils_getLinkedInUsername__WEBPACK_IMPORTED_MODULE_10__.getLinkedInProfileId)(url));
      } catch (error) {
        console.error('Error fetching profile data:', error);
      }
      const payload = {
        firstName,
        lastName,
        tagline: about,
        ...profileData
      };
      if (!isPlaceholder) {
        payload.image = profileImageUrl;
      }
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.contacts, "/search"), 'POST', {
        linkedinUrls: {
          [url]: payload
        }
      });

      //setting report payload for Ai personality that can be used globally
      const respnseData = (_data$contacts$0$cont = data.contacts[0].contact) !== null && _data$contacts$0$cont !== void 0 ? _data$contacts$0$cont : data.contacts[0].lead;

      //we need to check if it is contact or lead casue data is structured differently
      const userData = (_respnseData$leadId = respnseData === null || respnseData === void 0 ? void 0 : respnseData.leadId) !== null && _respnseData$leadId !== void 0 ? _respnseData$leadId : respnseData;

      //now we make payload that we need to save in report payload
      setReportPayload({
        full_name: "".concat(userData === null || userData === void 0 ? void 0 : userData.firstName, " ").concat(userData === null || userData === void 0 ? void 0 : userData.lastName),
        linkedin_username: userData === null || userData === void 0 || (_userData$linkedIn = userData.linkedIn) === null || _userData$linkedIn === void 0 ? void 0 : _userData$linkedIn.userName,
        linkedinUrl: userData === null || userData === void 0 || (_userData$linkedIn2 = userData.linkedIn) === null || _userData$linkedIn2 === void 0 ? void 0 : _userData$linkedIn2.url,
        ...userData,
        userId: id,
        teamId: team === null || team === void 0 ? void 0 : team._id
      });
      setProfileImageUrl(userData === null || userData === void 0 ? void 0 : userData.image);
      setContact(respnseData);
      setIsPersonalityActive(data.contacts[0].isContact);
      setIsContact(data.contacts[0].isContact);
      setdataFetchec(true);
      setLoading(false);
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.contacts, "/search POST API in indivitual.js file"),
          source: 'extension',
          module: 'Individual Prospect Search - Search Contact'
        });
      } catch (error) {}
    } finally {
      setScraped(false);
      setShowAndAddCalled(false);
    }
  };

  // function formatLinkedInURL(url) {
  //   if (url?.startsWith("https://www.")) {
  //     url = url?.slice(12);
  //   }
  //   if (url?.endsWith("/")) {
  //     return url?.slice(0, -1);
  //   }
  //   return url;
  // }

  function formatLinkedInURL(url) {
    if (url.includes('linkedin.com/in/')) {
      const username = url.split('linkedin.com/in/')[1].split('/')[0];
      return "linkedin.com/in/".concat(username);
    }
  }
  const formattedUrl = formatLinkedInURL(window.location.href);
  const checkSalesQL = async url => {
    try {
      const {
        data
      } = await makeRequest("/leads/salesql/check?linkedinUrl=".concat(encodeURIComponent(formattedUrl)), 'GET');
      return data;
    } catch (error) {
      react_hot_toast__WEBPACK_IMPORTED_MODULE_2__["default"].error('Failed to check contact info from SalesQL');
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with /leads/salesql/check?linkedinUrl=".concat(encodeURIComponent(formattedUrl), " GET API in indivitual.js file"),
          source: 'extension',
          module: 'Individual Prospect Search - Search from Salesql'
        });
      } catch (error) {}
      return null;
    }
  };
  const showAndAdd = async () => {
    setShowAndAddCalled(true);
    try {
      var _team$plan, _contact$linkedIn, _ref;
      setLoading(true);
      setRevealInfo(true);
      if (!selectedFolder.id) throw Error('Please Select the Folder');
      const salesQLResponse = await checkSalesQL(formattedUrl);
      const isPaidPlan = team === null || team === void 0 || (_team$plan = team.plan) === null || _team$plan === void 0 || (_team$plan = _team$plan.planId) === null || _team$plan === void 0 ? void 0 : _team$plan.isPaid;
      const called = (salesQLResponse === null || salesQLResponse === void 0 ? void 0 : salesQLResponse.called) === true;
      const withinThreeMonths = (salesQLResponse === null || salesQLResponse === void 0 ? void 0 : salesQLResponse.withinThreeMonths) === true;
      let shouldCallSalesQL = false;
      let creditType = 'External Credit';
      if (!called) {
        // If never called before, always call POST
        shouldCallSalesQL = true;
        creditType = 'External Credit';
        console.log('SalesQL never called, calling POST lookup API');
      } else {
        // called === true
        if (isPaidPlan) {
          // Paid user: call POST only if withinThreeMonths === false
          if (!withinThreeMonths) {
            shouldCallSalesQL = true;
            creditType = 'External Credit';
          } else {
            shouldCallSalesQL = false;
            creditType = 'Internal Credit';
            console.log('Paid user - within 3 months, no POST call');
          }
        }
      }
      if (shouldCallSalesQL) {
        try {
          await makeRequest("/leads/salesql/lookup", 'POST', {
            linkedinUrl: formattedUrl,
            teamId: team === null || team === void 0 ? void 0 : team._id
          });
        } catch (error) {
          await makeRequest('/ErrorLog', 'POST', {
            message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
            stack: "Error with /leads/salesql/lookup POST API in indivitual.js file",
            source: 'extension',
            module: 'Individual Prospect Search - Search from Saalesql'
          });
        }
      }
      const payload = {
        linkedinUrls: [contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.url],
        folderId: selectedFolder.id,
        tags: (_ref = selectedTag || []) === null || _ref === void 0 ? void 0 : _ref.map(tag => tag._id),
        source: 'linkedIn'
      };
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.contacts), 'POST', payload);
      searchContact(payload.linkedinUrls[0], name, profileImageUrl);
      setIsPersonalityActive(true);
      setRevealInfo(false);
      updateCredits();
    } catch (error) {
      try {
        await makeRequest('/ErrorLog', 'POST', {
          message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
          stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.contacts, " POST API in indivitual.js file"),
          source: 'extension',
          module: 'Individual Prospect Search - Reveal Contact and Add'
        });
      } catch (error) {}
      react_hot_toast__WEBPACK_IMPORTED_MODULE_2__["default"].error((error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred');
    } finally {
      setRevealInfo(false);
      setLoading(false);
    }
  };
  const updateCredits = async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.credit), 'GET');
      setCredits(data.credits);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with \n        ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_6__.credit, " GET API in indivitual.js file"),
        source: 'extension',
        module: 'Individual Prospect Search - Reveal Contact and Add'
      });
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const onMessage = (request, sender, sendResponse) => {
      if (request.method === 'UrlChanged') {
        const ChangedUrl = request.url;
        if (ChangedUrl.match('/in/*')) {
          setLoading(true);
          setAbout('');
          setName('');
          setProfileImageUrl('');
          setOpenPersonalityAnalysis(true);
          setScraped(true);
        }
      }
    };
    chrome.runtime.onMessage.addListener(onMessage);
    if (!contact.length === 0) {
      setOpenPersonalityAnalysis(true);
    }
    scrapeData();
    return () => {
      chrome.runtime.onMessage.removeListener(onMessage);
    };
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (scraped) {
      scrapeData();
    }
  }, [scraped]);
  const scrapeData = () => {
    setTimeout(() => {
      var _profileUrl$, _names$0$innerText, _names$, _profileUrl$2, _profileUrl$3, _profileUrl$4, _about$, _profileImageUrl$0$fi, _profileImageUrl$, _profileImageUrl2$, _profileUrl$5, _names$0$innerText2, _names$2, _profileUrl$6, _profileUrl$7, _profileUrl$8, _profileImageUrl$0$fi2, _profileImageUrl2$2, _about$2;
      const about = document.getElementsByClassName(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__.linkedInClasses.IndivitualSearch.about);
      const names = document.getElementsByClassName(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__.linkedInClasses.IndivitualSearch.name);
      const profileUrl = document.getElementsByClassName(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__.linkedInClasses.IndivitualSearch.profileUrl);
      console.log('profile Url scrapped:', (_profileUrl$ = profileUrl[0]) === null || _profileUrl$ === void 0 ? void 0 : _profileUrl$.baseURI);
      const profileImageUrl = document.getElementsByClassName(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__.linkedInClasses.IndivitualSearch.imageUrl);
      const profileImageUrl2 = document.getElementsByClassName(_ExtractionClasses_linkedin__WEBPACK_IMPORTED_MODULE_9__.linkedInClasses.IndivitualSearch.imageUrl2);
      setName(((_names$0$innerText = (_names$ = names[0]) === null || _names$ === void 0 ? void 0 : _names$.innerText) !== null && _names$0$innerText !== void 0 ? _names$0$innerText : ((_profileUrl$2 = profileUrl[0]) === null || _profileUrl$2 === void 0 ? void 0 : _profileUrl$2.innerText) === 'test') ? (_profileUrl$3 = profileUrl[1]) === null || _profileUrl$3 === void 0 ? void 0 : _profileUrl$3.innerText : (_profileUrl$4 = profileUrl[0]) === null || _profileUrl$4 === void 0 ? void 0 : _profileUrl$4.innerText);
      setAbout((_about$ = about[0]) === null || _about$ === void 0 ? void 0 : _about$.innerText);
      const imageElement = (_profileImageUrl$0$fi = profileImageUrl === null || profileImageUrl === void 0 || (_profileImageUrl$ = profileImageUrl[0]) === null || _profileImageUrl$ === void 0 || (_profileImageUrl$ = _profileImageUrl$.firstElementChild) === null || _profileImageUrl$ === void 0 || (_profileImageUrl$ = _profileImageUrl$.firstElementChild) === null || _profileImageUrl$ === void 0 || (_profileImageUrl$ = _profileImageUrl$.firstElementChild) === null || _profileImageUrl$ === void 0 ? void 0 : _profileImageUrl$.currentSrc) !== null && _profileImageUrl$0$fi !== void 0 ? _profileImageUrl$0$fi : profileImageUrl2 === null || profileImageUrl2 === void 0 || (_profileImageUrl2$ = profileImageUrl2[0]) === null || _profileImageUrl2$ === void 0 || (_profileImageUrl2$ = _profileImageUrl2$.querySelector('img')) === null || _profileImageUrl2$ === void 0 ? void 0 : _profileImageUrl2$.src;
      setProfileImageUrl(!imageElement.currentSrc || imageElement.currentSrc.startsWith('data:') ? _utils_personImage__WEBPACK_IMPORTED_MODULE_11__.personImage : imageElement);
      searchContact((_profileUrl$5 = profileUrl[0]) === null || _profileUrl$5 === void 0 ? void 0 : _profileUrl$5.baseURI, ((_names$0$innerText2 = (_names$2 = names[0]) === null || _names$2 === void 0 ? void 0 : _names$2.innerText) !== null && _names$0$innerText2 !== void 0 ? _names$0$innerText2 : ((_profileUrl$6 = profileUrl[0]) === null || _profileUrl$6 === void 0 ? void 0 : _profileUrl$6.innerText) === 'test') ? (_profileUrl$7 = profileUrl[1]) === null || _profileUrl$7 === void 0 ? void 0 : _profileUrl$7.innerText : (_profileUrl$8 = profileUrl[0]) === null || _profileUrl$8 === void 0 ? void 0 : _profileUrl$8.innerText, (_profileImageUrl$0$fi2 = profileImageUrl[0].firstElementChild.firstElementChild.firstElementChild.currentSrc) !== null && _profileImageUrl$0$fi2 !== void 0 ? _profileImageUrl$0$fi2 : profileImageUrl2 === null || profileImageUrl2 === void 0 || (_profileImageUrl2$2 = profileImageUrl2[0]) === null || _profileImageUrl2$2 === void 0 || (_profileImageUrl2$2 = _profileImageUrl2$2.querySelector('img')) === null || _profileImageUrl2$2 === void 0 ? void 0 : _profileImageUrl2$2.src, (_about$2 = about[0]) === null || _about$2 === void 0 ? void 0 : _about$2.innerText);
    }, 1000);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx)(_ProfileComponent__WEBPACK_IMPORTED_MODULE_4__["default"], {
    name: name,
    about: about,
    profileImageUrl: profileImageUrl,
    dataFetched: dataFetched,
    loading: loading,
    contact: contact,
    revealInfo: revealInfo,
    showAndAdd: showAndAdd,
    isContact: isContact,
    showAndAddCalled: showAndAddCalled
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IndivitualComponent);

/***/ }),

/***/ "./src/component/indivitual/revealLoading/index.js":
/*!*********************************************************!*\
  !*** ./src/component/indivitual/revealLoading/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_lottie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-lottie */ "./node_modules/react-lottie/dist/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../App.css */ "./src/App.css");
/* harmony import */ var _animationJson_data_loading_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../animationJson/data-loading.json */ "./src/animationJson/data-loading.json");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const RevealLoadingComponent = () => {
  const defaultOptions = {
    loop: true,
    autoplay: true,
    animationData: _animationJson_data_loading_json__WEBPACK_IMPORTED_MODULE_3__,
    rendererSettings: {
      preserveAspectRatio: "xMidYMid slice"
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "loading-container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_lottie__WEBPACK_IMPORTED_MODULE_1__["default"], {
      options: defaultOptions,
      height: 124,
      width: 124
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "!tww-mt-2 f-15-500",
      children: "Exploring the Depths of Data..."
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "!tww-mt-2 f-11-lightGrey-lightGrey !tww-text-center",
      children: "Wait with patience, for your data's secrets will soon be revealed."
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RevealLoadingComponent);

/***/ }),

/***/ "./src/component/loading/index.js":
/*!****************************************!*\
  !*** ./src/component/loading/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");


const Loading = _ref => {
  let {
    position
  } = _ref;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: position,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "!tww-spinner-border",
      role: "status",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        className: "!tww-sr-only",
        children: "Loading..."
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Loading);

/***/ }),

/***/ "./src/component/login/index.js":
/*!**************************************!*\
  !*** ./src/component/login/index.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _animationJson_login_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../animationJson/login.json */ "./src/animationJson/login.json");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../public/assets/logo-main.svg */ "./public/assets/logo-main.svg");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");







const LoginPage = () => {
  const defaultOptions = {
    loop: true,
    autoplay: true,
    animationData: _animationJson_login_json__WEBPACK_IMPORTED_MODULE_2__,
    rendererSettings: {
      preserveAspectRatio: "xMidYMid slice"
    }
  };
  const handleClick = type => {
    if (type === "login") {
      (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_1__.navigateToWebsite)("login?extension_redirect=true", "production");
    } else {
      (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_1__.navigateToWebsite)("signup?extension_redirect=true", "production");
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    chrome.storage.local.remove("userInfo", function () {
      var error = chrome.runtime.lastError;
      if (error) {
        console.error(error);
      } else {
        console.log("Item removed from local storage useEffect");
      }
    });
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "wrongPage-container",
    style: {
      height: "100vh",
      backgroundColor: "white"
    },
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("img", {
      src: (_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_3___default()),
      alt: "EazyConnections Logo",
      className: "!tww-w-[150px] !tww-h-[150px]"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("p", {
      className: "!tww-mt-2 f-26 !tww-text-[22px]",
      style: {
        maxWidth: "65%"
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("b", {
        children: "Welcome to EazyConnections"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("button", {
      className: "btn-login-purple f-14-500-white",
      onClick: () => handleClick("login"),
      children: "Login"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("p", {
      className: "!tww-mt-2 f-15-lightGrey",
      style: {
        maxWidth: "60%"
      },
      children: ["Don't have an account?", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("a", {
          role: "button",
          onClick: () => handleClick("signUp"),
          style: {
            color: "#6a69ff",
            cursor: "pointer"
          },
          children: "Sign up."
        })
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoginPage);

/***/ }),

/***/ "./src/component/personality/analysis/index.js":
/*!*****************************************************!*\
  !*** ./src/component/personality/analysis/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _common_barChart__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../common/barChart */ "./src/component/common/barChart/index.js");
/* harmony import */ var _common_traistsGraph__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../common/traistsGraph */ "./src/component/common/traistsGraph/index.js");
/* harmony import */ var _common_traistProgressBar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../common/traistProgressBar */ "./src/component/common/traistProgressBar/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _common_personalityLayout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../common/personalityLayout */ "./src/component/common/personalityLayout/index.js");
/* harmony import */ var _common_accordian__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../common/accordian */ "./src/component/common/accordian/index.js");
/* harmony import */ var _public_assets_verified_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../public/assets/verified.svg */ "./public/assets/verified.svg");
/* harmony import */ var _public_assets_verified_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_public_assets_verified_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _public_assets_unverified_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../public/assets/unverified.svg */ "./public/assets/unverified.svg");
/* harmony import */ var _public_assets_unverified_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_public_assets_unverified_svg__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../../public/assets/tick.svg */ "./public/assets/tick.svg");
/* harmony import */ var _public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../../public/assets/cross.svg */ "./public/assets/cross.svg");
/* harmony import */ var _public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _public_assets_star_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../../public/assets/star.svg */ "./public/assets/star.svg");
/* harmony import */ var _public_assets_star_svg__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_public_assets_star_svg__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../../public/assets/information.svg */ "./public/assets/information.svg");
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");


















const AnalysisComponent = _ref => {
  var _indivitualData$leadI, _contact$firstName, _contact$firstName2, _personalityData$disc, _personalityData$disc2, _ref2, _personalityData$disc3, _personalityData$disc4, _ref3, _personalityData$disc5, _personalityData$disc6, _personalityData$disc7, _personalityData$disc8, _indivitualData$leadI2, _personalityData$disc9, _personalityData$disc10, _personalityData$disc11, _personalityData$disc12, _personalityData$disc13, _personalityData$disc14, _personalityData$disc15, _personalityData$disc16, _personalityData$disc17, _personalityData$disc18, _personalityData$disc19, _contact$firstName3, _personalityData$disc20, _contact$firstName4, _personalityData$disc21, _contact$firstName5, _personalityData$disc22, _contact$firstName6, _personalityData$disc23, _contact$firstName7, _personalityData$disc24, _contact$firstName8, _personalityData$disc25, _personalityData$disc26, _personalityData$sixt, _personalityData$sixt2, _personalityData$sixt3, _personalityData$sixt4;
  let {
    loading = false
  } = _ref;
  const indivitualData = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.indvitualUserState);
  const contact = (_indivitualData$leadI = indivitualData === null || indivitualData === void 0 ? void 0 : indivitualData.leadId) !== null && _indivitualData$leadI !== void 0 ? _indivitualData$leadI : indivitualData;
  const personalityData = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.personalityReportState);
  const [isToggled, setIsToggled] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.isPersonalityToggledState);
  const [isFullAnalytics, setIsFullAnalytics] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  function getTopTwoTraitsString(scores) {
    const traits = ['OPENNESS', 'CONSCIENTIOUSNESS', 'EXTRAVERSION', 'AGREEABLENESS', 'NEUROTICISM'];
    // Create an array of objects with score and trait
    let scoreTraitPairs = scores === null || scores === void 0 ? void 0 : scores.map((score, index) => {
      return {
        score,
        trait: traits[index]
      };
    });

    // Sort the array in descending order based on the score
    scoreTraitPairs.sort((a, b) => b.score - a.score);

    // Get the top two traits
    let topTwoTraits = scoreTraitPairs.slice(0, 2);

    // Return the top two traits as a string
    return "".concat(topTwoTraits[0].trait, "-").concat(topTwoTraits[1].trait);
  }
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setTimeout(() => {
      setIsFullAnalytics(true);
    }, 1000);
  }, []);
  const percentageString = (personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyAIConfPercentage) || '0%';
  const percentage = parseInt(percentageString === null || percentageString === void 0 ? void 0 : percentageString.replace('%', ''));
  return Object.keys(personalityData).length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_common_personalityLayout__WEBPACK_IMPORTED_MODULE_7__["default"], {
      title: "".concat(contact === null || contact === void 0 || (_contact$firstName = contact.firstName) === null || _contact$firstName === void 0 ? void 0 : _contact$firstName.split(' ')[0], "'s Personality").toUpperCase(),
      tooltipLink: 'https://dev.eazyconnections.ai/dashboard/personality-help',
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
        class: "tww-flex tww-items-end tww-absolute tww-top-0 tww-right-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
          class: "tww-mr-2 tww-m-0 f-11-lightGrey",
          children: "Sales"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("label", {
          class: "switch",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("input", {
            type: "checkbox",
            checked: isToggled,
            onChange: () => setIsToggled(!isToggled)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
            class: "slider round"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
          class: "tww-ml-2 tww-m-0 f-11-lightGrey",
          children: "Hiring"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
        className: "tww-mt-5 analysisContainer",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "tww-flex tww-items-center tww-justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-flex tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("img", {
              src: "https://i.ibb.co/8D4hJVc/cropped-DISC-Basic-Logo-1.png",
              className: "tww-rounded-full img-fluid"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
              className: "tww-m-0 tww-ml-3 f-15-400 ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
                className: "tww-flex tww-items-center tww-gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
                  className: "!tww-max-w-[220px] !tww-text-[14px]",
                  children: ["".concat(contact === null || contact === void 0 || (_contact$firstName2 = contact.firstName) === null || _contact$firstName2 === void 0 ? void 0 : _contact$firstName2.split(' ')[0], " has a "), ' ', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("strong", {
                    children: [(personalityData === null || personalityData === void 0 || (_personalityData$disc = personalityData.discStyle) === null || _personalityData$disc === void 0 ? void 0 : _personalityData$disc.pertyDiscStyle) === 'Dominance' ? 'Dominant' : personalityData === null || personalityData === void 0 || (_personalityData$disc2 = personalityData.discStyle) === null || _personalityData$disc2 === void 0 ? void 0 : _personalityData$disc2.pertyDiscStyle, ' ']
                  }), "Personality with", ' ', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("strong", {
                    children: personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyDiscType
                  }), " subtype"]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
                  tooltipText: 'Learn more about Personality Intel',
                  customClass: "!tww-text-nowrap tww-ml-[-120px]",
                  tooltipLink: 'https://dev.eazyconnections.ai/dashboard/personality-help',
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("img", {
                    src: (_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_14___default()),
                    className: "tww-ml-2 img-fluid",
                    width: 20
                  })
                })]
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
            className: "progress-circle-container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "progress-circle",
              style: {
                '--percentage': percentage || 0
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-bg-white tww-absolute tww-w-[32px] tww-h-[32px] tww-rounded-full tww-top-1/2 tww-left-1/2 tww-transform tww--translate-x-1/2 tww--translate-y-1/2"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-m-0 f-12-600",
                children: "".concat(personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyAIConfPercentage)
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
          className: "tww-mt-5 ",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
            className: "tww-flex",
            children: (_ref2 = (personalityData === null || personalityData === void 0 || (_personalityData$disc3 = personalityData.discStyle) === null || _personalityData$disc3 === void 0 ? void 0 : _personalityData$disc3.pertyDiscTraitsH) || (personalityData === null || personalityData === void 0 || (_personalityData$disc4 = personalityData.discStyle) === null || _personalityData$disc4 === void 0 ? void 0 : _personalityData$disc4.pertyDiscTraitsS)) === null || _ref2 === void 0 ? void 0 : _ref2.map((type, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
              className: "tww-flex tww-items-center tww-justify-between tww-px-3 tww-py-2 tww-ml-1",
              style: {
                backgroundColor: '#7B5DE9',
                borderRadius: '15px'
              },
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-m-0 f-10-500-white",
                children: type
              })
            }, index))
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
          className: "tww-mt-3",
          children: (_ref3 = (personalityData === null || personalityData === void 0 || (_personalityData$disc5 = personalityData.discStyle) === null || _personalityData$disc5 === void 0 ? void 0 : _personalityData$disc5.pertyDiscDescH) || (personalityData === null || personalityData === void 0 || (_personalityData$disc6 = personalityData.discStyle) === null || _personalityData$disc6 === void 0 ? void 0 : _personalityData$disc6.pertyDiscDescS)) === null || _ref3 === void 0 ? void 0 : _ref3.map((type, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
            className: "tww-m-0 f-12-400-grey",
            children: type
          }, index))
        }), isFullAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "tww-flex tww-flex-col",
          children: [!isToggled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-mt-4 tww-rounded-lg chartContainer",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
              className: "tww-my-4 tww-mb-2 tww-text-center f-14-600",
              children: "Behavioral Components (DISC)"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-my-5",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_barChart__WEBPACK_IMPORTED_MODULE_3__["default"], {
                data: JSON.parse(personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyDiscScore),
                isOcean: false
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
                className: "tww-flex tww-items-center tww-justify-between tww-text-[12px]",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                  children: "Dominance"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                  children: "Influential"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                  children: "Stable"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                  children: "Compliant"
                })]
              })]
            })]
          }), !isToggled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "".concat(isToggled ? 'tww-order-first' : '', " tww-mt-4 tww-rounded-lg chartContainer"),
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
              className: "tww-mt-4 tww-text-center f-14-600",
              children: "DISC personality Map "
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
              className: "tww-text-[12px] tww-mt-2 tww-text-center",
              children: ["Personality -", ' ', (personalityData === null || personalityData === void 0 || (_personalityData$disc7 = personalityData.discStyle) === null || _personalityData$disc7 === void 0 ? void 0 : _personalityData$disc7.pertyDiscStyle) === 'Dominance' ? 'Dominant' : personalityData === null || personalityData === void 0 || (_personalityData$disc8 = personalityData.discStyle) === null || _personalityData$disc8 === void 0 ? void 0 : _personalityData$disc8.pertyDiscStyle, ' ', "(", personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyDiscType, ")"]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-w-full tww-relative tww-h-[300px]  tww-flex tww-items-center tww-justify-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("img", {
                src: "https://ez-staging.s3.ap-south-1.amazonaws.com/".concat(personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyDiscType.toLowerCase(), ".png"),
                alt: "image",
                fill: true,
                className: "tww-object-cover tww-bg-center"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("img", {
                src: (indivitualData === null || indivitualData === void 0 || (_indivitualData$leadI2 = indivitualData.leadId) === null || _indivitualData$leadI2 === void 0 ? void 0 : _indivitualData$leadI2.image) || (indivitualData === null || indivitualData === void 0 ? void 0 : indivitualData.image),
                alt: "EazyConnection Personality Profile",
                width: 50,
                height: 50,
                className: "tww-absolute tww--translate-x-1/2 tww--translate-y-1/2 tww-rounded-full tww-top-1/2 tww-left-1/2"
              })]
            })]
          }), !(personalityData !== null && personalityData !== void 0 && (_personalityData$disc9 = personalityData.discStyle) !== null && _personalityData$disc9 !== void 0 && _personalityData$disc9.pertyDiscTraitsH) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "Do\u2019s for communicating",
              icon: (_public_assets_verified_svg__WEBPACK_IMPORTED_MODULE_9___default()),
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc10 = personalityData.discStyle) === null || _personalityData$disc10 === void 0 || (_personalityData$disc10 = _personalityData$disc10.pertyDiscCommDosDontsS) === null || _personalityData$disc10 === void 0 ? void 0 : _personalityData$disc10.slice(0, 3),
              listIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
              isOpened: true
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "Dont\u2019s for communicating",
              icon: (_public_assets_unverified_svg__WEBPACK_IMPORTED_MODULE_10___default()),
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc11 = personalityData.discStyle) === null || _personalityData$disc11 === void 0 || (_personalityData$disc11 = _personalityData$disc11.pertyDiscCommDosDontsS) === null || _personalityData$disc11 === void 0 ? void 0 : _personalityData$disc11.slice(3, 6),
              listIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default()),
              isOpened: true
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-mt-4 tww-rounded-lg chartContainer",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
                className: "tww-font-semibold tww-text-center tww-my-4",
                children: ["Personality Traits", ' ']
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-flex tww-flex-col tww-items-center tww-gap-4 tww-p-4",
                children: personalityData === null || personalityData === void 0 || (_personalityData$disc12 = personalityData.discStyle) === null || _personalityData$disc12 === void 0 || (_personalityData$disc12 = _personalityData$disc12.pertyDiscOCEANTraitsH) === null || _personalityData$disc12 === void 0 ? void 0 : _personalityData$disc12.map((traits, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                  className: "tww-w-full tww-bg-[#FFF0E7] tww-text-[14px] tww-p-1.5 tww-rounded-full tww-text-center tww-text-neutral-800 tww-font-semibold tww-cursor-pointer tww-capitalize",
                  children: traits
                }, idx))
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-p-2 tww-px-8 tww-mt-4 tww-bg-white tww-rounded-lg",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
                className: "tww-my-4 tww-font-semibold tww-text-center",
                children: ["Characteristics", ' ']
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "Naturally TENDS to",
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc13 = personalityData.discStyle) === null || _personalityData$disc13 === void 0 ? void 0 : _personalityData$disc13.pertyDiscTendsToS,
                listIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                isDesignChange: true,
                discription: true
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "Naturally STRESSED by",
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc14 = personalityData.discStyle) === null || _personalityData$disc14 === void 0 ? void 0 : _personalityData$disc14.pertyDiscStressedByS,
                listIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default()),
                isDesignChange: true,
                discription: true
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "Naturaly MOTIVATED by",
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc15 = personalityData.discStyle) === null || _personalityData$disc15 === void 0 ? void 0 : _personalityData$disc15.pertyDiscMotivatedByS,
                listIcon: (_public_assets_star_svg__WEBPACK_IMPORTED_MODULE_13___default()),
                isDesignChange: true
              })]
            })]
          }), !(personalityData !== null && personalityData !== void 0 && (_personalityData$disc16 = personalityData.discStyle) !== null && _personalityData$disc16 !== void 0 && _personalityData$disc16.pertyDiscTraitsH) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-p-2 tww-px-8 tww-mt-10 tww-bg-white tww-rounded-lg",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
              className: "f-14-600 tww-text-[16px] tww-text-center tww-mb-8 tww-my-4",
              children: "Engagement Tips"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "Build Rapport",
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc17 = personalityData.discStyle) === null || _personalityData$disc17 === void 0 ? void 0 : _personalityData$disc17.pertyDiscBuildRapportS,
              listIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
              icon: 'https://ez-staging.s3.ap-south-1.amazonaws.com/BuildRapport.png'
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "Gather Information",
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc18 = personalityData.discStyle) === null || _personalityData$disc18 === void 0 ? void 0 : _personalityData$disc18.pertyDiscGatherInfoS,
              listIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
              icon: 'https://ez-staging.s3.ap-south-1.amazonaws.com/gather.png'
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "While Negotiating & Closing",
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc19 = personalityData.discStyle) === null || _personalityData$disc19 === void 0 ? void 0 : _personalityData$disc19.pertyDiscNegotiatingClosingS,
              contactName: contact === null || contact === void 0 || (_contact$firstName3 = contact.firstName) === null || _contact$firstName3 === void 0 ? void 0 : _contact$firstName3.split(' ')[0],
              icon: 'https://ez-staging.s3.ap-south-1.amazonaws.com/Negotiation.png'
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
              title: "Insights For Deal Planning",
              data: personalityData === null || personalityData === void 0 || (_personalityData$disc20 = personalityData.discStyle) === null || _personalityData$disc20 === void 0 ? void 0 : _personalityData$disc20.pertyDiscDealPlanningS,
              contactName: contact === null || contact === void 0 || (_contact$firstName4 = contact.firstName) === null || _contact$firstName4 === void 0 ? void 0 : _contact$firstName4.split(' ')[0],
              icon: 'https://ez-staging.s3.ap-south-1.amazonaws.com/insights.png'
            })]
          })]
        })]
      }), isToggled && (personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyOceanScore) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
        className: "tww-mt-4 analysisContainer",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "tww-flex tww-items-center tww-justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-flex tww-items-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("img", {
              src: "https://i.ibb.co/dgC9vd6/Whats-App-Image-2024-07-07-at-9-16-13-PM-removebg-preview.png",
              className: "tww-rounded img-fluid",
              width: 30,
              height: 30
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-m-0 tww-ml-3 f-15-600",
                children: "OCEAN Analysis (OCA)"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-m-0 tww-ml-3 f-11-500",
                children: getTopTwoTraitsString(JSON.parse(personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyOceanScore))
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
            className: "progress-circle-container",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "progress-circle",
              style: {
                '--percentage': percentage || 0
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-bg-white tww-absolute tww-w-[32px] tww-h-[32px] tww-rounded-full tww-top-1/2 tww-left-1/2 tww-transform tww--translate-x-1/2 tww--translate-y-1/2"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-m-0 f-12-600",
                children: "80%"
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "tww-mt-4 tww-rounded-lg chartContainer",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
            className: "f-14-600",
            children: "Ocean personality"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-my-5",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_barChart__WEBPACK_IMPORTED_MODULE_3__["default"], {
              data: JSON.parse(personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyOceanScore),
              isOcean: true
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-flex tww-items-center tww-justify-between tww-text-[12px]",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                children: "Openness"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                children: "Extraversion"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                children: "Neuroticism"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-flex tww-items-center tww-justify-around tww-text-[12px]",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                className: "tww--ml-2",
                children: "Conscientiousness"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("span", {
                className: "tww--ml-6",
                children: "Agreeableness"
              })]
            })]
          })]
        })]
      }), isFullAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
        children: (personalityData === null || personalityData === void 0 || (_personalityData$disc21 = personalityData.discStyle) === null || _personalityData$disc21 === void 0 ? void 0 : _personalityData$disc21.pertyDiscAsLeaderH) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "tww-mt-4 analysisContainer",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-p-2 tww-px-8 accordianContainer",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-mt-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                  className: "tww-my-4 tww-mb-4 tww-text-[16px] tww-text-center f-15-500",
                  style: {
                    color: '#1C1C1C'
                  },
                  children: "Team Roles"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "".concat(contact === null || contact === void 0 || (_contact$firstName5 = contact.firstName) === null || _contact$firstName5 === void 0 ? void 0 : _contact$firstName5.split(' ')[0], " as a Leader"),
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc22 = personalityData.discStyle) === null || _personalityData$disc22 === void 0 ? void 0 : _personalityData$disc22.pertyDiscAsLeaderH,
                listIcon: 'tick-cross',
                isDesignChange: true,
                tickIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                crossIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default())
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "".concat(contact === null || contact === void 0 || (_contact$firstName6 = contact.firstName) === null || _contact$firstName6 === void 0 ? void 0 : _contact$firstName6.split(' ')[0], " under a Leader"),
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc23 = personalityData.discStyle) === null || _personalityData$disc23 === void 0 ? void 0 : _personalityData$disc23.pertyDiscUnderLeaderH,
                listIcon: 'tick-cross',
                isDesignChange: true,
                tickIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                crossIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default())
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "".concat(contact === null || contact === void 0 || (_contact$firstName7 = contact.firstName) === null || _contact$firstName7 === void 0 ? void 0 : _contact$firstName7.split(' ')[0], " with Peer"),
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc24 = personalityData.discStyle) === null || _personalityData$disc24 === void 0 ? void 0 : _personalityData$disc24.pertyDiscWithPeersH,
                listIcon: 'tick-cross',
                isDesignChange: true,
                tickIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                crossIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default())
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_accordian__WEBPACK_IMPORTED_MODULE_8__["default"], {
                title: "".concat(contact === null || contact === void 0 || (_contact$firstName8 = contact.firstName) === null || _contact$firstName8 === void 0 ? void 0 : _contact$firstName8.split(' ')[0], " with Ideal responsibility"),
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc25 = personalityData.discStyle) === null || _personalityData$disc25 === void 0 ? void 0 : _personalityData$disc25.pertyDiscWithResponsibilityH,
                listIcon: 'tick-cross',
                isDesignChange: true,
                tickIcon: (_public_assets_tick_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                crossIcon: (_public_assets_cross_svg__WEBPACK_IMPORTED_MODULE_12___default())
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-mt-4 accordianContainer",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-my-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                  className: "tww-my-4 tww-mb-5 tww-text-center tww-text-[16px] f-15-500",
                  style: {
                    color: '#1C1C1C'
                  },
                  children: "Personality Traits"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_traistsGraph__WEBPACK_IMPORTED_MODULE_4__["default"], {
                data: personalityData === null || personalityData === void 0 || (_personalityData$disc26 = personalityData.discStyle) === null || _personalityData$disc26 === void 0 ? void 0 : _personalityData$disc26.pertyDiscOCEANScoreH
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-pb-2 tww-mt-4 accordianContainer",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-mt-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                  className: "tww-my-4 tww-mb-6 tww-text-center tww-text-[16px] f-15-500",
                  style: {
                    color: '#1C1C1C'
                  },
                  children: "Big 5 (Ocean) Analysis"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_common_traistProgressBar__WEBPACK_IMPORTED_MODULE_5__["default"], {
                oceanScore: personalityData === null || personalityData === void 0 ? void 0 : personalityData.PertyOceanScore
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "tww-mt-4 accordianContainer",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-mt-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                  className: "tww-mt-2 tww-text-center tww-text-[16px] f-15-500",
                  style: {
                    color: '#1C1C1C'
                  },
                  children: "16-Personality Anaylsis"
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-text-[14px] tww-text-center tww-mb-4",
                children: "(Myers-Briggs / MBTI)"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
                className: "tww-font-bold tww-text-center tww-text-[14px] tww-mt-4 tww-my-2 tww-text-orange-600",
                children: [personalityData === null || personalityData === void 0 || (_personalityData$sixt = personalityData.sixteenPersonalityRecords[0]) === null || _personalityData$sixt === void 0 ? void 0 : _personalityData$sixt.sixteenPersStyle, "- (The", ' ', personalityData === null || personalityData === void 0 || (_personalityData$sixt2 = personalityData.sixteenPersonalityRecords[0]) === null || _personalityData$sixt2 === void 0 ? void 0 : _personalityData$sixt2.sixteenPersStyleType, ")"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                className: "tww-flex tww-flex-col tww-items-center tww-gap-4 tww-p-4 tww-mb-2",
                children: personalityData === null || personalityData === void 0 || (_personalityData$sixt3 = personalityData.sixteenPersonalityRecords[0]) === null || _personalityData$sixt3 === void 0 || (_personalityData$sixt3 = _personalityData$sixt3.pertySixteenChar) === null || _personalityData$sixt3 === void 0 ? void 0 : _personalityData$sixt3.map((traits, idx) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
                  className: "tww-w-full tww-bg-[#FFF0E7] tww-text-[14px] tww-p-1.5 tww-rounded-full tww-text-center tww-text-neutral-800 tww-font-semibold tww-cursor-pointer tww-capitalize",
                  children: traits
                }, idx))
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("p", {
                className: "tww-text-[14px]",
                children: personalityData === null || personalityData === void 0 || (_personalityData$sixt4 = personalityData.sixteenPersonalityRecords[0]) === null || _personalityData$sixt4 === void 0 ? void 0 : _personalityData$sixt4.sixteenPersDesc
              })]
            })]
          })
        })
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnalysisComponent);

/***/ }),

/***/ "./src/component/personality/engage/index.js":
/*!***************************************************!*\
  !*** ./src/component/personality/engage/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _common_engagementCards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/engagementCards */ "./src/component/common/engagementCards/index.js");
/* harmony import */ var _common_personalityLayout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../common/personalityLayout */ "./src/component/common/personalityLayout/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _userInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../userInfo */ "./src/component/personality/userInfo/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const EngageComponent = () => {
  var _indivitualData$leadI, _contact$firstName;
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_8__.useNavigate)();
  const indivitualData = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.indvitualUserState);
  const contact = (_indivitualData$leadI = indivitualData === null || indivitualData === void 0 ? void 0 : indivitualData.leadId) !== null && _indivitualData$leadI !== void 0 ? _indivitualData$leadI : indivitualData;
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    const onMessage = (request, sender, sendResponse) => {
      if (request.method === "UrlChanged") {
        const ChangedUrl = request.url;
        if (ChangedUrl.includes("linkedin.com") && (ChangedUrl.match("/in/*") || ChangedUrl.match("/search/results/people/*") || ChangedUrl.match(/\/mynetwork\/invite-connect\/connections\/.*/) || ChangedUrl.match(/\/company\/.*/) || ChangedUrl.match(/\/school\/.*/))) {
          navigate("/");
        }
      }
    };
    chrome.runtime.onMessage.addListener(onMessage);
    return () => {
      chrome.runtime.onMessage.removeListener(onMessage);
    };
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "!tww-p-3 !tww-h-full",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_userInfo__WEBPACK_IMPORTED_MODULE_5__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "!tww-px-2",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_personalityLayout__WEBPACK_IMPORTED_MODULE_1__["default"], {
        title: "REACH OUT TO ".concat(contact === null || contact === void 0 || (_contact$firstName = contact.firstName) === null || _contact$firstName === void 0 ? void 0 : _contact$firstName.toUpperCase()),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "!tww-flex !tww-flex-wrap !tww-justify-between !tww-mt-5 !tww-py-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "Email",
              icon: "https://ez-staging.s3.ap-south-1.amazonaws.com/EMAIL-ICON.png",
              color: "#AD1269",
              text: "Generate Hyper Personalized Emails",
              btnText: "Generate Emails",
              endpoint: "email"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "LinkedIn Messages",
              icon: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_4___default()),
              color: "#ffffff",
              text: "Generate Personalized LinkedIn Messages",
              btnText: "Generate Messages",
              endpoint: "linkedinMessage"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "Ice Breaker",
              icon: "https://ez-staging.s3.ap-south-1.amazonaws.com/Icebreaker+blue.png",
              color: "#5690E8",
              text: "Generate Handpicked Personalized Emails",
              btnText: "Generate IceBreaker",
              endpoint: "icebreaker"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "LinkedIn Insights",
              icon: "https://ez-staging.s3.ap-south-1.amazonaws.com/Linkedin+Insights+pink.png",
              color: "#5690E8",
              text: "Generate LinkedIn Personal Insight",
              btnText: "Generate Insights",
              endpoint: "linkedinInsight"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "AI Coaching",
              icon: "https://ez-staging.s3.ap-south-1.amazonaws.com/AI-COACH.png",
              color: "#AD1269",
              text: "Enhance your Sales skills with AI Practice",
              btnText: "AI Coaching"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
            className: "!tww-flex !tww-justify-center !tww-px-2 !tww-mb-4",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_common_engagementCards__WEBPACK_IMPORTED_MODULE_0__["default"], {
              label: "Call Script",
              icon: "https://ez-staging.s3.ap-south-1.amazonaws.com/call+script+blue.png",
              color: "#5690E8",
              text: "Generate Call Script with Josh Braun's Insight",
              btnText: "Generate Call Script",
              endpoint: "callScript"
            })
          })]
        })
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EngageComponent);

/***/ }),

/***/ "./src/component/personality/index.js":
/*!********************************************!*\
  !*** ./src/component/personality/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _userInfo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./userInfo */ "./src/component/personality/userInfo/index.js");
/* harmony import */ var _analysis__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./analysis */ "./src/component/personality/analysis/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _common_runAnalysisModal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/runAnalysisModal */ "./src/component/common/runAnalysisModal/index.js");
/* harmony import */ var _common_loader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/loader */ "./src/component/common/loader/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _common_personalityLayout__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../common/personalityLayout */ "./src/component/common/personalityLayout/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../public/assets/information.svg */ "./public/assets/information.svg");
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _common_barChart__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/barChart */ "./src/component/common/barChart/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
















const Personality = () => {
  var _userData$leadId, _contact$linkedIn2, _contact$linkedIn4, _contact$firstName, _contact$firstName2;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_8__.useApiRequest)();
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_14__.useNavigate)();
  const userData = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.indvitualUserState);
  const contact = (_userData$leadId = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId !== void 0 ? _userData$leadId : userData;
  const {
    id,
    team,
    environment
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.tokenState);
  const isPersonalityToggled = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.isPersonalityToggledState);
  const [personalityReport, setPersonalityReport] = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.personalityReportState);
  const [reportPayload, setReportPayload] = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.reportPayloadState);
  const [credits, setCredits] = (0,recoil__WEBPACK_IMPORTED_MODULE_3__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_4__.creditState);
  console.log('personalityReport', personalityReport);
  const [loadingStatus, setLoadingStatus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [personalityAvailable, setPersonalityAvailable] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const hasCalledPersonalityRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  const dummmyDiscTraits = ['Discontracted', 'Energy', 'Pioneer'];
  const checkPersonalityStatus = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    setLoadingStatus(true);
    try {
      var _contact$linkedIn;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityStatus, "?teamId=").concat(team === null || team === void 0 ? void 0 : team._id, "&linkedinUrl=").concat(contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.url), 'GET');
      setPersonalityAvailable(data === null || data === void 0 ? void 0 : data.personalityGenerated);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error),
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityStatus, " GET API"),
        source: 'extension',
        module: 'Personality'
      });
    } finally {
      setLoadingStatus(false);
    }
  }, [makeRequest, team === null || team === void 0 ? void 0 : team._id, contact === null || contact === void 0 || (_contact$linkedIn2 = contact.linkedIn) === null || _contact$linkedIn2 === void 0 ? void 0 : _contact$linkedIn2.url]);
  const updateCredits = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.credit), 'GET');
      setCredits(data.credits);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error),
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.credit, " GET API"),
        source: 'extension',
        module: 'Personality - Update Credits'
      });
    }
  }, [makeRequest, setCredits]);
  const generatePersonality = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    // if (hasCalledPersonalityRef.current) return
    // hasCalledPersonalityRef.current = true

    setLoading(true);
    try {
      var _contact$linkedIn3;
      const payload = {
        linkedinUrl: contact === null || contact === void 0 || (_contact$linkedIn3 = contact.linkedIn) === null || _contact$linkedIn3 === void 0 ? void 0 : _contact$linkedIn3.url,
        userId: id,
        teamId: team === null || team === void 0 ? void 0 : team._id
      };
      setReportPayload(payload);
      const endpoint = isPersonalityToggled ? _config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityHrReport : _config_routes__WEBPACK_IMPORTED_MODULE_5__.personalitySalesReport;
      const {
        data
      } = await makeRequest(endpoint, 'POST', payload);
      if (data) {
        setPersonalityReport(data);
        setPersonalityAvailable(true);
        await updateCredits();
      }
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error),
        stack: "Error with ".concat(isPersonalityToggled ? _config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityHrReport : _config_routes__WEBPACK_IMPORTED_MODULE_5__.personalitySalesReport, " POST API in personality.js file"),
        source: 'extension',
        module: 'Personality'
      });
    } finally {
      setLoading(false);
    }
  }, [contact === null || contact === void 0 || (_contact$linkedIn4 = contact.linkedIn) === null || _contact$linkedIn4 === void 0 ? void 0 : _contact$linkedIn4.url, id, team === null || team === void 0 ? void 0 : team._id, setReportPayload, isPersonalityToggled, makeRequest, setPersonalityReport, updateCredits]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkPersonalityStatus();
  }, [checkPersonalityStatus]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const onMessage = request => {
      if (request.method === 'UrlChanged') {
        const ChangedUrl = request.url;
        if (ChangedUrl.includes('linkedin.com') && (ChangedUrl.match('/in/*') || ChangedUrl.match('/search/results/people/*') || ChangedUrl.match(/\/mynetwork\/invite-connect\/connections\/.*/) || ChangedUrl.match(/\/company\/.*/) || ChangedUrl.match(/\/school\/.*/))) {
          navigate('/');
        }
      }
    };
    chrome.runtime.onMessage.addListener(onMessage);
    return () => chrome.runtime.onMessage.removeListener(onMessage);
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    generatePersonality();
  }, [isPersonalityToggled, generatePersonality]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
    className: "!tww-p-3 !tww-h-full",
    children: loadingStatus || loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
      className: "!tww-h-[80vh] !tww-flex !tww-items-center !tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_loader__WEBPACK_IMPORTED_MODULE_7__["default"], {})
    }) : personalityAvailable ? loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
      className: "!tww-h-[80vh] !tww-flex !tww-items-center !tww-justify-center",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_loader__WEBPACK_IMPORTED_MODULE_7__["default"], {})
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "!tww-flex !tww-flex-col !tww-justify-between !tww-h-full",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_userInfo__WEBPACK_IMPORTED_MODULE_1__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_analysis__WEBPACK_IMPORTED_MODULE_2__["default"], {
        loading: loading
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "!tww-mt-auto !tww-flex !tww-items-center !tww-p-5",
        style: {
          background: 'linear-gradient(89.06deg, #FFF6E9 1.42%, #FEE2F7 48.83%, #C8EBFF 101.57%)'
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
          src: "https://ez-staging.s3.ap-south-1.amazonaws.com/EMAIL-ICON.png",
          alt: "Email Icon"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("p", {
          className: "!tww-m-0 !tww-ml-5",
          onClick: () => navigate('/ai-engage'),
          role: "button",
          children: ["Let's Reach out to ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("strong", {
            children: contact === null || contact === void 0 ? void 0 : contact.firstName
          })]
        })]
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "!tww-relative  !tww-bg-black/10 !tww-h-full !tww-overflow-hidden",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_userInfo__WEBPACK_IMPORTED_MODULE_1__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_common_personalityLayout__WEBPACK_IMPORTED_MODULE_9__["default"], {
          title: "".concat(contact === null || contact === void 0 || (_contact$firstName = contact.firstName) === null || _contact$firstName === void 0 ? void 0 : _contact$firstName.split(' ')[0], "'s Personality").toUpperCase(),
          tooltipLink: 'https://dev.eazyconnections.ai/dashboard/personality-help',
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            class: "tww-flex tww-items-end tww-absolute tww-top-0 tww-right-4",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              class: "tww-mr-2 tww-m-0 f-11-lightGrey",
              children: "Sales"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
              class: "switch",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("input", {
                type: "checkbox",
                checked: true
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
                class: "slider round"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              class: "tww-ml-2 tww-m-0 f-11-lightGrey",
              children: "Hiring"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "tww-mt-5 analysisContainer",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
              className: "tww-flex tww-items-center tww-justify-between",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
                className: "tww-flex tww-items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
                  src: "https://i.ibb.co/8D4hJVc/cropped-DISC-Basic-Logo-1.png",
                  alt: "basic-logo",
                  className: "tww-rounded-full img-fluid"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                  className: "tww-m-0 tww-ml-3 f-15-400 ",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
                    className: "tww-flex tww-items-center tww-gap-2",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("p", {
                      className: "!tww-max-w-[220px] !tww-text-[14px]",
                      children: ["".concat(contact === null || contact === void 0 || (_contact$firstName2 = contact.firstName) === null || _contact$firstName2 === void 0 ? void 0 : _contact$firstName2.split(' ')[0], " has a "), ' ', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("strong", {
                        children: "Dominant"
                      }), "Personality with", ' ']
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_10__["default"], {
                      tooltipText: 'Learn more about Personality Intel',
                      customClass: "!tww-text-nowrap tww-ml-[-120px]",
                      tooltipLink: 'https://dev.eazyconnections.ai/dashboard/personality-help',
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("img", {
                        src: (_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_11___default()),
                        alt: "inf-img",
                        className: "tww-ml-2 img-fluid",
                        width: 20
                      })
                    })]
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
                className: "progress-circle-container",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
                  className: "progress-circle",
                  style: {
                    '--percentage': 50
                  },
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
                    className: "tww-bg-white tww-absolute tww-w-[32px] tww-h-[32px] tww-rounded-full tww-top-1/2 tww-left-1/2 tww-transform tww--translate-x-1/2 tww--translate-y-1/2"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                    className: "tww-m-0 f-12-600"
                  })]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
              className: "tww-mt-5 ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
                className: "tww-flex",
                children: dummmyDiscTraits === null || dummmyDiscTraits === void 0 ? void 0 : dummmyDiscTraits.map((type, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
                  className: "tww-flex tww-items-center tww-justify-between tww-px-3 tww-py-2 tww-ml-1",
                  style: {
                    backgroundColor: '#7B5DE9',
                    borderRadius: '15px'
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                    className: "tww-m-0 f-10-500-white",
                    children: type
                  })
                }, index))
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
              className: "tww-mt-3",
              children: dummmyDiscTraits === null || dummmyDiscTraits === void 0 ? void 0 : dummmyDiscTraits.map((type, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                className: "tww-m-0 f-12-400-grey",
                children: type
              }, index))
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
              className: "tww-flex tww-flex-col",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
                className: "tww-mt-4 tww-rounded-lg chartContainer",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
                  className: "tww-my-4 tww-mb-2 tww-text-center f-14-600",
                  children: "Behavioral Components (DISC)"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
                  className: "tww-my-5",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_barChart__WEBPACK_IMPORTED_MODULE_12__["default"], {
                    data: {
                      alice: '20',
                      bob: '40',
                      diana: '10',
                      charlie: '30'
                    },
                    isOcean: false
                  })
                })]
              })
            })]
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
        className: "!tww-absolute !tww-inset-0 !tww-flex !tww-items-center  !tww-backdrop-blur-sm !tww-justify-center",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_common_runAnalysisModal__WEBPACK_IMPORTED_MODULE_6__["default"], {
          onGeneratePersonality: generatePersonality,
          credits: credits,
          environment: environment
        })
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Personality);

/***/ }),

/***/ "./src/component/personality/userInfo/index.js":
/*!*****************************************************!*\
  !*** ./src/component/personality/userInfo/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../public/assets/linkedin-logo.svg */ "./public/assets/linkedin-logo.svg");
/* harmony import */ var _public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../public/assets/location.svg */ "./public/assets/location.svg");
/* harmony import */ var _public_assets_location_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_public_assets_location_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _public_assets_clock_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../public/assets/clock.svg */ "./public/assets/clock.svg");
/* harmony import */ var _public_assets_clock_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_public_assets_clock_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _public_assets_mic_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../public/assets/mic.svg */ "./public/assets/mic.svg");
/* harmony import */ var _public_assets_mic_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_mic_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _utils_personImage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../utils/personImage */ "./src/utils/personImage.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");











const UserInfo = () => {
  var _data$leadId, _data$leadId2, _data$leadId3, _data$leadId4, _data$leadId5, _data$leadId6, _data$leadId8;
  const data = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.indvitualUserState);
  const {
    environment
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.tokenState);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    id: "UserInfo",
    className: "!tww-flex !tww-flex-wrap !tww-gap-4 !tww-p-3",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
        id: "profileImage",
        src: data !== null && data !== void 0 && (_data$leadId = data.leadId) !== null && _data$leadId !== void 0 && _data$leadId.image || data !== null && data !== void 0 && data.image ? (data === null || data === void 0 || (_data$leadId2 = data.leadId) === null || _data$leadId2 === void 0 ? void 0 : _data$leadId2.image) || (data === null || data === void 0 ? void 0 : data.image) : _utils_personImage__WEBPACK_IMPORTED_MODULE_8__.personImage,
        alt: "Profile",
        style: {
          borderRadius: "15px"
        },
        width: 71,
        height: 71
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "!tww-w-full !tww-pl-2 md:!tww-w-2/3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "!tww-flex !tww-justify-between",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "!tww-flex !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
            tooltipText: "".concat((data === null || data === void 0 || (_data$leadId3 = data.leadId) === null || _data$leadId3 === void 0 ? void 0 : _data$leadId3.firstName) || (data === null || data === void 0 ? void 0 : data.firstName), " ").concat((data === null || data === void 0 || (_data$leadId4 = data.leadId) === null || _data$leadId4 === void 0 ? void 0 : _data$leadId4.lastName) || (data === null || data === void 0 ? void 0 : data.lastName)),
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
              id: "name",
              className: "!tww-truncate userName",
              children: "".concat((data === null || data === void 0 || (_data$leadId5 = data.leadId) === null || _data$leadId5 === void 0 ? void 0 : _data$leadId5.firstName) || (data === null || data === void 0 ? void 0 : data.firstName), " ").concat((data === null || data === void 0 || (_data$leadId6 = data.leadId) === null || _data$leadId6 === void 0 ? void 0 : _data$leadId6.lastName) || (data === null || data === void 0 ? void 0 : data.lastName))
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("img", {
            src: (_public_assets_linkedin_logo_svg__WEBPACK_IMPORTED_MODULE_2___default()),
            className: "!tww-ml-2 img-fluid",
            alt: "LinkedIn",
            role: "button",
            onClick: () => {
              var _data$leadId7, _data$linkedIn;
              return window.open("https://".concat(data === null || data === void 0 || (_data$leadId7 = data.leadId) === null || _data$leadId7 === void 0 || (_data$leadId7 = _data$leadId7.linkedIn) === null || _data$leadId7 === void 0 ? void 0 : _data$leadId7.url) || 0, "_blank");
            }
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
        id: "about",
        className: "userAbout",
        children: (data === null || data === void 0 || (_data$leadId8 = data.leadId) === null || _data$leadId8 === void 0 ? void 0 : _data$leadId8.tagline) || (data === null || data === void 0 ? void 0 : data.tagline)
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "!tww-mt-4",
      id: "RevealInfo",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("button", {
        className: "!tww-m-0 show-dashboard",
        onClick: () => {
          var _data$leadId9, _data$leadId10;
          return (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_7__.navigateToPortal)(data !== null && data !== void 0 && (_data$leadId9 = data.leadId) !== null && _data$leadId9 !== void 0 && _data$leadId9._id ? "ai-personality/".concat(data === null || data === void 0 || (_data$leadId10 = data.leadId) === null || _data$leadId10 === void 0 ? void 0 : _data$leadId10._id, "/personality-profile") : "ai-personality/personality-dashboard", environment);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
          className: "f-12-500",
          style: {
            color: "#7B7AFF"
          },
          children: "Open in dashboard"
        })
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserInfo);

/***/ }),

/***/ "./src/component/setting/index.js":
/*!****************************************!*\
  !*** ./src/component/setting/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/settings-icon.svg */ "./public/assets/settings-icon.svg");
/* harmony import */ var _public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../public/assets/add-folder.svg */ "./public/assets/add-folder.svg");
/* harmony import */ var _public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _public_assets_team_icon_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../public/assets/team-icon.svg */ "./public/assets/team-icon.svg");
/* harmony import */ var _public_assets_team_icon_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_public_assets_team_icon_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _public_assets_dashboard_icon_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../public/assets/dashboard-icon.svg */ "./public/assets/dashboard-icon.svg");
/* harmony import */ var _public_assets_dashboard_icon_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_public_assets_dashboard_icon_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _public_assets_wallet_icon_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../public/assets/wallet-icon.svg */ "./public/assets/wallet-icon.svg");
/* harmony import */ var _public_assets_wallet_icon_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_public_assets_wallet_icon_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _public_assets_bulb_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../public/assets/bulb.svg */ "./public/assets/bulb.svg");
/* harmony import */ var _public_assets_bulb_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_public_assets_bulb_svg__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../public/assets/goToFolder.svg */ "./public/assets/goToFolder.svg");
/* harmony import */ var _public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../public/assets/information.svg */ "./public/assets/information.svg");
/* harmony import */ var _public_assets_information_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _loading__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../loading */ "./src/component/loading/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _utils_calculateCreditRenewDays__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/calculateCreditRenewDays */ "./src/utils/calculateCreditRenewDays.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var _utils_personImage__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/personImage */ "./src/utils/personImage.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _common_apiContext__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../common/apiContext */ "./src/component/common/apiContext/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






















// Logout variables



const cookiesToRemove = ['isLoggedIn', 'user', 'credits', 'folders', 'plan', 'selectedFolder', 'isWebsiteLogin'];
const devDomains = ['https://webdev.eazyconnections.ai', 'https://dev.eazyconnections.ai'];
const stagingDomains = ['https://webstaging.eazyconnections.ai', 'https://staging.eazyconnections.ai'];
const prodDomains = ['https://www.eazyconnections.ai', 'https://app.eazyconnections.ai'];
const Setting = () => {
  var _userInfo$image, _credits$free, _credits$free2, _credits$free3, _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_17__.useApiRequest)();
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_21__.useNavigate)();
  const {
    host,
    settingData
  } = (0,_common_apiContext__WEBPACK_IMPORTED_MODULE_18__.useApiHost)();
  const userInfo = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.tokenState);
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const [version, setVersion] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("");
  const [isWebsiteAnalyzer, setIsWebsiteAnalyzer] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [credits, setCredits] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [planData, setPlanData] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const [barProgress, setBarProgress] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [personalityBarProgress, setPersonalityBarProgress] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [companyBarProgress, setCompanyBarProgress] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [personalityToggle, setPersonalityToggle] = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_2__.isPersonalityToggledState);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    chrome.storage.local.get(['bizWebsiteAnalyzerEnabled'], res => {
      // If there is a saved value, use it
      if (typeof res.bizWebsiteAnalyzerEnabled === 'boolean') {
        setIsWebsiteAnalyzer(res.bizWebsiteAnalyzerEnabled);
      }
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const version = chrome.runtime.getManifest().version;
    setVersion(version);
  }, []);
  const handleWebsiteToggleChange = e => {
    const newValue = e.target.checked;
    setIsWebsiteAnalyzer(newValue);
    chrome.storage.local.set({
      bizWebsiteAnalyzerEnabled: newValue
    });
    chrome.runtime.sendMessage({
      type: 'TOGGLE_BIZ_ANALYZER',
      value: newValue
    });
  };
  const handleChange = event => {
    setPersonalityToggle(event.target.value === 'true');
  };
  const getCredits = async () => {
    try {
      setLoading(true);
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.credit), 'GET', null, userInfo === null || userInfo === void 0 ? void 0 : userInfo.accessToken);
      setCredits(data.credits);
      await getPlan();
      setBarProgress((data.credits.total - data.credits.remaining) / data.credits.total * 100);
      setPersonalityBarProgress((data.credits.totalPersonality - data.credits.remainingPersonality) / data.credits.totalPersonality * 100);
      setCompanyBarProgress((data.credits.totalCompany - data.credits.remainingCompany) / data.credits.totalCompany * 100);
    } catch (error) {
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.credit, " GET API in setting.js file"),
        source: 'extension',
        module: 'Settings - Get Credits'
      });
    } finally {
      setLoading(false);
    }
  };
  const getPlan = async () => {
    try {
      var _userInfo$team;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.plan, "/").concat(userInfo === null || userInfo === void 0 || (_userInfo$team = userInfo.team) === null || _userInfo$team === void 0 || (_userInfo$team = _userInfo$team.plan) === null || _userInfo$team === void 0 ? void 0 : _userInfo$team.planId), 'GET', null, userInfo === null || userInfo === void 0 ? void 0 : userInfo.accessToken);
      setPlanData(data);
    } catch (error) {
      var _userInfo$team2;
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_4__.plan, "/").concat(userInfo === null || userInfo === void 0 || (_userInfo$team2 = userInfo.team) === null || _userInfo$team2 === void 0 || (_userInfo$team2 = _userInfo$team2.plan) === null || _userInfo$team2 === void 0 ? void 0 : _userInfo$team2.planId, " GET API in setting.js file"),
        source: 'extension',
        module: 'Settings - Get Plan'
      });
    }
  };
  const handleLogout = async () => {
    const domains = host !== null && host !== void 0 && host.includes('dev-api') ? devDomains : host !== null && host !== void 0 && host.includes('staging-api') ? stagingDomains : prodDomains;
    chrome.runtime.sendMessage({
      type: 'REMOVE_COOKIES',
      cookies: cookiesToRemove,
      domains
    }, response => {
      if (response !== null && response !== void 0 && response.success) {
        console.log('Cookies removed successfully.');
      } else {
        console.log('Failed to remove cookies.');
      }
      navigate('/login');
    });

    // navigate("/login");
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    getCredits();
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
    style: {
      display: 'flex',
      alignItems: 'center',
      flexDirection: 'column',
      paddingTop: '20px',
      background: '#F6F6F6'
    },
    className: "custom-scrollbar2",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
      className: "setting-container",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-gap-5",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_userInfo$image = userInfo === null || userInfo === void 0 ? void 0 : userInfo.image) !== null && _userInfo$image !== void 0 ? _userInfo$image : _utils_personImage__WEBPACK_IMPORTED_MODULE_16__.personImage,
          alt: "Avatar",
          className: "profile-img"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
            className: "f-16-500 !tww-text-gray-500",
            children: userInfo === null || userInfo === void 0 ? void 0 : userInfo.email
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
            className: "!tww-mt-2 f-12-500 !tww-font-semibold !tww-text-gray-800",
            children: [planData === null || planData === void 0 ? void 0 : planData.title, " Plan"]
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("hr", {}), loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_13__["default"], {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        className: "credit-info",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "!tww-flex !tww-justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
            className: "f-16-500 !tww-tracking-tight",
            children: "Contact Credits used"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
            className: "f-12-500",
            children: "".concat((credits === null || credits === void 0 ? void 0 : credits.total) - (credits === null || credits === void 0 ? void 0 : credits.remaining), "/").concat(credits === null || credits === void 0 ? void 0 : credits.total)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
          className: "credit-bar !tww-min-h-[8px]",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
            className: "credit-bar-inner !tww-min-h-[8px]",
            style: {
              width: "".concat(barProgress, "%")
            }
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        className: "f-12-400 !tww-mt-3 !tww-text-gray-400",
        children: ["Free Credits reset in ", (0,_utils_calculateCreditRenewDays__WEBPACK_IMPORTED_MODULE_15__.calculateDaysLeft)(credits === null || credits === void 0 || (_credits$free = credits.free) === null || _credits$free === void 0 ? void 0 : _credits$free.expiry), " days"]
      }), loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_13__["default"], {}) : settingData.aiPersonality && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "credit-info !tww-mt-9",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
            className: "!tww-flex !tww-justify-between",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
              className: "f-16-500 !tww-tracking-tight",
              children: "Research Credits used"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
              className: "f-12-500",
              children: "".concat((credits === null || credits === void 0 ? void 0 : credits.totalPersonality) - (credits === null || credits === void 0 ? void 0 : credits.remainingPersonality), "/").concat(credits === null || credits === void 0 ? void 0 : credits.totalPersonality)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
            className: "credit-bar !tww-min-h-[8px]",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
              className: "credit-bar-inner !tww-min-h-[8px]",
              style: {
                width: "".concat(personalityBarProgress, "%")
              }
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "f-12-400 !tww-mt-3 !tww-text-gray-400",
          children: ["Free Credits reset in ", (0,_utils_calculateCreditRenewDays__WEBPACK_IMPORTED_MODULE_15__.calculateDaysLeft)(credits === null || credits === void 0 || (_credits$free2 = credits.free) === null || _credits$free2 === void 0 ? void 0 : _credits$free2.expiry), ' ', "days"]
        })]
      }), (settingData === null || settingData === void 0 ? void 0 : settingData.companyAnalyzer) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.Fragment, {
        children: [loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_loading__WEBPACK_IMPORTED_MODULE_13__["default"], {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "credit-info !tww-mt-9",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
            className: "!tww-flex !tww-justify-between",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
              className: "f-16-500 !tww-tracking-tight",
              children: "Company Credits used"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
              className: "f-12-500",
              children: "".concat((credits === null || credits === void 0 ? void 0 : credits.totalCompany) - (credits === null || credits === void 0 ? void 0 : credits.remainingCompany), "/").concat(credits === null || credits === void 0 ? void 0 : credits.totalCompany)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
            className: "credit-bar !tww-min-h-[8px]",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
              className: "credit-bar-inner !tww-min-h-[8px]",
              style: {
                width: "".concat(companyBarProgress, "%")
              }
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "f-12-400 !tww-mt-3 !tww-text-gray-400",
          children: ["Free Credits reset in ", (0,_utils_calculateCreditRenewDays__WEBPACK_IMPORTED_MODULE_15__.calculateDaysLeft)(credits === null || credits === void 0 || (_credits$free3 = credits.free) === null || _credits$free3 === void 0 ? void 0 : _credits$free3.expiry), ' ', "days"]
        })]
      })]
    }), (settingData === null || settingData === void 0 ? void 0 : settingData.companyAnalyzer) && (settingData === null || settingData === void 0 ? void 0 : settingData.companyAnalyzerExtension) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
      className: "!tww-mt-10 setting-container !tww-p-7",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
        className: "!tww-text-gray-500 f-14-500 !tww-mx-2",
        children: "Extension Settings"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-gap-5 !tww-mt-8",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_bulb_svg__WEBPACK_IMPORTED_MODULE_10___default()),
          alt: "",
          className: "!tww-mr-3"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
          className: "!tww-flex !tww-items-center !tww-gap-2 !tww-mr-4",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
            className: "!tww-m-0 !tww-text-gray-700 f-15-400",
            children: "Company Analyzer"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_19__["default"], {
            tooltipText: "Use our extension to Analyse any website",
            customClass: "!tww-text-nowrap !tww-ml-[-70px]",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
              src: (_public_assets_information_svg__WEBPACK_IMPORTED_MODULE_12___default()),
              className: "!tww-ml-2 img-fluid",
              width: 20
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("label", {
          className: "switch !tww-m-0 !tww-flex !tww-justify-center !tww-items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("input", {
            type: "checkbox",
            checked: isWebsiteAnalyzer,
            onChange: handleWebsiteToggleChange
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
            className: "slider round ".concat(isWebsiteAnalyzer ? '' : '!tww-bg-gray-600')
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
      className: "!tww-mt-10 setting-container",
      children: (_ref = [{
        icon: (_public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
        label: 'AI Setting',
        path: 'ai-personality/personality-dashboard'
      }, {
        icon: (_public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
        label: 'Account Settings',
        path: 'account/edit-profile'
      }, {
        icon: (_public_assets_dashboard_icon_svg__WEBPACK_IMPORTED_MODULE_8___default()),
        label: 'Dashboard',
        path: ''
      }, {
        icon: (_public_assets_add_folder_svg__WEBPACK_IMPORTED_MODULE_6___default()),
        label: 'Current Work Folder',
        path: 'contacts-manager'
      }, {
        icon: (_public_assets_team_icon_svg__WEBPACK_IMPORTED_MODULE_7___default()),
        label: 'Teams',
        path: 'invite-team'
      }, {
        icon: (_public_assets_wallet_icon_svg__WEBPACK_IMPORTED_MODULE_9___default()),
        label: 'Subscription & Billing',
        path: 'subscriptions/new'
      }]) === null || _ref === void 0 ? void 0 : _ref.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("button", {
        className: "!tww-relative !tww-flex !tww-w-full !tww-items-center !tww-px-4 !tww-py-2 !tww-transition !tww-duration-200 !tww-rounded-lg menu-item hover:!tww-bg-gray-100",
        role: "button",
        onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_14__.navigateToPortal)(item.path, userInfo === null || userInfo === void 0 ? void 0 : userInfo.environment),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: item.icon,
          alt: "",
          className: "!tww-mr-7"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
          className: "!tww-text-gray-700 f-15-400",
          children: item.label
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11___default()),
          alt: "Go to Folder",
          className: "!tww-absolute !tww-right-0"
        })]
      }, index))
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
      className: "!tww-mt-10 setting-container !tww-py-7 !tww-mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
        className: "!tww-text-gray-500 f-14-500 !tww-mx-4",
        children: "Get Free Credit"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("button", {
        className: "!tww-mt-4 !tww-relative !tww-flex !tww-w-full !tww-items-center !tww-px-4 !tww-py-2 !tww-transition !tww-duration-200 !tww-rounded-lg menu-item hover:!tww-bg-gray-100",
        role: "button",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
          alt: "",
          className: "!tww-mr-7"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
          className: "!tww-text-gray-700 f-15-400",
          children: "Join Eazy Community"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11___default()),
          alt: "Go to Folder",
          className: "!tww-absolute !tww-right-0"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("button", {
        className: "!tww-relative !tww-flex !tww-w-full !tww-items-center !tww-px-4 !tww-py-2 !tww-transition !tww-duration-200 !tww-rounded-lg menu-item hover:!tww-bg-gray-100",
        role: "button",
        onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_14__.navigateToPortal)('dashboard/referral-management', userInfo === null || userInfo === void 0 ? void 0 : userInfo.environment),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_settings_icon_svg__WEBPACK_IMPORTED_MODULE_5___default()),
          alt: "",
          className: "!tww-mr-7"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
          className: "!tww-text-gray-700 f-15-400",
          children: "Invite Friends"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("img", {
          src: (_public_assets_goToFolder_svg__WEBPACK_IMPORTED_MODULE_11___default()),
          alt: "Go to Folder",
          className: "!tww-absolute !tww-right-0"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("button", {
        type: "button",
        className: "!tww-mx-4 !tww-mt-2 focus:!tww-outline-none !tww-text-white !tww-bg-red-700 hover:!tww-bg-red-800 focus:!tww-ring-4 focus:!tww-ring-red-300 !tww-font-medium !tww-rounded-lg f-12-500 !tww-px-8 !tww-py-2.5 !tww-mb-2",
        onClick: handleLogout,
        children: "Logout"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
      className: "!tww-mt-3 setting-container !tww-py-7 !tww-mb-6",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
        className: "!tww-flex !tww-items-center !tww-justify-between",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
          className: "!tww-text-gray-500 f-14-500 !tww-mx-4",
          children: "Extension Version"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
          className: "!tww-text-gray-500 f-14-500 !tww-mx-4",
          children: version
        })]
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Setting);

/***/ }),

/***/ "./src/component/tabs/index.js":
/*!*************************************!*\
  !*** ./src/component/tabs/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _common_customTooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/customTooltip */ "./src/component/common/customTooltip/index.js");
/* harmony import */ var _config_routes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../config/routes */ "./src/config/routes.js");
/* harmony import */ var _config_apiHook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config/apiHook */ "./src/config/apiHook.js");
/* harmony import */ var _common_apiContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/apiContext */ "./src/component/common/apiContext/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");










const Tabs = _ref => {
  var _userData$leadId;
  let {
    isBulk
  } = _ref;
  const makeRequest = (0,_config_apiHook__WEBPACK_IMPORTED_MODULE_6__.useApiRequest)();
  const [isPersonalityActive, setIsPersonalityActive] = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilState)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.isPersonalityActiveState);
  const personalityData = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.personalityReportState);
  const userData = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.indvitualUserState);
  const contact = (_userData$leadId = userData === null || userData === void 0 ? void 0 : userData.leadId) !== null && _userData$leadId !== void 0 ? _userData$leadId : userData;
  const {
    team
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_2__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.tokenState);
  const [fetchPersonality, setFetchPersonality] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const {
    settingData
  } = (0,_common_apiContext__WEBPACK_IMPORTED_MODULE_7__.useApiHost)();
  const routes = [{
    path: '/',
    text: 'Prospect',
    disabled: false
  }];
  if (settingData !== null && settingData !== void 0 && settingData.aiPersonality) {
    routes.push({
      path: '/personality',
      text: 'Personality',
      disabled: !isPersonalityActive || isBulk
    }, {
      path: '/ai-engage',
      text: 'AI Reachout',
      disabled: !isPersonalityActive || isBulk || !(personalityData !== null && personalityData !== void 0 && personalityData.oceanData) && !fetchPersonality
    });
  }
  const checkPersonalityStatus = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async () => {
    try {
      var _contact$linkedIn;
      const {
        data
      } = await makeRequest("".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityStatus, "?teamId=").concat(team === null || team === void 0 ? void 0 : team._id, "&linkedinUrl=").concat(contact === null || contact === void 0 || (_contact$linkedIn = contact.linkedIn) === null || _contact$linkedIn === void 0 ? void 0 : _contact$linkedIn.url), 'GET');
      setFetchPersonality(data === null || data === void 0 ? void 0 : data.personalityGenerated);
    } catch (error) {
      var _contact$linkedIn2;
      await makeRequest('/ErrorLog', 'POST', {
        message: (error === null || error === void 0 ? void 0 : error.message) || String(error) || 'An unknown error occurred',
        stack: "Error with ".concat(_config_routes__WEBPACK_IMPORTED_MODULE_5__.personalityStatus, "?teamId=").concat(team === null || team === void 0 ? void 0 : team._id, "&linkedinUrl=").concat(contact === null || contact === void 0 || (_contact$linkedIn2 = contact.linkedIn) === null || _contact$linkedIn2 === void 0 ? void 0 : _contact$linkedIn2.url, " GET API in tabs.js file"),
        source: 'extension',
        module: 'Personality'
      });
    }
  }, [team, contact]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkPersonalityStatus();
  }, [checkPersonalityStatus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "containerNav",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "buttonNav",
      children: routes === null || routes === void 0 ? void 0 : routes.map(route => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_9__.NavLink, {
        to: route.path,
        className: _ref2 => {
          let {
            isActive
          } = _ref2;
          return "navButton ".concat(isActive ? 'navButton-active' : '', " ").concat(route.disabled ? 'navButton-disabled' : '');
        },
        onClick: e => route.disabled && e.preventDefault() // Prevent click if disabled
        ,
        children: _ref3 => {
          let {
            isActive
          } = _ref3;
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
            style: {
              color: '#212529',
              textDecoration: 'none'
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_common_customTooltip__WEBPACK_IMPORTED_MODULE_4__["default"], {
              tooltipText: route.disabled ? route.text === 'AI Reachout' ? isBulk ? 'Personality works only for Individual Prospects' : isPersonalityActive ? "Generate Prospect's personality to access their AI Reachout" : "Reveal the Prospect's Contact to access their AI ReachOut" : isBulk ? 'AI Reachout works only for Individual Prospects' : "Reveal the Prospect's Contact to access their Personality" : undefined,
              children: route.text
            })
          });
        }
      }, route.path))
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tabs);

/***/ }),

/***/ "./src/component/termsAndConditions/index.js":
/*!***************************************************!*\
  !*** ./src/component/termsAndConditions/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var react_icons_fa6__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-icons/fa6 */ "./node_modules/react-icons/fa6/index.mjs");
/* harmony import */ var _utils_getStoragevalue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/getStoragevalue */ "./src/utils/getStoragevalue.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../recoil/state */ "./src/recoil/state/index.js");
/* harmony import */ var _utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/navigationToPortal */ "./src/utils/navigationToPortal.js");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../public/assets/logo-main.svg */ "./public/assets/logo-main.svg");
/* harmony import */ var _public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../public/assets/minimize.svg */ "./public/assets/minimize.svg");
/* harmony import */ var _public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");











const TermsAndConditions = () => {
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_8__.useNavigate)();
  const [checked, setChecked] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const {
    environment
  } = (0,recoil__WEBPACK_IMPORTED_MODULE_1__.useRecoilValue)(_recoil_state__WEBPACK_IMPORTED_MODULE_3__.tokenState);
  const handleAccept = () => {
    (0,_utils_getStoragevalue__WEBPACK_IMPORTED_MODULE_2__.setStorageValue)("needsTermsAcceptance", false);
    navigate("/");
  };
  const handleMinimize = () => {
    const message = {
      type: "MINIMIZE"
    };
    chrome.runtime.sendMessage(message, () => {});
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "!tww-flex !tww-flex-col !tww-h-full !tww-overflow-y-scroll custom-scrollbar2",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("nav", {
      className: "navbar",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "navbar-logo",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
          src: (_public_assets_logo_main_svg__WEBPACK_IMPORTED_MODULE_5___default()),
          alt: "EazyConnections Logo"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("span", {
          style: {
            fontSize: "16px"
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("strong", {
            children: "Eazy"
          }), "Connections"]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "!tww-flex !tww-items-center navbar-icons",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
          src: (_public_assets_minimize_svg__WEBPACK_IMPORTED_MODULE_6___default()),
          alt: "minimize",
          style: {
            width: "20px",
            height: "20px"
          },
          role: "button",
          onClick: handleMinimize
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "!tww-px-8 !tww-pb-10",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("h1", {
        className: "!tww-mt-8 !tww-mb-6 !tww-text-3xl !tww-font-semibold !tww-text-gray-600 !tww-text-[26px]",
        children: "Before we get started"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("p", {
        children: ["Our extension provides you with enriched business profile information. In order to provide you this service and search relevant information with applicable profiles you view, we need to read certain words (seahc as full name, position, company name) from such such sites when you use our service.", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("br", {}), "For more information, please visit our terms and conditions and privacy policy."]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "!tww-flex !tww-gap-5 !tww-items-start !tww-mt-8 !tww-text-start",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("button", {
          className: "mycheckbox !tww-border !tww-mt-6 !tww-rounded-lg p-2 ".concat(checked ? "!tww-bg-[#7B5DE9] !tww-border-[#7B5DE9]" : "!tww-bg-white !tww-border-gray-400"),
          onClick: () => setChecked(!checked),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_icons_fa6__WEBPACK_IMPORTED_MODULE_9__.FaCheck, {
            size: 18,
            className: "!tww-text-white ".concat(checked ? "!tww-opacity-100" : "!tww-opacity-20")
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("label", {
          htmlFor: "termsAndConditions",
          className: "",
          children: ["I accept the", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
            className: "!tww-text-[#7B5DE9]",
            role: "button",
            onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_4__.navigateToWebsite)("legal/terms", environment),
            children: "Terms and Conditions"
          }), " ", "and", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
            className: "!tww-text-[#7B5DE9]",
            role: "button",
            onClick: () => (0,_utils_navigationToPortal__WEBPACK_IMPORTED_MODULE_4__.navigateToWebsite)("legal/privacy-policy", environment),
            children: "Privacy Policy"
          }), "."]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("button", {
        onClick: handleAccept,
        className: "!tww-bg-[#7B5DE9]  ".concat(checked ? "hover:!tww-bg-[#6e4de9]" : "!tww-opacity-50", " !tww-text-white !tww-mt-6 !tww-w-full !tww-p-2 !tww-rounded-md !tww-flex !tww-justify-center !tww-items-center f-20-500"),
        disabled: !checked,
        children: "Got it, let's go"
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TermsAndConditions);

/***/ }),

/***/ "./src/component/wrongPage/index.js":
/*!******************************************!*\
  !*** ./src/component/wrongPage/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_lottie__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-lottie */ "./node_modules/react-lottie/dist/index.js");
/* harmony import */ var _App_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../App.css */ "./src/App.css");
/* harmony import */ var _animationJson_no_data_found_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../animationJson/no-data-found.json */ "./src/animationJson/no-data-found.json");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const WrongPage = () => {
  const defaultOptions = {
    loop: true,
    autoplay: true,
    animationData: _animationJson_no_data_found_json__WEBPACK_IMPORTED_MODULE_3__,
    rendererSettings: {
      preserveAspectRatio: "xMidYMid slice"
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "wrongPage-container",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_lottie__WEBPACK_IMPORTED_MODULE_1__["default"], {
      options: defaultOptions,
      height: 124,
      width: 124
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "!tww-mt-2 f-26",
      style: {
        maxWidth: "65%"
      },
      children: "Try navigating to a Search or Profile page"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "!tww-mt-2 f-15-lightGrey",
      style: {
        maxWidth: "70%"
      },
      children: "You can find contact info, save to your CRM, and send emails & track when they are read"
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WrongPage);

/***/ }),

/***/ "./src/config/apiHook.js":
/*!*******************************!*\
  !*** ./src/config/apiHook.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useApiRequest: () => (/* binding */ useApiRequest)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _middleware_fetch_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../middleware/fetch-api */ "./src/middleware/fetch-api/index.js");
/* harmony import */ var _component_common_apiContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../component/common/apiContext */ "./src/component/common/apiContext/index.js");



function useApiRequest() {
  const {
    host
  } = (0,_component_common_apiContext__WEBPACK_IMPORTED_MODULE_2__.useApiHost)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(async (endpoint, method, data) => {
    if (!host) {
      throw new Error("API host not initialized.");
    }
    const url = "".concat(host).concat(endpoint);
    return (0,_middleware_fetch_api__WEBPACK_IMPORTED_MODULE_1__.makeRequest)(url, method, data);
  }, [host]);
}

/***/ }),

/***/ "./src/config/routes.js":
/*!******************************!*\
  !*** ./src/config/routes.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tags: () => (/* binding */ Tags),
/* harmony export */   aiSetting: () => (/* binding */ aiSetting),
/* harmony export */   companyURL: () => (/* binding */ companyURL),
/* harmony export */   contacts: () => (/* binding */ contacts),
/* harmony export */   credit: () => (/* binding */ credit),
/* harmony export */   folder: () => (/* binding */ folder),
/* harmony export */   personality: () => (/* binding */ personality),
/* harmony export */   personalityCallScript: () => (/* binding */ personalityCallScript),
/* harmony export */   personalityCompany: () => (/* binding */ personalityCompany),
/* harmony export */   personalityEmail: () => (/* binding */ personalityEmail),
/* harmony export */   personalityHrReport: () => (/* binding */ personalityHrReport),
/* harmony export */   personalityIceBreaker: () => (/* binding */ personalityIceBreaker),
/* harmony export */   personalityInsight: () => (/* binding */ personalityInsight),
/* harmony export */   personalityLinkedIn: () => (/* binding */ personalityLinkedIn),
/* harmony export */   personalityLinkedInUpdate: () => (/* binding */ personalityLinkedInUpdate),
/* harmony export */   personalitySalesReport: () => (/* binding */ personalitySalesReport),
/* harmony export */   personalityStatus: () => (/* binding */ personalityStatus),
/* harmony export */   plan: () => (/* binding */ plan),
/* harmony export */   setting: () => (/* binding */ setting),
/* harmony export */   valuePropositions: () => (/* binding */ valuePropositions)
/* harmony export */ });
const credit = "/credit";
const folder = "/folder";
const plan = "/plan";
const contacts = "/contacts";
const Tags = "/tag";
const personality = "/reports";
const personalityStatus = "".concat(personality, "/check_personality_status");
const personalityHrReport = "".concat(personality, "/hr_pers_report");
const personalitySalesReport = "".concat(personality, "/sales_pers_report");
const personalityEmail = "".concat(personality, "/email_Report");
const personalityIceBreaker = "".concat(personality, "/icebreaker_Report");
const personalityLinkedIn = "".concat(personality, "/linkedin_Report");
const personalityLinkedInUpdate = "".concat(personality, "/linkedin_Report_update");
const personalityCompany = "".concat(personality, "/company_Report");
const personalityInsight = "".concat(personality, "/linkedInInsight_Report");
const personalityCallScript = "".concat(personality, "/callscript_Report");
const aiSetting = "/aiSetting";
const valuePropositions = "/value-propositions";
const companyURL = "/company";
const setting = "/settings";

/***/ }),

/***/ "./src/dummyJson/companyDummy.js":
/*!***************************************!*\
  !*** ./src/dummyJson/companyDummy.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const response = {
  company: {
    _id: "66e0510a32eb8cda62979529",
    name: "EdgeFirm",
    details: "1-10",
    industry: "Computer Software",
    website: "https://edgefirm.io",
    linkedin: "https://www.linkedin.com/company/edgefirm",
    location: "London, (England, Europe), United Kingdom GB",
    foundedYear: "2023",
    image: "https://ez-staging.s3.ap-south-1.amazonaws.com/image_1736348046730_compressed.jpg"
  },
  websiteData: {
    _id: "677d3273c0e8d5a2ae649419",
    url: "http://edgefirm.io",
    links: ["http://edgefirm.io/", "http://edgefirm.io/about-us", "http://edgefirm.io/services", "http://edgefirm.io/blog", "http://edgefirm.io/contact-us", "http://edgefirm.io/services/ai-ml", "http://edgefirm.io/services/web3", "http://edgefirm.io/services/digital-marketing", "http://edgefirm.io/services/website-development", "http://edgefirm.io/services/ui-ux", "http://edgefirm.io/blog/supercharging-language-models", "http://edgefirm.io/blog/developing-a-supercharged-blockchain-infrastructure-to-support-ecommerce-and-dApps", "http://edgefirm.io/blog/the-outcome-of-a-robust-digital-marketing-strategy", "http://edgefirm.io/terms-and-use", "http://edgefirm.io/privacy-policy", "http://edgefirm.io/#", "https://pk.linkedin.com/company/edgefirm", "mailto:hello@edgefirm.io", "tel:+16309315590"],
    socialAccounts: ["https://pk.linkedin.com/company/edgefirm"],
    contactInfo: {
      emails: [{
        email: "hello@edgefirm.io",
        sources: [],
        _id: "677d3273c0e8d5a2ae64941b"
      }, {
        email: "hello@edgefirm.io",
        sources: [],
        _id: "677d3273c0e8d5a2ae64941c"
      }],
      phones: [{
        phone: "+1 630 931 5590",
        country: "US",
        sources: [],
        _id: "677d3273c0e8d5a2ae64941d"
      }, {
        phone: "+1 630 931 5590",
        country: "US",
        sources: [],
        _id: "677d3273c0e8d5a2ae64941e"
      }],
      _id: "677d3273c0e8d5a2ae64941a"
    },
    technologies: ["expertise in ai", "blockchain", "digital marketing", "website development", "ui/ux design", "web3", "artificial intelligence", "machine learning", "large language models", "gpt", "data extraction", "software development", "dapps", "decentralization", "digital media marketing", "social media management"],
    __v: 0
  },
  currentEmployees: [{
    _id: "663bf2a89d76dc9619364040",
    firstName: "Nawal",
    lastName: "Irfan",
    image: "https://ez-staging.s3.ap-south-1.amazonaws.com/image_1715204776308.jpeg",
    industry: "government relations",
    tagline: "i dont have a tagline bro",
    location: "Pakistan PK",
    linkedin: {
      url: "https://pk.linkedin.com/in/nawalirfan"
    }
  }, {
    _id: "66e16b5aeb0c7f1353e2e897",
    firstName: "Vitor",
    lastName: "Guerreiro",
    tagline: "Full Stack Software Developer | BSCS- IBA'24",
    location: "Pakistan PK",
    image: "https://ez-staging.s3.ap-south-1.amazonaws.com/image_1731768423309_compressed.jpg",
    industry: "Computer Software",
    linkedin: {
      url: "https://pk.linkedin.com/in/nawalirfan"
    }
  }],
  pastEmployees: [{
    _id: "66e16b5aeb0c7f1353kdn897",
    firstName: "Khuzema",
    lastName: "Imran",
    tagline: "Full Stack Software Developer | BSCS- IBA'24",
    location: "Pakistan PK",
    image: "https://ez-staging.s3.ap-south-1.amazonaws.com/image_1730911046537_compressed.jpg",
    industry: "Computer Software",
    linkedin: {
      url: "https://pk.linkedin.com/in/nawalirfan"
    }
  }]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (response);

/***/ }),

/***/ "./src/middleware/fetch-api/index.js":
/*!*******************************************!*\
  !*** ./src/middleware/fetch-api/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeRequest: () => (/* binding */ makeRequest)
/* harmony export */ });
const makeRequest = async function () {
  let url = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  let method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GET';
  let data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const getUserInfo = () => {
    return new Promise((resolve, reject) => {
      chrome.storage.local.get('userInfo', result => {
        if (result.hasOwnProperty('userInfo')) {
          resolve(result.userInfo);
        } else {
          reject('No userInfo found');
        }
      });
    });
  };
  const getPublicIp = () => {
    return new Promise((resolve, reject) => {
      chrome.storage.local.get('ipAddress', async result => {
        if (result.ipAddress) {
          resolve(result.ipAddress);
        } else {
          try {
            const res = await fetch('https://api.ipify.org?format=json');
            const {
              ip
            } = await res.json();
            chrome.storage.local.set({
              ipAddress: ip
            });
            resolve(ip);
          } catch (err) {
            reject(err);
          }
        }
      });
    });
  };
  const ipAddress = await getPublicIp();
  try {
    const userInfo = await getUserInfo();
    const token = userInfo.accessToken;
    // const ipAddress = userInfo.ipAddress

    const options = {
      method,
      headers: {
        'Content-Type': 'application/json',
        Authorization: "Bearer ".concat(token),
        'X-Forwarded-For': ipAddress
      },
      body: data ? JSON.stringify(data) : null
    };
    const response = await fetch(url, options);
    let responseData = null;
    const text = await response.text();
    if (text) {
      try {
        responseData = JSON.parse(text);
      } catch (err) {
        throw new Error("Invalid JSON response: ".concat(text));
      }
    }
    if (!response.ok) {
      var _responseData;
      const errorMessage = ((_responseData = responseData) === null || _responseData === void 0 ? void 0 : _responseData.message) || response.statusText;
      throw new Error(errorMessage);
    }
    return {
      data: responseData,
      headers: response.headers
    };
  } catch (error) {
    throw error;
  }
};

/***/ }),

/***/ "./src/recoil/state/index.js":
/*!***********************************!*\
  !*** ./src/recoil/state/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aiSettingState: () => (/* binding */ aiSettingState),
/* harmony export */   companySearchDataState: () => (/* binding */ companySearchDataState),
/* harmony export */   companySearchLoaderState: () => (/* binding */ companySearchLoaderState),
/* harmony export */   companyUrlState: () => (/* binding */ companyUrlState),
/* harmony export */   creditState: () => (/* binding */ creditState),
/* harmony export */   fetchedUsersState: () => (/* binding */ fetchedUsersState),
/* harmony export */   indvitualUserState: () => (/* binding */ indvitualUserState),
/* harmony export */   isBizAnalyzerOnWebsiteState: () => (/* binding */ isBizAnalyzerOnWebsiteState),
/* harmony export */   isPersonalityActiveState: () => (/* binding */ isPersonalityActiveState),
/* harmony export */   isPersonalityToggledState: () => (/* binding */ isPersonalityToggledState),
/* harmony export */   isUpdatedState: () => (/* binding */ isUpdatedState),
/* harmony export */   openAnalysisState: () => (/* binding */ openAnalysisState),
/* harmony export */   personalityReportState: () => (/* binding */ personalityReportState),
/* harmony export */   reportPayloadState: () => (/* binding */ reportPayloadState),
/* harmony export */   scrapeUsersState: () => (/* binding */ scrapeUsersState),
/* harmony export */   selectedFolderState: () => (/* binding */ selectedFolderState),
/* harmony export */   selectedTagsState: () => (/* binding */ selectedTagsState),
/* harmony export */   settingState: () => (/* binding */ settingState),
/* harmony export */   tokenState: () => (/* binding */ tokenState)
/* harmony export */ });
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");

const tokenState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'tokenState',
  default: {}
});
const settingState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'settingState',
  default: {}
});
const creditState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'creditState',
  default: {}
});
const selectedFolderState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'selectedFolderState',
  default: {
    id: '',
    name: '',
    color: ''
  }
});
const selectedTagsState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'selectedTagsState',
  default: []
});
const fetchedUsersState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'fetchedUsersState',
  default: []
});
const scrapeUsersState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'scrapeUsersState',
  default: []
});
const isUpdatedState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'isUpdated',
  default: false
});
const indvitualUserState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'indvitualUserState',
  default: []
});
const personalityReportState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'personalityReportState',
  default: {}
});
const reportPayloadState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'reportPayloadState',
  default: {}
});
const isPersonalityToggledState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'isPersonalityToggledState',
  default: false
});
const openAnalysisState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'openAnalysisState',
  default: true
});
const aiSettingState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'aiSettingState',
  default: {}
});
const isPersonalityActiveState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'isPersonalityActiveState',
  default: false
});
const isBizAnalyzerOnWebsiteState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'isBizAnalyzerOnWebsiteState',
  default: false
});
const companySearchDataState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'companySearchDataState',
  default: {}
});
const companySearchLoaderState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'companySearchLoaderState',
  default: false
});
const companyUrlState = (0,recoil__WEBPACK_IMPORTED_MODULE_0__.atom)({
  key: 'companyUrlState',
  default: ''
});

/***/ }),

/***/ "./src/utils/calculateCreditRenewDays.js":
/*!***********************************************!*\
  !*** ./src/utils/calculateCreditRenewDays.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDaysLeft: () => (/* binding */ calculateDaysLeft)
/* harmony export */ });
const calculateDaysLeft = expiryInMillis => {
  const now = Date.now();
  const timeLeft = expiryInMillis - now;
  if (timeLeft <= 0) {
    return 0;
  }
  return Math.floor(timeLeft / (1000 * 60 * 60 * 24));
};

/***/ }),

/***/ "./src/utils/copyTextToClipboard.js":
/*!******************************************!*\
  !*** ./src/utils/copyTextToClipboard.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   copyTextToClipboard: () => (/* binding */ copyTextToClipboard)
/* harmony export */ });
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-hot-toast */ "./node_modules/react-hot-toast/dist/index.mjs");

const copyTextToClipboard = copiedText => {
  if (!("clipboard" in navigator)) {
    return;
  }
  navigator.clipboard.writeText(copiedText);
  react_hot_toast__WEBPACK_IMPORTED_MODULE_0__.toast.success("Copied to clipboard");
  return navigator.clipboard.writeText(copiedText);
};

/***/ }),

/***/ "./src/utils/formatLinkedinUrl.js":
/*!****************************************!*\
  !*** ./src/utils/formatLinkedinUrl.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatLinkedInURL: () => (/* binding */ formatLinkedInURL)
/* harmony export */ });
const formatLinkedInURL = url => {
  if (url.startsWith("https://www.")) {
    url = url.slice(12);
  }
  if (url.endsWith("/")) {
    url = url.slice(0, -1);
  }
  return url.split("?")[0];
};

/***/ }),

/***/ "./src/utils/getDateFromMonthYear.js":
/*!*******************************************!*\
  !*** ./src/utils/getDateFromMonthYear.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDateWithDefault: () => (/* binding */ getDateWithDefault)
/* harmony export */ });
function getDateWithDefault(itemDate) {
  if (!(itemDate !== null && itemDate !== void 0 && itemDate.year)) {
    return null;
  }
  const year = itemDate === null || itemDate === void 0 ? void 0 : itemDate.year;
  const month = (itemDate === null || itemDate === void 0 ? void 0 : itemDate.month) != null ? itemDate.month - 1 : 0; // Default to January if month is missing
  return new Date(year, month).getTime();
}

/***/ }),

/***/ "./src/utils/getLinkedInUsername.js":
/*!******************************************!*\
  !*** ./src/utils/getLinkedInUsername.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLinkedInProfileId: () => (/* binding */ getLinkedInProfileId)
/* harmony export */ });
function getLinkedInProfileId(url) {
  const pattern = /linkedin\.com\/in\/([^\/]+)/;
  const match = url.match(pattern);
  return match ? match[1] : null;
}

/***/ }),

/***/ "./src/utils/getStoragevalue.js":
/*!**************************************!*\
  !*** ./src/utils/getStoragevalue.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorageValue: () => (/* binding */ getStorageValue),
/* harmony export */   setStorageValue: () => (/* binding */ setStorageValue)
/* harmony export */ });
function getStorageValue(key) {
  return new Promise(resolve => {
    chrome.storage.local.get(key, result => {
      resolve(result[key]);
    });
  });
}
function setStorageValue(key, value) {
  return new Promise(resolve => {
    chrome.storage.local.set({
      [key]: value
    }, () => {
      resolve();
    });
  });
}

/***/ }),

/***/ "./src/utils/handleStatechange.js":
/*!****************************************!*\
  !*** ./src/utils/handleStatechange.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleStateChange: () => (/* binding */ handleStateChange)
/* harmony export */ });
const handleStateChange = function (data, response) {
  let singleUpdate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const updatedData = data === null || data === void 0 ? void 0 : data.map(user => {
    var _user$lead$linkedIn$u, _user$lead, _user$contact, _response$contacts;
    const dataLinkedInUrl = (_user$lead$linkedIn$u = user === null || user === void 0 || (_user$lead = user.lead) === null || _user$lead === void 0 || (_user$lead = _user$lead.linkedIn) === null || _user$lead === void 0 ? void 0 : _user$lead.url) !== null && _user$lead$linkedIn$u !== void 0 ? _user$lead$linkedIn$u : user === null || user === void 0 || (_user$contact = user.contact) === null || _user$contact === void 0 || (_user$contact = _user$contact.leadId) === null || _user$contact === void 0 || (_user$contact = _user$contact.linkedIn) === null || _user$contact === void 0 ? void 0 : _user$contact.url;
    const responseUser = response === null || response === void 0 || (_response$contacts = response.contacts) === null || _response$contacts === void 0 ? void 0 : _response$contacts.find(user => {
      var _user$leadId$linkedIn, _user$leadId, _user$contact2;
      const responseLinkedInUrl = (_user$leadId$linkedIn = user === null || user === void 0 || (_user$leadId = user.leadId) === null || _user$leadId === void 0 || (_user$leadId = _user$leadId.linkedIn) === null || _user$leadId === void 0 ? void 0 : _user$leadId.url) !== null && _user$leadId$linkedIn !== void 0 ? _user$leadId$linkedIn : user === null || user === void 0 || (_user$contact2 = user.contact) === null || _user$contact2 === void 0 || (_user$contact2 = _user$contact2.leadId) === null || _user$contact2 === void 0 || (_user$contact2 = _user$contact2.linkedIn) === null || _user$contact2 === void 0 ? void 0 : _user$contact2.url;
      return responseLinkedInUrl === dataLinkedInUrl;
    });
    if (responseUser) {
      return {
        ...user,
        contact: singleUpdate ? responseUser.contact : responseUser,
        isContact: true
      };
    }
    return user;
  });
  return updatedData;
};

/***/ }),

/***/ "./src/utils/isBizAnalyzerOnWebsiteState.js":
/*!**************************************************!*\
  !*** ./src/utils/isBizAnalyzerOnWebsiteState.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   updateIsBizAnalyzerOnWebsite: () => (/* binding */ updateIsBizAnalyzerOnWebsite)
/* harmony export */ });
/* harmony import */ var recoil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! recoil */ "./node_modules/recoil/es/index.js");
/* harmony import */ var _recoil_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../recoil/state */ "./src/recoil/state/index.js");



// Helper to update recoil state without using hooks
const updateIsBizAnalyzerOnWebsite = newValue => {
  (0,recoil__WEBPACK_IMPORTED_MODULE_0__.snapshot_UNSTABLE)(_ref => {
    let {
      set
    } = _ref;
    return set(_recoil_state__WEBPACK_IMPORTED_MODULE_1__.isBizAnalyzerOnWebsiteState, newValue);
  });
};

/***/ }),

/***/ "./src/utils/isPlaceholderImage.js":
/*!*****************************************!*\
  !*** ./src/utils/isPlaceholderImage.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isPlaceholderImage: () => (/* binding */ isPlaceholderImage)
/* harmony export */ });
const isPlaceholderImage = url => {
  const placeholderGif = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
  return (url === null || url === void 0 ? void 0 : url.startsWith("data:")) || url === placeholderGif;
};

/***/ }),

/***/ "./src/utils/navigationToPortal.js":
/*!*****************************************!*\
  !*** ./src/utils/navigationToPortal.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   navigateToPortal: () => (/* binding */ navigateToPortal),
/* harmony export */   navigateToWebsite: () => (/* binding */ navigateToWebsite)
/* harmony export */ });
const navigateToPortal = (route, env) => {
  let config = 'app';
  if (env === 'development') config = 'dev';else if (env === 'staging') config = 'staging';
  chrome.runtime.sendMessage({
    action: 'openTab',
    url: "https://".concat(config, ".eazyconnections.ai/dashboard/").concat(route)
  });
};
const navigateToWebsite = (route, env) => {
  let config = 'www';
  if (env === 'development') config = 'webdev';else if (env === 'staging') config = 'webstaging';
  chrome.runtime.sendMessage({
    action: 'openTab',
    url: "https://".concat(config, ".eazyconnections.ai/").concat(route)
  });
};

/***/ }),

/***/ "./src/utils/personImage.js":
/*!**********************************!*\
  !*** ./src/utils/personImage.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   personImage: () => (/* binding */ personImage)
/* harmony export */ });
const personImage = 'https://static.vecteezy.com/system/resources/thumbnails/003/337/584/small/default-avatar-photo-placeholder-profile-icon-vector.jpg';

/***/ }),

/***/ "./src/utils/userNameFormatter.js":
/*!****************************************!*\
  !*** ./src/utils/userNameFormatter.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   userNameFormatter: () => (/* binding */ userNameFormatter)
/* harmony export */ });
const userNameFormatter = username => {
  const firstName = username === null || username === void 0 ? void 0 : username.split(" ").slice(0, -1).join(" ");
  const lastName = username === null || username === void 0 ? void 0 : username.split(" ").slice(-1).join(" ");
  return {
    firstName,
    lastName
  };
};

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/object/assign.js":
/*!*************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/assign.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/assign */ "./node_modules/core-js/library/fn/object/assign.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/object/create.js":
/*!*************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/create.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/create */ "./node_modules/core-js/library/fn/object/create.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/object/define-property.js":
/*!**********************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/define-property.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/define-property */ "./node_modules/core-js/library/fn/object/define-property.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/object/get-prototype-of.js":
/*!***********************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/get-prototype-of.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/get-prototype-of */ "./node_modules/core-js/library/fn/object/get-prototype-of.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/object/set-prototype-of.js":
/*!***********************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/object/set-prototype-of.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/set-prototype-of */ "./node_modules/core-js/library/fn/object/set-prototype-of.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/symbol.js":
/*!******************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/symbol.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol */ "./node_modules/core-js/library/fn/symbol/index.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/core-js/symbol/iterator.js":
/*!***************************************************************!*\
  !*** ./node_modules/babel-runtime/core-js/symbol/iterator.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol/iterator */ "./node_modules/core-js/library/fn/symbol/iterator.js"), __esModule: true };

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/classCallCheck.js":
/*!**************************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/classCallCheck.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;

exports["default"] = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/createClass.js":
/*!***********************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/createClass.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _defineProperty = __webpack_require__(/*! ../core-js/object/define-property */ "./node_modules/babel-runtime/core-js/object/define-property.js");

var _defineProperty2 = _interopRequireDefault(_defineProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      (0, _defineProperty2.default)(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/extends.js":
/*!*******************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/extends.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _assign = __webpack_require__(/*! ../core-js/object/assign */ "./node_modules/babel-runtime/core-js/object/assign.js");

var _assign2 = _interopRequireDefault(_assign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = _assign2.default || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/inherits.js":
/*!********************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/inherits.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _setPrototypeOf = __webpack_require__(/*! ../core-js/object/set-prototype-of */ "./node_modules/babel-runtime/core-js/object/set-prototype-of.js");

var _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf);

var _create = __webpack_require__(/*! ../core-js/object/create */ "./node_modules/babel-runtime/core-js/object/create.js");

var _create2 = _interopRequireDefault(_create);

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ "./node_modules/babel-runtime/helpers/typeof.js");

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : (0, _typeof3.default)(superClass)));
  }

  subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass;
};

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/possibleConstructorReturn.js":
/*!*************************************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/possibleConstructorReturn.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ "./node_modules/babel-runtime/helpers/typeof.js");

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && ((typeof call === "undefined" ? "undefined" : (0, _typeof3.default)(call)) === "object" || typeof call === "function") ? call : self;
};

/***/ }),

/***/ "./node_modules/babel-runtime/helpers/typeof.js":
/*!******************************************************!*\
  !*** ./node_modules/babel-runtime/helpers/typeof.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(/*! ../core-js/symbol/iterator */ "./node_modules/babel-runtime/core-js/symbol/iterator.js");

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(/*! ../core-js/symbol */ "./node_modules/babel-runtime/core-js/symbol.js");

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),

/***/ "./node_modules/core-js/library/fn/object/assign.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/assign.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.assign */ "./node_modules/core-js/library/modules/es6.object.assign.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object.assign;


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/create.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/create.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.create */ "./node_modules/core-js/library/modules/es6.object.create.js");
var $Object = (__webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object);
module.exports = function create(P, D) {
  return $Object.create(P, D);
};


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/define-property.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/define-property.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.define-property */ "./node_modules/core-js/library/modules/es6.object.define-property.js");
var $Object = (__webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object);
module.exports = function defineProperty(it, key, desc) {
  return $Object.defineProperty(it, key, desc);
};


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/get-prototype-of.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/get-prototype-of.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.get-prototype-of */ "./node_modules/core-js/library/modules/es6.object.get-prototype-of.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object.getPrototypeOf;


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/set-prototype-of.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/set-prototype-of.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.set-prototype-of */ "./node_modules/core-js/library/modules/es6.object.set-prototype-of.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object.setPrototypeOf;


/***/ }),

/***/ "./node_modules/core-js/library/fn/symbol/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/fn/symbol/index.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.symbol */ "./node_modules/core-js/library/modules/es6.symbol.js");
__webpack_require__(/*! ../../modules/es6.object.to-string */ "./node_modules/core-js/library/modules/es6.object.to-string.js");
__webpack_require__(/*! ../../modules/es7.symbol.async-iterator */ "./node_modules/core-js/library/modules/es7.symbol.async-iterator.js");
__webpack_require__(/*! ../../modules/es7.symbol.observable */ "./node_modules/core-js/library/modules/es7.symbol.observable.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Symbol;


/***/ }),

/***/ "./node_modules/core-js/library/fn/symbol/iterator.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/fn/symbol/iterator.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.string.iterator */ "./node_modules/core-js/library/modules/es6.string.iterator.js");
__webpack_require__(/*! ../../modules/web.dom.iterable */ "./node_modules/core-js/library/modules/web.dom.iterable.js");
module.exports = (__webpack_require__(/*! ../../modules/_wks-ext */ "./node_modules/core-js/library/modules/_wks-ext.js").f)('iterator');


/***/ }),

/***/ "./node_modules/core-js/library/modules/_a-function.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_a-function.js ***!
  \*************************************************************/
/***/ ((module) => {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_add-to-unscopables.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_add-to-unscopables.js ***!
  \*********************************************************************/
/***/ ((module) => {

module.exports = function () { /* empty */ };


/***/ }),

/***/ "./node_modules/core-js/library/modules/_an-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_an-object.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-includes.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-includes.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");
var toAbsoluteIndex = __webpack_require__(/*! ./_to-absolute-index */ "./node_modules/core-js/library/modules/_to-absolute-index.js");
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_cof.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_cof.js ***!
  \******************************************************/
/***/ ((module) => {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_core.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_core.js ***!
  \*******************************************************/
/***/ ((module) => {

var core = module.exports = { version: '2.6.12' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),

/***/ "./node_modules/core-js/library/modules/_ctx.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ctx.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// optional / simple context binding
var aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/library/modules/_a-function.js");
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_defined.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_defined.js ***!
  \**********************************************************/
/***/ ((module) => {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_descriptors.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_descriptors.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_dom-create.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_dom-create.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var document = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").document);
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_enum-bug-keys.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_enum-bug-keys.js ***!
  \****************************************************************/
/***/ ((module) => {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),

/***/ "./node_modules/core-js/library/modules/_enum-keys.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_enum-keys.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// all enumerable object keys, includes symbols
var getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");
var gOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/library/modules/_object-gops.js");
var pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/library/modules/_object-pie.js");
module.exports = function (it) {
  var result = getKeys(it);
  var getSymbols = gOPS.f;
  if (getSymbols) {
    var symbols = getSymbols(it);
    var isEnum = pIE.f;
    var i = 0;
    var key;
    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
  } return result;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_export.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_export.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_fails.js":
/*!********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_fails.js ***!
  \********************************************************/
/***/ ((module) => {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_global.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_global.js ***!
  \*********************************************************/
/***/ ((module) => {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),

/***/ "./node_modules/core-js/library/modules/_has.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_has.js ***!
  \******************************************************/
/***/ ((module) => {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_hide.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_hide.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
module.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_html.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_html.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var document = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").document);
module.exports = document && document.documentElement;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_ie8-dom-define.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ie8-dom-define.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") && !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty(__webpack_require__(/*! ./_dom-create */ "./node_modules/core-js/library/modules/_dom-create.js")('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iobject.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iobject.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-array.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-array.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-object.js ***!
  \************************************************************/
/***/ ((module) => {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-create.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-create.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js");
var descriptor = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js")(IteratorPrototype, __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-define.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-define.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var LIBRARY = __webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js");
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/library/modules/_redefine.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var $iterCreate = __webpack_require__(/*! ./_iter-create */ "./node_modules/core-js/library/modules/_iter-create.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ "./node_modules/core-js/library/modules/_object-gpo.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-step.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-step.js ***!
  \************************************************************/
/***/ ((module) => {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iterators.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iterators.js ***!
  \************************************************************/
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_library.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_library.js ***!
  \**********************************************************/
/***/ ((module) => {

module.exports = true;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_meta.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_meta.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var META = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js")('meta');
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var setDesc = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f);
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-assign.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-assign.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// 19.1.2.1 Object.assign(target, source, ...)
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");
var gOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/library/modules/_object-gops.js");
var pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/library/modules/_object-pie.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || isEnum.call(S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-create.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-create.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var dPs = __webpack_require__(/*! ./_object-dps */ "./node_modules/core-js/library/modules/_object-dps.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/library/modules/_enum-bug-keys.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(/*! ./_dom-create */ "./node_modules/core-js/library/modules/_dom-create.js")('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  (__webpack_require__(/*! ./_html */ "./node_modules/core-js/library/modules/_html.js").appendChild)(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-dp.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dp.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "./node_modules/core-js/library/modules/_ie8-dom-define.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/library/modules/_to-primitive.js");
var dP = Object.defineProperty;

exports.f = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-dps.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dps.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");

module.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gopd.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopd.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/library/modules/_object-pie.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/library/modules/_to-primitive.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "./node_modules/core-js/library/modules/_ie8-dom-define.js");
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gopn-ext.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopn-ext.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var gOPN = (__webpack_require__(/*! ./_object-gopn */ "./node_modules/core-js/library/modules/_object-gopn.js").f);
var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN(it);
  } catch (e) {
    return windowNames.slice();
  }
};

module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gopn.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gopn.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ "./node_modules/core-js/library/modules/_object-keys-internal.js");
var hiddenKeys = (__webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/library/modules/_enum-bug-keys.js").concat)('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gops.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gops.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gpo.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gpo.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-keys-internal.js":
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys-internal.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var arrayIndexOf = __webpack_require__(/*! ./_array-includes */ "./node_modules/core-js/library/modules/_array-includes.js")(false);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-keys.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ "./node_modules/core-js/library/modules/_object-keys-internal.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/library/modules/_enum-bug-keys.js");

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-pie.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-pie.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.f = {}.propertyIsEnumerable;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-sap.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-sap.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js");
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_property-desc.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_property-desc.js ***!
  \****************************************************************/
/***/ ((module) => {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_redefine.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_redefine.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-proto.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-proto.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Works with __proto__ only. Old v8 can't work with null proto objects.
/* eslint-disable no-proto */
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var check = function (O, proto) {
  anObject(O);
  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
};
module.exports = {
  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
    function (test, buggy, set) {
      try {
        set = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js")(Function.call, (__webpack_require__(/*! ./_object-gopd */ "./node_modules/core-js/library/modules/_object-gopd.js").f)(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) { buggy = true; }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy) O.__proto__ = proto;
        else set(O, proto);
        return O;
      };
    }({}, false) : undefined),
  check: check
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-to-string-tag.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-to-string-tag.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var def = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f);
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_shared-key.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared-key.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var shared = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/library/modules/_shared.js")('keys');
var uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js");
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_shared.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js") ? 'pure' : 'global',
  copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_string-at.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_string-at.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-absolute-index.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-absolute-index.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-integer.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-integer.js ***!
  \*************************************************************/
/***/ ((module) => {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-iobject.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-iobject.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-length.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-length.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.15 ToLength
var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-object.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-primitive.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-primitive.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_uid.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_uid.js ***!
  \******************************************************/
/***/ ((module) => {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_wks-define.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks-define.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var LIBRARY = __webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js");
var wksExt = __webpack_require__(/*! ./_wks-ext */ "./node_modules/core-js/library/modules/_wks-ext.js");
var defineProperty = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f);
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_wks-ext.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks-ext.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

exports.f = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js");


/***/ }),

/***/ "./node_modules/core-js/library/modules/_wks.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var store = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/library/modules/_shared.js")('wks');
var uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js");
var Symbol = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").Symbol);
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.iterator.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.iterator.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var addToUnscopables = __webpack_require__(/*! ./_add-to-unscopables */ "./node_modules/core-js/library/modules/_add-to-unscopables.js");
var step = __webpack_require__(/*! ./_iter-step */ "./node_modules/core-js/library/modules/_iter-step.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/library/modules/_iter-define.js")(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.assign.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.assign.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.3.1 Object.assign(target, source)
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");

$export($export.S + $export.F, 'Object', { assign: __webpack_require__(/*! ./_object-assign */ "./node_modules/core-js/library/modules/_object-assign.js") });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.create.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.create.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js") });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.define-property.js":
/*!****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.define-property.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
$export($export.S + $export.F * !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js"), 'Object', { defineProperty: (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f) });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.get-prototype-of.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.get-prototype-of.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.9 Object.getPrototypeOf(O)
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var $getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ "./node_modules/core-js/library/modules/_object-gpo.js");

__webpack_require__(/*! ./_object-sap */ "./node_modules/core-js/library/modules/_object-sap.js")('getPrototypeOf', function () {
  return function getPrototypeOf(it) {
    return $getPrototypeOf(toObject(it));
  };
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.set-prototype-of.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.set-prototype-of.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.3.19 Object.setPrototypeOf(O, proto)
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
$export($export.S, 'Object', { setPrototypeOf: (__webpack_require__(/*! ./_set-proto */ "./node_modules/core-js/library/modules/_set-proto.js").set) });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.to-string.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.to-string.js ***!
  \**********************************************************************/
/***/ (() => {



/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.string.iterator.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.string.iterator.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $at = __webpack_require__(/*! ./_string-at */ "./node_modules/core-js/library/modules/_string-at.js")(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/library/modules/_iter-define.js")(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.symbol.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.symbol.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// ECMAScript 6 symbols shim
var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/library/modules/_redefine.js");
var META = (__webpack_require__(/*! ./_meta */ "./node_modules/core-js/library/modules/_meta.js").KEY);
var $fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js");
var shared = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/library/modules/_shared.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js");
var wks = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js");
var wksExt = __webpack_require__(/*! ./_wks-ext */ "./node_modules/core-js/library/modules/_wks-ext.js");
var wksDefine = __webpack_require__(/*! ./_wks-define */ "./node_modules/core-js/library/modules/_wks-define.js");
var enumKeys = __webpack_require__(/*! ./_enum-keys */ "./node_modules/core-js/library/modules/_enum-keys.js");
var isArray = __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/library/modules/_is-array.js");
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/library/modules/_to-primitive.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
var _create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js");
var gOPNExt = __webpack_require__(/*! ./_object-gopn-ext */ "./node_modules/core-js/library/modules/_object-gopn-ext.js");
var $GOPD = __webpack_require__(/*! ./_object-gopd */ "./node_modules/core-js/library/modules/_object-gopd.js");
var $GOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/library/modules/_object-gops.js");
var $DP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var $keys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");
var gOPD = $GOPD.f;
var dP = $DP.f;
var gOPN = gOPNExt.f;
var $Symbol = global.Symbol;
var $JSON = global.JSON;
var _stringify = $JSON && $JSON.stringify;
var PROTOTYPE = 'prototype';
var HIDDEN = wks('_hidden');
var TO_PRIMITIVE = wks('toPrimitive');
var isEnum = {}.propertyIsEnumerable;
var SymbolRegistry = shared('symbol-registry');
var AllSymbols = shared('symbols');
var OPSymbols = shared('op-symbols');
var ObjectProto = Object[PROTOTYPE];
var USE_NATIVE = typeof $Symbol == 'function' && !!$GOPS.f;
var QObject = global.QObject;
// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDesc = DESCRIPTORS && $fails(function () {
  return _create(dP({}, 'a', {
    get: function () { return dP(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (it, key, D) {
  var protoDesc = gOPD(ObjectProto, key);
  if (protoDesc) delete ObjectProto[key];
  dP(it, key, D);
  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);
} : dP;

var wrap = function (tag) {
  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
  sym._k = tag;
  return sym;
};

var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  return it instanceof $Symbol;
};

var $defineProperty = function defineProperty(it, key, D) {
  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
  anObject(it);
  key = toPrimitive(key, true);
  anObject(D);
  if (has(AllSymbols, key)) {
    if (!D.enumerable) {
      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));
      it[HIDDEN][key] = true;
    } else {
      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
      D = _create(D, { enumerable: createDesc(0, false) });
    } return setSymbolDesc(it, key, D);
  } return dP(it, key, D);
};
var $defineProperties = function defineProperties(it, P) {
  anObject(it);
  var keys = enumKeys(P = toIObject(P));
  var i = 0;
  var l = keys.length;
  var key;
  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
  return it;
};
var $create = function create(it, P) {
  return P === undefined ? _create(it) : $defineProperties(_create(it), P);
};
var $propertyIsEnumerable = function propertyIsEnumerable(key) {
  var E = isEnum.call(this, key = toPrimitive(key, true));
  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;
  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
  it = toIObject(it);
  key = toPrimitive(key, true);
  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;
  var D = gOPD(it, key);
  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
  return D;
};
var $getOwnPropertyNames = function getOwnPropertyNames(it) {
  var names = gOPN(toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
  } return result;
};
var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
  var IS_OP = it === ObjectProto;
  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
  } return result;
};

// 19.4.1.1 Symbol([description])
if (!USE_NATIVE) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
    var $set = function (value) {
      if (this === ObjectProto) $set.call(OPSymbols, value);
      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDesc(this, tag, createDesc(1, value));
    };
    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
    return wrap(tag);
  };
  redefine($Symbol[PROTOTYPE], 'toString', function toString() {
    return this._k;
  });

  $GOPD.f = $getOwnPropertyDescriptor;
  $DP.f = $defineProperty;
  (__webpack_require__(/*! ./_object-gopn */ "./node_modules/core-js/library/modules/_object-gopn.js").f) = gOPNExt.f = $getOwnPropertyNames;
  (__webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/library/modules/_object-pie.js").f) = $propertyIsEnumerable;
  $GOPS.f = $getOwnPropertySymbols;

  if (DESCRIPTORS && !__webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js")) {
    redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
  }

  wksExt.f = function (name) {
    return wrap(wks(name));
  };
}

$export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });

for (var es6Symbols = (
  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
  'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
).split(','), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);

for (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);

$export($export.S + $export.F * !USE_NATIVE, 'Symbol', {
  // 19.4.2.1 Symbol.for(key)
  'for': function (key) {
    return has(SymbolRegistry, key += '')
      ? SymbolRegistry[key]
      : SymbolRegistry[key] = $Symbol(key);
  },
  // 19.4.2.5 Symbol.keyFor(sym)
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
  },
  useSetter: function () { setter = true; },
  useSimple: function () { setter = false; }
});

$export($export.S + $export.F * !USE_NATIVE, 'Object', {
  // 19.1.2.2 Object.create(O [, Properties])
  create: $create,
  // 19.1.2.4 Object.defineProperty(O, P, Attributes)
  defineProperty: $defineProperty,
  // 19.1.2.3 Object.defineProperties(O, Properties)
  defineProperties: $defineProperties,
  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
  // 19.1.2.7 Object.getOwnPropertyNames(O)
  getOwnPropertyNames: $getOwnPropertyNames,
  // 19.1.2.8 Object.getOwnPropertySymbols(O)
  getOwnPropertySymbols: $getOwnPropertySymbols
});

// Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
// https://bugs.chromium.org/p/v8/issues/detail?id=3443
var FAILS_ON_PRIMITIVES = $fails(function () { $GOPS.f(1); });

$export($export.S + $export.F * FAILS_ON_PRIMITIVES, 'Object', {
  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
    return $GOPS.f(toObject(it));
  }
});

// 24.3.2 JSON.stringify(value [, replacer [, space]])
$JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {
  var S = $Symbol();
  // MS Edge converts symbol values to JSON as {}
  // WebKit converts symbol values to JSON as null
  // V8 throws on boxed symbols
  return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
})), 'JSON', {
  stringify: function stringify(it) {
    var args = [it];
    var i = 1;
    var replacer, $replacer;
    while (arguments.length > i) args.push(arguments[i++]);
    $replacer = replacer = args[1];
    if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
    if (!isArray(replacer)) replacer = function (key, value) {
      if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
      if (!isSymbol(value)) return value;
    };
    args[1] = replacer;
    return _stringify.apply($JSON, args);
  }
});

// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
$Symbol[PROTOTYPE][TO_PRIMITIVE] || __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js")($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
// 19.4.3.5 Symbol.prototype[@@toStringTag]
setToStringTag($Symbol, 'Symbol');
// 20.2.1.9 Math[@@toStringTag]
setToStringTag(Math, 'Math', true);
// 24.3.3 JSON[@@toStringTag]
setToStringTag(global.JSON, 'JSON', true);


/***/ }),

/***/ "./node_modules/core-js/library/modules/es7.symbol.async-iterator.js":
/*!***************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.symbol.async-iterator.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ./_wks-define */ "./node_modules/core-js/library/modules/_wks-define.js")('asyncIterator');


/***/ }),

/***/ "./node_modules/core-js/library/modules/es7.symbol.observable.js":
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.symbol.observable.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ./_wks-define */ "./node_modules/core-js/library/modules/_wks-define.js")('observable');


/***/ }),

/***/ "./node_modules/core-js/library/modules/web.dom.iterable.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/web.dom.iterable.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ./es6.array.iterator */ "./node_modules/core-js/library/modules/es6.array.iterator.js");
var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var TO_STRING_TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),

/***/ "./node_modules/decimal.js-light/decimal.js":
/*!**************************************************!*\
  !*** ./node_modules/decimal.js-light/decimal.js ***!
  \**************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/*! decimal.js-light v2.5.1 https://github.com/MikeMcl/decimal.js-light/LICENCE */
;(function (globalScope) {
  'use strict';


  /*
   *  decimal.js-light v2.5.1
   *  An arbitrary-precision Decimal type for JavaScript.
   *  https://github.com/MikeMcl/decimal.js-light
   *  Copyright (c) 2020 Michael Mclaughlin <M8ch88l@gmail.com>
   *  MIT Expat Licence
   */


  // -----------------------------------  EDITABLE DEFAULTS  ------------------------------------ //


    // The limit on the value of `precision`, and on the value of the first argument to
    // `toDecimalPlaces`, `toExponential`, `toFixed`, `toPrecision` and `toSignificantDigits`.
  var MAX_DIGITS = 1e9,                        // 0 to 1e9


    // The initial configuration properties of the Decimal constructor.
    Decimal = {

      // These values must be integers within the stated ranges (inclusive).
      // Most of these values can be changed during run-time using `Decimal.config`.

      // The maximum number of significant digits of the result of a calculation or base conversion.
      // E.g. `Decimal.config({ precision: 20 });`
      precision: 20,                         // 1 to MAX_DIGITS

      // The rounding mode used by default by `toInteger`, `toDecimalPlaces`, `toExponential`,
      // `toFixed`, `toPrecision` and `toSignificantDigits`.
      //
      // ROUND_UP         0 Away from zero.
      // ROUND_DOWN       1 Towards zero.
      // ROUND_CEIL       2 Towards +Infinity.
      // ROUND_FLOOR      3 Towards -Infinity.
      // ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
      // ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
      // ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
      // ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
      // ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
      //
      // E.g.
      // `Decimal.rounding = 4;`
      // `Decimal.rounding = Decimal.ROUND_HALF_UP;`
      rounding: 4,                           // 0 to 8

      // The exponent value at and beneath which `toString` returns exponential notation.
      // JavaScript numbers: -7
      toExpNeg: -7,                          // 0 to -MAX_E

      // The exponent value at and above which `toString` returns exponential notation.
      // JavaScript numbers: 21
      toExpPos:  21,                         // 0 to MAX_E

      // The natural logarithm of 10.
      // 115 digits
      LN10: '2.302585092994045684017991454684364207601101488628772976033327900967572609677352480235997205089598298341967784042286'
    },


  // ----------------------------------- END OF EDITABLE DEFAULTS ------------------------------- //


    external = true,

    decimalError = '[DecimalError] ',
    invalidArgument = decimalError + 'Invalid argument: ',
    exponentOutOfRange = decimalError + 'Exponent out of range: ',

    mathfloor = Math.floor,
    mathpow = Math.pow,

    isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,

    ONE,
    BASE = 1e7,
    LOG_BASE = 7,
    MAX_SAFE_INTEGER = 9007199254740991,
    MAX_E = mathfloor(MAX_SAFE_INTEGER / LOG_BASE),    // 1286742750677284

    // Decimal.prototype object
    P = {};


  // Decimal prototype methods


  /*
   *  absoluteValue                       abs
   *  comparedTo                          cmp
   *  decimalPlaces                       dp
   *  dividedBy                           div
   *  dividedToIntegerBy                  idiv
   *  equals                              eq
   *  exponent
   *  greaterThan                         gt
   *  greaterThanOrEqualTo                gte
   *  isInteger                           isint
   *  isNegative                          isneg
   *  isPositive                          ispos
   *  isZero
   *  lessThan                            lt
   *  lessThanOrEqualTo                   lte
   *  logarithm                           log
   *  minus                               sub
   *  modulo                              mod
   *  naturalExponential                  exp
   *  naturalLogarithm                    ln
   *  negated                             neg
   *  plus                                add
   *  precision                           sd
   *  squareRoot                          sqrt
   *  times                               mul
   *  toDecimalPlaces                     todp
   *  toExponential
   *  toFixed
   *  toInteger                           toint
   *  toNumber
   *  toPower                             pow
   *  toPrecision
   *  toSignificantDigits                 tosd
   *  toString
   *  valueOf                             val
   */


  /*
   * Return a new Decimal whose value is the absolute value of this Decimal.
   *
   */
  P.absoluteValue = P.abs = function () {
    var x = new this.constructor(this);
    if (x.s) x.s = 1;
    return x;
  };


  /*
   * Return
   *   1    if the value of this Decimal is greater than the value of `y`,
   *  -1    if the value of this Decimal is less than the value of `y`,
   *   0    if they have the same value
   *
   */
  P.comparedTo = P.cmp = function (y) {
    var i, j, xdL, ydL,
      x = this;

    y = new x.constructor(y);

    // Signs differ?
    if (x.s !== y.s) return x.s || -y.s;

    // Compare exponents.
    if (x.e !== y.e) return x.e > y.e ^ x.s < 0 ? 1 : -1;

    xdL = x.d.length;
    ydL = y.d.length;

    // Compare digit by digit.
    for (i = 0, j = xdL < ydL ? xdL : ydL; i < j; ++i) {
      if (x.d[i] !== y.d[i]) return x.d[i] > y.d[i] ^ x.s < 0 ? 1 : -1;
    }

    // Compare lengths.
    return xdL === ydL ? 0 : xdL > ydL ^ x.s < 0 ? 1 : -1;
  };


  /*
   * Return the number of decimal places of the value of this Decimal.
   *
   */
  P.decimalPlaces = P.dp = function () {
    var x = this,
      w = x.d.length - 1,
      dp = (w - x.e) * LOG_BASE;

    // Subtract the number of trailing zeros of the last word.
    w = x.d[w];
    if (w) for (; w % 10 == 0; w /= 10) dp--;

    return dp < 0 ? 0 : dp;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal divided by `y`, truncated to
   * `precision` significant digits.
   *
   */
  P.dividedBy = P.div = function (y) {
    return divide(this, new this.constructor(y));
  };


  /*
   * Return a new Decimal whose value is the integer part of dividing the value of this Decimal
   * by the value of `y`, truncated to `precision` significant digits.
   *
   */
  P.dividedToIntegerBy = P.idiv = function (y) {
    var x = this,
      Ctor = x.constructor;
    return round(divide(x, new Ctor(y), 0, 1), Ctor.precision);
  };


  /*
   * Return true if the value of this Decimal is equal to the value of `y`, otherwise return false.
   *
   */
  P.equals = P.eq = function (y) {
    return !this.cmp(y);
  };


  /*
   * Return the (base 10) exponent value of this Decimal (this.e is the base 10000000 exponent).
   *
   */
  P.exponent = function () {
    return getBase10Exponent(this);
  };


  /*
   * Return true if the value of this Decimal is greater than the value of `y`, otherwise return
   * false.
   *
   */
  P.greaterThan = P.gt = function (y) {
    return this.cmp(y) > 0;
  };


  /*
   * Return true if the value of this Decimal is greater than or equal to the value of `y`,
   * otherwise return false.
   *
   */
  P.greaterThanOrEqualTo = P.gte = function (y) {
    return this.cmp(y) >= 0;
  };


  /*
   * Return true if the value of this Decimal is an integer, otherwise return false.
   *
   */
  P.isInteger = P.isint = function () {
    return this.e > this.d.length - 2;
  };


  /*
   * Return true if the value of this Decimal is negative, otherwise return false.
   *
   */
  P.isNegative = P.isneg = function () {
    return this.s < 0;
  };


  /*
   * Return true if the value of this Decimal is positive, otherwise return false.
   *
   */
  P.isPositive = P.ispos = function () {
    return this.s > 0;
  };


  /*
   * Return true if the value of this Decimal is 0, otherwise return false.
   *
   */
  P.isZero = function () {
    return this.s === 0;
  };


  /*
   * Return true if the value of this Decimal is less than `y`, otherwise return false.
   *
   */
  P.lessThan = P.lt = function (y) {
    return this.cmp(y) < 0;
  };


  /*
   * Return true if the value of this Decimal is less than or equal to `y`, otherwise return false.
   *
   */
  P.lessThanOrEqualTo = P.lte = function (y) {
    return this.cmp(y) < 1;
  };


  /*
   * Return the logarithm of the value of this Decimal to the specified base, truncated to
   * `precision` significant digits.
   *
   * If no base is specified, return log[10](x).
   *
   * log[base](x) = ln(x) / ln(base)
   *
   * The maximum error of the result is 1 ulp (unit in the last place).
   *
   * [base] {number|string|Decimal} The base of the logarithm.
   *
   */
  P.logarithm = P.log = function (base) {
    var r,
      x = this,
      Ctor = x.constructor,
      pr = Ctor.precision,
      wpr = pr + 5;

    // Default base is 10.
    if (base === void 0) {
      base = new Ctor(10);
    } else {
      base = new Ctor(base);

      // log[-b](x) = NaN
      // log[0](x)  = NaN
      // log[1](x)  = NaN
      if (base.s < 1 || base.eq(ONE)) throw Error(decimalError + 'NaN');
    }

    // log[b](-x) = NaN
    // log[b](0) = -Infinity
    if (x.s < 1) throw Error(decimalError + (x.s ? 'NaN' : '-Infinity'));

    // log[b](1) = 0
    if (x.eq(ONE)) return new Ctor(0);

    external = false;
    r = divide(ln(x, wpr), ln(base, wpr), wpr);
    external = true;

    return round(r, pr);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal minus `y`, truncated to
   * `precision` significant digits.
   *
   */
  P.minus = P.sub = function (y) {
    var x = this;
    y = new x.constructor(y);
    return x.s == y.s ? subtract(x, y) : add(x, (y.s = -y.s, y));
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal modulo `y`, truncated to
   * `precision` significant digits.
   *
   */
  P.modulo = P.mod = function (y) {
    var q,
      x = this,
      Ctor = x.constructor,
      pr = Ctor.precision;

    y = new Ctor(y);

    // x % 0 = NaN
    if (!y.s) throw Error(decimalError + 'NaN');

    // Return x if x is 0.
    if (!x.s) return round(new Ctor(x), pr);

    // Prevent rounding of intermediate calculations.
    external = false;
    q = divide(x, y, 0, 1).times(y);
    external = true;

    return x.minus(q);
  };


  /*
   * Return a new Decimal whose value is the natural exponential of the value of this Decimal,
   * i.e. the base e raised to the power the value of this Decimal, truncated to `precision`
   * significant digits.
   *
   */
  P.naturalExponential = P.exp = function () {
    return exp(this);
  };


  /*
   * Return a new Decimal whose value is the natural logarithm of the value of this Decimal,
   * truncated to `precision` significant digits.
   *
   */
  P.naturalLogarithm = P.ln = function () {
    return ln(this);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal negated, i.e. as if multiplied by
   * -1.
   *
   */
  P.negated = P.neg = function () {
    var x = new this.constructor(this);
    x.s = -x.s || 0;
    return x;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal plus `y`, truncated to
   * `precision` significant digits.
   *
   */
  P.plus = P.add = function (y) {
    var x = this;
    y = new x.constructor(y);
    return x.s == y.s ? add(x, y) : subtract(x, (y.s = -y.s, y));
  };


  /*
   * Return the number of significant digits of the value of this Decimal.
   *
   * [z] {boolean|number} Whether to count integer-part trailing zeros: true, false, 1 or 0.
   *
   */
  P.precision = P.sd = function (z) {
    var e, sd, w,
      x = this;

    if (z !== void 0 && z !== !!z && z !== 1 && z !== 0) throw Error(invalidArgument + z);

    e = getBase10Exponent(x) + 1;
    w = x.d.length - 1;
    sd = w * LOG_BASE + 1;
    w = x.d[w];

    // If non-zero...
    if (w) {

      // Subtract the number of trailing zeros of the last word.
      for (; w % 10 == 0; w /= 10) sd--;

      // Add the number of digits of the first word.
      for (w = x.d[0]; w >= 10; w /= 10) sd++;
    }

    return z && e > sd ? e : sd;
  };


  /*
   * Return a new Decimal whose value is the square root of this Decimal, truncated to `precision`
   * significant digits.
   *
   */
  P.squareRoot = P.sqrt = function () {
    var e, n, pr, r, s, t, wpr,
      x = this,
      Ctor = x.constructor;

    // Negative or zero?
    if (x.s < 1) {
      if (!x.s) return new Ctor(0);

      // sqrt(-x) = NaN
      throw Error(decimalError + 'NaN');
    }

    e = getBase10Exponent(x);
    external = false;

    // Initial estimate.
    s = Math.sqrt(+x);

    // Math.sqrt underflow/overflow?
    // Pass x to Math.sqrt as integer, then adjust the exponent of the result.
    if (s == 0 || s == 1 / 0) {
      n = digitsToString(x.d);
      if ((n.length + e) % 2 == 0) n += '0';
      s = Math.sqrt(n);
      e = mathfloor((e + 1) / 2) - (e < 0 || e % 2);

      if (s == 1 / 0) {
        n = '5e' + e;
      } else {
        n = s.toExponential();
        n = n.slice(0, n.indexOf('e') + 1) + e;
      }

      r = new Ctor(n);
    } else {
      r = new Ctor(s.toString());
    }

    pr = Ctor.precision;
    s = wpr = pr + 3;

    // Newton-Raphson iteration.
    for (;;) {
      t = r;
      r = t.plus(divide(x, t, wpr + 2)).times(0.5);

      if (digitsToString(t.d).slice(0, wpr) === (n = digitsToString(r.d)).slice(0, wpr)) {
        n = n.slice(wpr - 3, wpr + 1);

        // The 4th rounding digit may be in error by -1 so if the 4 rounding digits are 9999 or
        // 4999, i.e. approaching a rounding boundary, continue the iteration.
        if (s == wpr && n == '4999') {

          // On the first iteration only, check to see if rounding up gives the exact result as the
          // nines may infinitely repeat.
          round(t, pr + 1, 0);

          if (t.times(t).eq(x)) {
            r = t;
            break;
          }
        } else if (n != '9999') {
          break;
        }

        wpr += 4;
      }
    }

    external = true;

    return round(r, pr);
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal times `y`, truncated to
   * `precision` significant digits.
   *
   */
  P.times = P.mul = function (y) {
    var carry, e, i, k, r, rL, t, xdL, ydL,
      x = this,
      Ctor = x.constructor,
      xd = x.d,
      yd = (y = new Ctor(y)).d;

    // Return 0 if either is 0.
    if (!x.s || !y.s) return new Ctor(0);

    y.s *= x.s;
    e = x.e + y.e;
    xdL = xd.length;
    ydL = yd.length;

    // Ensure xd points to the longer array.
    if (xdL < ydL) {
      r = xd;
      xd = yd;
      yd = r;
      rL = xdL;
      xdL = ydL;
      ydL = rL;
    }

    // Initialise the result array with zeros.
    r = [];
    rL = xdL + ydL;
    for (i = rL; i--;) r.push(0);

    // Multiply!
    for (i = ydL; --i >= 0;) {
      carry = 0;
      for (k = xdL + i; k > i;) {
        t = r[k] + yd[i] * xd[k - i - 1] + carry;
        r[k--] = t % BASE | 0;
        carry = t / BASE | 0;
      }

      r[k] = (r[k] + carry) % BASE | 0;
    }

    // Remove trailing zeros.
    for (; !r[--rL];) r.pop();

    if (carry) ++e;
    else r.shift();

    y.d = r;
    y.e = e;

    return external ? round(y, Ctor.precision) : y;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a maximum of `dp`
   * decimal places using rounding mode `rm` or `rounding` if `rm` is omitted.
   *
   * If `dp` is omitted, return a new Decimal whose value is the value of this Decimal.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toDecimalPlaces = P.todp = function (dp, rm) {
    var x = this,
      Ctor = x.constructor;

    x = new Ctor(x);
    if (dp === void 0) return x;

    checkInt32(dp, 0, MAX_DIGITS);

    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);

    return round(x, dp + getBase10Exponent(x) + 1, rm);
  };


  /*
   * Return a string representing the value of this Decimal in exponential notation rounded to
   * `dp` fixed decimal places using rounding mode `rounding`.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toExponential = function (dp, rm) {
    var str,
      x = this,
      Ctor = x.constructor;

    if (dp === void 0) {
      str = toString(x, true);
    } else {
      checkInt32(dp, 0, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);

      x = round(new Ctor(x), dp + 1, rm);
      str = toString(x, true, dp + 1);
    }

    return str;
  };


  /*
   * Return a string representing the value of this Decimal in normal (fixed-point) notation to
   * `dp` fixed decimal places and rounded using rounding mode `rm` or `rounding` if `rm` is
   * omitted.
   *
   * As with JavaScript numbers, (-0).toFixed(0) is '0', but e.g. (-0.00001).toFixed(0) is '-0'.
   *
   * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   * (-0).toFixed(0) is '0', but (-0.1).toFixed(0) is '-0'.
   * (-0).toFixed(1) is '0.0', but (-0.01).toFixed(1) is '-0.0'.
   * (-0).toFixed(3) is '0.000'.
   * (-0.5).toFixed(0) is '-0'.
   *
   */
  P.toFixed = function (dp, rm) {
    var str, y,
      x = this,
      Ctor = x.constructor;

    if (dp === void 0) return toString(x);

    checkInt32(dp, 0, MAX_DIGITS);

    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);

    y = round(new Ctor(x), dp + getBase10Exponent(x) + 1, rm);
    str = toString(y.abs(), false, dp + getBase10Exponent(y) + 1);

    // To determine whether to add the minus sign look at the value before it was rounded,
    // i.e. look at `x` rather than `y`.
    return x.isneg() && !x.isZero() ? '-' + str : str;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a whole number using
   * rounding mode `rounding`.
   *
   */
  P.toInteger = P.toint = function () {
    var x = this,
      Ctor = x.constructor;
    return round(new Ctor(x), getBase10Exponent(x) + 1, Ctor.rounding);
  };


  /*
   * Return the value of this Decimal converted to a number primitive.
   *
   */
  P.toNumber = function () {
    return +this;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal raised to the power `y`,
   * truncated to `precision` significant digits.
   *
   * For non-integer or very large exponents pow(x, y) is calculated using
   *
   *   x^y = exp(y*ln(x))
   *
   * The maximum error is 1 ulp (unit in last place).
   *
   * y {number|string|Decimal} The power to which to raise this Decimal.
   *
   */
  P.toPower = P.pow = function (y) {
    var e, k, pr, r, sign, yIsInt,
      x = this,
      Ctor = x.constructor,
      guard = 12,
      yn = +(y = new Ctor(y));

    // pow(x, 0) = 1
    if (!y.s) return new Ctor(ONE);

    x = new Ctor(x);

    // pow(0, y > 0) = 0
    // pow(0, y < 0) = Infinity
    if (!x.s) {
      if (y.s < 1) throw Error(decimalError + 'Infinity');
      return x;
    }

    // pow(1, y) = 1
    if (x.eq(ONE)) return x;

    pr = Ctor.precision;

    // pow(x, 1) = x
    if (y.eq(ONE)) return round(x, pr);

    e = y.e;
    k = y.d.length - 1;
    yIsInt = e >= k;
    sign = x.s;

    if (!yIsInt) {

      // pow(x < 0, y non-integer) = NaN
      if (sign < 0) throw Error(decimalError + 'NaN');

    // If y is a small integer use the 'exponentiation by squaring' algorithm.
    } else if ((k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
      r = new Ctor(ONE);

      // Max k of 9007199254740991 takes 53 loop iterations.
      // Maximum digits array length; leaves [28, 34] guard digits.
      e = Math.ceil(pr / LOG_BASE + 4);

      external = false;

      for (;;) {
        if (k % 2) {
          r = r.times(x);
          truncate(r.d, e);
        }

        k = mathfloor(k / 2);
        if (k === 0) break;

        x = x.times(x);
        truncate(x.d, e);
      }

      external = true;

      return y.s < 0 ? new Ctor(ONE).div(r) : round(r, pr);
    }

    // Result is negative if x is negative and the last digit of integer y is odd.
    sign = sign < 0 && y.d[Math.max(e, k)] & 1 ? -1 : 1;

    x.s = 1;
    external = false;
    r = y.times(ln(x, pr + guard));
    external = true;
    r = exp(r);
    r.s = sign;

    return r;
  };


  /*
   * Return a string representing the value of this Decimal rounded to `sd` significant digits
   * using rounding mode `rounding`.
   *
   * Return exponential notation if `sd` is less than the number of digits necessary to represent
   * the integer part of the value in normal notation.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toPrecision = function (sd, rm) {
    var e, str,
      x = this,
      Ctor = x.constructor;

    if (sd === void 0) {
      e = getBase10Exponent(x);
      str = toString(x, e <= Ctor.toExpNeg || e >= Ctor.toExpPos);
    } else {
      checkInt32(sd, 1, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);

      x = round(new Ctor(x), sd, rm);
      e = getBase10Exponent(x);
      str = toString(x, sd <= e || e <= Ctor.toExpNeg, sd);
    }

    return str;
  };


  /*
   * Return a new Decimal whose value is the value of this Decimal rounded to a maximum of `sd`
   * significant digits using rounding mode `rm`, or to `precision` and `rounding` respectively if
   * omitted.
   *
   * [sd] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
   * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
   *
   */
  P.toSignificantDigits = P.tosd = function (sd, rm) {
    var x = this,
      Ctor = x.constructor;

    if (sd === void 0) {
      sd = Ctor.precision;
      rm = Ctor.rounding;
    } else {
      checkInt32(sd, 1, MAX_DIGITS);

      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
    }

    return round(new Ctor(x), sd, rm);
  };


  /*
   * Return a string representing the value of this Decimal.
   *
   * Return exponential notation if this Decimal has a positive exponent equal to or greater than
   * `toExpPos`, or a negative exponent equal to or less than `toExpNeg`.
   *
   */
  P.toString = P.valueOf = P.val = P.toJSON = function () {
    var x = this,
      e = getBase10Exponent(x),
      Ctor = x.constructor;

    return toString(x, e <= Ctor.toExpNeg || e >= Ctor.toExpPos);
  };


  // Helper functions for Decimal.prototype (P) and/or Decimal methods, and their callers.


  /*
   *  add                 P.minus, P.plus
   *  checkInt32          P.todp, P.toExponential, P.toFixed, P.toPrecision, P.tosd
   *  digitsToString      P.log, P.sqrt, P.pow, toString, exp, ln
   *  divide              P.div, P.idiv, P.log, P.mod, P.sqrt, exp, ln
   *  exp                 P.exp, P.pow
   *  getBase10Exponent   P.exponent, P.sd, P.toint, P.sqrt, P.todp, P.toFixed, P.toPrecision,
   *                      P.toString, divide, round, toString, exp, ln
   *  getLn10             P.log, ln
   *  getZeroString       digitsToString, toString
   *  ln                  P.log, P.ln, P.pow, exp
   *  parseDecimal        Decimal
   *  round               P.abs, P.idiv, P.log, P.minus, P.mod, P.neg, P.plus, P.toint, P.sqrt,
   *                      P.times, P.todp, P.toExponential, P.toFixed, P.pow, P.toPrecision, P.tosd,
   *                      divide, getLn10, exp, ln
   *  subtract            P.minus, P.plus
   *  toString            P.toExponential, P.toFixed, P.toPrecision, P.toString, P.valueOf
   *  truncate            P.pow
   *
   *  Throws:             P.log, P.mod, P.sd, P.sqrt, P.pow,  checkInt32, divide, round,
   *                      getLn10, exp, ln, parseDecimal, Decimal, config
   */


  function add(x, y) {
    var carry, d, e, i, k, len, xd, yd,
      Ctor = x.constructor,
      pr = Ctor.precision;

    // If either is zero...
    if (!x.s || !y.s) {

      // Return x if y is zero.
      // Return y if y is non-zero.
      if (!y.s) y = new Ctor(x);
      return external ? round(y, pr) : y;
    }

    xd = x.d;
    yd = y.d;

    // x and y are finite, non-zero numbers with the same sign.

    k = x.e;
    e = y.e;
    xd = xd.slice();
    i = k - e;

    // If base 1e7 exponents differ...
    if (i) {
      if (i < 0) {
        d = xd;
        i = -i;
        len = yd.length;
      } else {
        d = yd;
        e = k;
        len = xd.length;
      }

      // Limit number of zeros prepended to max(ceil(pr / LOG_BASE), len) + 1.
      k = Math.ceil(pr / LOG_BASE);
      len = k > len ? k + 1 : len + 1;

      if (i > len) {
        i = len;
        d.length = 1;
      }

      // Prepend zeros to equalise exponents. Note: Faster to use reverse then do unshifts.
      d.reverse();
      for (; i--;) d.push(0);
      d.reverse();
    }

    len = xd.length;
    i = yd.length;

    // If yd is longer than xd, swap xd and yd so xd points to the longer array.
    if (len - i < 0) {
      i = len;
      d = yd;
      yd = xd;
      xd = d;
    }

    // Only start adding at yd.length - 1 as the further digits of xd can be left as they are.
    for (carry = 0; i;) {
      carry = (xd[--i] = xd[i] + yd[i] + carry) / BASE | 0;
      xd[i] %= BASE;
    }

    if (carry) {
      xd.unshift(carry);
      ++e;
    }

    // Remove trailing zeros.
    // No need to check for zero, as +x + +y != 0 && -x + -y != 0
    for (len = xd.length; xd[--len] == 0;) xd.pop();

    y.d = xd;
    y.e = e;

    return external ? round(y, pr) : y;
  }


  function checkInt32(i, min, max) {
    if (i !== ~~i || i < min || i > max) {
      throw Error(invalidArgument + i);
    }
  }


  function digitsToString(d) {
    var i, k, ws,
      indexOfLastWord = d.length - 1,
      str = '',
      w = d[0];

    if (indexOfLastWord > 0) {
      str += w;
      for (i = 1; i < indexOfLastWord; i++) {
        ws = d[i] + '';
        k = LOG_BASE - ws.length;
        if (k) str += getZeroString(k);
        str += ws;
      }

      w = d[i];
      ws = w + '';
      k = LOG_BASE - ws.length;
      if (k) str += getZeroString(k);
    } else if (w === 0) {
      return '0';
    }

    // Remove trailing zeros of last w.
    for (; w % 10 === 0;) w /= 10;

    return str + w;
  }


  var divide = (function () {

    // Assumes non-zero x and k, and hence non-zero result.
    function multiplyInteger(x, k) {
      var temp,
        carry = 0,
        i = x.length;

      for (x = x.slice(); i--;) {
        temp = x[i] * k + carry;
        x[i] = temp % BASE | 0;
        carry = temp / BASE | 0;
      }

      if (carry) x.unshift(carry);

      return x;
    }

    function compare(a, b, aL, bL) {
      var i, r;

      if (aL != bL) {
        r = aL > bL ? 1 : -1;
      } else {
        for (i = r = 0; i < aL; i++) {
          if (a[i] != b[i]) {
            r = a[i] > b[i] ? 1 : -1;
            break;
          }
        }
      }

      return r;
    }

    function subtract(a, b, aL) {
      var i = 0;

      // Subtract b from a.
      for (; aL--;) {
        a[aL] -= i;
        i = a[aL] < b[aL] ? 1 : 0;
        a[aL] = i * BASE + a[aL] - b[aL];
      }

      // Remove leading zeros.
      for (; !a[0] && a.length > 1;) a.shift();
    }

    return function (x, y, pr, dp) {
      var cmp, e, i, k, prod, prodL, q, qd, rem, remL, rem0, sd, t, xi, xL, yd0, yL, yz,
        Ctor = x.constructor,
        sign = x.s == y.s ? 1 : -1,
        xd = x.d,
        yd = y.d;

      // Either 0?
      if (!x.s) return new Ctor(x);
      if (!y.s) throw Error(decimalError + 'Division by zero');

      e = x.e - y.e;
      yL = yd.length;
      xL = xd.length;
      q = new Ctor(sign);
      qd = q.d = [];

      // Result exponent may be one less than e.
      for (i = 0; yd[i] == (xd[i] || 0); ) ++i;
      if (yd[i] > (xd[i] || 0)) --e;

      if (pr == null) {
        sd = pr = Ctor.precision;
      } else if (dp) {
        sd = pr + (getBase10Exponent(x) - getBase10Exponent(y)) + 1;
      } else {
        sd = pr;
      }

      if (sd < 0) return new Ctor(0);

      // Convert precision in number of base 10 digits to base 1e7 digits.
      sd = sd / LOG_BASE + 2 | 0;
      i = 0;

      // divisor < 1e7
      if (yL == 1) {
        k = 0;
        yd = yd[0];
        sd++;

        // k is the carry.
        for (; (i < xL || k) && sd--; i++) {
          t = k * BASE + (xd[i] || 0);
          qd[i] = t / yd | 0;
          k = t % yd | 0;
        }

      // divisor >= 1e7
      } else {

        // Normalise xd and yd so highest order digit of yd is >= BASE/2
        k = BASE / (yd[0] + 1) | 0;

        if (k > 1) {
          yd = multiplyInteger(yd, k);
          xd = multiplyInteger(xd, k);
          yL = yd.length;
          xL = xd.length;
        }

        xi = yL;
        rem = xd.slice(0, yL);
        remL = rem.length;

        // Add zeros to make remainder as long as divisor.
        for (; remL < yL;) rem[remL++] = 0;

        yz = yd.slice();
        yz.unshift(0);
        yd0 = yd[0];

        if (yd[1] >= BASE / 2) ++yd0;

        do {
          k = 0;

          // Compare divisor and remainder.
          cmp = compare(yd, rem, yL, remL);

          // If divisor < remainder.
          if (cmp < 0) {

            // Calculate trial digit, k.
            rem0 = rem[0];
            if (yL != remL) rem0 = rem0 * BASE + (rem[1] || 0);

            // k will be how many times the divisor goes into the current remainder.
            k = rem0 / yd0 | 0;

            //  Algorithm:
            //  1. product = divisor * trial digit (k)
            //  2. if product > remainder: product -= divisor, k--
            //  3. remainder -= product
            //  4. if product was < remainder at 2:
            //    5. compare new remainder and divisor
            //    6. If remainder > divisor: remainder -= divisor, k++

            if (k > 1) {
              if (k >= BASE) k = BASE - 1;

              // product = divisor * trial digit.
              prod = multiplyInteger(yd, k);
              prodL = prod.length;
              remL = rem.length;

              // Compare product and remainder.
              cmp = compare(prod, rem, prodL, remL);

              // product > remainder.
              if (cmp == 1) {
                k--;

                // Subtract divisor from product.
                subtract(prod, yL < prodL ? yz : yd, prodL);
              }
            } else {

              // cmp is -1.
              // If k is 0, there is no need to compare yd and rem again below, so change cmp to 1
              // to avoid it. If k is 1 there is a need to compare yd and rem again below.
              if (k == 0) cmp = k = 1;
              prod = yd.slice();
            }

            prodL = prod.length;
            if (prodL < remL) prod.unshift(0);

            // Subtract product from remainder.
            subtract(rem, prod, remL);

            // If product was < previous remainder.
            if (cmp == -1) {
              remL = rem.length;

              // Compare divisor and new remainder.
              cmp = compare(yd, rem, yL, remL);

              // If divisor < new remainder, subtract divisor from remainder.
              if (cmp < 1) {
                k++;

                // Subtract divisor from remainder.
                subtract(rem, yL < remL ? yz : yd, remL);
              }
            }

            remL = rem.length;
          } else if (cmp === 0) {
            k++;
            rem = [0];
          }    // if cmp === 1, k will be 0

          // Add the next digit, k, to the result array.
          qd[i++] = k;

          // Update the remainder.
          if (cmp && rem[0]) {
            rem[remL++] = xd[xi] || 0;
          } else {
            rem = [xd[xi]];
            remL = 1;
          }

        } while ((xi++ < xL || rem[0] !== void 0) && sd--);
      }

      // Leading zero?
      if (!qd[0]) qd.shift();

      q.e = e;

      return round(q, dp ? pr + getBase10Exponent(q) + 1 : pr);
    };
  })();


  /*
   * Return a new Decimal whose value is the natural exponential of `x` truncated to `sd`
   * significant digits.
   *
   * Taylor/Maclaurin series.
   *
   * exp(x) = x^0/0! + x^1/1! + x^2/2! + x^3/3! + ...
   *
   * Argument reduction:
   *   Repeat x = x / 32, k += 5, until |x| < 0.1
   *   exp(x) = exp(x / 2^k)^(2^k)
   *
   * Previously, the argument was initially reduced by
   * exp(x) = exp(r) * 10^k  where r = x - k * ln10, k = floor(x / ln10)
   * to first put r in the range [0, ln10], before dividing by 32 until |x| < 0.1, but this was
   * found to be slower than just dividing repeatedly by 32 as above.
   *
   * (Math object integer min/max: Math.exp(709) = 8.2e+307, Math.exp(-745) = 5e-324)
   *
   *  exp(x) is non-terminating for any finite, non-zero x.
   *
   */
  function exp(x, sd) {
    var denominator, guard, pow, sum, t, wpr,
      i = 0,
      k = 0,
      Ctor = x.constructor,
      pr = Ctor.precision;

    if (getBase10Exponent(x) > 16) throw Error(exponentOutOfRange + getBase10Exponent(x));

    // exp(0) = 1
    if (!x.s) return new Ctor(ONE);

    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }

    t = new Ctor(0.03125);

    while (x.abs().gte(0.1)) {
      x = x.times(t);    // x = x / 2^5
      k += 5;
    }

    // Estimate the precision increase necessary to ensure the first 4 rounding digits are correct.
    guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
    wpr += guard;
    denominator = pow = sum = new Ctor(ONE);
    Ctor.precision = wpr;

    for (;;) {
      pow = round(pow.times(x), wpr);
      denominator = denominator.times(++i);
      t = sum.plus(divide(pow, denominator, wpr));

      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum.d).slice(0, wpr)) {
        while (k--) sum = round(sum.times(sum), wpr);
        Ctor.precision = pr;
        return sd == null ? (external = true, round(sum, pr)) : sum;
      }

      sum = t;
    }
  }


  // Calculate the base 10 exponent from the base 1e7 exponent.
  function getBase10Exponent(x) {
    var e = x.e * LOG_BASE,
      w = x.d[0];

    // Add the number of digits of the first word of the digits array.
    for (; w >= 10; w /= 10) e++;
    return e;
  }


  function getLn10(Ctor, sd, pr) {

    if (sd > Ctor.LN10.sd()) {


      // Reset global state in case the exception is caught.
      external = true;
      if (pr) Ctor.precision = pr;
      throw Error(decimalError + 'LN10 precision limit exceeded');
    }

    return round(new Ctor(Ctor.LN10), sd);
  }


  function getZeroString(k) {
    var zs = '';
    for (; k--;) zs += '0';
    return zs;
  }


  /*
   * Return a new Decimal whose value is the natural logarithm of `x` truncated to `sd` significant
   * digits.
   *
   *  ln(n) is non-terminating (n != 1)
   *
   */
  function ln(y, sd) {
    var c, c0, denominator, e, numerator, sum, t, wpr, x2,
      n = 1,
      guard = 10,
      x = y,
      xd = x.d,
      Ctor = x.constructor,
      pr = Ctor.precision;

    // ln(-x) = NaN
    // ln(0) = -Infinity
    if (x.s < 1) throw Error(decimalError + (x.s ? 'NaN' : '-Infinity'));

    // ln(1) = 0
    if (x.eq(ONE)) return new Ctor(0);

    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }

    if (x.eq(10)) {
      if (sd == null) external = true;
      return getLn10(Ctor, wpr);
    }

    wpr += guard;
    Ctor.precision = wpr;
    c = digitsToString(xd);
    c0 = c.charAt(0);
    e = getBase10Exponent(x);

    if (Math.abs(e) < 1.5e15) {

      // Argument reduction.
      // The series converges faster the closer the argument is to 1, so using
      // ln(a^b) = b * ln(a),   ln(a) = ln(a^b) / b
      // multiply the argument by itself until the leading digits of the significand are 7, 8, 9,
      // 10, 11, 12 or 13, recording the number of multiplications so the sum of the series can
      // later be divided by this number, then separate out the power of 10 using
      // ln(a*10^b) = ln(a) + b*ln(10).

      // max n is 21 (gives 0.9, 1.0 or 1.1) (9e15 / 21 = 4.2e14).
      //while (c0 < 9 && c0 != 1 || c0 == 1 && c.charAt(1) > 1) {
      // max n is 6 (gives 0.7 - 1.3)
      while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
        x = x.times(y);
        c = digitsToString(x.d);
        c0 = c.charAt(0);
        n++;
      }

      e = getBase10Exponent(x);

      if (c0 > 1) {
        x = new Ctor('0.' + c);
        e++;
      } else {
        x = new Ctor(c0 + '.' + c.slice(1));
      }
    } else {

      // The argument reduction method above may result in overflow if the argument y is a massive
      // number with exponent >= 1500000000000000 (9e15 / 6 = 1.5e15), so instead recall this
      // function using ln(x*10^e) = ln(x) + e*ln(10).
      t = getLn10(Ctor, wpr + 2, pr).times(e + '');
      x = ln(new Ctor(c0 + '.' + c.slice(1)), wpr - guard).plus(t);

      Ctor.precision = pr;
      return sd == null ? (external = true, round(x, pr)) : x;
    }

    // x is reduced to a value near 1.

    // Taylor series.
    // ln(y) = ln((1 + x)/(1 - x)) = 2(x + x^3/3 + x^5/5 + x^7/7 + ...)
    // where x = (y - 1)/(y + 1)    (|x| < 1)
    sum = numerator = x = divide(x.minus(ONE), x.plus(ONE), wpr);
    x2 = round(x.times(x), wpr);
    denominator = 3;

    for (;;) {
      numerator = round(numerator.times(x2), wpr);
      t = sum.plus(divide(numerator, new Ctor(denominator), wpr));

      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum.d).slice(0, wpr)) {
        sum = sum.times(2);

        // Reverse the argument reduction.
        if (e !== 0) sum = sum.plus(getLn10(Ctor, wpr + 2, pr).times(e + ''));
        sum = divide(sum, new Ctor(n), wpr);

        Ctor.precision = pr;
        return sd == null ? (external = true, round(sum, pr)) : sum;
      }

      sum = t;
      denominator += 2;
    }
  }


  /*
   * Parse the value of a new Decimal `x` from string `str`.
   */
  function parseDecimal(x, str) {
    var e, i, len;

    // Decimal point?
    if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');

    // Exponential form?
    if ((i = str.search(/e/i)) > 0) {

      // Determine exponent.
      if (e < 0) e = i;
      e += +str.slice(i + 1);
      str = str.substring(0, i);
    } else if (e < 0) {

      // Integer.
      e = str.length;
    }

    // Determine leading zeros.
    for (i = 0; str.charCodeAt(i) === 48;) ++i;

    // Determine trailing zeros.
    for (len = str.length; str.charCodeAt(len - 1) === 48;) --len;
    str = str.slice(i, len);

    if (str) {
      len -= i;
      e = e - i - 1;
      x.e = mathfloor(e / LOG_BASE);
      x.d = [];

      // Transform base

      // e is the base 10 exponent.
      // i is where to slice str to get the first word of the digits array.
      i = (e + 1) % LOG_BASE;
      if (e < 0) i += LOG_BASE;

      if (i < len) {
        if (i) x.d.push(+str.slice(0, i));
        for (len -= LOG_BASE; i < len;) x.d.push(+str.slice(i, i += LOG_BASE));
        str = str.slice(i);
        i = LOG_BASE - str.length;
      } else {
        i -= len;
      }

      for (; i--;) str += '0';
      x.d.push(+str);

      if (external && (x.e > MAX_E || x.e < -MAX_E)) throw Error(exponentOutOfRange + e);
    } else {

      // Zero.
      x.s = 0;
      x.e = 0;
      x.d = [0];
    }

    return x;
  }


  /*
   * Round `x` to `sd` significant digits, using rounding mode `rm` if present (truncate otherwise).
   */
   function round(x, sd, rm) {
    var i, j, k, n, rd, doRound, w, xdi,
      xd = x.d;

    // rd: the rounding digit, i.e. the digit after the digit that may be rounded up.
    // w: the word of xd which contains the rounding digit, a base 1e7 number.
    // xdi: the index of w within xd.
    // n: the number of digits of w.
    // i: what would be the index of rd within w if all the numbers were 7 digits long (i.e. if
    // they had leading zeros)
    // j: if > 0, the actual index of rd within w (if < 0, rd is a leading zero).

    // Get the length of the first word of the digits array xd.
    for (n = 1, k = xd[0]; k >= 10; k /= 10) n++;
    i = sd - n;

    // Is the rounding digit in the first word of xd?
    if (i < 0) {
      i += LOG_BASE;
      j = sd;
      w = xd[xdi = 0];
    } else {
      xdi = Math.ceil((i + 1) / LOG_BASE);
      k = xd.length;
      if (xdi >= k) return x;
      w = k = xd[xdi];

      // Get the number of digits of w.
      for (n = 1; k >= 10; k /= 10) n++;

      // Get the index of rd within w.
      i %= LOG_BASE;

      // Get the index of rd within w, adjusted for leading zeros.
      // The number of leading zeros of w is given by LOG_BASE - n.
      j = i - LOG_BASE + n;
    }

    if (rm !== void 0) {
      k = mathpow(10, n - j - 1);

      // Get the rounding digit at index j of w.
      rd = w / k % 10 | 0;

      // Are there any non-zero digits after the rounding digit?
      doRound = sd < 0 || xd[xdi + 1] !== void 0 || w % k;

      // The expression `w % mathpow(10, n - j - 1)` returns all the digits of w to the right of the
      // digit at (left-to-right) index j, e.g. if w is 908714 and j is 2, the expression will give
      // 714.

      doRound = rm < 4
        ? (rd || doRound) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
        : rd > 5 || rd == 5 && (rm == 4 || doRound || rm == 6 &&

          // Check whether the digit to the left of the rounding digit is odd.
          ((i > 0 ? j > 0 ? w / mathpow(10, n - j) : 0 : xd[xdi - 1]) % 10) & 1 ||
            rm == (x.s < 0 ? 8 : 7));
    }

    if (sd < 1 || !xd[0]) {
      if (doRound) {
        k = getBase10Exponent(x);
        xd.length = 1;

        // Convert sd to decimal places.
        sd = sd - k - 1;

        // 1, 0.1, 0.01, 0.001, 0.0001 etc.
        xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
        x.e = mathfloor(-sd / LOG_BASE) || 0;
      } else {
        xd.length = 1;

        // Zero.
        xd[0] = x.e = x.s = 0;
      }

      return x;
    }

    // Remove excess digits.
    if (i == 0) {
      xd.length = xdi;
      k = 1;
      xdi--;
    } else {
      xd.length = xdi + 1;
      k = mathpow(10, LOG_BASE - i);

      // E.g. 56700 becomes 56000 if 7 is the rounding digit.
      // j > 0 means i > number of leading zeros of w.
      xd[xdi] = j > 0 ? (w / mathpow(10, n - j) % mathpow(10, j) | 0) * k : 0;
    }

    if (doRound) {
      for (;;) {

        // Is the digit to be rounded up in the first word of xd?
        if (xdi == 0) {
          if ((xd[0] += k) == BASE) {
            xd[0] = 1;
            ++x.e;
          }

          break;
        } else {
          xd[xdi] += k;
          if (xd[xdi] != BASE) break;
          xd[xdi--] = 0;
          k = 1;
        }
      }
    }

    // Remove trailing zeros.
    for (i = xd.length; xd[--i] === 0;) xd.pop();

    if (external && (x.e > MAX_E || x.e < -MAX_E)) {
      throw Error(exponentOutOfRange + getBase10Exponent(x));
    }

    return x;
  }


  function subtract(x, y) {
    var d, e, i, j, k, len, xd, xe, xLTy, yd,
      Ctor = x.constructor,
      pr = Ctor.precision;

    // Return y negated if x is zero.
    // Return x if y is zero and x is non-zero.
    if (!x.s || !y.s) {
      if (y.s) y.s = -y.s;
      else y = new Ctor(x);
      return external ? round(y, pr) : y;
    }

    xd = x.d;
    yd = y.d;

    // x and y are non-zero numbers with the same sign.

    e = y.e;
    xe = x.e;
    xd = xd.slice();
    k = xe - e;

    // If exponents differ...
    if (k) {
      xLTy = k < 0;

      if (xLTy) {
        d = xd;
        k = -k;
        len = yd.length;
      } else {
        d = yd;
        e = xe;
        len = xd.length;
      }

      // Numbers with massively different exponents would result in a very high number of zeros
      // needing to be prepended, but this can be avoided while still ensuring correct rounding by
      // limiting the number of zeros to `Math.ceil(pr / LOG_BASE) + 2`.
      i = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;

      if (k > i) {
        k = i;
        d.length = 1;
      }

      // Prepend zeros to equalise exponents.
      d.reverse();
      for (i = k; i--;) d.push(0);
      d.reverse();

    // Base 1e7 exponents equal.
    } else {

      // Check digits to determine which is the bigger number.

      i = xd.length;
      len = yd.length;
      xLTy = i < len;
      if (xLTy) len = i;

      for (i = 0; i < len; i++) {
        if (xd[i] != yd[i]) {
          xLTy = xd[i] < yd[i];
          break;
        }
      }

      k = 0;
    }

    if (xLTy) {
      d = xd;
      xd = yd;
      yd = d;
      y.s = -y.s;
    }

    len = xd.length;

    // Append zeros to xd if shorter.
    // Don't add zeros to yd if shorter as subtraction only needs to start at yd length.
    for (i = yd.length - len; i > 0; --i) xd[len++] = 0;

    // Subtract yd from xd.
    for (i = yd.length; i > k;) {
      if (xd[--i] < yd[i]) {
        for (j = i; j && xd[--j] === 0;) xd[j] = BASE - 1;
        --xd[j];
        xd[i] += BASE;
      }

      xd[i] -= yd[i];
    }

    // Remove trailing zeros.
    for (; xd[--len] === 0;) xd.pop();

    // Remove leading zeros and adjust exponent accordingly.
    for (; xd[0] === 0; xd.shift()) --e;

    // Zero?
    if (!xd[0]) return new Ctor(0);

    y.d = xd;
    y.e = e;

    //return external && xd.length >= pr / LOG_BASE ? round(y, pr) : y;
    return external ? round(y, pr) : y;
  }


  function toString(x, isExp, sd) {
    var k,
      e = getBase10Exponent(x),
      str = digitsToString(x.d),
      len = str.length;

    if (isExp) {
      if (sd && (k = sd - len) > 0) {
        str = str.charAt(0) + '.' + str.slice(1) + getZeroString(k);
      } else if (len > 1) {
        str = str.charAt(0) + '.' + str.slice(1);
      }

      str = str + (e < 0 ? 'e' : 'e+') + e;
    } else if (e < 0) {
      str = '0.' + getZeroString(-e - 1) + str;
      if (sd && (k = sd - len) > 0) str += getZeroString(k);
    } else if (e >= len) {
      str += getZeroString(e + 1 - len);
      if (sd && (k = sd - e - 1) > 0) str = str + '.' + getZeroString(k);
    } else {
      if ((k = e + 1) < len) str = str.slice(0, k) + '.' + str.slice(k);
      if (sd && (k = sd - len) > 0) {
        if (e + 1 === len) str += '.';
        str += getZeroString(k);
      }
    }

    return x.s < 0 ? '-' + str : str;
  }


  // Does not strip trailing zeros.
  function truncate(arr, len) {
    if (arr.length > len) {
      arr.length = len;
      return true;
    }
  }


  // Decimal methods


  /*
   *  clone
   *  config/set
   */


  /*
   * Create and return a Decimal constructor with the same configuration properties as this Decimal
   * constructor.
   *
   */
  function clone(obj) {
    var i, p, ps;

    /*
     * The Decimal constructor and exported function.
     * Return a new Decimal instance.
     *
     * value {number|string|Decimal} A numeric value.
     *
     */
    function Decimal(value) {
      var x = this;

      // Decimal called without new.
      if (!(x instanceof Decimal)) return new Decimal(value);

      // Retain a reference to this Decimal constructor, and shadow Decimal.prototype.constructor
      // which points to Object.
      x.constructor = Decimal;

      // Duplicate.
      if (value instanceof Decimal) {
        x.s = value.s;
        x.e = value.e;
        x.d = (value = value.d) ? value.slice() : value;
        return;
      }

      if (typeof value === 'number') {

        // Reject Infinity/NaN.
        if (value * 0 !== 0) {
          throw Error(invalidArgument + value);
        }

        if (value > 0) {
          x.s = 1;
        } else if (value < 0) {
          value = -value;
          x.s = -1;
        } else {
          x.s = 0;
          x.e = 0;
          x.d = [0];
          return;
        }

        // Fast path for small integers.
        if (value === ~~value && value < 1e7) {
          x.e = 0;
          x.d = [value];
          return;
        }

        return parseDecimal(x, value.toString());
      } else if (typeof value !== 'string') {
        throw Error(invalidArgument + value);
      }

      // Minus sign?
      if (value.charCodeAt(0) === 45) {
        value = value.slice(1);
        x.s = -1;
      } else {
        x.s = 1;
      }

      if (isDecimal.test(value)) parseDecimal(x, value);
      else throw Error(invalidArgument + value);
    }

    Decimal.prototype = P;

    Decimal.ROUND_UP = 0;
    Decimal.ROUND_DOWN = 1;
    Decimal.ROUND_CEIL = 2;
    Decimal.ROUND_FLOOR = 3;
    Decimal.ROUND_HALF_UP = 4;
    Decimal.ROUND_HALF_DOWN = 5;
    Decimal.ROUND_HALF_EVEN = 6;
    Decimal.ROUND_HALF_CEIL = 7;
    Decimal.ROUND_HALF_FLOOR = 8;

    Decimal.clone = clone;
    Decimal.config = Decimal.set = config;

    if (obj === void 0) obj = {};
    if (obj) {
      ps = ['precision', 'rounding', 'toExpNeg', 'toExpPos', 'LN10'];
      for (i = 0; i < ps.length;) if (!obj.hasOwnProperty(p = ps[i++])) obj[p] = this[p];
    }

    Decimal.config(obj);

    return Decimal;
  }


  /*
   * Configure global settings for a Decimal constructor.
   *
   * `obj` is an object with one or more of the following properties,
   *
   *   precision  {number}
   *   rounding   {number}
   *   toExpNeg   {number}
   *   toExpPos   {number}
   *
   * E.g. Decimal.config({ precision: 20, rounding: 4 })
   *
   */
  function config(obj) {
    if (!obj || typeof obj !== 'object') {
      throw Error(decimalError + 'Object expected');
    }
    var i, p, v,
      ps = [
        'precision', 1, MAX_DIGITS,
        'rounding', 0, 8,
        'toExpNeg', -1 / 0, 0,
        'toExpPos', 0, 1 / 0
      ];

    for (i = 0; i < ps.length; i += 3) {
      if ((v = obj[p = ps[i]]) !== void 0) {
        if (mathfloor(v) === v && v >= ps[i + 1] && v <= ps[i + 2]) this[p] = v;
        else throw Error(invalidArgument + p + ': ' + v);
      }
    }

    if ((v = obj[p = 'LN10']) !== void 0) {
        if (v == Math.LN10) this[p] = new this(v);
        else throw Error(invalidArgument + p + ': ' + v);
    }

    return this;
  }


  // Create and configure initial Decimal constructor.
  Decimal = clone(Decimal);

  Decimal['default'] = Decimal.Decimal = Decimal;

  // Internal constant.
  ONE = new Decimal(1);


  // Export.


  // AMD.
  if (true) {
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
      return Decimal;
    }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

  // Node and other environments that support module.exports.
  } else {}
})(this);


/***/ }),

/***/ "./node_modules/eventemitter3/index.js":
/*!*********************************************!*\
  !*** ./node_modules/eventemitter3/index.js ***!
  \*********************************************/
/***/ ((module) => {

"use strict";


var has = Object.prototype.hasOwnProperty
  , prefix = '~';

/**
 * Constructor to create a storage for our `EE` objects.
 * An `Events` instance is a plain object whose properties are event names.
 *
 * @constructor
 * @private
 */
function Events() {}

//
// We try to not inherit from `Object.prototype`. In some engines creating an
// instance in this way is faster than calling `Object.create(null)` directly.
// If `Object.create(null)` is not supported we prefix the event names with a
// character to make sure that the built-in object properties are not
// overridden or used as an attack vector.
//
if (Object.create) {
  Events.prototype = Object.create(null);

  //
  // This hack is needed because the `__proto__` property is still inherited in
  // some old browsers like Android 4, iPhone 5.1, Opera 11 and Safari 5.
  //
  if (!new Events().__proto__) prefix = false;
}

/**
 * Representation of a single event listener.
 *
 * @param {Function} fn The listener function.
 * @param {*} context The context to invoke the listener with.
 * @param {Boolean} [once=false] Specify if the listener is a one-time listener.
 * @constructor
 * @private
 */
function EE(fn, context, once) {
  this.fn = fn;
  this.context = context;
  this.once = once || false;
}

/**
 * Add a listener for a given event.
 *
 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} context The context to invoke the listener with.
 * @param {Boolean} once Specify if the listener is a one-time listener.
 * @returns {EventEmitter}
 * @private
 */
function addListener(emitter, event, fn, context, once) {
  if (typeof fn !== 'function') {
    throw new TypeError('The listener must be a function');
  }

  var listener = new EE(fn, context || emitter, once)
    , evt = prefix ? prefix + event : event;

  if (!emitter._events[evt]) emitter._events[evt] = listener, emitter._eventsCount++;
  else if (!emitter._events[evt].fn) emitter._events[evt].push(listener);
  else emitter._events[evt] = [emitter._events[evt], listener];

  return emitter;
}

/**
 * Clear event by name.
 *
 * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.
 * @param {(String|Symbol)} evt The Event name.
 * @private
 */
function clearEvent(emitter, evt) {
  if (--emitter._eventsCount === 0) emitter._events = new Events();
  else delete emitter._events[evt];
}

/**
 * Minimal `EventEmitter` interface that is molded against the Node.js
 * `EventEmitter` interface.
 *
 * @constructor
 * @public
 */
function EventEmitter() {
  this._events = new Events();
  this._eventsCount = 0;
}

/**
 * Return an array listing the events for which the emitter has registered
 * listeners.
 *
 * @returns {Array}
 * @public
 */
EventEmitter.prototype.eventNames = function eventNames() {
  var names = []
    , events
    , name;

  if (this._eventsCount === 0) return names;

  for (name in (events = this._events)) {
    if (has.call(events, name)) names.push(prefix ? name.slice(1) : name);
  }

  if (Object.getOwnPropertySymbols) {
    return names.concat(Object.getOwnPropertySymbols(events));
  }

  return names;
};

/**
 * Return the listeners registered for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Array} The registered listeners.
 * @public
 */
EventEmitter.prototype.listeners = function listeners(event) {
  var evt = prefix ? prefix + event : event
    , handlers = this._events[evt];

  if (!handlers) return [];
  if (handlers.fn) return [handlers.fn];

  for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {
    ee[i] = handlers[i].fn;
  }

  return ee;
};

/**
 * Return the number of listeners listening to a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Number} The number of listeners.
 * @public
 */
EventEmitter.prototype.listenerCount = function listenerCount(event) {
  var evt = prefix ? prefix + event : event
    , listeners = this._events[evt];

  if (!listeners) return 0;
  if (listeners.fn) return 1;
  return listeners.length;
};

/**
 * Calls each of the listeners registered for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @returns {Boolean} `true` if the event had listeners, else `false`.
 * @public
 */
EventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {
  var evt = prefix ? prefix + event : event;

  if (!this._events[evt]) return false;

  var listeners = this._events[evt]
    , len = arguments.length
    , args
    , i;

  if (listeners.fn) {
    if (listeners.once) this.removeListener(event, listeners.fn, undefined, true);

    switch (len) {
      case 1: return listeners.fn.call(listeners.context), true;
      case 2: return listeners.fn.call(listeners.context, a1), true;
      case 3: return listeners.fn.call(listeners.context, a1, a2), true;
      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;
      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;
      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;
    }

    for (i = 1, args = new Array(len -1); i < len; i++) {
      args[i - 1] = arguments[i];
    }

    listeners.fn.apply(listeners.context, args);
  } else {
    var length = listeners.length
      , j;

    for (i = 0; i < length; i++) {
      if (listeners[i].once) this.removeListener(event, listeners[i].fn, undefined, true);

      switch (len) {
        case 1: listeners[i].fn.call(listeners[i].context); break;
        case 2: listeners[i].fn.call(listeners[i].context, a1); break;
        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;
        case 4: listeners[i].fn.call(listeners[i].context, a1, a2, a3); break;
        default:
          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {
            args[j - 1] = arguments[j];
          }

          listeners[i].fn.apply(listeners[i].context, args);
      }
    }
  }

  return true;
};

/**
 * Add a listener for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} [context=this] The context to invoke the listener with.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.on = function on(event, fn, context) {
  return addListener(this, event, fn, context, false);
};

/**
 * Add a one-time listener for a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn The listener function.
 * @param {*} [context=this] The context to invoke the listener with.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.once = function once(event, fn, context) {
  return addListener(this, event, fn, context, true);
};

/**
 * Remove the listeners of a given event.
 *
 * @param {(String|Symbol)} event The event name.
 * @param {Function} fn Only remove the listeners that match this function.
 * @param {*} context Only remove the listeners that have this context.
 * @param {Boolean} once Only remove one-time listeners.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.removeListener = function removeListener(event, fn, context, once) {
  var evt = prefix ? prefix + event : event;

  if (!this._events[evt]) return this;
  if (!fn) {
    clearEvent(this, evt);
    return this;
  }

  var listeners = this._events[evt];

  if (listeners.fn) {
    if (
      listeners.fn === fn &&
      (!once || listeners.once) &&
      (!context || listeners.context === context)
    ) {
      clearEvent(this, evt);
    }
  } else {
    for (var i = 0, events = [], length = listeners.length; i < length; i++) {
      if (
        listeners[i].fn !== fn ||
        (once && !listeners[i].once) ||
        (context && listeners[i].context !== context)
      ) {
        events.push(listeners[i]);
      }
    }

    //
    // Reset the array, or remove it completely if we have no more listeners.
    //
    if (events.length) this._events[evt] = events.length === 1 ? events[0] : events;
    else clearEvent(this, evt);
  }

  return this;
};

/**
 * Remove all listeners, or those of the specified event.
 *
 * @param {(String|Symbol)} [event] The event name.
 * @returns {EventEmitter} `this`.
 * @public
 */
EventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {
  var evt;

  if (event) {
    evt = prefix ? prefix + event : event;
    if (this._events[evt]) clearEvent(this, evt);
  } else {
    this._events = new Events();
    this._eventsCount = 0;
  }

  return this;
};

//
// Alias methods names because people roll like that.
//
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.addListener = EventEmitter.prototype.on;

//
// Expose the prefix.
//
EventEmitter.prefixed = prefix;

//
// Allow `EventEmitter` to be imported as module namespace.
//
EventEmitter.EventEmitter = EventEmitter;

//
// Expose the module.
//
if (true) {
  module.exports = EventEmitter;
}


/***/ }),

/***/ "./node_modules/lodash/_DataView.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_DataView.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ }),

/***/ "./node_modules/lodash/_Hash.js":
/*!**************************************!*\
  !*** ./node_modules/lodash/_Hash.js ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hashClear = __webpack_require__(/*! ./_hashClear */ "./node_modules/lodash/_hashClear.js"),
    hashDelete = __webpack_require__(/*! ./_hashDelete */ "./node_modules/lodash/_hashDelete.js"),
    hashGet = __webpack_require__(/*! ./_hashGet */ "./node_modules/lodash/_hashGet.js"),
    hashHas = __webpack_require__(/*! ./_hashHas */ "./node_modules/lodash/_hashHas.js"),
    hashSet = __webpack_require__(/*! ./_hashSet */ "./node_modules/lodash/_hashSet.js");

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),

/***/ "./node_modules/lodash/_ListCache.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_ListCache.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var listCacheClear = __webpack_require__(/*! ./_listCacheClear */ "./node_modules/lodash/_listCacheClear.js"),
    listCacheDelete = __webpack_require__(/*! ./_listCacheDelete */ "./node_modules/lodash/_listCacheDelete.js"),
    listCacheGet = __webpack_require__(/*! ./_listCacheGet */ "./node_modules/lodash/_listCacheGet.js"),
    listCacheHas = __webpack_require__(/*! ./_listCacheHas */ "./node_modules/lodash/_listCacheHas.js"),
    listCacheSet = __webpack_require__(/*! ./_listCacheSet */ "./node_modules/lodash/_listCacheSet.js");

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),

/***/ "./node_modules/lodash/_Map.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/_Map.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ }),

/***/ "./node_modules/lodash/_MapCache.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_MapCache.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var mapCacheClear = __webpack_require__(/*! ./_mapCacheClear */ "./node_modules/lodash/_mapCacheClear.js"),
    mapCacheDelete = __webpack_require__(/*! ./_mapCacheDelete */ "./node_modules/lodash/_mapCacheDelete.js"),
    mapCacheGet = __webpack_require__(/*! ./_mapCacheGet */ "./node_modules/lodash/_mapCacheGet.js"),
    mapCacheHas = __webpack_require__(/*! ./_mapCacheHas */ "./node_modules/lodash/_mapCacheHas.js"),
    mapCacheSet = __webpack_require__(/*! ./_mapCacheSet */ "./node_modules/lodash/_mapCacheSet.js");

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),

/***/ "./node_modules/lodash/_Promise.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_Promise.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ }),

/***/ "./node_modules/lodash/_Set.js":
/*!*************************************!*\
  !*** ./node_modules/lodash/_Set.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var Set = getNative(root, 'Set');

module.exports = Set;


/***/ }),

/***/ "./node_modules/lodash/_SetCache.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_SetCache.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var MapCache = __webpack_require__(/*! ./_MapCache */ "./node_modules/lodash/_MapCache.js"),
    setCacheAdd = __webpack_require__(/*! ./_setCacheAdd */ "./node_modules/lodash/_setCacheAdd.js"),
    setCacheHas = __webpack_require__(/*! ./_setCacheHas */ "./node_modules/lodash/_setCacheHas.js");

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

module.exports = SetCache;


/***/ }),

/***/ "./node_modules/lodash/_Stack.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/_Stack.js ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(/*! ./_ListCache */ "./node_modules/lodash/_ListCache.js"),
    stackClear = __webpack_require__(/*! ./_stackClear */ "./node_modules/lodash/_stackClear.js"),
    stackDelete = __webpack_require__(/*! ./_stackDelete */ "./node_modules/lodash/_stackDelete.js"),
    stackGet = __webpack_require__(/*! ./_stackGet */ "./node_modules/lodash/_stackGet.js"),
    stackHas = __webpack_require__(/*! ./_stackHas */ "./node_modules/lodash/_stackHas.js"),
    stackSet = __webpack_require__(/*! ./_stackSet */ "./node_modules/lodash/_stackSet.js");

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ }),

/***/ "./node_modules/lodash/_Symbol.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_Symbol.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),

/***/ "./node_modules/lodash/_Uint8Array.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_Uint8Array.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),

/***/ "./node_modules/lodash/_WeakMap.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_WeakMap.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js"),
    root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ }),

/***/ "./node_modules/lodash/_apply.js":
/*!***************************************!*\
  !*** ./node_modules/lodash/_apply.js ***!
  \***************************************/
/***/ ((module) => {

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

module.exports = apply;


/***/ }),

/***/ "./node_modules/lodash/_arrayEvery.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_arrayEvery.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.every` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if all elements pass the predicate check,
 *  else `false`.
 */
function arrayEvery(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (!predicate(array[index], index, array)) {
      return false;
    }
  }
  return true;
}

module.exports = arrayEvery;


/***/ }),

/***/ "./node_modules/lodash/_arrayFilter.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_arrayFilter.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ }),

/***/ "./node_modules/lodash/_arrayIncludes.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_arrayIncludes.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIndexOf = __webpack_require__(/*! ./_baseIndexOf */ "./node_modules/lodash/_baseIndexOf.js");

/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && baseIndexOf(array, value, 0) > -1;
}

module.exports = arrayIncludes;


/***/ }),

/***/ "./node_modules/lodash/_arrayIncludesWith.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash/_arrayIncludesWith.js ***!
  \***************************************************/
/***/ ((module) => {

/**
 * This function is like `arrayIncludes` except that it accepts a comparator.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @param {Function} comparator The comparator invoked per element.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludesWith(array, value, comparator) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (comparator(value, array[index])) {
      return true;
    }
  }
  return false;
}

module.exports = arrayIncludesWith;


/***/ }),

/***/ "./node_modules/lodash/_arrayLikeKeys.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_arrayLikeKeys.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTimes = __webpack_require__(/*! ./_baseTimes */ "./node_modules/lodash/_baseTimes.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "./node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "./node_modules/lodash/isBuffer.js"),
    isIndex = __webpack_require__(/*! ./_isIndex */ "./node_modules/lodash/_isIndex.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "./node_modules/lodash/isTypedArray.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),

/***/ "./node_modules/lodash/_arrayMap.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_arrayMap.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ }),

/***/ "./node_modules/lodash/_arrayPush.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_arrayPush.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),

/***/ "./node_modules/lodash/_arraySome.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_arraySome.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ "./node_modules/lodash/_asciiToArray.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_asciiToArray.js ***!
  \**********************************************/
/***/ ((module) => {

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

module.exports = asciiToArray;


/***/ }),

/***/ "./node_modules/lodash/_assocIndexOf.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_assocIndexOf.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(/*! ./eq */ "./node_modules/lodash/eq.js");

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),

/***/ "./node_modules/lodash/_baseAssignValue.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseAssignValue.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var defineProperty = __webpack_require__(/*! ./_defineProperty */ "./node_modules/lodash/_defineProperty.js");

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ }),

/***/ "./node_modules/lodash/_baseEach.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseEach.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseForOwn = __webpack_require__(/*! ./_baseForOwn */ "./node_modules/lodash/_baseForOwn.js"),
    createBaseEach = __webpack_require__(/*! ./_createBaseEach */ "./node_modules/lodash/_createBaseEach.js");

/**
 * The base implementation of `_.forEach` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 */
var baseEach = createBaseEach(baseForOwn);

module.exports = baseEach;


/***/ }),

/***/ "./node_modules/lodash/_baseEvery.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseEvery.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseEach = __webpack_require__(/*! ./_baseEach */ "./node_modules/lodash/_baseEach.js");

/**
 * The base implementation of `_.every` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if all elements pass the predicate check,
 *  else `false`
 */
function baseEvery(collection, predicate) {
  var result = true;
  baseEach(collection, function(value, index, collection) {
    result = !!predicate(value, index, collection);
    return result;
  });
  return result;
}

module.exports = baseEvery;


/***/ }),

/***/ "./node_modules/lodash/_baseExtremum.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseExtremum.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/**
 * The base implementation of methods like `_.max` and `_.min` which accepts a
 * `comparator` to determine the extremum value.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} iteratee The iteratee invoked per iteration.
 * @param {Function} comparator The comparator used to compare values.
 * @returns {*} Returns the extremum value.
 */
function baseExtremum(array, iteratee, comparator) {
  var index = -1,
      length = array.length;

  while (++index < length) {
    var value = array[index],
        current = iteratee(value);

    if (current != null && (computed === undefined
          ? (current === current && !isSymbol(current))
          : comparator(current, computed)
        )) {
      var computed = current,
          result = value;
    }
  }
  return result;
}

module.exports = baseExtremum;


/***/ }),

/***/ "./node_modules/lodash/_baseFindIndex.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_baseFindIndex.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.findIndex` and `_.findLastIndex` without
 * support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} predicate The function invoked per iteration.
 * @param {number} fromIndex The index to search from.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseFindIndex(array, predicate, fromIndex, fromRight) {
  var length = array.length,
      index = fromIndex + (fromRight ? 1 : -1);

  while ((fromRight ? index-- : ++index < length)) {
    if (predicate(array[index], index, array)) {
      return index;
    }
  }
  return -1;
}

module.exports = baseFindIndex;


/***/ }),

/***/ "./node_modules/lodash/_baseFlatten.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseFlatten.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayPush = __webpack_require__(/*! ./_arrayPush */ "./node_modules/lodash/_arrayPush.js"),
    isFlattenable = __webpack_require__(/*! ./_isFlattenable */ "./node_modules/lodash/_isFlattenable.js");

/**
 * The base implementation of `_.flatten` with support for restricting flattening.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {number} depth The maximum recursion depth.
 * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
 * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, depth, predicate, isStrict, result) {
  var index = -1,
      length = array.length;

  predicate || (predicate = isFlattenable);
  result || (result = []);

  while (++index < length) {
    var value = array[index];
    if (depth > 0 && predicate(value)) {
      if (depth > 1) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, depth - 1, predicate, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;


/***/ }),

/***/ "./node_modules/lodash/_baseFor.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseFor.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var createBaseFor = __webpack_require__(/*! ./_createBaseFor */ "./node_modules/lodash/_createBaseFor.js");

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ }),

/***/ "./node_modules/lodash/_baseForOwn.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseForOwn.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFor = __webpack_require__(/*! ./_baseFor */ "./node_modules/lodash/_baseFor.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

module.exports = baseForOwn;


/***/ }),

/***/ "./node_modules/lodash/_baseGet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseGet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var castPath = __webpack_require__(/*! ./_castPath */ "./node_modules/lodash/_castPath.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ }),

/***/ "./node_modules/lodash/_baseGetAllKeys.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_baseGetAllKeys.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayPush = __webpack_require__(/*! ./_arrayPush */ "./node_modules/lodash/_arrayPush.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ }),

/***/ "./node_modules/lodash/_baseGetTag.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseGetTag.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    getRawTag = __webpack_require__(/*! ./_getRawTag */ "./node_modules/lodash/_getRawTag.js"),
    objectToString = __webpack_require__(/*! ./_objectToString */ "./node_modules/lodash/_objectToString.js");

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),

/***/ "./node_modules/lodash/_baseGt.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_baseGt.js ***!
  \****************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.gt` which doesn't coerce arguments.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if `value` is greater than `other`,
 *  else `false`.
 */
function baseGt(value, other) {
  return value > other;
}

module.exports = baseGt;


/***/ }),

/***/ "./node_modules/lodash/_baseHasIn.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseHasIn.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

module.exports = baseHasIn;


/***/ }),

/***/ "./node_modules/lodash/_baseIndexOf.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIndexOf.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseFindIndex = __webpack_require__(/*! ./_baseFindIndex */ "./node_modules/lodash/_baseFindIndex.js"),
    baseIsNaN = __webpack_require__(/*! ./_baseIsNaN */ "./node_modules/lodash/_baseIsNaN.js"),
    strictIndexOf = __webpack_require__(/*! ./_strictIndexOf */ "./node_modules/lodash/_strictIndexOf.js");

/**
 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function baseIndexOf(array, value, fromIndex) {
  return value === value
    ? strictIndexOf(array, value, fromIndex)
    : baseFindIndex(array, baseIsNaN, fromIndex);
}

module.exports = baseIndexOf;


/***/ }),

/***/ "./node_modules/lodash/_baseIsArguments.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseIsArguments.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),

/***/ "./node_modules/lodash/_baseIsEqual.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIsEqual.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqualDeep = __webpack_require__(/*! ./_baseIsEqualDeep */ "./node_modules/lodash/_baseIsEqualDeep.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),

/***/ "./node_modules/lodash/_baseIsEqualDeep.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseIsEqualDeep.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "./node_modules/lodash/_Stack.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "./node_modules/lodash/_equalArrays.js"),
    equalByTag = __webpack_require__(/*! ./_equalByTag */ "./node_modules/lodash/_equalByTag.js"),
    equalObjects = __webpack_require__(/*! ./_equalObjects */ "./node_modules/lodash/_equalObjects.js"),
    getTag = __webpack_require__(/*! ./_getTag */ "./node_modules/lodash/_getTag.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isBuffer = __webpack_require__(/*! ./isBuffer */ "./node_modules/lodash/isBuffer.js"),
    isTypedArray = __webpack_require__(/*! ./isTypedArray */ "./node_modules/lodash/isTypedArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),

/***/ "./node_modules/lodash/_baseIsMatch.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseIsMatch.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(/*! ./_Stack */ "./node_modules/lodash/_Stack.js"),
    baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "./node_modules/lodash/_baseIsEqual.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

module.exports = baseIsMatch;


/***/ }),

/***/ "./node_modules/lodash/_baseIsNaN.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseIsNaN.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.isNaN` without support for number objects.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
 */
function baseIsNaN(value) {
  return value !== value;
}

module.exports = baseIsNaN;


/***/ }),

/***/ "./node_modules/lodash/_baseIsNative.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseIsNative.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isFunction = __webpack_require__(/*! ./isFunction */ "./node_modules/lodash/isFunction.js"),
    isMasked = __webpack_require__(/*! ./_isMasked */ "./node_modules/lodash/_isMasked.js"),
    isObject = __webpack_require__(/*! ./isObject */ "./node_modules/lodash/isObject.js"),
    toSource = __webpack_require__(/*! ./_toSource */ "./node_modules/lodash/_toSource.js");

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ }),

/***/ "./node_modules/lodash/_baseIsTypedArray.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_baseIsTypedArray.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    isLength = __webpack_require__(/*! ./isLength */ "./node_modules/lodash/isLength.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "./node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ }),

/***/ "./node_modules/lodash/_baseIteratee.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseIteratee.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseMatches = __webpack_require__(/*! ./_baseMatches */ "./node_modules/lodash/_baseMatches.js"),
    baseMatchesProperty = __webpack_require__(/*! ./_baseMatchesProperty */ "./node_modules/lodash/_baseMatchesProperty.js"),
    identity = __webpack_require__(/*! ./identity */ "./node_modules/lodash/identity.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    property = __webpack_require__(/*! ./property */ "./node_modules/lodash/property.js");

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

module.exports = baseIteratee;


/***/ }),

/***/ "./node_modules/lodash/_baseKeys.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseKeys.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isPrototype = __webpack_require__(/*! ./_isPrototype */ "./node_modules/lodash/_isPrototype.js"),
    nativeKeys = __webpack_require__(/*! ./_nativeKeys */ "./node_modules/lodash/_nativeKeys.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ }),

/***/ "./node_modules/lodash/_baseLt.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_baseLt.js ***!
  \****************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.lt` which doesn't coerce arguments.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if `value` is less than `other`,
 *  else `false`.
 */
function baseLt(value, other) {
  return value < other;
}

module.exports = baseLt;


/***/ }),

/***/ "./node_modules/lodash/_baseMap.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_baseMap.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseEach = __webpack_require__(/*! ./_baseEach */ "./node_modules/lodash/_baseEach.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * The base implementation of `_.map` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = isArrayLike(collection) ? Array(collection.length) : [];

  baseEach(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

module.exports = baseMap;


/***/ }),

/***/ "./node_modules/lodash/_baseMatches.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseMatches.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsMatch = __webpack_require__(/*! ./_baseIsMatch */ "./node_modules/lodash/_baseIsMatch.js"),
    getMatchData = __webpack_require__(/*! ./_getMatchData */ "./node_modules/lodash/_getMatchData.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "./node_modules/lodash/_matchesStrictComparable.js");

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}

module.exports = baseMatches;


/***/ }),

/***/ "./node_modules/lodash/_baseMatchesProperty.js":
/*!*****************************************************!*\
  !*** ./node_modules/lodash/_baseMatchesProperty.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(/*! ./_baseIsEqual */ "./node_modules/lodash/_baseIsEqual.js"),
    get = __webpack_require__(/*! ./get */ "./node_modules/lodash/get.js"),
    hasIn = __webpack_require__(/*! ./hasIn */ "./node_modules/lodash/hasIn.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "./node_modules/lodash/_isKey.js"),
    isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "./node_modules/lodash/_isStrictComparable.js"),
    matchesStrictComparable = __webpack_require__(/*! ./_matchesStrictComparable */ "./node_modules/lodash/_matchesStrictComparable.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? hasIn(object, path)
      : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}

module.exports = baseMatchesProperty;


/***/ }),

/***/ "./node_modules/lodash/_baseOrderBy.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_baseOrderBy.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayMap = __webpack_require__(/*! ./_arrayMap */ "./node_modules/lodash/_arrayMap.js"),
    baseGet = __webpack_require__(/*! ./_baseGet */ "./node_modules/lodash/_baseGet.js"),
    baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "./node_modules/lodash/_baseIteratee.js"),
    baseMap = __webpack_require__(/*! ./_baseMap */ "./node_modules/lodash/_baseMap.js"),
    baseSortBy = __webpack_require__(/*! ./_baseSortBy */ "./node_modules/lodash/_baseSortBy.js"),
    baseUnary = __webpack_require__(/*! ./_baseUnary */ "./node_modules/lodash/_baseUnary.js"),
    compareMultiple = __webpack_require__(/*! ./_compareMultiple */ "./node_modules/lodash/_compareMultiple.js"),
    identity = __webpack_require__(/*! ./identity */ "./node_modules/lodash/identity.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/**
 * The base implementation of `_.orderBy` without param guards.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
 * @param {string[]} orders The sort orders of `iteratees`.
 * @returns {Array} Returns the new sorted array.
 */
function baseOrderBy(collection, iteratees, orders) {
  if (iteratees.length) {
    iteratees = arrayMap(iteratees, function(iteratee) {
      if (isArray(iteratee)) {
        return function(value) {
          return baseGet(value, iteratee.length === 1 ? iteratee[0] : iteratee);
        }
      }
      return iteratee;
    });
  } else {
    iteratees = [identity];
  }

  var index = -1;
  iteratees = arrayMap(iteratees, baseUnary(baseIteratee));

  var result = baseMap(collection, function(value, key, collection) {
    var criteria = arrayMap(iteratees, function(iteratee) {
      return iteratee(value);
    });
    return { 'criteria': criteria, 'index': ++index, 'value': value };
  });

  return baseSortBy(result, function(object, other) {
    return compareMultiple(object, other, orders);
  });
}

module.exports = baseOrderBy;


/***/ }),

/***/ "./node_modules/lodash/_baseProperty.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseProperty.js ***!
  \**********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

module.exports = baseProperty;


/***/ }),

/***/ "./node_modules/lodash/_basePropertyDeep.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_basePropertyDeep.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(/*! ./_baseGet */ "./node_modules/lodash/_baseGet.js");

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}

module.exports = basePropertyDeep;


/***/ }),

/***/ "./node_modules/lodash/_baseRange.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseRange.js ***!
  \*******************************************/
/***/ ((module) => {

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeCeil = Math.ceil,
    nativeMax = Math.max;

/**
 * The base implementation of `_.range` and `_.rangeRight` which doesn't
 * coerce arguments.
 *
 * @private
 * @param {number} start The start of the range.
 * @param {number} end The end of the range.
 * @param {number} step The value to increment or decrement by.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Array} Returns the range of numbers.
 */
function baseRange(start, end, step, fromRight) {
  var index = -1,
      length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
      result = Array(length);

  while (length--) {
    result[fromRight ? length : ++index] = start;
    start += step;
  }
  return result;
}

module.exports = baseRange;


/***/ }),

/***/ "./node_modules/lodash/_baseRest.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseRest.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var identity = __webpack_require__(/*! ./identity */ "./node_modules/lodash/identity.js"),
    overRest = __webpack_require__(/*! ./_overRest */ "./node_modules/lodash/_overRest.js"),
    setToString = __webpack_require__(/*! ./_setToString */ "./node_modules/lodash/_setToString.js");

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ }),

/***/ "./node_modules/lodash/_baseSetToString.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_baseSetToString.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var constant = __webpack_require__(/*! ./constant */ "./node_modules/lodash/constant.js"),
    defineProperty = __webpack_require__(/*! ./_defineProperty */ "./node_modules/lodash/_defineProperty.js"),
    identity = __webpack_require__(/*! ./identity */ "./node_modules/lodash/identity.js");

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty ? identity : function(func, string) {
  return defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

module.exports = baseSetToString;


/***/ }),

/***/ "./node_modules/lodash/_baseSlice.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseSlice.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

module.exports = baseSlice;


/***/ }),

/***/ "./node_modules/lodash/_baseSome.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseSome.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseEach = __webpack_require__(/*! ./_baseEach */ "./node_modules/lodash/_baseEach.js");

/**
 * The base implementation of `_.some` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function baseSome(collection, predicate) {
  var result;

  baseEach(collection, function(value, index, collection) {
    result = predicate(value, index, collection);
    return !result;
  });
  return !!result;
}

module.exports = baseSome;


/***/ }),

/***/ "./node_modules/lodash/_baseSortBy.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_baseSortBy.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.sortBy` which uses `comparer` to define the
 * sort order of `array` and replaces criteria objects with their corresponding
 * values.
 *
 * @private
 * @param {Array} array The array to sort.
 * @param {Function} comparer The function to define sort order.
 * @returns {Array} Returns `array`.
 */
function baseSortBy(array, comparer) {
  var length = array.length;

  array.sort(comparer);
  while (length--) {
    array[length] = array[length].value;
  }
  return array;
}

module.exports = baseSortBy;


/***/ }),

/***/ "./node_modules/lodash/_baseTimes.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseTimes.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ }),

/***/ "./node_modules/lodash/_baseToString.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_baseToString.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    arrayMap = __webpack_require__(/*! ./_arrayMap */ "./node_modules/lodash/_arrayMap.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ }),

/***/ "./node_modules/lodash/_baseTrim.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseTrim.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var trimmedEndIndex = __webpack_require__(/*! ./_trimmedEndIndex */ "./node_modules/lodash/_trimmedEndIndex.js");

/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

module.exports = baseTrim;


/***/ }),

/***/ "./node_modules/lodash/_baseUnary.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_baseUnary.js ***!
  \*******************************************/
/***/ ((module) => {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),

/***/ "./node_modules/lodash/_baseUniq.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_baseUniq.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "./node_modules/lodash/_SetCache.js"),
    arrayIncludes = __webpack_require__(/*! ./_arrayIncludes */ "./node_modules/lodash/_arrayIncludes.js"),
    arrayIncludesWith = __webpack_require__(/*! ./_arrayIncludesWith */ "./node_modules/lodash/_arrayIncludesWith.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "./node_modules/lodash/_cacheHas.js"),
    createSet = __webpack_require__(/*! ./_createSet */ "./node_modules/lodash/_createSet.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * The base implementation of `_.uniqBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns the new duplicate free array.
 */
function baseUniq(array, iteratee, comparator) {
  var index = -1,
      includes = arrayIncludes,
      length = array.length,
      isCommon = true,
      result = [],
      seen = result;

  if (comparator) {
    isCommon = false;
    includes = arrayIncludesWith;
  }
  else if (length >= LARGE_ARRAY_SIZE) {
    var set = iteratee ? null : createSet(array);
    if (set) {
      return setToArray(set);
    }
    isCommon = false;
    includes = cacheHas;
    seen = new SetCache;
  }
  else {
    seen = iteratee ? [] : result;
  }
  outer:
  while (++index < length) {
    var value = array[index],
        computed = iteratee ? iteratee(value) : value;

    value = (comparator || value !== 0) ? value : 0;
    if (isCommon && computed === computed) {
      var seenIndex = seen.length;
      while (seenIndex--) {
        if (seen[seenIndex] === computed) {
          continue outer;
        }
      }
      if (iteratee) {
        seen.push(computed);
      }
      result.push(value);
    }
    else if (!includes(seen, computed, comparator)) {
      if (seen !== result) {
        seen.push(computed);
      }
      result.push(value);
    }
  }
  return result;
}

module.exports = baseUniq;


/***/ }),

/***/ "./node_modules/lodash/_cacheHas.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_cacheHas.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),

/***/ "./node_modules/lodash/_castPath.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_castPath.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isKey = __webpack_require__(/*! ./_isKey */ "./node_modules/lodash/_isKey.js"),
    stringToPath = __webpack_require__(/*! ./_stringToPath */ "./node_modules/lodash/_stringToPath.js"),
    toString = __webpack_require__(/*! ./toString */ "./node_modules/lodash/toString.js");

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ }),

/***/ "./node_modules/lodash/_castSlice.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_castSlice.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseSlice = __webpack_require__(/*! ./_baseSlice */ "./node_modules/lodash/_baseSlice.js");

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : baseSlice(array, start, end);
}

module.exports = castSlice;


/***/ }),

/***/ "./node_modules/lodash/_compareAscending.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash/_compareAscending.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isSymbol = __webpack_require__(/*! ./isSymbol */ "./node_modules/lodash/isSymbol.js");

/**
 * Compares values to sort them in ascending order.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {number} Returns the sort order indicator for `value`.
 */
function compareAscending(value, other) {
  if (value !== other) {
    var valIsDefined = value !== undefined,
        valIsNull = value === null,
        valIsReflexive = value === value,
        valIsSymbol = isSymbol(value);

    var othIsDefined = other !== undefined,
        othIsNull = other === null,
        othIsReflexive = other === other,
        othIsSymbol = isSymbol(other);

    if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
        (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
        (valIsNull && othIsDefined && othIsReflexive) ||
        (!valIsDefined && othIsReflexive) ||
        !valIsReflexive) {
      return 1;
    }
    if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
        (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
        (othIsNull && valIsDefined && valIsReflexive) ||
        (!othIsDefined && valIsReflexive) ||
        !othIsReflexive) {
      return -1;
    }
  }
  return 0;
}

module.exports = compareAscending;


/***/ }),

/***/ "./node_modules/lodash/_compareMultiple.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_compareMultiple.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var compareAscending = __webpack_require__(/*! ./_compareAscending */ "./node_modules/lodash/_compareAscending.js");

/**
 * Used by `_.orderBy` to compare multiple properties of a value to another
 * and stable sort them.
 *
 * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
 * specify an order of "desc" for descending or "asc" for ascending sort order
 * of corresponding values.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {boolean[]|string[]} orders The order to sort by for each property.
 * @returns {number} Returns the sort order indicator for `object`.
 */
function compareMultiple(object, other, orders) {
  var index = -1,
      objCriteria = object.criteria,
      othCriteria = other.criteria,
      length = objCriteria.length,
      ordersLength = orders.length;

  while (++index < length) {
    var result = compareAscending(objCriteria[index], othCriteria[index]);
    if (result) {
      if (index >= ordersLength) {
        return result;
      }
      var order = orders[index];
      return result * (order == 'desc' ? -1 : 1);
    }
  }
  // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
  // that causes it, under certain circumstances, to provide the same value for
  // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
  // for more details.
  //
  // This also ensures a stable sort in V8 and other engines.
  // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
  return object.index - other.index;
}

module.exports = compareMultiple;


/***/ }),

/***/ "./node_modules/lodash/_coreJsData.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_coreJsData.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "./node_modules/lodash/_root.js");

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ }),

/***/ "./node_modules/lodash/_createBaseEach.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_createBaseEach.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js");

/**
 * Creates a `baseEach` or `baseEachRight` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!isArrayLike(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length,
        index = fromRight ? length : -1,
        iterable = Object(collection);

    while ((fromRight ? index-- : ++index < length)) {
      if (iteratee(iterable[index], index, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}

module.exports = createBaseEach;


/***/ }),

/***/ "./node_modules/lodash/_createBaseFor.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_createBaseFor.js ***!
  \***********************************************/
/***/ ((module) => {

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;


/***/ }),

/***/ "./node_modules/lodash/_createCaseFirst.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash/_createCaseFirst.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var castSlice = __webpack_require__(/*! ./_castSlice */ "./node_modules/lodash/_castSlice.js"),
    hasUnicode = __webpack_require__(/*! ./_hasUnicode */ "./node_modules/lodash/_hasUnicode.js"),
    stringToArray = __webpack_require__(/*! ./_stringToArray */ "./node_modules/lodash/_stringToArray.js"),
    toString = __webpack_require__(/*! ./toString */ "./node_modules/lodash/toString.js");

/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = toString(string);

    var strSymbols = hasUnicode(string)
      ? stringToArray(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? castSlice(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

module.exports = createCaseFirst;


/***/ }),

/***/ "./node_modules/lodash/_createFind.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_createFind.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIteratee = __webpack_require__(/*! ./_baseIteratee */ "./node_modules/lodash/_baseIteratee.js"),
    isArrayLike = __webpack_require__(/*! ./isArrayLike */ "./node_modules/lodash/isArrayLike.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * Creates a `_.find` or `_.findLast` function.
 *
 * @private
 * @param {Function} findIndexFunc The function to find the collection index.
 * @returns {Function} Returns the new find function.
 */
function createFind(findIndexFunc) {
  return function(collection, predicate, fromIndex) {
    var iterable = Object(collection);
    if (!isArrayLike(collection)) {
      var iteratee = baseIteratee(predicate, 3);
      collection = keys(collection);
      predicate = function(key) { return iteratee(iterable[key], key, iterable); };
    }
    var index = findIndexFunc(collection, predicate, fromIndex);
    return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined;
  };
}

module.exports = createFind;


/***/ }),

/***/ "./node_modules/lodash/_createRange.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_createRange.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseRange = __webpack_require__(/*! ./_baseRange */ "./node_modules/lodash/_baseRange.js"),
    isIterateeCall = __webpack_require__(/*! ./_isIterateeCall */ "./node_modules/lodash/_isIterateeCall.js"),
    toFinite = __webpack_require__(/*! ./toFinite */ "./node_modules/lodash/toFinite.js");

/**
 * Creates a `_.range` or `_.rangeRight` function.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new range function.
 */
function createRange(fromRight) {
  return function(start, end, step) {
    if (step && typeof step != 'number' && isIterateeCall(start, end, step)) {
      end = step = undefined;
    }
    // Ensure the sign of `-0` is preserved.
    start = toFinite(start);
    if (end === undefined) {
      end = start;
      start = 0;
    } else {
      end = toFinite(end);
    }
    step = step === undefined ? (start < end ? 1 : -1) : toFinite(step);
    return baseRange(start, end, step, fromRight);
  };
}

module.exports = createRange;


/***/ }),

/***/ "./node_modules/lodash/_createSet.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_createSet.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Set = __webpack_require__(/*! ./_Set */ "./node_modules/lodash/_Set.js"),
    noop = __webpack_require__(/*! ./noop */ "./node_modules/lodash/noop.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Creates a set object of `values`.
 *
 * @private
 * @param {Array} values The values to add to the set.
 * @returns {Object} Returns the new set.
 */
var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
  return new Set(values);
};

module.exports = createSet;


/***/ }),

/***/ "./node_modules/lodash/_defineProperty.js":
/*!************************************************!*\
  !*** ./node_modules/lodash/_defineProperty.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(/*! ./_getNative */ "./node_modules/lodash/_getNative.js");

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),

/***/ "./node_modules/lodash/_equalArrays.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash/_equalArrays.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(/*! ./_SetCache */ "./node_modules/lodash/_SetCache.js"),
    arraySome = __webpack_require__(/*! ./_arraySome */ "./node_modules/lodash/_arraySome.js"),
    cacheHas = __webpack_require__(/*! ./_cacheHas */ "./node_modules/lodash/_cacheHas.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ "./node_modules/lodash/_equalByTag.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_equalByTag.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    Uint8Array = __webpack_require__(/*! ./_Uint8Array */ "./node_modules/lodash/_Uint8Array.js"),
    eq = __webpack_require__(/*! ./eq */ "./node_modules/lodash/eq.js"),
    equalArrays = __webpack_require__(/*! ./_equalArrays */ "./node_modules/lodash/_equalArrays.js"),
    mapToArray = __webpack_require__(/*! ./_mapToArray */ "./node_modules/lodash/_mapToArray.js"),
    setToArray = __webpack_require__(/*! ./_setToArray */ "./node_modules/lodash/_setToArray.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),

/***/ "./node_modules/lodash/_equalObjects.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_equalObjects.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getAllKeys = __webpack_require__(/*! ./_getAllKeys */ "./node_modules/lodash/_getAllKeys.js");

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

module.exports = equalObjects;


/***/ }),

/***/ "./node_modules/lodash/_freeGlobal.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_freeGlobal.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

module.exports = freeGlobal;


/***/ }),

/***/ "./node_modules/lodash/_getAllKeys.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getAllKeys.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetAllKeys = __webpack_require__(/*! ./_baseGetAllKeys */ "./node_modules/lodash/_baseGetAllKeys.js"),
    getSymbols = __webpack_require__(/*! ./_getSymbols */ "./node_modules/lodash/_getSymbols.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ }),

/***/ "./node_modules/lodash/_getMapData.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getMapData.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isKeyable = __webpack_require__(/*! ./_isKeyable */ "./node_modules/lodash/_isKeyable.js");

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),

/***/ "./node_modules/lodash/_getMatchData.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getMatchData.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isStrictComparable = __webpack_require__(/*! ./_isStrictComparable */ "./node_modules/lodash/_isStrictComparable.js"),
    keys = __webpack_require__(/*! ./keys */ "./node_modules/lodash/keys.js");

/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = keys(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}

module.exports = getMatchData;


/***/ }),

/***/ "./node_modules/lodash/_getNative.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_getNative.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsNative = __webpack_require__(/*! ./_baseIsNative */ "./node_modules/lodash/_baseIsNative.js"),
    getValue = __webpack_require__(/*! ./_getValue */ "./node_modules/lodash/_getValue.js");

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),

/***/ "./node_modules/lodash/_getPrototype.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash/_getPrototype.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(/*! ./_overArg */ "./node_modules/lodash/_overArg.js");

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ }),

/***/ "./node_modules/lodash/_getRawTag.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_getRawTag.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ "./node_modules/lodash/_getSymbols.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_getSymbols.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayFilter = __webpack_require__(/*! ./_arrayFilter */ "./node_modules/lodash/_arrayFilter.js"),
    stubArray = __webpack_require__(/*! ./stubArray */ "./node_modules/lodash/stubArray.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ }),

/***/ "./node_modules/lodash/_getTag.js":
/*!****************************************!*\
  !*** ./node_modules/lodash/_getTag.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DataView = __webpack_require__(/*! ./_DataView */ "./node_modules/lodash/_DataView.js"),
    Map = __webpack_require__(/*! ./_Map */ "./node_modules/lodash/_Map.js"),
    Promise = __webpack_require__(/*! ./_Promise */ "./node_modules/lodash/_Promise.js"),
    Set = __webpack_require__(/*! ./_Set */ "./node_modules/lodash/_Set.js"),
    WeakMap = __webpack_require__(/*! ./_WeakMap */ "./node_modules/lodash/_WeakMap.js"),
    baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "./node_modules/lodash/_baseGetTag.js"),
    toSource = __webpack_require__(/*! ./_toSource */ "./node_modules/lodash/_toSource.js");

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ }),

/***/ "./node_modules/lodash/_getValue.js":
/*!******************************************!*\
  !*** ./node_modules/lodash/_getValue.js ***!
  \******************************************/
/***/ ((module) => {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),

/***/ "./node_modules/lodash/_hasPath.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hasPath.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var castPath = __webpack_require__(/*! ./_castPath */ "./node_modules/lodash/_castPath.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "./node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js"),
    isIndex = __webpack_require__(/*! ./_isIndex */ "./node_modules/lodash/_isIndex.js"),
    isLength = __webpack_require__(/*! ./isLength */ "./node_modules/lodash/isLength.js"),
    toKey = __webpack_require__(/*! ./_toKey */ "./node_modules/lodash/_toKey.js");

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ }),

/***/ "./node_modules/lodash/_hasUnicode.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_hasUnicode.js ***!
  \********************************************/
/***/ ((module) => {

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

module.exports = hasUnicode;


/***/ }),

/***/ "./node_modules/lodash/_hashClear.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash/_hashClear.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ }),

/***/ "./node_modules/lodash/_hashDelete.js":
/*!********************************************!*\
  !*** ./node_modules/lodash/_hashDelete.js ***!
  \********************************************/
/***/ ((module) => {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ }),

/***/ "./node_modules/lodash/_hashGet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashGet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ }),

/***/ "./node_modules/lodash/_hashHas.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashHas.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ }),

/***/ "./node_modules/lodash/_hashSet.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash/_hashSet.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(/*! ./_nativeCreate */ "./node_modules/lodash/_nativeCreate.js");

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ }),

/***/ "./node_modules/lodash/_isFlattenable.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash/_isFlattenable.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "./node_modules/lodash/_Symbol.js"),
    isArguments = __webpack_require__(/*! ./isArguments */ "./node_modules/lodash/isArguments.js"),
    isArray = __webpack_require__(/*! ./isArray */ "./node_modules/lodash/isArray.js");

/** Built-in value references. */
var spreadableSymbol = Symbol ? 