/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**************************************!*\
  !*** ./src/background/background.js ***!
  \**************************************/
// background.js (updated)
// -----------------------
// GraphQL query IDs you provided

const VANITY_QUERY_ID = 'voyagerIdentityDashProfiles.a1a483e719b20537a256b6853cdca711';
const NEW_VANITY_QUERY_ID = 'voyagerIdentityDashProfiles.34ead06db82a2cc9a778fac97f69ad6a';
const PROFILE_QUERY_ID = 'voyagerIdentityDashProfileCards.f0415f0ff9d9968bab1cd89c0352f7c8';
const Experience_QUERY_ID = 'voyagerIdentityDashProfileComponents.c5d4db426a0f8247b8ab7bc1d660775a';

// ----------------------- existing listeners (kept mostly as-is)
chrome.runtime.onInstalled.addListener(() => {
  console.log('I am installed');
});
chrome.runtime.onInstalled.addListener(function (details) {
  if (details.reason === 'install') {
    chrome.storage.local.set({
      needsTermsAcceptance: true
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'removeExtension') {
    chrome.management.uninstallSelf({
      showConfirmDialog: true
    }, () => {
      if (chrome.runtime.lastError) {
        sendResponse({
          success: false,
          error: chrome.runtime.lastError.message
        });
      } else {
        sendResponse({
          success: true
        });
      }
    });
    return true;
  }
});
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'REMOVE_COOKIES') {
    const cookiesToRemove = request.cookies;
    const domains = request.domains;
    console.log("Removing cookies:", cookiesToRemove, "from domains:", domains);
    chrome.storage.local.remove('ipAddress');
    domains.forEach(domain => {
      cookiesToRemove.forEach(cookieName => {
        chrome.cookies.remove({
          url: domain,
          name: cookieName
        }, details => {
          // if (details) {
          //   console.log(`Cookie "${cookieName}" removed from ${domain}`);
          // } else {
          //   console.log(
          //     `Failed to remove cookie: "${cookieName}" from ${domain}`
          //   );
          // }
        });
      });
    });
    chrome.tabs.query({}, tabs => {
      tabs.forEach(tab => {
        if (domains.some(domain => {
          var _tab$url;
          return (_tab$url = tab.url) === null || _tab$url === void 0 ? void 0 : _tab$url.startsWith(domain);
        })) {
          chrome.tabs.reload(tab.id);
        }
      });
    });
    sendResponse({
      success: true
    });
  }
});
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.url && tab.active) {
    chrome.tabs.sendMessage(tabId, {
      method: 'UrlChanged',
      url: changeInfo.url
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'MINIMIZE') {
    const message = {
      type: 'MINIMIZE'
    };
    chrome.tabs.query({
      active: true,
      currentWindow: true
    }, tabs => {
      chrome.tabs.sendMessage(tabs[0].id, message);
    });
  }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'openTab') {
    chrome.tabs.create({
      url: message.url
    });
  }
});
const queue = [];
let isProcessing = false;
const retryDelay = 1000;
chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
  if (request.linkedinAction === 'getProfileContactInfo') {
    fetchAndImportProfileData(request.profileId).then(result => {
      sendResponse({
        result
      });
    }).catch(error => {
      console.error('Error fetching profile data and contact info', error);
      sendResponse({
        error
      });
    });
  }
  return true;
});
chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
  if (request.linkedinAction === 'getCompanyProfile') {
    fetchCompanyData(request.profileId).then(result => {
      sendResponse({
        result
      });
    }).catch(error => {
      console.error('Error fetching company data', error);
      sendResponse({
        error
      });
    });
  }
  return true;
});
async function callLinkedInGraphQL(_ref) {
  let {
    queryId,
    variables = {},
    method = 'GET'
  } = _ref;
  const base = 'https://www.linkedin.com/voyager/api/graphql';
  const headersBase = {
    'x-restli-protocol-version': '2.0.0',
    'accept': 'application/vnd.linkedin.normalized+json+2.1, application/json',
    'x-li-track': JSON.stringify({
      clientVersion: '1.5.*',
      osName: 'web',
      timezoneOffset: 1,
      deviceFormFactor: 'DESKTOP',
      mpName: 'voyager-web'
    }),
    'x-li-lang': 'en_US',
    'referer': 'https://www.linkedin.com/feed/',
    'origin': 'https://www.linkedin.com'
  };
  if (String(queryId).startsWith('voyagerIdentityDashProfiles') || String(queryId).startsWith('voyagerIdentityDashProfileCards')) {
    headersBase['x-li-pem-metadata'] = 'Voyager - Profile=profile-top-card-core';
  }
  try {
    const csrf = await getCsrfToken().catch(() => null);
    if (csrf) headersBase['csrf-token'] = csrf;
  } catch (e) {/* continue without csrf if unavailable */}
  const buildUrl = function (qId, variablesString) {
    let includeWebMetadata = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let rawVars = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    const parts = [];
    if (includeWebMetadata) parts.push('includeWebMetadata=true');
    parts.push('queryId=' + encodeURIComponent(qId));
    if (typeof variablesString !== 'undefined') {
      if (rawVars) {
        parts.push('variables=' + variablesString);
      } else {
        parts.push('variables=' + encodeURIComponent(variablesString));
      }
    }
    if (rawVars) {
      return base + '?' + parts.join('&');
    }
    return encodeURI(base + '?' + parts.join('&'));
  };
  const varKeys = Object.keys(variables || {});
  const singleKey = varKeys.length === 1 ? varKeys[0] : null;
  const singleVal = singleKey ? String(variables[singleKey]) : null;
  const attempts = [];
  const includeWebMetadataDefault = String(queryId).startsWith('voyagerIdentityDashProfileCards');
  if (singleKey && singleVal !== null) {
    if (singleKey === 'profileUrn') {
      if (String(queryId).startsWith('voyagerIdentityDashProfileCards')) {
        headersBase['accept'] = 'application/vnd.linkedin.normalized+json+2.1';
      }
      const encodedVal = singleVal.replace(/:/g, '%3A');
      const quotedEncodedVal = '%22' + encodedVal + '%22';
      attempts.push({
        name: 'parenthesis-encoded-value',
        url: buildUrl(queryId, "(".concat(singleKey, ":").concat(encodedVal, ")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'parenthesis-quoted-encoded',
        url: buildUrl(queryId, "(".concat(singleKey, ":").concat(quotedEncodedVal, ")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'parenthesis-raw-quoted',
        url: buildUrl(queryId, "(".concat(singleKey, ":\"").concat(singleVal, "\")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'parenthesis-unquoted',
        url: buildUrl(queryId, "(".concat(singleKey, ":").concat(singleVal, ")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'json-variables',
        url: buildUrl(queryId, JSON.stringify(variables), includeWebMetadataDefault, false),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
    } else {
      attempts.push({
        name: 'parenthesis-unquoted',
        url: buildUrl(queryId, "(".concat(singleKey, ":").concat(singleVal, ")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'parenthesis-quoted',
        url: buildUrl(queryId, "(".concat(singleKey, ":\"").concat(singleVal, "\")"), includeWebMetadataDefault, true),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
      attempts.push({
        name: 'json-variables',
        url: buildUrl(queryId, JSON.stringify(variables), includeWebMetadataDefault, false),
        options: {
          method: 'GET',
          headers: headersBase,
          credentials: 'include'
        }
      });
    }
  } else {
    attempts.push({
      name: 'json-variables',
      url: buildUrl(queryId, JSON.stringify(variables || {}), includeWebMetadataDefault),
      options: {
        method: 'GET',
        headers: headersBase,
        credentials: 'include'
      }
    });
  }
  let lastError = null;
  for (const attempt of attempts) {
    try {
      const resp = await fetch(attempt.url, attempt.options);
      const status = resp.status;
      const ct = (resp.headers.get('content-type') || '').toLowerCase();
      let body;
      try {
        body = ct.includes('application/json') ? await resp.json() : await resp.text();
      } catch (e) {
        body = await resp.text().catch(() => '(unreadable body)');
      }
      if (status >= 200 && status < 300) return body;
      lastError = {
        attempt: attempt.name,
        status,
        body,
        url: attempt.url
      };
    } catch (err) {
      console.error("[LinkedIn DEBUG] fetch error for ".concat(attempt.name), err);
      lastError = {
        attempt: attempt.name,
        error: String(err)
      };
    }
  }
  try {
    const postBody = JSON.stringify({
      queryId,
      variables
    });
    const resp = await fetch(base, {
      method: 'POST',
      headers: {
        ...headersBase,
        'content-type': 'application/json'
      },
      credentials: 'include',
      body: postBody
    });
    const status = resp.status;
    const ct = (resp.headers.get('content-type') || '').toLowerCase();
    let body;
    if (ct.includes('application/json')) {
      try {
        body = await resp.json();
      } catch (e) {
        body = await resp.text();
      }
    } else {
      body = await resp.text();
    }
    if (status >= 200 && status < 300) return body;
    lastError = lastError || {
      attempt: 'post-fallback',
      status,
      body
    };
  } catch (err) {
    console.error('[LinkedIn DEBUG] POST fallback error', err);
    lastError = lastError || {
      attempt: 'post-fallback',
      error: String(err)
    };
  }
  throw new Error('LinkedIn GraphQL debug: all attempts failed: ' + JSON.stringify(lastError));
}
function getCsrfToken() {
  return new Promise((resolve, reject) => {
    chrome.cookies.get({
      url: 'https://www.linkedin.com',
      name: 'JSESSIONID'
    }, cookie => {
      if (!cookie || !cookie.value) {
        reject('JSESSIONID not found');
        return;
      }
      let v = cookie.value;
      if (v.startsWith('"') && v.endsWith('"')) v = v.slice(1, -1);
      resolve(v);
    });
  });
}
function encodeCompanyUrn(urn) {
  if (!urn) return urn;
  if (urn.includes('%3A')) return urn;
  return urn.replace(/:/g, '%3A');
}
function findFirstObject(obj, predicate) {
  let seen = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new WeakSet();
  if (obj && typeof obj === 'object') {
    if (seen.has(obj)) return null;
    seen.add(obj);
    if (predicate(obj)) return obj;
    if (Array.isArray(obj)) {
      for (const el of obj) {
        const found = findFirstObject(el, predicate, seen);
        if (found) return found;
      }
    } else {
      for (const key of Object.keys(obj)) {
        const found = findFirstObject(obj[key], predicate, seen);
        if (found) return found;
      }
    }
  }
  return null;
}
function extractAddress(loc) {
  if (!loc || !loc.address) return null;
  const a = loc.address;
  const parts = [a.line1, a.line2, a.city, a.geographicArea, a.postalCode, a.country].filter(Boolean);
  return parts.join(', ');
}
function parseCompanyResponse(resp) {
  var _company$industry, _company$foundedOn, _company$callToAction;
  if (typeof resp === 'string') return {
    raw: resp
  };
  const company = findFirstObject(resp, o => o && o.$type === 'com.linkedin.voyager.dash.organization.Company') || findFirstObject(resp, o => o && o.$type === 'com.linkedin.voyager.organization.Organization') || findFirstObject(resp, o => {
    var _o$entityUrn;
    return o && ((_o$entityUrn = o.entityUrn) === null || _o$entityUrn === void 0 ? void 0 : _o$entityUrn.includes('fsd_company'));
  });
  if (!company) return {
    raw: resp
  };
  const result = {
    urn: company.entityUrn || null,
    name: company.name || company.localizedName || company.companyName || null,
    tagline: company.tagline || null,
    description: company.description || null,
    industry: ((_company$industry = company.industry) === null || _company$industry === void 0 ? void 0 : _company$industry[0].name) || company.industryName || null,
    employeeCountRange: company.employeeCountRange ? "".concat(company.employeeCountRange.start || '?', "-").concat(company.employeeCountRange.end || '?') : null,
    location: extractAddress(company.headquarter) || extractAddress(company.location),
    foundedOn: ((_company$foundedOn = company.foundedOn) === null || _company$foundedOn === void 0 ? void 0 : _company$foundedOn.year) || company.foundedOn || null,
    logoResolutionResult: company.logoResolutionResult || null,
    website: company.websiteUrl || null,
    callToAction: ((_company$callToAction = company.callToAction) === null || _company$callToAction === void 0 ? void 0 : _company$callToAction.displayText) || null,
    active: company.active || null
  };
  return result;
}
async function processCompaniesSequentially(entityUrns) {
  let {
    queryId,
    delayMs = 0,
    log = true
  } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (!Array.isArray(entityUrns)) throw new Error('entityUrns must be an array');
  if (!queryId) throw new Error('queryId is required');
  const results = [];
  for (const urn of entityUrns) {
    const encoded = encodeCompanyUrn(String(urn));
    try {
      const resp = await callLinkedInCompanyGraphQL({
        queryId,
        companyUrns: urn
      });
      const rawResp = Array.isArray(resp) ? resp[0] : resp;
      const parsed = parseCompanyResponse(rawResp);
      results.push({
        urn,
        ok: true,
        result: parsed
      });
    } catch (err) {
      console.log("[company] error for ".concat(urn, ":"), err);
      results.push({
        urn,
        ok: false,
        error: String(err)
      });
    }
    if (delayMs > 0) {
      await new Promise(resolve => setTimeout(resolve, delayMs));
    }
  }
  return results;
}
async function callLinkedInCompanyGraphQL(_ref2) {
  let {
    queryId,
    companyUrns,
    parallel = false,
    method = 'GET'
  } = _ref2;
  if (!queryId) throw new Error('queryId is required');
  const urnList = Array.isArray(companyUrns) ? companyUrns : [companyUrns];
  const calls = urnList.map(urn => {
    const encoded = encodeCompanyUrn(String(urn));
    const singleVal = "List(".concat(encoded, ")");
    return async () => {
      return callLinkedInGraphQL({
        queryId,
        variables: {
          companyUrns: singleVal
        },
        method: method
      });
    };
  });
  if (parallel) {
    return Promise.all(calls.map(fn => fn()));
  }
  const results = [];
  for (const fn of calls) {
    const res = await fn();
    results.push(res);
  }
  return results;
}

// ------------------ fetchCompanyData (unchanged behavior) ------------------
function fetchCompanyData(profileId) {
  return new Promise(async (resolve, reject) => {
    if (!profileId) return reject();
    const queryId = 'voyagerOrganizationDashCompanies.4fbcd4df2d3e37fcf3a4f5296be958b9';
    try {
      const gqlResp = await callLinkedInGraphQL({
        queryId,
        variables: {
          universalName: profileId
        },
        method: 'GET'
      });
      if (gqlResp) {
        var _gqlResp$data;
        const companyData = gqlResp === null || gqlResp === void 0 || (_gqlResp$data = gqlResp.data) === null || _gqlResp$data === void 0 || (_gqlResp$data = _gqlResp$data.organizationDashCompaniesByUniversalName) === null || _gqlResp$data === void 0 || (_gqlResp$data = _gqlResp$data.elements) === null || _gqlResp$data === void 0 ? void 0 : _gqlResp$data[0];
        if (companyData) {
          var _companyData$foundedO, _companyData$industry, _companyData$logoReso, _companyData$logoReso2;
          resolve({
            name: companyData.name,
            description: companyData.description,
            employeeCount: companyData.employeeCount,
            foundedYear: (_companyData$foundedO = companyData.foundedOn) === null || _companyData$foundedO === void 0 ? void 0 : _companyData$foundedO.year,
            website: companyData.websiteUrl,
            industry: (_companyData$industry = companyData.industry) === null || _companyData$industry === void 0 || (_companyData$industry = _companyData$industry[0]) === null || _companyData$industry === void 0 ? void 0 : _companyData$industry.name,
            image: "".concat((_companyData$logoReso = companyData.logoResolutionResult) === null || _companyData$logoReso === void 0 || (_companyData$logoReso = _companyData$logoReso.vectorImage) === null || _companyData$logoReso === void 0 ? void 0 : _companyData$logoReso.rootUrl).concat(((_companyData$logoReso2 = companyData.logoResolutionResult) === null || _companyData$logoReso2 === void 0 || (_companyData$logoReso2 = _companyData$logoReso2.vectorImage) === null || _companyData$logoReso2 === void 0 || (_companyData$logoReso2 = _companyData$logoReso2.artifacts) === null || _companyData$logoReso2 === void 0 || (_companyData$logoReso2 = _companyData$logoReso2[0]) === null || _companyData$logoReso2 === void 0 ? void 0 : _companyData$logoReso2.fileIdentifyingUrlPathSegment) || '')
          });
          return;
        }
      }
      reject('Company record not fetched');
    } catch (error) {
      console.error('Error fetching Company record', error);
      reject(error);
    }
  });
}
function tryParse(value) {
  if (typeof value !== 'string') return value;
  try {
    return JSON.parse(value);
  } catch (e) {
    return value;
  }
}
async function fetchExperienceData(profileUrn) {
  let opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const {
    sectionType = 'experience',
    locale = 'en_US',
    queryId = Experience_QUERY_ID
  } = opts;
  if (!profileUrn) throw new Error('profileUrn is required');
  const base = 'https://www.linkedin.com/voyager/api/graphql';
  const encodedUrn = String(profileUrn).replace(/:/g, '%3A');
  const variablesChunk = "(".concat(['profileUrn:' + encodedUrn, 'sectionType:' + sectionType, 'locale:' + locale].join(','), ")");
  const url = "".concat(base, "?variables=").concat(variablesChunk, "&queryId=").concat(encodeURIComponent(queryId));
  const headers = {
    'x-restli-protocol-version': '2.0.0',
    'accept': 'application/vnd.linkedin.normalized+json+2.1, application/json',
    'x-li-track': JSON.stringify({
      clientVersion: '1.5.*',
      osName: 'web',
      timezoneOffset: 1,
      deviceFormFactor: 'DESKTOP',
      mpName: 'voyager-web'
    }),
    'x-li-lang': 'en_US',
    'referer': 'https://www.linkedin.com/feed/',
    'origin': 'https://www.linkedin.com'
  };
  headers['x-li-pem-metadata'] = 'Voyager - Profile=profile-top-card-core';
  try {
    const csrf = await getCsrfToken().catch(() => null);
    if (csrf) headers['csrf-token'] = csrf;
  } catch (e) {
    console.log(e);
  }
  const resp = await fetch(url, {
    method: 'GET',
    headers,
    credentials: 'include'
  });
  const ct = resp.headers.get && resp.headers.get('content-type') || '';
  if (resp.status >= 200 && resp.status < 300) {
    if (ct.toLowerCase().includes('application/json')) {
      return resp.json();
    } else {
      const text = await resp.text();
      try {
        return JSON.parse(text);
      } catch (e) {
        return text;
      }
    }
  } else {
    let bodyText;
    try {
      bodyText = ct.includes('application/json') ? await resp.json() : await resp.text();
    } catch (e) {
      bodyText = '(unreadable)';
    }
    throw new Error("LinkedIn experience fetch failed: ".concat(resp.status, " - ").concat(JSON.stringify(bodyText)));
  }
}
function splitRange(raw) {
  if (!raw || typeof raw !== 'string') return [null, null];
  const beforeDot = raw.split('·')[0].trim();
  const normalized = beforeDot.replace(/–|—/g, '-').replace(/\s+to\s+/i, ' - ');
  const parts = normalized.split(/\s*-\s*/);
  const left = (parts[0] || '').trim();
  const right = (parts[1] || '').trim();
  return [left || null, right || null];
}
const MONTH_MAP = {
  january: 0,
  february: 1,
  march: 2,
  april: 3,
  may: 4,
  june: 5,
  july: 6,
  august: 7,
  september: 8,
  october: 9,
  november: 10,
  december: 11,
  jan: 0,
  feb: 1,
  mar: 2,
  apr: 3,
  sept: 8,
  sep: 8,
  oct: 9,
  nov: 10,
  dec: 11
};
function parseDateToEpochMs(str) {
  if (!str || typeof str !== 'string') return null;
  const s = str.trim();
  if (/^(present|current|now)$/i.test(s)) return null;
  let m = s.match(/^(?:([0-9]{1,2})[,\s]+)?([A-Za-z]+)[\s,]+([0-9]{4})$/);
  if (m) {
    var _MONTH_MAP$monthStr;
    const maybeDay = m[1] ? parseInt(m[1], 10) : 1;
    const monthStr = m[2].toLowerCase();
    const year = parseInt(m[3], 10);
    const mon = (_MONTH_MAP$monthStr = MONTH_MAP[monthStr]) !== null && _MONTH_MAP$monthStr !== void 0 ? _MONTH_MAP$monthStr : MONTH_MAP[monthStr.slice(0, 3)];
    if (typeof mon === 'number') return Date.UTC(year, mon, maybeDay);
  }
  m = s.match(/^([A-Za-z]+)\s+([0-9]{4})$/);
  if (m) {
    var _MONTH_MAP$monthStr2;
    const monthStr = m[1].toLowerCase();
    const year = parseInt(m[2], 10);
    const mon = (_MONTH_MAP$monthStr2 = MONTH_MAP[monthStr]) !== null && _MONTH_MAP$monthStr2 !== void 0 ? _MONTH_MAP$monthStr2 : MONTH_MAP[monthStr.slice(0, 3)];
    if (typeof mon === 'number') return Date.UTC(year, mon, 1);
  }
  m = s.match(/^([0-9]{4})$/);
  if (m) {
    const year = parseInt(m[1], 10);
    return Date.UTC(year, 0, 1);
  }
  const parsed = Date.parse(s);
  if (!Number.isNaN(parsed)) return new Date(parsed).getTime();
  return null;
}
function getNested(obj, path) {
  if (!obj) return undefined;
  let cur = obj;
  for (const p of path) {
    if (!cur) return undefined;
    cur = cur[p];
  }
  return cur;
}
function extractTextFromTextView(tv) {
  if (!tv) return null;
  if (typeof tv === 'string') return tv;
  if (tv.text && typeof tv.text === 'object' && typeof tv.text.text === 'string') return tv.text.text;
  if (tv.accessibilityText && typeof tv.accessibilityText === 'string') return tv.accessibilityText;
  if (tv.text && typeof tv.text === 'string') return tv.text;
  return null;
}
function parseExperienceElements(elementsArray) {
  if (!Array.isArray(elementsArray)) return [];
  const out = [];
  for (const el of elementsArray) {
    let captionText = getNested(el, ['components', 'entityComponent', 'caption', 'text']) || getNested(el, ['entityComponent', 'caption', 'text']) || getNested(el, ['caption', 'text']);
    captionText = extractTextFromTextView(captionText);
    let titleText = getNested(el, ['components', 'entityComponent', 'titleV2', 'text']) || getNested(el, ['titleV2', 'text']) || getNested(el, ['components', 'entityComponent', 'title', 'text']) || getNested(el, ['title', 'text']);
    titleText = extractTextFromTextView(titleText) || null;
    let degreeText = getNested(el, ['components', 'entityComponent', 'subtitle', 'text']) || getNested(el, ['entityComponent', 'subtitle', 'text']) || getNested(el, ['subtitle', 'text']);
    degreeText = extractTextFromTextView(degreeText) || null;
    let degree = null;
    let fieldOfStudy = null;
    if (degreeText) {
      var _parts$;
      const parts = degreeText.split(',');
      degree = ((_parts$ = parts[0]) === null || _parts$ === void 0 ? void 0 : _parts$.trim()) || null;
      fieldOfStudy = parts.slice(1).join(',').trim() || null;
    }
    let companyUrl = getNested(el, ['components', 'entityComponent', 'image', 'actionTarget']) || getNested(el, ['components', 'entityComponent', 'textActionTarget']) || getNested(el, ['entityComponent', 'image', 'actionTarget']) || getNested(el, ['textActionTarget']) || getNested(el, ['actionTarget']) || null;
    if (companyUrl && typeof companyUrl === 'object' && companyUrl.url) companyUrl = companyUrl.url;
    if (companyUrl && typeof companyUrl !== 'string') companyUrl = String(companyUrl);
    let startDate = null,
      endDate = null;
    if (captionText) {
      const [left, right] = splitRange(captionText);
      startDate = parseDateToEpochMs(left);
      endDate = right && /present|current/i.test(right) ? null : parseDateToEpochMs(right);
    }
    let companyId = null,
      shouldFetchCompany = false,
      normalizedCompanyUrl = companyUrl;
    if (companyUrl && typeof companyUrl === 'string') {
      const cleaned = companyUrl.split('?')[0];
      normalizedCompanyUrl = cleaned;
      const m = cleaned.match(/\/company\/(\d+)\/?/i);
      if (m) {
        companyId = m[1];
        shouldFetchCompany = true;
      } else {
        shouldFetchCompany = false;
      }
    }
    out.push({
      title: titleText,
      degree: degree,
      fieldOfStudy: fieldOfStudy,
      startDate: startDate,
      endDate: endDate,
      rawCaption: captionText,
      companyUrl: normalizedCompanyUrl,
      companyId: companyId,
      shouldFetchCompany: !!shouldFetchCompany,
      rawElement: el
    });
  }
  return out;
}

// ---------- helper to build company URN and call your company pipeline ----------
function companyIdToUrn(id) {
  if (!id) return null;
  return "urn:li:fsd_company:".concat(id);
}
function prepareCompanyUrnsFromParsed(parsedExperiences) {
  const urns = parsedExperiences.filter(x => x.companyId).map(x => companyIdToUrn(x.companyId));
  return Array.from(new Set(urns));
}
function processExperienceResponse(resp) {
  var _ref3, _parsed$included, _parsed$data;
  const parsed = typeof resp === 'string' ? tryParse(resp) : resp || {};
  const included = (_ref3 = (_parsed$included = parsed === null || parsed === void 0 ? void 0 : parsed.included) !== null && _parsed$included !== void 0 ? _parsed$included : parsed === null || parsed === void 0 || (_parsed$data = parsed.data) === null || _parsed$data === void 0 ? void 0 : _parsed$data.included) !== null && _ref3 !== void 0 ? _ref3 : null;
  let elements = null;
  if (Array.isArray(included) && included.length) {
    for (const item of included) {
      if (item && (item.components || item.component || item.$type)) {
        var _item$components;
        if (Array.isArray((_item$components = item.components) === null || _item$components === void 0 ? void 0 : _item$components.elements) && item.components.elements.length) {
          elements = item.components.elements;
          break;
        }
        if (Array.isArray(item.elements) && item.elements.length) {
          elements = item.elements;
          break;
        }
      }
    }
  }
  if (!elements) {
    const found = findFirstObject(parsed, o => o && o.components && Array.isArray(o.components.elements) && o.components.elements.length > 0);
    elements = found ? found.components.elements : null;
  }
  if (!elements) {
    var _parsed$components;
    if (parsed !== null && parsed !== void 0 && (_parsed$components = parsed.components) !== null && _parsed$components !== void 0 && _parsed$components.elements) elements = parsed.components.elements;else if (parsed !== null && parsed !== void 0 && parsed.elements) elements = parsed.elements;
  }
  const safeElements = Array.isArray(elements) ? elements : [];
  const entityUrns = safeElements.map(e => {
    var _e$entityUrn;
    return e && (e.entityUrn || e.entityUrnString || ((_e$entityUrn = e.entityUrn) === null || _e$entityUrn === void 0 ? void 0 : _e$entityUrn.toString())) || null;
  }).filter(Boolean);
  return {
    entityUrns,
    experiences: safeElements,
    raw: parsed
  };
}
function normalizeProfileUrn(u) {
  if (!u) return null;
  let s = String(u);
  s = s.replace(/^%22|%22$/g, '').replace(/^"|"$/g, '');
  if (s.includes('%3A')) {
    try {
      s = decodeURIComponent(s);
    } catch (e) {/* ignore */}
  }
  return s;
}

// ------------------ fetchAndImportProfileData (updated to include education) ------------------

async function fetchAndImportProfileData(vanityName) {
  try {
    var _newVanityResp$data, _profile$geoLocation, _profile$projectView, _profile$publicationV, _profile$honorView, _profile$volunteerExp;
    const vanityResp = await callLinkedInGraphQL({
      queryId: VANITY_QUERY_ID,
      variables: {
        vanityName
      },
      method: 'GET'
    });
    const newVanityResp = await callLinkedInGraphQL({
      queryId: NEW_VANITY_QUERY_ID,
      variables: {
        vanityName
      },
      method: 'GET'
    });
    const rawUrn = newVanityResp === null || newVanityResp === void 0 || (_newVanityResp$data = newVanityResp.data) === null || _newVanityResp$data === void 0 || (_newVanityResp$data = _newVanityResp$data.identityDashProfilesByMemberIdentity) === null || _newVanityResp$data === void 0 || (_newVanityResp$data = _newVanityResp$data.elements) === null || _newVanityResp$data === void 0 || (_newVanityResp$data = _newVanityResp$data[0]) === null || _newVanityResp$data === void 0 ? void 0 : _newVanityResp$data.entityUrn;
    const profileUrn2 = normalizeProfileUrn(rawUrn);
    const profile = newVanityResp.data.identityDashProfilesByMemberIdentity.elements[0];
    const headline = profile.headline || null;
    const dateOfBirth = profile.birthDateOn || null;
    const defaultLocalizedName = ((_profile$geoLocation = profile.geoLocation) === null || _profile$geoLocation === void 0 || (_profile$geoLocation = _profile$geoLocation.geo) === null || _profile$geoLocation === void 0 || (_profile$geoLocation = _profile$geoLocation.country) === null || _profile$geoLocation === void 0 ? void 0 : _profile$geoLocation.defaultLocalizedName) || null;
    const profileUrn = findEntityUrn(vanityResp);
    if (!profileUrn) throw new Error('Could not resolve profile URN');

    // ---------- EXPERIENCE ----------

    const experienceRaw = await fetchExperienceData(profileUrn2);
    const experienceParsed = processExperienceResponse(experienceRaw);
    const elements = experienceParsed.experiences || [];
    const parsedExperiences = parseExperienceElements(elements);
    const companyUrns = prepareCompanyUrnsFromParsed(parsedExperiences);
    const companyQueryId = 'voyagerOrganizationDashCompanies.32a7cdaea60de8f9ce50df019654c45d';
    const companyResults = companyUrns.length ? await processCompaniesSequentially(companyUrns, {
      queryId: companyQueryId,
      delayMs: 250,
      log: true
    }) : [];
    const companyResultMap = {};
    for (const r of companyResults) {
      if (r.ok && r.result && r.urn) {
        const id = String(r.urn).split(':').pop();
        companyResultMap[id] = r.result;
      }
    }
    const finalCompanies = parsedExperiences.map(pe => {
      return {
        title: pe.title,
        startDate: pe.startDate,
        endDate: pe.endDate,
        companyUrl: pe.companyUrl,
        companyId: pe.companyId,
        shouldFetchCompany: pe.shouldFetchCompany,
        companyDetails: pe.companyId ? companyResultMap[pe.companyId] || {} : {},
        raw: pe.rawElement
      };
    });
    let finalSkills = [];
    try {
      var _profile$skillView;
      const skillsRaw = await fetchExperienceData(profileUrn2, {
        sectionType: 'skills',
        queryId: Experience_QUERY_ID
      });
      const skillsParsedResp = processExperienceResponse(skillsRaw);
      const skillsElements = skillsParsedResp.experiences || [];
      const extractSkillNameFromElement = el => {
        if (!el) return null;
        const candidates = [extractTextFromTextView(getNested(el, ['components', 'entityComponent', 'titleV2', 'text'])), extractTextFromTextView(getNested(el, ['titleV2', 'text'])), extractTextFromTextView(getNested(el, ['components', 'entityComponent', 'title', 'text'])), extractTextFromTextView(getNested(el, ['title', 'text'])), extractTextFromTextView(getNested(el, ['name'])), extractTextFromTextView(getNested(el, ['skill', 'name'])), typeof el === 'string' ? el : null];
        for (const c of candidates) {
          if (c && typeof c === 'string' && c.trim()) return c.trim();
        }
        if (typeof el === 'object') {
          for (const k of Object.keys(el)) {
            const v = el[k];
            if (typeof v === 'string' && v.trim()) return v.trim();
            const nested = extractTextFromTextView(v);
            if (nested && nested.trim()) return nested.trim();
          }
        }
        return null;
      };
      const names = skillsElements.map(extractSkillNameFromElement).filter(Boolean).map(n => n.trim());
      if (names.length === 0 && Array.isArray(profile === null || profile === void 0 || (_profile$skillView = profile.skillView) === null || _profile$skillView === void 0 ? void 0 : _profile$skillView.elements) && profile.skillView.elements.length) {
        finalSkills = Array.from(new Set(profile.skillView.elements.map(s => {
          if (!s) return null;
          if (typeof s === 'string') return s.trim();
          return s.name || extractTextFromTextView(s) || (s.text && typeof s.text === 'string' ? s.text : null);
        }).filter(Boolean))).map(s => s.trim());
      } else {
        finalSkills = Array.from(new Set(names));
      }
    } catch (skillsErr) {
      var _profile$skillView2;
      if (Array.isArray(profile === null || profile === void 0 || (_profile$skillView2 = profile.skillView) === null || _profile$skillView2 === void 0 ? void 0 : _profile$skillView2.elements) && profile.skillView.elements.length) {
        finalSkills = Array.from(new Set(profile.skillView.elements.map(s => {
          if (!s) return null;
          if (typeof s === 'string') return s.trim();
          return s.name || extractTextFromTextView(s) || (s.text && typeof s.text === 'string' ? s.text : null);
        }).filter(Boolean))).map(s => s.trim());
      } else {
        finalSkills = [];
      }
    }

    // ---------- EDUCATION ----------    

    let finalEducation = [];
    try {
      const educationRaw = await fetchExperienceData(profileUrn2, {
        sectionType: 'education',
        queryId: Experience_QUERY_ID
      });
      const educationParsedResp = processExperienceResponse(educationRaw);
      const educationElements = educationParsedResp.experiences || [];
      const parsedEducation = parseExperienceElements(educationElements);
      const educationUrns = prepareCompanyUrnsFromParsed(parsedEducation);
      const educationCompanyResults = educationUrns.length ? await processCompaniesSequentially(educationUrns, {
        queryId: companyQueryId,
        delayMs: 250,
        log: true
      }) : [];
      const educationResultMap = {};
      for (const r of educationCompanyResults) {
        if (r.ok && r.result && r.urn) {
          const id = String(r.urn).split(':').pop();
          educationResultMap[id] = r.result;
        }
      }
      finalEducation = parsedEducation.map(pe => ({
        title: pe.title,
        degree: pe.degree,
        fieldOfStudy: pe.fieldOfStudy,
        startDate: pe.startDate,
        endDate: pe.endDate,
        companyUrl: pe.companyUrl,
        companyId: pe.companyId,
        shouldFetchCompany: pe.shouldFetchCompany,
        schoolDetails: pe.companyId ? educationResultMap[pe.companyId] || {} : {},
        raw: pe.rawElement
      }));
    } catch (eduErr) {
      console.warn('Education fetch/parse failed, falling back to profile educationView. Error:', eduErr);
      finalEducation = [];
    }
    let finalCertificates = [];
    try {
      var _profile$skillView3;
      const CertificatesRaw = await fetchExperienceData(profileUrn2, {
        sectionType: 'certifications',
        queryId: Experience_QUERY_ID
      });
      const CertificatesParsedResp = processExperienceResponse(CertificatesRaw);
      const CertificatesElements = CertificatesParsedResp.experiences || [];

      // helper: try many possible paths and text view shapes
      const tryTextPaths = function (el) {
        let paths = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        for (const p of paths) {
          const v = getNested(el, p);
          const t = extractTextFromTextView(v);
          if (t && typeof t === 'string' && t.trim()) return t.trim();
        }
        return null;
      };

      // parse "Issued Apr 2016" / "Apr 2016" / "2016" -> ms timestamp (UTC of 1st day)
      const parseIssuedCaptionToMs = txt => {
        if (!txt || typeof txt !== 'string') return null;
        // try month-year like "Apr 2016" or "Issued Apr 2016"
        const monthRegex = /\b(?:Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:t(?:ember)?)?|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?)\b\s+(\d{4})/i;
        const m = txt.match(monthRegex);
        if (m) {
          var _monthMap$monthName;
          // extract month name from full match
          const full = m[0];
          const parts = full.split(/\s+/);
          const monthName = parts[0].slice(0, 3).toLowerCase();
          const monthMap = {
            jan: 0,
            feb: 1,
            mar: 2,
            apr: 3,
            may: 4,
            jun: 5,
            jul: 6,
            aug: 7,
            sep: 8,
            oct: 9,
            nov: 10,
            dec: 11
          };
          const monthIndex = (_monthMap$monthName = monthMap[monthName]) !== null && _monthMap$monthName !== void 0 ? _monthMap$monthName : 0;
          const year = parseInt(m[1], 10);
          return Date.UTC(year, monthIndex, 1);
        }
        // try plain year "2016"
        const yearRegex = /(\d{4})/;
        const y = txt.match(yearRegex);
        if (y) {
          const year = parseInt(y[1], 10);
          return Date.UTC(year, 0, 1);
        }
        return null;
      };

      // company username/id from a linkedin company url like https://www.linkedin.com/company/3506908/
      const extractCompanyUsernameFromUrl = url => {
        if (!url || typeof url !== 'string') return null;
        try {
          const u = new URL(url);
          const segments = u.pathname.split('/').filter(Boolean);
          const idx = segments.indexOf('company');
          if (idx >= 0 && segments.length > idx + 1) return segments[idx + 1];
          // fallback: last path segment
          return segments[segments.length - 1] || null;
        } catch (err) {
          // not a full URL, maybe just path:
          const m = url.match(/company\/([^\/\?]+)/i);
          return m ? m[1] : null;
        }
      };

      // best-effort extraction per element
      const extractCertObject = el => {
        if (!el) return null;

        // name candidates (order matters)
        const name = tryTextPaths(el, [['components', 'entityComponent', 'titleV2', 'text'], ['components', 'entityComponent', 'title', 'text'], ['titleV2', 'text'], ['title', 'text'], ['name'], ['skill', 'name'], ['text'], ['caption', 'text']]) || (typeof el === 'string' ? el.trim() : null);

        // company name: subtitle text (common in your sample), or image/company detail
        let companyName = tryTextPaths(el, [['components', 'entityComponent', 'subtitle', 'text'], ['components', 'entityComponent', 'subtitleV2', 'text'], ['subtitle', 'text'], ['company', 'name'], ['companyName']]);

        // company username / id (from any company link we can find)
        // check image actionTarget, or entityComponent.image.actionTarget, or tertiaryAction.navigation.actionTargetV2.deeplink
        let companyUrl = getNested(el, ['components', 'entityComponent', 'image', 'actionTarget']) || getNested(el, ['components', 'entityComponent', 'tertiaryAction', 'action', 'navigationAction', 'actionTarget']) || getNested(el, ['components', 'entityComponent', 'tertiaryAction', 'action', 'navigationAction', 'actionTarget']) || getNested(el, ['components', 'entityComponent', 'image', 'attributes', 0, 'detailData', 'companyLogo', 'actionTarget']) || null;

        // sometimes image attributes carry company object; also try the companyLogo entityUrn (we won't resolve it but can keep it)
        const companyLogoEntity = getNested(el, ['components', 'entityComponent', 'image', 'attributes', 0, 'detailData', 'companyLogo']);
        if (!companyName && companyLogoEntity && companyLogoEntity._type === 'com.linkedin.voyager.dash.organization.Company') {
          // company name might not be present there; fallback to subtitle already handled; keep entityUrn as a fallback username
          if (!companyUrl && companyLogoEntity.entityUrn) companyUrl = companyLogoEntity.entityUrn;
        }

        // extract username/id from found url or urn
        let companyUsername = companyUrl ? extractCompanyUsernameFromUrl(companyUrl) : null;

        // date: try structured timePeriod first
        const startDateNested = getNested(el, ['timePeriod', 'startDate']);
        const endDateNested = getNested(el, ['timePeriod', 'endDate']);
        const captionText = extractTextFromTextView(getNested(el, ['components', 'entityComponent', 'caption', 'text'])) || extractTextFromTextView(getNested(el, ['caption', 'text'])) || null;
        const parsedStartMs = startDateNested ? typeof startDateNested === 'object' && startDateNested.$numberLong ? parseInt(startDateNested.$numberLong, 10) : typeof startDateNested === 'number' ? startDateNested : null : captionText ? parseIssuedCaptionToMs(captionText) : null;
        const parsedEndMs = endDateNested ? typeof endDateNested === 'object' && endDateNested.$numberLong ? parseInt(endDateNested.$numberLong, 10) : typeof endDateNested === 'number' ? endDateNested : null : null;
        const result = {
          name: name || null,
          company: {
            name: companyName || null,
            universalName: companyUsername || null
          },
          // keep the shape compatible with other places in your code: timePeriod.startDate/endDate may be {$numberLong: "..."}
          timePeriod: {
            startDate: parsedStartMs ? {
              $numberLong: String(parsedStartMs)
            } : null,
            endDate: parsedEndMs ? {
              $numberLong: String(parsedEndMs)
            } : null
          },
          // keep raw caption for debugging if needed
          _rawCaption: captionText || null
        };
        return result;
      };

      // build finalCertificates
      const candidates = CertificatesElements.map(extractCertObject).filter(Boolean);
      if (!candidates.length && Array.isArray(profile === null || profile === void 0 || (_profile$skillView3 = profile.skillView) === null || _profile$skillView3 === void 0 ? void 0 : _profile$skillView3.elements) && profile.skillView.elements.length) {
        // fallback: map skillView to certificates (your existing fallback)
        finalCertificates = Array.from(new Set(profile.skillView.elements.map(s => {
          if (!s) return null;
          if (typeof s === 'string') return s.trim();
          return s.name || extractTextFromTextView(s) || (s.text && typeof s.text === 'string' ? s.text : null);
        }).filter(Boolean))).map(name => ({
          name: name.trim(),
          company: {
            name: null,
            universalName: null
          },
          timePeriod: {
            startDate: null,
            endDate: null
          }
        }));
      } else {
        finalCertificates = candidates;
      }
    } catch (CertificatesErr) {
      var _profile$skillView4;
      // your existing fallback if fetch fails
      if (Array.isArray(profile === null || profile === void 0 || (_profile$skillView4 = profile.skillView) === null || _profile$skillView4 === void 0 ? void 0 : _profile$skillView4.elements) && profile.skillView.elements.length) {
        finalCertificates = Array.from(new Set(profile.skillView.elements.map(s => {
          if (!s) return null;
          if (typeof s === 'string') return s.trim();
          return s.name || extractTextFromTextView(s) || (s.text && typeof s.text === 'string' ? s.text : null);
        }).filter(Boolean))).map(s => ({
          name: s.trim(),
          company: {
            name: null,
            universalName: null
          },
          timePeriod: {
            startDate: null,
            endDate: null
          }
        }));
      } else {
        finalCertificates = [];
      }
    }
    console.log("finalCertificates", finalCertificates);
    return {
      firstName: (profile === null || profile === void 0 ? void 0 : profile.firstName) || '',
      lastName: (profile === null || profile === void 0 ? void 0 : profile.lastName) || '',
      dateOfBirth: dateOfBirth || '',
      linkedInProfileHeadline: headline || '',
      linkedInUrl: "https://www.linkedin.com/in/".concat(vanityName),
      encodedUsername: profileUrn.replace('urn:li:fsd_profile:', ''),
      skills: finalSkills || [],
      employment: finalCompanies || [],
      location: defaultLocalizedName || '',
      education: finalEducation || [],
      certifications: finalCertificates || [],
      projects: (profile === null || profile === void 0 || (_profile$projectView = profile.projectView) === null || _profile$projectView === void 0 ? void 0 : _profile$projectView.elements) || [],
      publications: (profile === null || profile === void 0 || (_profile$publicationV = profile.publicationView) === null || _profile$publicationV === void 0 ? void 0 : _profile$publicationV.elements) || [],
      honors: (profile === null || profile === void 0 || (_profile$honorView = profile.honorView) === null || _profile$honorView === void 0 ? void 0 : _profile$honorView.elements) || [],
      volunteerWorks: (profile === null || profile === void 0 || (_profile$volunteerExp = profile.volunteerExperienceView) === null || _profile$volunteerExp === void 0 ? void 0 : _profile$volunteerExp.elements) || []
    };
  } catch (err) {
    console.error('Error fetching profile data', err);
    throw err;
  }
}

// ---------- helper: findEntityUrn (unchanged) ----------
function findEntityUrn(obj) {
  if (!obj) return null;
  if (typeof obj === 'string') {
    if (obj.startsWith('urn:li:fsd_profile:') || obj.startsWith('urn:li:fs_profile:')) return obj;
    return null;
  }
  if (Array.isArray(obj)) {
    for (const item of obj) {
      const found = findEntityUrn(item);
      if (found) return found;
    }
  } else if (typeof obj === 'object') {
    for (const k of Object.keys(obj)) {
      const found = findEntityUrn(obj[k]);
      if (found) return found;
    }
  }
  return null;
}

// ------------------ getProfileContactInfo (unchanged) ------------------
function getProfileContactInfo(profileId) {
  return new Promise(async (resolve, reject) => {
    if (!profileId) {
      console.error('Invalid profileId');
      return reject();
    }
    const contactQueryId = 'voyagerIdentityDashProfileContactInfo.xxxxx';
    let resolvedUrn;
    try {
      resolvedUrn = await resolveProfileUrn(profileId);
    } catch (err) {
      resolvedUrn = "urn:li:fsd_profile:".concat(profileId);
    }
    try {
      var _contactBlock$contact;
      const gql = await callLinkedInGraphQL({
        queryId: contactQueryId,
        variables: {
          profileUrn: resolvedUrn
        },
        method: 'GET'
      });
      const contactBlock = (gql === null || gql === void 0 ? void 0 : gql.data) || {};
      const email = (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.emailAddress) || (contactBlock === null || contactBlock === void 0 || (_contactBlock$contact = contactBlock.contactInfo) === null || _contactBlock$contact === void 0 ? void 0 : _contactBlock$contact.emailAddress) || null;
      resolve({
        profileUrl: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.entityUrn) || null,
        email,
        website: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.websites) || (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.website) || null,
        phone: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.phoneNumbers) || null,
        skypeId: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.ims) || null,
        birthDate: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.birthDateOn) || null,
        connectedOn: (contactBlock === null || contactBlock === void 0 ? void 0 : contactBlock.connectedAt) || null,
        profileUrlWithName: "https://www.linkedin.com/in/".concat(profileId)
      });
      return;
    } catch (gqlErr) {
      console.error('Error in getProfileContactInfo', gqlErr);
      reject(gqlErr);
    }
  });
}

// ------------------ sendRequest (queue based) ------------------
async function sendRequest(url) {
  let method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GET';
  let body = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return new Promise((resolve, reject) => {
    queue.push({
      url,
      method,
      body,
      resolve,
      reject
    });
    if (isProcessing) return;
    processQueue();
  });
  function processQueue() {
    if (queue.length === 0) {
      isProcessing = false;
      return;
    }
    isProcessing = true;
    let {
      url,
      method,
      body,
      resolve,
      reject
    } = queue.shift();
    if (!url) {
      console.error('URL is required');
      reject(new Error('URL is required'));
      isProcessing = false;
      return;
    }
    getCsrfToken().then(csrfToken => {
      if (body) body = JSON.stringify(body);
      fetch(url, {
        method,
        headers: {
          'x-restli-protocol-version': '2.0.0',
          'csrf-token': csrfToken,
          'x-li-track': JSON.stringify({
            clientVersion: '1.5.*',
            osName: 'web',
            timezoneOffset: 1,
            deviceFormFactor: 'DESKTOP',
            mpName: 'voyager-web'
          })
        },
        credentials: 'include',
        body
      }).then(response => {
        const ct = response.headers && response.headers.get && response.headers.get('content-type') || '';
        if (response.status >= 200 && response.status < 300) {
          return ct.includes('application/json') ? response.json() : response.text();
        } else {
          if (ct.includes('application/json')) {
            return response.json().then(error => reject(JSON.stringify(error)));
          } else {
            return response.text().then(text => reject(text));
          }
        }
      }).then(response => {
        resolve(response);
      }).catch(error => {
        console.error('Fetch error:', error);
        reject(error);
      }).finally(() => {
        isProcessing = false;
        setTimeout(processQueue, retryDelay);
      });
    }).catch(error => {
      console.error('Error fetching CSRF token', error);
      reject(error);
      isProcessing = false;
    });
  }
}

// ------------------ cookie / csrf helpers ------------------ 
function getCookies() {
  return new Promise((resolve, reject) => {
    chrome.cookies.getAll({
      url: 'https://www.linkedin.com'
    }, cookies => {
      if (cookies.length > 0) {
        let cookieString = cookies.map(cookie => cookie.name + '=' + cookie.value).join('; ');
        resolve(cookieString);
      } else {
        console.error('No cookies found or user not logged in.');
        reject('User is not correctly logged in.');
      }
    });
  });
}
function getAuthToken() {
  return new Promise((resolve, reject) => {
    chrome.cookies.get({
      url: 'YOUR_DOMAIN_URL',
      name: 'YOUR_AUTH_COOKIE_NAME'
    }, cookie => {
      if (!cookie || !cookie.value) reject('Auth token not found');else resolve(cookie.value);
    });
  });
}
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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